require 'amrita/template'
require 'amrita/xml'

MAX = (ARGV[0] || "3000").to_i
am_data = {  # data for Amrita
  :books => (0..MAX).collect{|i|
    Amrita::a(:isbn=>i){ {:title => "book#{i}", :authors => "author#{i}"} }
  }
}

t = Amrita::TemplateText.new <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<books>
  <book id="books">
    <title id="title"></title>
    <author id="authors"></author>
  </book>
</books>
EOF
t.xml = true
t.use_compiler = true
t.set_hint_by_sample_data(am_data)
t1 = Time.now
t.expand($stdout, am_data)
t2 = Time.now
$stderr.puts (t2 - t1)
#puts t.src
