# -*- ruby -*-
#
# How to expand a template with data.
#

require 'xtemplate'

class Comment
  def initialize(str)
    @str = str
  end

  def to_s
    @str
  end
end

data = {
  'members' => [
    {'name' => 'name1', 'age' => 21},
    {'name' => 'name2', 'age' => 22},
    {'name' => 'name3', 'age' => 23},
  ],
  'comment' => [
    "This is not 'sanitized' data.",
    XTemplate::SanitizedString["This is &apos;sanitized&apos; data."],
    Comment.new("This is not 'sanitized' data."),
    XTemplate::SanitizedString[Comment.new("This is &apos;sanitized&apos; data.")],
  ],
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<document xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
  <comment xt:id="comment"></comment>
  <comment id="foo">This attribute is not regarded as a data ID.</comment>
  <members>
    <member xt:id="members">
      <name xt:id="name" />
      <age xt:id="age" />
    </member>
  </members>
</document>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
