require 'rubyunit'

require 'dpklib/csv'

class TESTCASE_CSV < RUNIT::TestCase
  def test_simple
    check_consistency %w(1)
    check_consistency %w(1 2 3)
  end

  def test_empty
    check_consistency [""]
    check_consistency ["a", ""]
    check_consistency ["", "b"]
    check_consistency ["a", "", "b"]
  end

  def test_quote
    check_consistency ['"']
    check_consistency ["", '"', ""]
    check_consistency ['abc""d']
    check_consistency ['"""""']
    check_consistency ['e,t']
    check_consistency ['","']
    check_consistency ["\n"]
  end

  def check_consistency(source)
    csv = Dpklib::CSV.create( source )

    parsed = Dpklib::CSV.parse( csv )
    assert_equals(source, parsed)
  end

end #/TESTCASE_CSV
