require "dpklib/tsv"
require "rubyunit"

class TESTCASE_Tsv < RUNIT::TestCase
  def test_split
    assert_equals %w'1 2 3', Dpklib.tsv_split("1\t2\t3")
    assert_equals [""] * 3, Dpklib.tsv_split("\t\t")
    assert_equals [""], Dpklib.tsv_split("")
  end

  def test_join
    assert_equals "1\t2\t3", Dpklib.tsv_join(%w'1 2 3')
    assert_equals "\t\t", Dpklib.tsv_join([""] * 3)
    assert_equals "", Dpklib.tsv_join([])
  end
end #/TESTCASE_Tsv
