module Dpklib
  class YAEnumerator
    include Enumerable

    def initialize(&each_proc)
      @each_proc = each_proc
    end

    def each(&block)
      @each_proc[block]
    end

    def +(rhs)
      Pair.new(self, rhs)
    end

    def each_or_enum(given_block)
      given_block ? each(&given_block) : self
    end

    def self.each_or_enum(given_block, &each_proc)
      if given_block
        each_proc[given_block]
      else
        new(&each_proc)
      end
    end

    class Pair < self
      def initialize(lhs, rhs)
        @lhs, @rhs = lhs, rhs
      end

      def each(&block)
        @lhs.each(&block)
        @rhs.each(&block)
      end
    end #/Pair

    def self.foreign(enumerable, each_name = nil)
      each_name ||= :each
      new { |block|
        enumerable.__send__(each_name, &block)
      }
    end
  end #/YAEnumerator
end #/Dpklib

module Enumerable
  def split_at(&block)
    lhs = []
    rhs = []
    is_split = false
    self.each do |i|
      ary = nil
      unless is_split then
	is_split = yield i
      end
      ary = is_split ? rhs : lhs

      ary << i
    end

    [lhs, rhs]
  end

end #/Enumerable

class Array
  def cut_until!(&block)
    lhs = []
    is_split = false
    until self.empty? do
      i = self[0]
      unless is_split then
	is_split = yield i
      end
      break if is_split
      lhs << self.shift
    end
    lhs
  end

  def extract!(&extract_if)
    extracted = []
    self.reject! do |i|
      is_extract = yield i
      extracted << i if is_extract
      is_extract
    end
    extracted
  end
end

class << Dpklib
  def array_to_hash(array, &block)
    hash = Hash.new
    array.each do |i|
      key = yield(i)
      hash[key] = i
    end
    hash
  end

  def concurrent_each(*arrays, &block)
    unless arrays.empty?
      (arrays.shift).each_with_index { |item, index|
        args = arrays.collect { |array|
          array[index]
        }
        yield(item, *args)
      }
    end
  end

  def swap!(array, i, j)
    tmp = array[i]
    array[i] = array[j]
    array[j] = tmp
    array
  end

  def shuffle!(array)
    i = array.size - 1
    while i > 0
      j = rand(i+1)
      swap!(array, i, j) if i != j
      i -= 1
    end
    array
  end
  
  def shuffle(array)
    shuffle!(array.dup)
  end

  def collect_hash(hash, &block)
    newhash = {}
    hash.each { |key, value|
      key, value = yield(key, value)
      newhash[key] = value
    }
    newhash
  end

  def divide_array_per(array, count)
    if count == 0 then
      raise(ZeroDivisionError)
    else
      divided = []
      index = 0
      while (index < array.size)
        divided << array[index, count]
        index += count
      end
      divided << [] if (divided.size == 0)
      divided
    end
  end

  def divide_array_by(array, num)
    raise(ZeroDivisionError) if num == 0
    return [[]] if (array.size == 0)
    num = array.size if (array.size < num)
    
    percount = array.size / num
    mod = array.size % num
    
    divided = []
    index = 0
    while (index < array.size)
      count = percount
      if mod > 0
        count += + 1
        mod -= 1
      end
      divided << array[index, count]
      index += count
    end
    divided << [] if (divided.size == 0)
    divided
  end

  def invert_matrix(matrix, rows, cols)
    src = matrix

    inverted = []
    (0...cols).each do |x|
      inverted_col = []
      (0...rows).each do |y|
        srccol = src[y]
        cell = srccol.nil?() ? nil : srccol[x]
        inverted_col << cell
      end
      inverted << inverted_col
    end
    inverted
  end

  def find_index(enum, &block)
    found = nil
    enum.each_with_index { |item, index|
      if yield(item)
        found = index
        break
      end
    }
    found
  end

  def collect_concat(enum, &block)
    result = []
    for item in enum
      item = yield(item) if block_given?
      result.concat(item)
    end
    result
  end
end #/<< Dpklib
