require "dpklib/class"
require "dpklib/dpkstd"
require "runit/assert"

module Dpklib
  module RUNIT_Assert
    include RUNIT::Assert
    include Dpklib::BacktraceRewriteMethod

    def assert_if(obj, message="")
      setup_assert
      unless obj then
	msg = build_message(message) {
	  "nil or false"
	}
	raise_assertion_error(msg)
      end
    end

    def assert_unless(obj, message="")
      setup_assert
      if obj then
	msg = build_message(message) {
	  "not nil or false"
	}
	raise_assertion_error(msg)
      end
    end

    def assert_error(error_class, message="", &block)
      error_class.kind_of?(Module) ||
        assert_fail("assert_error: invalid error class.")

      setup_assert

      exception = nil
      ret = nil
      begin
        ret = yield
      rescue
        exception = $!
      end

      msg = nil
      case exception
      when nil
	msg = build_message(message) {
	  "expected:<#{error_class}> but NO ERROR RAISED"
	}
      when error_class
      else
	msg = build_message(message) {
          root_cause = Dpklib.stacktrace_message(exception)
	  "expected:<#{error_class}> but was:{\n#{root_cause}\n}"
	}
      end

      msg && raise_assertion_error(msg)
      ret
    end

    backtrace_rewrite_method RUNIT::AssertionFailedError, :assert_if
    backtrace_rewrite_method RUNIT::AssertionFailedError, :assert_unless
    backtrace_rewrite_method RUNIT::AssertionFailedError, :assert_error
  end #/RUNIT_Assert
end #/Dpklib
