require "dpklib/file"

module Dpklib
  class SimpleConfigSpec
    attr_accessor :field_num, :comment_regexp, :field_splitter
    def initialize(field_num = nil)
      @field_num = field_num
      @comment_regexp = %r"\A#"
      @field_splitter = /\s+/
    end

    def parse_line(line)
      line = line.strip
      if line.empty?
        nil
      elsif @comment_regexp =~ line
        nil
      else
        if @field_num
          line.split(@field_splitter, @field_num)
        else
          line
        end
      end
    end

    def parse_text(text)
      configs = []
      text.each_line { |line|
        if parsed = parse_line(line)
          configs << parsed
        end
      }
      configs
    end

    def parse_input(input)
      configs = []
      while line = input.gets
        if parsed = parse_line(line)
          configs << parsed
        end
      end
      configs
    end

    def parse_file(file)
      File.open(file, &method(:parse_input).to_proc)
    end
  end #/SimpleConfigSpec
end #/Dpklib
