# -*- ruby -*-
#
# Using templates for expanding data.
#

require 'xtemplate'
require 'xtemplate/xml'

data = XTemplate::XMLDocument.new(<<EOS)
<?xml version="1.0"?>
<members xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
<member uid="1">
  <name>name1</name>
  <comment>
  Home Page:
     <ul>
       <li><link>http://www.foo.bar/</link></li>
       <li><a href="http://www2.foo.bar/">Second page</a></li>
     </ul>
  </comment>
</member>
<member uid="2">
  <name>name2</name>
  <comment>Home Page: <link>http://www.bar.foo/</link></comment>
</member>
</members>
EOS

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<xt:template xmlns:xt="#{XTemplate::BIND_URI}">
<xt:expand id="//*[link]" strip="yes">
  <a href="@{link}" xt:id="."><xt:value-of id="link" /></a>
</xt:expand>

<members>
  <xt:copy-of id="/members" />
</members>

</xt:template>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
