require 'rubyunit'

require 'dpklib/dpkstd'
require 'dpklib/resource'

class TESTCASE_Resource < RUNIT::TestCase
  def setup
    @resource_loader = Dpklib::ResourceLoader.new
    
    Dpklib.local_load(__FILE__) do |localdir|
      for i in %w{dir1 dir2 dir3} do
	@resource_loader >> File.expand_path(i, localdir)
      end
    end
  end

  def test_find
    filepath = @resource_loader.find("test.rb")
    assert File.exist?(filepath)

    @resource_loader["test.rb"]
    assert_exception Dpklib::ResourceNotFoundError do
      @resource_loader["noexist"]
    end
  end

  def test_load
    @resource_loader.load "test.rb"
    @resource_loader.require "test"
    assert_not_nil defined?(RESOURCE_TEST_LOADED)
  end

end #/TESTCASE_Resource

