
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_eventlog.h"
#include "autoconf/librpc/gen_ndr/ndr_eventlog_c.h"

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject eventlog_OpenUnknown0_Type;
staticforward PyTypeObject eventlog_Record_tdb_Type;
staticforward PyTypeObject EVENTLOGHEADER_Type;
staticforward PyTypeObject EVENTLOGRECORD_Type;
staticforward PyTypeObject EVENTLOGEOF_Type;
staticforward PyTypeObject EVENTLOG_EVT_FILE_Type;
staticforward PyTypeObject EVENTLOG_FULL_INFORMATION_Type;
staticforward PyTypeObject eventlog_InterfaceType;

void initeventlog(void);static PyTypeObject *lsa_String_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *ClientConnection_Type;

static PyObject *py_eventlog_OpenUnknown0_get_unknown0(PyObject *obj, void *closure)
{
	struct eventlog_OpenUnknown0 *object = (struct eventlog_OpenUnknown0 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown0;
	py_unknown0 = PyInt_FromLong(object->unknown0);
	return py_unknown0;
}

static int py_eventlog_OpenUnknown0_set_unknown0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_OpenUnknown0 *object = (struct eventlog_OpenUnknown0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_OpenUnknown0_get_unknown1(PyObject *obj, void *closure)
{
	struct eventlog_OpenUnknown0 *object = (struct eventlog_OpenUnknown0 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_eventlog_OpenUnknown0_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_OpenUnknown0 *object = (struct eventlog_OpenUnknown0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_eventlog_OpenUnknown0_getsetters[] = {
	{ discard_const_p(char, "unknown0"), py_eventlog_OpenUnknown0_get_unknown0, py_eventlog_OpenUnknown0_set_unknown0 },
	{ discard_const_p(char, "unknown1"), py_eventlog_OpenUnknown0_get_unknown1, py_eventlog_OpenUnknown0_set_unknown1 },
	{ NULL }
};

static PyObject *py_eventlog_OpenUnknown0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct eventlog_OpenUnknown0, type);
}


static PyTypeObject eventlog_OpenUnknown0_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.OpenUnknown0",
	.tp_getset = py_eventlog_OpenUnknown0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_eventlog_OpenUnknown0_new,
};


static PyObject *py_eventlog_Record_tdb_get_size(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_eventlog_Record_tdb_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_reserved(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	if (object->reserved == NULL) {
		py_reserved = Py_None;
		Py_INCREF(py_reserved);
	} else {
		py_reserved = PyUnicode_Decode(object->reserved, strlen(object->reserved), "utf-8", "ignore");
	}
	return py_reserved;
}

static int py_eventlog_Record_tdb_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->reserved = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->reserved = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_record_number(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_record_number;
	py_record_number = PyInt_FromLong(object->record_number);
	return py_record_number;
}

static int py_eventlog_Record_tdb_set_record_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->record_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_time_generated(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_time_generated;
	py_time_generated = PyInt_FromLong(object->time_generated);
	return py_time_generated;
}

static int py_eventlog_Record_tdb_set_time_generated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->time_generated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_time_written(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_time_written;
	py_time_written = PyInt_FromLong(object->time_written);
	return py_time_written;
}

static int py_eventlog_Record_tdb_set_time_written(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->time_written = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_event_id(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_event_id;
	py_event_id = PyInt_FromLong(object->event_id);
	return py_event_id;
}

static int py_eventlog_Record_tdb_set_event_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->event_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_event_type(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_event_type;
	py_event_type = PyInt_FromLong(object->event_type);
	return py_event_type;
}

static int py_eventlog_Record_tdb_set_event_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->event_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->event_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_num_of_strings(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_num_of_strings;
	py_num_of_strings = PyInt_FromLong(object->num_of_strings);
	return py_num_of_strings;
}

static int py_eventlog_Record_tdb_set_num_of_strings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_of_strings = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_event_category(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_event_category;
	py_event_category = PyInt_FromLong(object->event_category);
	return py_event_category;
}

static int py_eventlog_Record_tdb_set_event_category(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->event_category = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_reserved_flags(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_reserved_flags;
	py_reserved_flags = PyInt_FromLong(object->reserved_flags);
	return py_reserved_flags;
}

static int py_eventlog_Record_tdb_set_reserved_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_closing_record_number(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_closing_record_number;
	py_closing_record_number = PyInt_FromLong(object->closing_record_number);
	return py_closing_record_number;
}

static int py_eventlog_Record_tdb_set_closing_record_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->closing_record_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_stringoffset(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_stringoffset;
	py_stringoffset = PyInt_FromLong(object->stringoffset);
	return py_stringoffset;
}

static int py_eventlog_Record_tdb_set_stringoffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->stringoffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_sid_length(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_sid_length;
	py_sid_length = PyInt_FromLong(object->sid_length);
	return py_sid_length;
}

static int py_eventlog_Record_tdb_set_sid_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_sid_offset(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_sid_offset;
	py_sid_offset = PyInt_FromLong(object->sid_offset);
	return py_sid_offset;
}

static int py_eventlog_Record_tdb_set_sid_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_data_length(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_data_length;
	py_data_length = PyInt_FromLong(object->data_length);
	return py_data_length;
}

static int py_eventlog_Record_tdb_set_data_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_data_offset(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_data_offset;
	py_data_offset = PyInt_FromLong(object->data_offset);
	return py_data_offset;
}

static int py_eventlog_Record_tdb_set_data_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_source_name_len(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_source_name_len;
	py_source_name_len = PyInt_FromLong(object->source_name_len);
	return py_source_name_len;
}

static int py_eventlog_Record_tdb_set_source_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->source_name_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_source_name(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_source_name;
	py_source_name = PyString_FromStringOrNULL(object->source_name);
	return py_source_name;
}

static int py_eventlog_Record_tdb_set_source_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	object->source_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_computer_name_len(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_computer_name_len;
	py_computer_name_len = PyInt_FromLong(object->computer_name_len);
	return py_computer_name_len;
}

static int py_eventlog_Record_tdb_set_computer_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->computer_name_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_computer_name(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromStringOrNULL(object->computer_name);
	return py_computer_name;
}

static int py_eventlog_Record_tdb_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	object->computer_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_sid_padding(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_sid_padding;
	py_sid_padding = PyInt_FromLong(object->sid_padding);
	return py_sid_padding;
}

static int py_eventlog_Record_tdb_set_sid_padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_padding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_sid(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = PyString_FromStringAndSize((char *)(object->sid).data, (object->sid).length);
	return py_sid;
}

static int py_eventlog_Record_tdb_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	object->sid = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_strings_len(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_strings_len;
	py_strings_len = PyInt_FromLong(object->strings_len);
	return py_strings_len;
}

static int py_eventlog_Record_tdb_set_strings_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->strings_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_strings(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_strings;
	py_strings = PyList_New(object->num_of_strings);
	if (py_strings == NULL) {
		return NULL;
	}
	{
		int strings_cntr_0;
		for (strings_cntr_0 = 0; strings_cntr_0 < object->num_of_strings; strings_cntr_0++) {
			PyObject *py_strings_0;
			py_strings_0 = PyString_FromStringOrNULL(object->strings[strings_cntr_0]);
			PyList_SetItem(py_strings, strings_cntr_0, py_strings_0);
		}
	}
	return py_strings;
}

static int py_eventlog_Record_tdb_set_strings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int strings_cntr_0;
		object->strings = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->strings, PyList_GET_SIZE(value));
		if (!object->strings) { return -1;; }
		talloc_set_name_const(object->strings, "ARRAY: object->strings");
		for (strings_cntr_0 = 0; strings_cntr_0 < PyList_GET_SIZE(value); strings_cntr_0++) {
			object->strings[strings_cntr_0] = talloc_strdup(object->strings, PyString_AS_STRING(PyList_GET_ITEM(value, strings_cntr_0)));
		}
	}
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_data(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyString_FromStringAndSize((char *)(object->data).data, (object->data).length);
	return py_data;
}

static int py_eventlog_Record_tdb_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	object->data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_eventlog_Record_tdb_get_padding(PyObject *obj, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(obj);
	PyObject *py_padding;
	py_padding = PyInt_FromLong(object->padding);
	return py_padding;
}

static int py_eventlog_Record_tdb_set_padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->padding = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_eventlog_Record_tdb_getsetters[] = {
	{ discard_const_p(char, "size"), py_eventlog_Record_tdb_get_size, py_eventlog_Record_tdb_set_size },
	{ discard_const_p(char, "reserved"), py_eventlog_Record_tdb_get_reserved, py_eventlog_Record_tdb_set_reserved },
	{ discard_const_p(char, "record_number"), py_eventlog_Record_tdb_get_record_number, py_eventlog_Record_tdb_set_record_number },
	{ discard_const_p(char, "time_generated"), py_eventlog_Record_tdb_get_time_generated, py_eventlog_Record_tdb_set_time_generated },
	{ discard_const_p(char, "time_written"), py_eventlog_Record_tdb_get_time_written, py_eventlog_Record_tdb_set_time_written },
	{ discard_const_p(char, "event_id"), py_eventlog_Record_tdb_get_event_id, py_eventlog_Record_tdb_set_event_id },
	{ discard_const_p(char, "event_type"), py_eventlog_Record_tdb_get_event_type, py_eventlog_Record_tdb_set_event_type },
	{ discard_const_p(char, "num_of_strings"), py_eventlog_Record_tdb_get_num_of_strings, py_eventlog_Record_tdb_set_num_of_strings },
	{ discard_const_p(char, "event_category"), py_eventlog_Record_tdb_get_event_category, py_eventlog_Record_tdb_set_event_category },
	{ discard_const_p(char, "reserved_flags"), py_eventlog_Record_tdb_get_reserved_flags, py_eventlog_Record_tdb_set_reserved_flags },
	{ discard_const_p(char, "closing_record_number"), py_eventlog_Record_tdb_get_closing_record_number, py_eventlog_Record_tdb_set_closing_record_number },
	{ discard_const_p(char, "stringoffset"), py_eventlog_Record_tdb_get_stringoffset, py_eventlog_Record_tdb_set_stringoffset },
	{ discard_const_p(char, "sid_length"), py_eventlog_Record_tdb_get_sid_length, py_eventlog_Record_tdb_set_sid_length },
	{ discard_const_p(char, "sid_offset"), py_eventlog_Record_tdb_get_sid_offset, py_eventlog_Record_tdb_set_sid_offset },
	{ discard_const_p(char, "data_length"), py_eventlog_Record_tdb_get_data_length, py_eventlog_Record_tdb_set_data_length },
	{ discard_const_p(char, "data_offset"), py_eventlog_Record_tdb_get_data_offset, py_eventlog_Record_tdb_set_data_offset },
	{ discard_const_p(char, "source_name_len"), py_eventlog_Record_tdb_get_source_name_len, py_eventlog_Record_tdb_set_source_name_len },
	{ discard_const_p(char, "source_name"), py_eventlog_Record_tdb_get_source_name, py_eventlog_Record_tdb_set_source_name },
	{ discard_const_p(char, "computer_name_len"), py_eventlog_Record_tdb_get_computer_name_len, py_eventlog_Record_tdb_set_computer_name_len },
	{ discard_const_p(char, "computer_name"), py_eventlog_Record_tdb_get_computer_name, py_eventlog_Record_tdb_set_computer_name },
	{ discard_const_p(char, "sid_padding"), py_eventlog_Record_tdb_get_sid_padding, py_eventlog_Record_tdb_set_sid_padding },
	{ discard_const_p(char, "sid"), py_eventlog_Record_tdb_get_sid, py_eventlog_Record_tdb_set_sid },
	{ discard_const_p(char, "strings_len"), py_eventlog_Record_tdb_get_strings_len, py_eventlog_Record_tdb_set_strings_len },
	{ discard_const_p(char, "strings"), py_eventlog_Record_tdb_get_strings, py_eventlog_Record_tdb_set_strings },
	{ discard_const_p(char, "data"), py_eventlog_Record_tdb_get_data, py_eventlog_Record_tdb_set_data },
	{ discard_const_p(char, "padding"), py_eventlog_Record_tdb_get_padding, py_eventlog_Record_tdb_set_padding },
	{ NULL }
};

static PyObject *py_eventlog_Record_tdb_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct eventlog_Record_tdb, type);
}

static PyObject *py_eventlog_Record_tdb_ndr_pack(PyObject *py_obj)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_eventlog_Record_tdb);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_eventlog_Record_tdb_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_eventlog_Record_tdb);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_eventlog_Record_tdb);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_eventlog_Record_tdb_ndr_print(PyObject *py_obj)
{
	struct eventlog_Record_tdb *object = (struct eventlog_Record_tdb *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_eventlog_Record_tdb, "eventlog_Record_tdb", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_eventlog_Record_tdb_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_eventlog_Record_tdb_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_eventlog_Record_tdb_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_eventlog_Record_tdb_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject eventlog_Record_tdb_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.Record_tdb",
	.tp_getset = py_eventlog_Record_tdb_getsetters,
	.tp_methods = py_eventlog_Record_tdb_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_eventlog_Record_tdb_new,
};


static PyObject *py_EVENTLOGHEADER_get_HeaderSize(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_HeaderSize;
	py_HeaderSize = PyInt_FromLong(object->HeaderSize);
	return py_HeaderSize;
}

static int py_EVENTLOGHEADER_set_HeaderSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->HeaderSize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_Signature(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	if (object->Signature == NULL) {
		py_Signature = Py_None;
		Py_INCREF(py_Signature);
	} else {
		py_Signature = PyUnicode_Decode(object->Signature, strlen(object->Signature), "utf-8", "ignore");
	}
	return py_Signature;
}

static int py_EVENTLOGHEADER_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->Signature = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->Signature = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_MajorVersion(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_MajorVersion;
	py_MajorVersion = PyInt_FromLong(object->MajorVersion);
	return py_MajorVersion;
}

static int py_EVENTLOGHEADER_set_MajorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MajorVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_MinorVersion(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_MinorVersion;
	py_MinorVersion = PyInt_FromLong(object->MinorVersion);
	return py_MinorVersion;
}

static int py_EVENTLOGHEADER_set_MinorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MinorVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_StartOffset(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_StartOffset;
	py_StartOffset = PyInt_FromLong(object->StartOffset);
	return py_StartOffset;
}

static int py_EVENTLOGHEADER_set_StartOffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->StartOffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_EndOffset(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_EndOffset;
	py_EndOffset = PyInt_FromLong(object->EndOffset);
	return py_EndOffset;
}

static int py_EVENTLOGHEADER_set_EndOffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->EndOffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_CurrentRecordNumber(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_CurrentRecordNumber;
	py_CurrentRecordNumber = PyInt_FromLong(object->CurrentRecordNumber);
	return py_CurrentRecordNumber;
}

static int py_EVENTLOGHEADER_set_CurrentRecordNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->CurrentRecordNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_OldestRecordNumber(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_OldestRecordNumber;
	py_OldestRecordNumber = PyInt_FromLong(object->OldestRecordNumber);
	return py_OldestRecordNumber;
}

static int py_EVENTLOGHEADER_set_OldestRecordNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OldestRecordNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_MaxSize(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_MaxSize;
	py_MaxSize = PyInt_FromLong(object->MaxSize);
	return py_MaxSize;
}

static int py_EVENTLOGHEADER_set_MaxSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MaxSize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_Flags(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_EVENTLOGHEADER_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->Flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->Flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_Retention(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_Retention;
	py_Retention = PyInt_FromLong(object->Retention);
	return py_Retention;
}

static int py_EVENTLOGHEADER_set_Retention(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Retention = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGHEADER_get_EndHeaderSize(PyObject *obj, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(obj);
	PyObject *py_EndHeaderSize;
	py_EndHeaderSize = PyInt_FromLong(object->EndHeaderSize);
	return py_EndHeaderSize;
}

static int py_EVENTLOGHEADER_set_EndHeaderSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->EndHeaderSize = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_EVENTLOGHEADER_getsetters[] = {
	{ discard_const_p(char, "HeaderSize"), py_EVENTLOGHEADER_get_HeaderSize, py_EVENTLOGHEADER_set_HeaderSize },
	{ discard_const_p(char, "Signature"), py_EVENTLOGHEADER_get_Signature, py_EVENTLOGHEADER_set_Signature },
	{ discard_const_p(char, "MajorVersion"), py_EVENTLOGHEADER_get_MajorVersion, py_EVENTLOGHEADER_set_MajorVersion },
	{ discard_const_p(char, "MinorVersion"), py_EVENTLOGHEADER_get_MinorVersion, py_EVENTLOGHEADER_set_MinorVersion },
	{ discard_const_p(char, "StartOffset"), py_EVENTLOGHEADER_get_StartOffset, py_EVENTLOGHEADER_set_StartOffset },
	{ discard_const_p(char, "EndOffset"), py_EVENTLOGHEADER_get_EndOffset, py_EVENTLOGHEADER_set_EndOffset },
	{ discard_const_p(char, "CurrentRecordNumber"), py_EVENTLOGHEADER_get_CurrentRecordNumber, py_EVENTLOGHEADER_set_CurrentRecordNumber },
	{ discard_const_p(char, "OldestRecordNumber"), py_EVENTLOGHEADER_get_OldestRecordNumber, py_EVENTLOGHEADER_set_OldestRecordNumber },
	{ discard_const_p(char, "MaxSize"), py_EVENTLOGHEADER_get_MaxSize, py_EVENTLOGHEADER_set_MaxSize },
	{ discard_const_p(char, "Flags"), py_EVENTLOGHEADER_get_Flags, py_EVENTLOGHEADER_set_Flags },
	{ discard_const_p(char, "Retention"), py_EVENTLOGHEADER_get_Retention, py_EVENTLOGHEADER_set_Retention },
	{ discard_const_p(char, "EndHeaderSize"), py_EVENTLOGHEADER_get_EndHeaderSize, py_EVENTLOGHEADER_set_EndHeaderSize },
	{ NULL }
};

static PyObject *py_EVENTLOGHEADER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EVENTLOGHEADER, type);
}

static PyObject *py_EVENTLOGHEADER_ndr_pack(PyObject *py_obj)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_EVENTLOGHEADER);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_EVENTLOGHEADER_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOGHEADER);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOGHEADER);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EVENTLOGHEADER_ndr_print(PyObject *py_obj)
{
	struct EVENTLOGHEADER *object = (struct EVENTLOGHEADER *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EVENTLOGHEADER, "EVENTLOGHEADER", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EVENTLOGHEADER_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EVENTLOGHEADER_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_EVENTLOGHEADER_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_EVENTLOGHEADER_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EVENTLOGHEADER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.EVENTLOGHEADER",
	.tp_getset = py_EVENTLOGHEADER_getsetters,
	.tp_methods = py_EVENTLOGHEADER_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_EVENTLOGHEADER_new,
};


static PyObject *py_EVENTLOGRECORD_get_Length(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_Length;
	py_Length = PyInt_FromLong(object->Length);
	return py_Length;
}

static int py_EVENTLOGRECORD_set_Length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_Reserved(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_Reserved;
	if (object->Reserved == NULL) {
		py_Reserved = Py_None;
		Py_INCREF(py_Reserved);
	} else {
		py_Reserved = PyUnicode_Decode(object->Reserved, strlen(object->Reserved), "utf-8", "ignore");
	}
	return py_Reserved;
}

static int py_EVENTLOGRECORD_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->Reserved = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->Reserved = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_RecordNumber(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_RecordNumber;
	py_RecordNumber = PyInt_FromLong(object->RecordNumber);
	return py_RecordNumber;
}

static int py_EVENTLOGRECORD_set_RecordNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->RecordNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_TimeGenerated(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_TimeGenerated;
	py_TimeGenerated = PyInt_FromLong(object->TimeGenerated);
	return py_TimeGenerated;
}

static int py_EVENTLOGRECORD_set_TimeGenerated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->TimeGenerated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_TimeWritten(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_TimeWritten;
	py_TimeWritten = PyInt_FromLong(object->TimeWritten);
	return py_TimeWritten;
}

static int py_EVENTLOGRECORD_set_TimeWritten(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->TimeWritten = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_EventID(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_EventID;
	py_EventID = PyInt_FromLong(object->EventID);
	return py_EventID;
}

static int py_EVENTLOGRECORD_set_EventID(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->EventID = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_EventType(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_EventType;
	py_EventType = PyInt_FromLong(object->EventType);
	return py_EventType;
}

static int py_EVENTLOGRECORD_set_EventType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->EventType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->EventType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_NumStrings(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_NumStrings;
	py_NumStrings = PyInt_FromLong(object->NumStrings);
	return py_NumStrings;
}

static int py_EVENTLOGRECORD_set_NumStrings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NumStrings = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_EventCategory(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_EventCategory;
	py_EventCategory = PyInt_FromLong(object->EventCategory);
	return py_EventCategory;
}

static int py_EVENTLOGRECORD_set_EventCategory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->EventCategory = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_ReservedFlags(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_ReservedFlags;
	py_ReservedFlags = PyInt_FromLong(object->ReservedFlags);
	return py_ReservedFlags;
}

static int py_EVENTLOGRECORD_set_ReservedFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ReservedFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_ClosingRecordNumber(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_ClosingRecordNumber;
	py_ClosingRecordNumber = PyInt_FromLong(object->ClosingRecordNumber);
	return py_ClosingRecordNumber;
}

static int py_EVENTLOGRECORD_set_ClosingRecordNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ClosingRecordNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_StringOffset(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_StringOffset;
	py_StringOffset = PyInt_FromLong(object->StringOffset);
	return py_StringOffset;
}

static int py_EVENTLOGRECORD_set_StringOffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->StringOffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_UserSidLength(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_UserSidLength;
	py_UserSidLength = PyInt_FromLong(object->UserSidLength);
	return py_UserSidLength;
}

static int py_EVENTLOGRECORD_set_UserSidLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UserSidLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_UserSidOffset(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_UserSidOffset;
	py_UserSidOffset = PyInt_FromLong(object->UserSidOffset);
	return py_UserSidOffset;
}

static int py_EVENTLOGRECORD_set_UserSidOffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UserSidOffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_DataLength(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_DataLength;
	py_DataLength = PyInt_FromLong(object->DataLength);
	return py_DataLength;
}

static int py_EVENTLOGRECORD_set_DataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DataLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_DataOffset(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_DataOffset;
	py_DataOffset = PyInt_FromLong(object->DataOffset);
	return py_DataOffset;
}

static int py_EVENTLOGRECORD_set_DataOffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DataOffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_SourceName(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_SourceName;
	py_SourceName = PyString_FromStringOrNULL(object->SourceName);
	return py_SourceName;
}

static int py_EVENTLOGRECORD_set_SourceName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	object->SourceName = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_Computername(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_Computername;
	py_Computername = PyString_FromStringOrNULL(object->Computername);
	return py_Computername;
}

static int py_EVENTLOGRECORD_set_Computername(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	object->Computername = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_UserSid(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_UserSid;
	py_UserSid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->UserSid);
	return py_UserSid;
}

static int py_EVENTLOGRECORD_set_UserSid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->UserSid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_Strings(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_Strings;
	py_Strings = PyList_New(object->NumStrings);
	if (py_Strings == NULL) {
		return NULL;
	}
	{
		int Strings_cntr_0;
		for (Strings_cntr_0 = 0; Strings_cntr_0 < object->NumStrings; Strings_cntr_0++) {
			PyObject *py_Strings_0;
			py_Strings_0 = PyString_FromStringOrNULL(object->Strings[Strings_cntr_0]);
			PyList_SetItem(py_Strings, Strings_cntr_0, py_Strings_0);
		}
	}
	return py_Strings;
}

static int py_EVENTLOGRECORD_set_Strings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Strings_cntr_0;
		object->Strings = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Strings, PyList_GET_SIZE(value));
		if (!object->Strings) { return -1;; }
		talloc_set_name_const(object->Strings, "ARRAY: object->Strings");
		for (Strings_cntr_0 = 0; Strings_cntr_0 < PyList_GET_SIZE(value); Strings_cntr_0++) {
			object->Strings[Strings_cntr_0] = talloc_strdup(object->Strings, PyString_AS_STRING(PyList_GET_ITEM(value, Strings_cntr_0)));
		}
	}
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_Data(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_Data;
	py_Data = PyList_New(object->DataLength);
	if (py_Data == NULL) {
		return NULL;
	}
	{
		int Data_cntr_0;
		for (Data_cntr_0 = 0; Data_cntr_0 < object->DataLength; Data_cntr_0++) {
			PyObject *py_Data_0;
			py_Data_0 = PyInt_FromLong(object->Data[Data_cntr_0]);
			PyList_SetItem(py_Data, Data_cntr_0, py_Data_0);
		}
	}
	return py_Data;
}

static int py_EVENTLOGRECORD_set_Data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Data_cntr_0;
		object->Data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Data, PyList_GET_SIZE(value));
		if (!object->Data) { return -1;; }
		talloc_set_name_const(object->Data, "ARRAY: object->Data");
		for (Data_cntr_0 = 0; Data_cntr_0 < PyList_GET_SIZE(value); Data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Data_cntr_0), return -1;);
			object->Data[Data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Data_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_Pad(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_Pad;
	py_Pad = PyString_FromStringOrNULL(object->Pad);
	return py_Pad;
}

static int py_EVENTLOGRECORD_set_Pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	object->Pad = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_EVENTLOGRECORD_get_Length2(PyObject *obj, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(obj);
	PyObject *py_Length2;
	py_Length2 = PyInt_FromLong(object->Length2);
	return py_Length2;
}

static int py_EVENTLOGRECORD_set_Length2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Length2 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_EVENTLOGRECORD_getsetters[] = {
	{ discard_const_p(char, "Length"), py_EVENTLOGRECORD_get_Length, py_EVENTLOGRECORD_set_Length },
	{ discard_const_p(char, "Reserved"), py_EVENTLOGRECORD_get_Reserved, py_EVENTLOGRECORD_set_Reserved },
	{ discard_const_p(char, "RecordNumber"), py_EVENTLOGRECORD_get_RecordNumber, py_EVENTLOGRECORD_set_RecordNumber },
	{ discard_const_p(char, "TimeGenerated"), py_EVENTLOGRECORD_get_TimeGenerated, py_EVENTLOGRECORD_set_TimeGenerated },
	{ discard_const_p(char, "TimeWritten"), py_EVENTLOGRECORD_get_TimeWritten, py_EVENTLOGRECORD_set_TimeWritten },
	{ discard_const_p(char, "EventID"), py_EVENTLOGRECORD_get_EventID, py_EVENTLOGRECORD_set_EventID },
	{ discard_const_p(char, "EventType"), py_EVENTLOGRECORD_get_EventType, py_EVENTLOGRECORD_set_EventType },
	{ discard_const_p(char, "NumStrings"), py_EVENTLOGRECORD_get_NumStrings, py_EVENTLOGRECORD_set_NumStrings },
	{ discard_const_p(char, "EventCategory"), py_EVENTLOGRECORD_get_EventCategory, py_EVENTLOGRECORD_set_EventCategory },
	{ discard_const_p(char, "ReservedFlags"), py_EVENTLOGRECORD_get_ReservedFlags, py_EVENTLOGRECORD_set_ReservedFlags },
	{ discard_const_p(char, "ClosingRecordNumber"), py_EVENTLOGRECORD_get_ClosingRecordNumber, py_EVENTLOGRECORD_set_ClosingRecordNumber },
	{ discard_const_p(char, "StringOffset"), py_EVENTLOGRECORD_get_StringOffset, py_EVENTLOGRECORD_set_StringOffset },
	{ discard_const_p(char, "UserSidLength"), py_EVENTLOGRECORD_get_UserSidLength, py_EVENTLOGRECORD_set_UserSidLength },
	{ discard_const_p(char, "UserSidOffset"), py_EVENTLOGRECORD_get_UserSidOffset, py_EVENTLOGRECORD_set_UserSidOffset },
	{ discard_const_p(char, "DataLength"), py_EVENTLOGRECORD_get_DataLength, py_EVENTLOGRECORD_set_DataLength },
	{ discard_const_p(char, "DataOffset"), py_EVENTLOGRECORD_get_DataOffset, py_EVENTLOGRECORD_set_DataOffset },
	{ discard_const_p(char, "SourceName"), py_EVENTLOGRECORD_get_SourceName, py_EVENTLOGRECORD_set_SourceName },
	{ discard_const_p(char, "Computername"), py_EVENTLOGRECORD_get_Computername, py_EVENTLOGRECORD_set_Computername },
	{ discard_const_p(char, "UserSid"), py_EVENTLOGRECORD_get_UserSid, py_EVENTLOGRECORD_set_UserSid },
	{ discard_const_p(char, "Strings"), py_EVENTLOGRECORD_get_Strings, py_EVENTLOGRECORD_set_Strings },
	{ discard_const_p(char, "Data"), py_EVENTLOGRECORD_get_Data, py_EVENTLOGRECORD_set_Data },
	{ discard_const_p(char, "Pad"), py_EVENTLOGRECORD_get_Pad, py_EVENTLOGRECORD_set_Pad },
	{ discard_const_p(char, "Length2"), py_EVENTLOGRECORD_get_Length2, py_EVENTLOGRECORD_set_Length2 },
	{ NULL }
};

static PyObject *py_EVENTLOGRECORD_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EVENTLOGRECORD, type);
}

static PyObject *py_EVENTLOGRECORD_ndr_pack(PyObject *py_obj)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_EVENTLOGRECORD);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_EVENTLOGRECORD_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOGRECORD);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOGRECORD);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EVENTLOGRECORD_ndr_print(PyObject *py_obj)
{
	struct EVENTLOGRECORD *object = (struct EVENTLOGRECORD *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EVENTLOGRECORD, "EVENTLOGRECORD", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EVENTLOGRECORD_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EVENTLOGRECORD_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_EVENTLOGRECORD_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_EVENTLOGRECORD_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EVENTLOGRECORD_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.EVENTLOGRECORD",
	.tp_getset = py_EVENTLOGRECORD_getsetters,
	.tp_methods = py_EVENTLOGRECORD_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_EVENTLOGRECORD_new,
};


static PyObject *py_EVENTLOGEOF_get_RecordSizeBeginning(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_RecordSizeBeginning;
	py_RecordSizeBeginning = PyInt_FromLong(object->RecordSizeBeginning);
	return py_RecordSizeBeginning;
}

static int py_EVENTLOGEOF_set_RecordSizeBeginning(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->RecordSizeBeginning = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_One(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_One;
	py_One = PyInt_FromLong(object->One);
	return py_One;
}

static int py_EVENTLOGEOF_set_One(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->One = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_Two(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_Two;
	py_Two = PyInt_FromLong(object->Two);
	return py_Two;
}

static int py_EVENTLOGEOF_set_Two(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Two = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_Three(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_Three;
	py_Three = PyInt_FromLong(object->Three);
	return py_Three;
}

static int py_EVENTLOGEOF_set_Three(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Three = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_Four(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_Four;
	py_Four = PyInt_FromLong(object->Four);
	return py_Four;
}

static int py_EVENTLOGEOF_set_Four(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Four = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_BeginRecord(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_BeginRecord;
	py_BeginRecord = PyInt_FromLong(object->BeginRecord);
	return py_BeginRecord;
}

static int py_EVENTLOGEOF_set_BeginRecord(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BeginRecord = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_EndRecord(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_EndRecord;
	py_EndRecord = PyInt_FromLong(object->EndRecord);
	return py_EndRecord;
}

static int py_EVENTLOGEOF_set_EndRecord(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->EndRecord = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_CurrentRecordNumber(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_CurrentRecordNumber;
	py_CurrentRecordNumber = PyInt_FromLong(object->CurrentRecordNumber);
	return py_CurrentRecordNumber;
}

static int py_EVENTLOGEOF_set_CurrentRecordNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->CurrentRecordNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_OldestRecordNumber(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_OldestRecordNumber;
	py_OldestRecordNumber = PyInt_FromLong(object->OldestRecordNumber);
	return py_OldestRecordNumber;
}

static int py_EVENTLOGEOF_set_OldestRecordNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OldestRecordNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_EVENTLOGEOF_get_RecordSizeEnd(PyObject *obj, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(obj);
	PyObject *py_RecordSizeEnd;
	py_RecordSizeEnd = PyInt_FromLong(object->RecordSizeEnd);
	return py_RecordSizeEnd;
}

static int py_EVENTLOGEOF_set_RecordSizeEnd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->RecordSizeEnd = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_EVENTLOGEOF_getsetters[] = {
	{ discard_const_p(char, "RecordSizeBeginning"), py_EVENTLOGEOF_get_RecordSizeBeginning, py_EVENTLOGEOF_set_RecordSizeBeginning },
	{ discard_const_p(char, "One"), py_EVENTLOGEOF_get_One, py_EVENTLOGEOF_set_One },
	{ discard_const_p(char, "Two"), py_EVENTLOGEOF_get_Two, py_EVENTLOGEOF_set_Two },
	{ discard_const_p(char, "Three"), py_EVENTLOGEOF_get_Three, py_EVENTLOGEOF_set_Three },
	{ discard_const_p(char, "Four"), py_EVENTLOGEOF_get_Four, py_EVENTLOGEOF_set_Four },
	{ discard_const_p(char, "BeginRecord"), py_EVENTLOGEOF_get_BeginRecord, py_EVENTLOGEOF_set_BeginRecord },
	{ discard_const_p(char, "EndRecord"), py_EVENTLOGEOF_get_EndRecord, py_EVENTLOGEOF_set_EndRecord },
	{ discard_const_p(char, "CurrentRecordNumber"), py_EVENTLOGEOF_get_CurrentRecordNumber, py_EVENTLOGEOF_set_CurrentRecordNumber },
	{ discard_const_p(char, "OldestRecordNumber"), py_EVENTLOGEOF_get_OldestRecordNumber, py_EVENTLOGEOF_set_OldestRecordNumber },
	{ discard_const_p(char, "RecordSizeEnd"), py_EVENTLOGEOF_get_RecordSizeEnd, py_EVENTLOGEOF_set_RecordSizeEnd },
	{ NULL }
};

static PyObject *py_EVENTLOGEOF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EVENTLOGEOF, type);
}

static PyObject *py_EVENTLOGEOF_ndr_pack(PyObject *py_obj)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_EVENTLOGEOF);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_EVENTLOGEOF_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOGEOF);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOGEOF);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EVENTLOGEOF_ndr_print(PyObject *py_obj)
{
	struct EVENTLOGEOF *object = (struct EVENTLOGEOF *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EVENTLOGEOF, "EVENTLOGEOF", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EVENTLOGEOF_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EVENTLOGEOF_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_EVENTLOGEOF_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_EVENTLOGEOF_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EVENTLOGEOF_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.EVENTLOGEOF",
	.tp_getset = py_EVENTLOGEOF_getsetters,
	.tp_methods = py_EVENTLOGEOF_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_EVENTLOGEOF_new,
};


static PyObject *py_EVENTLOG_EVT_FILE_get_hdr(PyObject *obj, void *closure)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(obj);
	PyObject *py_hdr;
	py_hdr = pytalloc_reference_ex(&EVENTLOGHEADER_Type, pytalloc_get_mem_ctx(obj), &object->hdr);
	return py_hdr;
}

static int py_EVENTLOG_EVT_FILE_set_hdr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&EVENTLOGHEADER_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->hdr = *(struct EVENTLOGHEADER *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_EVENTLOG_EVT_FILE_get_records(PyObject *obj, void *closure)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(obj);
	PyObject *py_records;
	py_records = PyList_New(object->hdr.CurrentRecordNumber - object->hdr.OldestRecordNumber);
	if (py_records == NULL) {
		return NULL;
	}
	{
		int records_cntr_0;
		for (records_cntr_0 = 0; records_cntr_0 < object->hdr.CurrentRecordNumber - object->hdr.OldestRecordNumber; records_cntr_0++) {
			PyObject *py_records_0;
			py_records_0 = pytalloc_reference_ex(&EVENTLOGRECORD_Type, object->records, &object->records[records_cntr_0]);
			PyList_SetItem(py_records, records_cntr_0, py_records_0);
		}
	}
	return py_records;
}

static int py_EVENTLOG_EVT_FILE_set_records(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int records_cntr_0;
		object->records = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->records, PyList_GET_SIZE(value));
		if (!object->records) { return -1;; }
		talloc_set_name_const(object->records, "ARRAY: object->records");
		for (records_cntr_0 = 0; records_cntr_0 < PyList_GET_SIZE(value); records_cntr_0++) {
			PY_CHECK_TYPE(&EVENTLOGRECORD_Type, PyList_GET_ITEM(value, records_cntr_0), return -1;);
			if (talloc_reference(object->records, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, records_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->records[records_cntr_0] = *(struct EVENTLOGRECORD *)pytalloc_get_ptr(PyList_GET_ITEM(value, records_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_EVENTLOG_EVT_FILE_get_eof(PyObject *obj, void *closure)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(obj);
	PyObject *py_eof;
	py_eof = pytalloc_reference_ex(&EVENTLOGEOF_Type, pytalloc_get_mem_ctx(obj), &object->eof);
	return py_eof;
}

static int py_EVENTLOG_EVT_FILE_set_eof(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&EVENTLOGEOF_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->eof = *(struct EVENTLOGEOF *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_EVENTLOG_EVT_FILE_getsetters[] = {
	{ discard_const_p(char, "hdr"), py_EVENTLOG_EVT_FILE_get_hdr, py_EVENTLOG_EVT_FILE_set_hdr },
	{ discard_const_p(char, "records"), py_EVENTLOG_EVT_FILE_get_records, py_EVENTLOG_EVT_FILE_set_records },
	{ discard_const_p(char, "eof"), py_EVENTLOG_EVT_FILE_get_eof, py_EVENTLOG_EVT_FILE_set_eof },
	{ NULL }
};

static PyObject *py_EVENTLOG_EVT_FILE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EVENTLOG_EVT_FILE, type);
}

static PyObject *py_EVENTLOG_EVT_FILE_ndr_pack(PyObject *py_obj)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_EVENTLOG_EVT_FILE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_EVENTLOG_EVT_FILE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOG_EVT_FILE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOG_EVT_FILE);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EVENTLOG_EVT_FILE_ndr_print(PyObject *py_obj)
{
	struct EVENTLOG_EVT_FILE *object = (struct EVENTLOG_EVT_FILE *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EVENTLOG_EVT_FILE, "EVENTLOG_EVT_FILE", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EVENTLOG_EVT_FILE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EVENTLOG_EVT_FILE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_EVENTLOG_EVT_FILE_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_EVENTLOG_EVT_FILE_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EVENTLOG_EVT_FILE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.EVENTLOG_EVT_FILE",
	.tp_getset = py_EVENTLOG_EVT_FILE_getsetters,
	.tp_methods = py_EVENTLOG_EVT_FILE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_EVENTLOG_EVT_FILE_new,
};


static PyObject *py_EVENTLOG_FULL_INFORMATION_get_full(PyObject *obj, void *closure)
{
	struct EVENTLOG_FULL_INFORMATION *object = (struct EVENTLOG_FULL_INFORMATION *)pytalloc_get_ptr(obj);
	PyObject *py_full;
	py_full = PyInt_FromLong(object->full);
	return py_full;
}

static int py_EVENTLOG_FULL_INFORMATION_set_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EVENTLOG_FULL_INFORMATION *object = (struct EVENTLOG_FULL_INFORMATION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->full = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_EVENTLOG_FULL_INFORMATION_getsetters[] = {
	{ discard_const_p(char, "full"), py_EVENTLOG_FULL_INFORMATION_get_full, py_EVENTLOG_FULL_INFORMATION_set_full },
	{ NULL }
};

static PyObject *py_EVENTLOG_FULL_INFORMATION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EVENTLOG_FULL_INFORMATION, type);
}

static PyObject *py_EVENTLOG_FULL_INFORMATION_ndr_pack(PyObject *py_obj)
{
	struct EVENTLOG_FULL_INFORMATION *object = (struct EVENTLOG_FULL_INFORMATION *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_EVENTLOG_FULL_INFORMATION);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_EVENTLOG_FULL_INFORMATION_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EVENTLOG_FULL_INFORMATION *object = (struct EVENTLOG_FULL_INFORMATION *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOG_FULL_INFORMATION);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EVENTLOG_FULL_INFORMATION);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EVENTLOG_FULL_INFORMATION_ndr_print(PyObject *py_obj)
{
	struct EVENTLOG_FULL_INFORMATION *object = (struct EVENTLOG_FULL_INFORMATION *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EVENTLOG_FULL_INFORMATION, "EVENTLOG_FULL_INFORMATION", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EVENTLOG_FULL_INFORMATION_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EVENTLOG_FULL_INFORMATION_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_EVENTLOG_FULL_INFORMATION_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_EVENTLOG_FULL_INFORMATION_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EVENTLOG_FULL_INFORMATION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.EVENTLOG_FULL_INFORMATION",
	.tp_getset = py_EVENTLOG_FULL_INFORMATION_getsetters,
	.tp_methods = py_EVENTLOG_FULL_INFORMATION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_EVENTLOG_FULL_INFORMATION_new,
};


static bool pack_py_eventlog_ClearEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_ClearEventLogW *r)
{
	PyObject *py_handle;
	PyObject *py_backupfile;
	const char *kwnames[] = {
		"handle", "backupfile", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog_ClearEventLogW", discard_const_p(char *, kwnames), &py_handle, &py_backupfile)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_backupfile == Py_None) {
		r->in.backupfile = NULL;
	} else {
		r->in.backupfile = NULL;
		PY_CHECK_TYPE(lsa_String_Type, py_backupfile, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_backupfile)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.backupfile = (struct lsa_String *)pytalloc_get_ptr(py_backupfile);
	}
	return true;
}

static PyObject *unpack_py_eventlog_ClearEventLogW_args_out(struct eventlog_ClearEventLogW *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_BackupEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_BackupEventLogW *r)
{
	PyObject *py_handle;
	PyObject *py_backup_filename;
	const char *kwnames[] = {
		"handle", "backup_filename", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog_BackupEventLogW", discard_const_p(char *, kwnames), &py_handle, &py_backup_filename)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.backup_filename = talloc_ptrtype(r, r->in.backup_filename);
	PY_CHECK_TYPE(lsa_String_Type, py_backup_filename, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_backup_filename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.backup_filename = (struct lsa_String *)pytalloc_get_ptr(py_backup_filename);
	return true;
}

static PyObject *unpack_py_eventlog_BackupEventLogW_args_out(struct eventlog_BackupEventLogW *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_CloseEventLog_args_in(PyObject *args, PyObject *kwargs, struct eventlog_CloseEventLog *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_CloseEventLog", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_CloseEventLog_args_out(struct eventlog_CloseEventLog *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_DeregisterEventSource_args_in(PyObject *args, PyObject *kwargs, struct eventlog_DeregisterEventSource *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_DeregisterEventSource", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_DeregisterEventSource_args_out(struct eventlog_DeregisterEventSource *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_GetNumRecords_args_in(PyObject *args, PyObject *kwargs, struct eventlog_GetNumRecords *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_GetNumRecords", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_GetNumRecords_args_out(struct eventlog_GetNumRecords *r)
{
	PyObject *result;
	PyObject *py_number;
	py_number = PyInt_FromLong(*r->out.number);
	result = py_number;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_GetOldestRecord_args_in(PyObject *args, PyObject *kwargs, struct eventlog_GetOldestRecord *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_GetOldestRecord", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_GetOldestRecord_args_out(struct eventlog_GetOldestRecord *r)
{
	PyObject *result;
	PyObject *py_oldest_entry;
	py_oldest_entry = PyInt_FromLong(*r->out.oldest_entry);
	result = py_oldest_entry;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_OpenEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_OpenEventLogW *r)
{
	PyObject *py_unknown0;
	PyObject *py_logname;
	PyObject *py_servername;
	PyObject *py_major_version;
	PyObject *py_minor_version;
	const char *kwnames[] = {
		"unknown0", "logname", "servername", "major_version", "minor_version", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:eventlog_OpenEventLogW", discard_const_p(char *, kwnames), &py_unknown0, &py_logname, &py_servername, &py_major_version, &py_minor_version)) {
		return false;
	}

	if (py_unknown0 == Py_None) {
		r->in.unknown0 = NULL;
	} else {
		r->in.unknown0 = NULL;
		PY_CHECK_TYPE(&eventlog_OpenUnknown0_Type, py_unknown0, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_unknown0)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.unknown0 = (struct eventlog_OpenUnknown0 *)pytalloc_get_ptr(py_unknown0);
	}
	r->in.logname = talloc_ptrtype(r, r->in.logname);
	PY_CHECK_TYPE(lsa_String_Type, py_logname, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_logname)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.logname = (struct lsa_String *)pytalloc_get_ptr(py_logname);
	r->in.servername = talloc_ptrtype(r, r->in.servername);
	PY_CHECK_TYPE(lsa_String_Type, py_servername, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_servername)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.servername = (struct lsa_String *)pytalloc_get_ptr(py_servername);
	PY_CHECK_TYPE(&PyInt_Type, py_major_version, return false;);
	r->in.major_version = PyInt_AsLong(py_major_version);
	PY_CHECK_TYPE(&PyInt_Type, py_minor_version, return false;);
	r->in.minor_version = PyInt_AsLong(py_minor_version);
	return true;
}

static PyObject *unpack_py_eventlog_OpenEventLogW_args_out(struct eventlog_OpenEventLogW *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_RegisterEventSourceW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_RegisterEventSourceW *r)
{
	PyObject *py_unknown0;
	PyObject *py_module_name;
	PyObject *py_reg_module_name;
	PyObject *py_major_version;
	PyObject *py_minor_version;
	const char *kwnames[] = {
		"unknown0", "module_name", "reg_module_name", "major_version", "minor_version", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:eventlog_RegisterEventSourceW", discard_const_p(char *, kwnames), &py_unknown0, &py_module_name, &py_reg_module_name, &py_major_version, &py_minor_version)) {
		return false;
	}

	if (py_unknown0 == Py_None) {
		r->in.unknown0 = NULL;
	} else {
		r->in.unknown0 = NULL;
		PY_CHECK_TYPE(&eventlog_OpenUnknown0_Type, py_unknown0, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_unknown0)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.unknown0 = (struct eventlog_OpenUnknown0 *)pytalloc_get_ptr(py_unknown0);
	}
	r->in.module_name = talloc_ptrtype(r, r->in.module_name);
	PY_CHECK_TYPE(lsa_String_Type, py_module_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_module_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.module_name = (struct lsa_String *)pytalloc_get_ptr(py_module_name);
	r->in.reg_module_name = talloc_ptrtype(r, r->in.reg_module_name);
	PY_CHECK_TYPE(lsa_String_Type, py_reg_module_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_reg_module_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.reg_module_name = (struct lsa_String *)pytalloc_get_ptr(py_reg_module_name);
	PY_CHECK_TYPE(&PyInt_Type, py_major_version, return false;);
	r->in.major_version = PyInt_AsLong(py_major_version);
	PY_CHECK_TYPE(&PyInt_Type, py_minor_version, return false;);
	r->in.minor_version = PyInt_AsLong(py_minor_version);
	return true;
}

static PyObject *unpack_py_eventlog_RegisterEventSourceW_args_out(struct eventlog_RegisterEventSourceW *r)
{
	PyObject *result;
	PyObject *py_log_handle;
	py_log_handle = pytalloc_reference_ex(policy_handle_Type, r->out.log_handle, r->out.log_handle);
	result = py_log_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_OpenBackupEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_OpenBackupEventLogW *r)
{
	PyObject *py_unknown0;
	PyObject *py_backup_logname;
	PyObject *py_major_version;
	PyObject *py_minor_version;
	const char *kwnames[] = {
		"unknown0", "backup_logname", "major_version", "minor_version", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog_OpenBackupEventLogW", discard_const_p(char *, kwnames), &py_unknown0, &py_backup_logname, &py_major_version, &py_minor_version)) {
		return false;
	}

	if (py_unknown0 == Py_None) {
		r->in.unknown0 = NULL;
	} else {
		r->in.unknown0 = NULL;
		PY_CHECK_TYPE(&eventlog_OpenUnknown0_Type, py_unknown0, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_unknown0)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.unknown0 = (struct eventlog_OpenUnknown0 *)pytalloc_get_ptr(py_unknown0);
	}
	r->in.backup_logname = talloc_ptrtype(r, r->in.backup_logname);
	PY_CHECK_TYPE(lsa_String_Type, py_backup_logname, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_backup_logname)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.backup_logname = (struct lsa_String *)pytalloc_get_ptr(py_backup_logname);
	PY_CHECK_TYPE(&PyInt_Type, py_major_version, return false;);
	r->in.major_version = PyInt_AsLong(py_major_version);
	PY_CHECK_TYPE(&PyInt_Type, py_minor_version, return false;);
	r->in.minor_version = PyInt_AsLong(py_minor_version);
	return true;
}

static PyObject *unpack_py_eventlog_OpenBackupEventLogW_args_out(struct eventlog_OpenBackupEventLogW *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_ReadEventLogW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_ReadEventLogW *r)
{
	PyObject *py_handle;
	PyObject *py_flags;
	PyObject *py_offset;
	PyObject *py_number_of_bytes;
	const char *kwnames[] = {
		"handle", "flags", "offset", "number_of_bytes", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog_ReadEventLogW", discard_const_p(char *, kwnames), &py_handle, &py_flags, &py_offset, &py_number_of_bytes)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_flags)) {
		r->in.flags = PyLong_AsLongLong(py_flags);
	} else if (PyInt_Check(py_flags)) {
		r->in.flags = PyInt_AsLong(py_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_offset, return false;);
	r->in.offset = PyInt_AsLong(py_offset);
	PY_CHECK_TYPE(&PyInt_Type, py_number_of_bytes, return false;);
	r->in.number_of_bytes = PyInt_AsLong(py_number_of_bytes);
	return true;
}

static PyObject *unpack_py_eventlog_ReadEventLogW_args_out(struct eventlog_ReadEventLogW *r)
{
	PyObject *result;
	PyObject *py_data;
	PyObject *py_sent_size;
	PyObject *py_real_size;
	result = PyTuple_New(3);
	py_data = PyList_New(r->in.number_of_bytes);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_1;
		for (data_cntr_1 = 0; data_cntr_1 < r->in.number_of_bytes; data_cntr_1++) {
			PyObject *py_data_1;
			py_data_1 = PyInt_FromLong(r->out.data[data_cntr_1]);
			PyList_SetItem(py_data, data_cntr_1, py_data_1);
		}
	}
	PyTuple_SetItem(result, 0, py_data);
	py_sent_size = PyInt_FromLong(*r->out.sent_size);
	PyTuple_SetItem(result, 1, py_sent_size);
	py_real_size = PyInt_FromLong(*r->out.real_size);
	PyTuple_SetItem(result, 2, py_real_size);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_ReportEventW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_ReportEventW *r)
{
	PyObject *py_handle;
	PyObject *py_timestamp;
	PyObject *py_event_type;
	PyObject *py_event_category;
	PyObject *py_event_id;
	PyObject *py_servername;
	PyObject *py_user_sid;
	PyObject *py_strings;
	PyObject *py_data;
	PyObject *py_flags;
	PyObject *py_record_number;
	PyObject *py_time_written;
	const char *kwnames[] = {
		"handle", "timestamp", "event_type", "event_category", "event_id", "servername", "user_sid", "strings", "data", "flags", "record_number", "time_written", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOO:eventlog_ReportEventW", discard_const_p(char *, kwnames), &py_handle, &py_timestamp, &py_event_type, &py_event_category, &py_event_id, &py_servername, &py_user_sid, &py_strings, &py_data, &py_flags, &py_record_number, &py_time_written)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_timestamp, return false;);
	r->in.timestamp = PyInt_AsLong(py_timestamp);
	if (PyLong_Check(py_event_type)) {
		r->in.event_type = PyLong_AsLongLong(py_event_type);
	} else if (PyInt_Check(py_event_type)) {
		r->in.event_type = PyInt_AsLong(py_event_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_event_category, return false;);
	r->in.event_category = PyInt_AsLong(py_event_category);
	PY_CHECK_TYPE(&PyInt_Type, py_event_id, return false;);
	r->in.event_id = PyInt_AsLong(py_event_id);
	PY_CHECK_TYPE(&PyList_Type, py_strings, return false;);
	r->in.num_of_strings = PyList_GET_SIZE(py_strings);
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.data_size = PyList_GET_SIZE(py_data);
	r->in.servername = talloc_ptrtype(r, r->in.servername);
	PY_CHECK_TYPE(lsa_String_Type, py_servername, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_servername)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.servername = (struct lsa_String *)pytalloc_get_ptr(py_servername);
	if (py_user_sid == Py_None) {
		r->in.user_sid = NULL;
	} else {
		r->in.user_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, py_user_sid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_user_sid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.user_sid = (struct dom_sid *)pytalloc_get_ptr(py_user_sid);
	}
	if (py_strings == Py_None) {
		r->in.strings = NULL;
	} else {
		r->in.strings = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_strings, return false;);
		{
			int strings_cntr_1;
			r->in.strings = talloc_array_ptrtype(r, r->in.strings, PyList_GET_SIZE(py_strings));
			if (!r->in.strings) { return false;; }
			talloc_set_name_const(r->in.strings, "ARRAY: r->in.strings");
			for (strings_cntr_1 = 0; strings_cntr_1 < PyList_GET_SIZE(py_strings); strings_cntr_1++) {
				if (PyList_GET_ITEM(py_strings, strings_cntr_1) == Py_None) {
					r->in.strings[strings_cntr_1] = NULL;
				} else {
					r->in.strings[strings_cntr_1] = NULL;
					PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(py_strings, strings_cntr_1), return false;);
					if (talloc_reference(r->in.strings, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_strings, strings_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return false;
					}
					r->in.strings[strings_cntr_1] = (struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_strings, strings_cntr_1));
				}
			}
		}
	}
	if (py_data == Py_None) {
		r->in.data = NULL;
	} else {
		r->in.data = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
		{
			int data_cntr_1;
			r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
			if (!r->in.data) { return false;; }
			talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(py_data); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_data, data_cntr_1), return false;);
				r->in.data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_data, data_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	if (py_record_number == Py_None) {
		r->in.record_number = NULL;
	} else {
		r->in.record_number = talloc_ptrtype(r, r->in.record_number);
		PY_CHECK_TYPE(&PyInt_Type, py_record_number, return false;);
		*r->in.record_number = PyInt_AsLong(py_record_number);
	}
	if (py_time_written == Py_None) {
		r->in.time_written = NULL;
	} else {
		r->in.time_written = talloc_ptrtype(r, r->in.time_written);
		PY_CHECK_TYPE(&PyInt_Type, py_time_written, return false;);
		*r->in.time_written = PyInt_AsLong(py_time_written);
	}
	return true;
}

static PyObject *unpack_py_eventlog_ReportEventW_args_out(struct eventlog_ReportEventW *r)
{
	PyObject *result;
	PyObject *py_record_number;
	PyObject *py_time_written;
	result = PyTuple_New(2);
	if (r->out.record_number == NULL) {
		py_record_number = Py_None;
		Py_INCREF(py_record_number);
	} else {
		py_record_number = PyInt_FromLong(*r->out.record_number);
	}
	PyTuple_SetItem(result, 0, py_record_number);
	if (r->out.time_written == NULL) {
		py_time_written = Py_None;
		Py_INCREF(py_time_written);
	} else {
		py_time_written = PyInt_FromLong(*r->out.time_written);
	}
	PyTuple_SetItem(result, 1, py_time_written);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_GetLogInformation_args_in(PyObject *args, PyObject *kwargs, struct eventlog_GetLogInformation *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	PyObject *py_buf_size;
	const char *kwnames[] = {
		"handle", "level", "buf_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog_GetLogInformation", discard_const_p(char *, kwnames), &py_handle, &py_level, &py_buf_size)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	PY_CHECK_TYPE(&PyInt_Type, py_buf_size, return false;);
	r->in.buf_size = PyInt_AsLong(py_buf_size);
	return true;
}

static PyObject *unpack_py_eventlog_GetLogInformation_args_out(struct eventlog_GetLogInformation *r)
{
	PyObject *result;
	PyObject *py_buffer;
	PyObject *py_bytes_needed;
	result = PyTuple_New(2);
	py_buffer = PyList_New(r->in.buf_size);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < r->in.buf_size; buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	PyTuple_SetItem(result, 0, py_buffer);
	py_bytes_needed = PyInt_FromLong(*r->out.bytes_needed);
	PyTuple_SetItem(result, 1, py_bytes_needed);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_FlushEventLog_args_in(PyObject *args, PyObject *kwargs, struct eventlog_FlushEventLog *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog_FlushEventLog", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog_FlushEventLog_args_out(struct eventlog_FlushEventLog *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog_ReportEventAndSourceW_args_in(PyObject *args, PyObject *kwargs, struct eventlog_ReportEventAndSourceW *r)
{
	PyObject *py_handle;
	PyObject *py_timestamp;
	PyObject *py_event_type;
	PyObject *py_event_category;
	PyObject *py_event_id;
	PyObject *py_sourcename;
	PyObject *py_servername;
	PyObject *py_user_sid;
	PyObject *py_strings;
	PyObject *py_data;
	PyObject *py_flags;
	PyObject *py_record_number;
	PyObject *py_time_written;
	const char *kwnames[] = {
		"handle", "timestamp", "event_type", "event_category", "event_id", "sourcename", "servername", "user_sid", "strings", "data", "flags", "record_number", "time_written", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOOO:eventlog_ReportEventAndSourceW", discard_const_p(char *, kwnames), &py_handle, &py_timestamp, &py_event_type, &py_event_category, &py_event_id, &py_sourcename, &py_servername, &py_user_sid, &py_strings, &py_data, &py_flags, &py_record_number, &py_time_written)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_timestamp, return false;);
	r->in.timestamp = PyInt_AsLong(py_timestamp);
	if (PyLong_Check(py_event_type)) {
		r->in.event_type = PyLong_AsLongLong(py_event_type);
	} else if (PyInt_Check(py_event_type)) {
		r->in.event_type = PyInt_AsLong(py_event_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_event_category, return false;);
	r->in.event_category = PyInt_AsLong(py_event_category);
	PY_CHECK_TYPE(&PyInt_Type, py_event_id, return false;);
	r->in.event_id = PyInt_AsLong(py_event_id);
	r->in.sourcename = talloc_ptrtype(r, r->in.sourcename);
	PY_CHECK_TYPE(lsa_String_Type, py_sourcename, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sourcename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sourcename = (struct lsa_String *)pytalloc_get_ptr(py_sourcename);
	PY_CHECK_TYPE(&PyList_Type, py_strings, return false;);
	r->in.num_of_strings = PyList_GET_SIZE(py_strings);
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.data_size = PyList_GET_SIZE(py_data);
	r->in.servername = talloc_ptrtype(r, r->in.servername);
	PY_CHECK_TYPE(lsa_String_Type, py_servername, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_servername)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.servername = (struct lsa_String *)pytalloc_get_ptr(py_servername);
	if (py_user_sid == Py_None) {
		r->in.user_sid = NULL;
	} else {
		r->in.user_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, py_user_sid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_user_sid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.user_sid = (struct dom_sid *)pytalloc_get_ptr(py_user_sid);
	}
	if (py_strings == Py_None) {
		r->in.strings = NULL;
	} else {
		r->in.strings = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_strings, return false;);
		{
			int strings_cntr_1;
			r->in.strings = talloc_array_ptrtype(r, r->in.strings, PyList_GET_SIZE(py_strings));
			if (!r->in.strings) { return false;; }
			talloc_set_name_const(r->in.strings, "ARRAY: r->in.strings");
			for (strings_cntr_1 = 0; strings_cntr_1 < PyList_GET_SIZE(py_strings); strings_cntr_1++) {
				if (PyList_GET_ITEM(py_strings, strings_cntr_1) == Py_None) {
					r->in.strings[strings_cntr_1] = NULL;
				} else {
					r->in.strings[strings_cntr_1] = NULL;
					PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(py_strings, strings_cntr_1), return false;);
					if (talloc_reference(r->in.strings, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_strings, strings_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return false;
					}
					r->in.strings[strings_cntr_1] = (struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_strings, strings_cntr_1));
				}
			}
		}
	}
	if (py_data == Py_None) {
		r->in.data = NULL;
	} else {
		r->in.data = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
		{
			int data_cntr_1;
			r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
			if (!r->in.data) { return false;; }
			talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(py_data); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_data, data_cntr_1), return false;);
				r->in.data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_data, data_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	if (py_record_number == Py_None) {
		r->in.record_number = NULL;
	} else {
		r->in.record_number = talloc_ptrtype(r, r->in.record_number);
		PY_CHECK_TYPE(&PyInt_Type, py_record_number, return false;);
		*r->in.record_number = PyInt_AsLong(py_record_number);
	}
	if (py_time_written == Py_None) {
		r->in.time_written = NULL;
	} else {
		r->in.time_written = talloc_ptrtype(r, r->in.time_written);
		PY_CHECK_TYPE(&PyInt_Type, py_time_written, return false;);
		*r->in.time_written = PyInt_AsLong(py_time_written);
	}
	return true;
}

static PyObject *unpack_py_eventlog_ReportEventAndSourceW_args_out(struct eventlog_ReportEventAndSourceW *r)
{
	PyObject *result;
	PyObject *py_record_number;
	PyObject *py_time_written;
	result = PyTuple_New(2);
	if (r->out.record_number == NULL) {
		py_record_number = Py_None;
		Py_INCREF(py_record_number);
	} else {
		py_record_number = PyInt_FromLong(*r->out.record_number);
	}
	PyTuple_SetItem(result, 0, py_record_number);
	if (r->out.time_written == NULL) {
		py_time_written = Py_None;
		Py_INCREF(py_time_written);
	} else {
		py_time_written = PyInt_FromLong(*r->out.time_written);
	}
	PyTuple_SetItem(result, 1, py_time_written);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_eventlog_methods[] = {
	{ "ClearEventLogW", "S.ClearEventLogW(handle, backupfile) -> None", (py_dcerpc_call_fn)dcerpc_eventlog_ClearEventLogW_r, (py_data_pack_fn)pack_py_eventlog_ClearEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_ClearEventLogW_args_out, 0, &ndr_table_eventlog },
	{ "BackupEventLogW", "S.BackupEventLogW(handle, backup_filename) -> None", (py_dcerpc_call_fn)dcerpc_eventlog_BackupEventLogW_r, (py_data_pack_fn)pack_py_eventlog_BackupEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_BackupEventLogW_args_out, 1, &ndr_table_eventlog },
	{ "CloseEventLog", "S.CloseEventLog(handle) -> handle", (py_dcerpc_call_fn)dcerpc_eventlog_CloseEventLog_r, (py_data_pack_fn)pack_py_eventlog_CloseEventLog_args_in, (py_data_unpack_fn)unpack_py_eventlog_CloseEventLog_args_out, 2, &ndr_table_eventlog },
	{ "DeregisterEventSource", "S.DeregisterEventSource(handle) -> handle", (py_dcerpc_call_fn)dcerpc_eventlog_DeregisterEventSource_r, (py_data_pack_fn)pack_py_eventlog_DeregisterEventSource_args_in, (py_data_unpack_fn)unpack_py_eventlog_DeregisterEventSource_args_out, 3, &ndr_table_eventlog },
	{ "GetNumRecords", "S.GetNumRecords(handle) -> number", (py_dcerpc_call_fn)dcerpc_eventlog_GetNumRecords_r, (py_data_pack_fn)pack_py_eventlog_GetNumRecords_args_in, (py_data_unpack_fn)unpack_py_eventlog_GetNumRecords_args_out, 4, &ndr_table_eventlog },
	{ "GetOldestRecord", "S.GetOldestRecord(handle) -> oldest_entry", (py_dcerpc_call_fn)dcerpc_eventlog_GetOldestRecord_r, (py_data_pack_fn)pack_py_eventlog_GetOldestRecord_args_in, (py_data_unpack_fn)unpack_py_eventlog_GetOldestRecord_args_out, 5, &ndr_table_eventlog },
	{ "OpenEventLogW", "S.OpenEventLogW(unknown0, logname, servername, major_version, minor_version) -> handle", (py_dcerpc_call_fn)dcerpc_eventlog_OpenEventLogW_r, (py_data_pack_fn)pack_py_eventlog_OpenEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_OpenEventLogW_args_out, 7, &ndr_table_eventlog },
	{ "RegisterEventSourceW", "S.RegisterEventSourceW(unknown0, module_name, reg_module_name, major_version, minor_version) -> log_handle", (py_dcerpc_call_fn)dcerpc_eventlog_RegisterEventSourceW_r, (py_data_pack_fn)pack_py_eventlog_RegisterEventSourceW_args_in, (py_data_unpack_fn)unpack_py_eventlog_RegisterEventSourceW_args_out, 8, &ndr_table_eventlog },
	{ "OpenBackupEventLogW", "S.OpenBackupEventLogW(unknown0, backup_logname, major_version, minor_version) -> handle", (py_dcerpc_call_fn)dcerpc_eventlog_OpenBackupEventLogW_r, (py_data_pack_fn)pack_py_eventlog_OpenBackupEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_OpenBackupEventLogW_args_out, 9, &ndr_table_eventlog },
	{ "ReadEventLogW", "S.ReadEventLogW(handle, flags, offset, number_of_bytes) -> (data, sent_size, real_size)", (py_dcerpc_call_fn)dcerpc_eventlog_ReadEventLogW_r, (py_data_pack_fn)pack_py_eventlog_ReadEventLogW_args_in, (py_data_unpack_fn)unpack_py_eventlog_ReadEventLogW_args_out, 10, &ndr_table_eventlog },
	{ "ReportEventW", "S.ReportEventW(handle, timestamp, event_type, event_category, event_id, servername, user_sid, strings, data, flags, record_number, time_written) -> (record_number, time_written)", (py_dcerpc_call_fn)dcerpc_eventlog_ReportEventW_r, (py_data_pack_fn)pack_py_eventlog_ReportEventW_args_in, (py_data_unpack_fn)unpack_py_eventlog_ReportEventW_args_out, 11, &ndr_table_eventlog },
	{ "GetLogInformation", "S.GetLogInformation(handle, level, buf_size) -> (buffer, bytes_needed)", (py_dcerpc_call_fn)dcerpc_eventlog_GetLogInformation_r, (py_data_pack_fn)pack_py_eventlog_GetLogInformation_args_in, (py_data_unpack_fn)unpack_py_eventlog_GetLogInformation_args_out, 22, &ndr_table_eventlog },
	{ "FlushEventLog", "S.FlushEventLog(handle) -> None", (py_dcerpc_call_fn)dcerpc_eventlog_FlushEventLog_r, (py_data_pack_fn)pack_py_eventlog_FlushEventLog_args_in, (py_data_unpack_fn)unpack_py_eventlog_FlushEventLog_args_out, 23, &ndr_table_eventlog },
	{ "ReportEventAndSourceW", "S.ReportEventAndSourceW(handle, timestamp, event_type, event_category, event_id, sourcename, servername, user_sid, strings, data, flags, record_number, time_written) -> (record_number, time_written)", (py_dcerpc_call_fn)dcerpc_eventlog_ReportEventAndSourceW_r, (py_data_pack_fn)pack_py_eventlog_ReportEventAndSourceW_args_in, (py_data_unpack_fn)unpack_py_eventlog_ReportEventAndSourceW_args_out, 24, &ndr_table_eventlog },
	{ NULL }
};

static PyObject *interface_eventlog_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_eventlog);
}

#define PY_DOC_EVENTLOG "Event Logger"
static PyTypeObject eventlog_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog.eventlog",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "eventlog(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_EVENTLOG,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_eventlog_new,
};

static PyMethodDef eventlog_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initeventlog(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_security;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_samba_dcerpc_lsa;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		return;

	lsa_String_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "String");
	if (lsa_String_Type == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	eventlog_OpenUnknown0_Type.tp_base = Object_Type;

	eventlog_Record_tdb_Type.tp_base = Object_Type;

	EVENTLOGHEADER_Type.tp_base = Object_Type;

	EVENTLOGRECORD_Type.tp_base = Object_Type;

	EVENTLOGEOF_Type.tp_base = Object_Type;

	EVENTLOG_EVT_FILE_Type.tp_base = Object_Type;

	EVENTLOG_FULL_INFORMATION_Type.tp_base = Object_Type;

	eventlog_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&eventlog_OpenUnknown0_Type) < 0)
		return;
	if (PyType_Ready(&eventlog_Record_tdb_Type) < 0)
		return;
	if (PyType_Ready(&EVENTLOGHEADER_Type) < 0)
		return;
	if (PyType_Ready(&EVENTLOGRECORD_Type) < 0)
		return;
	if (PyType_Ready(&EVENTLOGEOF_Type) < 0)
		return;
	if (PyType_Ready(&EVENTLOG_EVT_FILE_Type) < 0)
		return;
	if (PyType_Ready(&EVENTLOG_FULL_INFORMATION_Type) < 0)
		return;
	if (PyType_Ready(&eventlog_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&eventlog_InterfaceType, py_ndr_eventlog_methods))
		return;

#ifdef PY_OPENUNKNOWN0_PATCH
	PY_OPENUNKNOWN0_PATCH(&eventlog_OpenUnknown0_Type);
#endif
#ifdef PY_RECORD_TDB_PATCH
	PY_RECORD_TDB_PATCH(&eventlog_Record_tdb_Type);
#endif
#ifdef PY_EVENTLOGHEADER_PATCH
	PY_EVENTLOGHEADER_PATCH(&EVENTLOGHEADER_Type);
#endif
#ifdef PY_EVENTLOGRECORD_PATCH
	PY_EVENTLOGRECORD_PATCH(&EVENTLOGRECORD_Type);
#endif
#ifdef PY_EVENTLOGEOF_PATCH
	PY_EVENTLOGEOF_PATCH(&EVENTLOGEOF_Type);
#endif
#ifdef PY_EVENTLOG_EVT_FILE_PATCH
	PY_EVENTLOG_EVT_FILE_PATCH(&EVENTLOG_EVT_FILE_Type);
#endif
#ifdef PY_EVENTLOG_FULL_INFORMATION_PATCH
	PY_EVENTLOG_FULL_INFORMATION_PATCH(&EVENTLOG_FULL_INFORMATION_Type);
#endif
#ifdef PY_EVENTLOG_PATCH
	PY_EVENTLOG_PATCH(&eventlog_InterfaceType);
#endif

	m = Py_InitModule3("eventlog", eventlog_methods, "eventlog DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "EVENTLOG_SUCCESS", PyInt_FromLong(EVENTLOG_SUCCESS));
	PyModule_AddObject(m, "ELF_LOGFILE_ARCHIVE_SET", PyInt_FromLong(ELF_LOGFILE_ARCHIVE_SET));
	PyModule_AddObject(m, "ELF_LOGFILE_HEADER_WRAP", PyInt_FromLong(ELF_LOGFILE_HEADER_WRAP));
	PyModule_AddObject(m, "ELF_LOGFILE_HEADER_DIRTY", PyInt_FromLong(ELF_LOGFILE_HEADER_DIRTY));
	PyModule_AddObject(m, "EVENTLOG_WARNING_TYPE", PyInt_FromLong(EVENTLOG_WARNING_TYPE));
	PyModule_AddObject(m, "EVENTLOG_AUDIT_FAILURE", PyInt_FromLong(EVENTLOG_AUDIT_FAILURE));
	PyModule_AddObject(m, "EVENTLOG_FORWARDS_READ", PyInt_FromLong(EVENTLOG_FORWARDS_READ));
	PyModule_AddObject(m, "EVENTLOG_INFORMATION_TYPE", PyInt_FromLong(EVENTLOG_INFORMATION_TYPE));
	PyModule_AddObject(m, "EVENTLOG_BACKWARDS_READ", PyInt_FromLong(EVENTLOG_BACKWARDS_READ));
	PyModule_AddObject(m, "EVENTLOG_SEQUENTIAL_READ", PyInt_FromLong(EVENTLOG_SEQUENTIAL_READ));
	PyModule_AddObject(m, "EVENTLOG_SEEK_READ", PyInt_FromLong(EVENTLOG_SEEK_READ));
	PyModule_AddObject(m, "EVENTLOG_AUDIT_SUCCESS", PyInt_FromLong(EVENTLOG_AUDIT_SUCCESS));
	PyModule_AddObject(m, "ELF_LOGFILE_LOGFULL_WRITTEN", PyInt_FromLong(ELF_LOGFILE_LOGFULL_WRITTEN));
	PyModule_AddObject(m, "EVENTLOG_ERROR_TYPE", PyInt_FromLong(EVENTLOG_ERROR_TYPE));
	Py_INCREF((PyObject *)(void *)&eventlog_OpenUnknown0_Type);
	PyModule_AddObject(m, "OpenUnknown0", (PyObject *)(void *)&eventlog_OpenUnknown0_Type);
	Py_INCREF((PyObject *)(void *)&eventlog_Record_tdb_Type);
	PyModule_AddObject(m, "Record_tdb", (PyObject *)(void *)&eventlog_Record_tdb_Type);
	Py_INCREF((PyObject *)(void *)&EVENTLOGHEADER_Type);
	PyModule_AddObject(m, "EVENTLOGHEADER", (PyObject *)(void *)&EVENTLOGHEADER_Type);
	Py_INCREF((PyObject *)(void *)&EVENTLOGRECORD_Type);
	PyModule_AddObject(m, "EVENTLOGRECORD", (PyObject *)(void *)&EVENTLOGRECORD_Type);
	Py_INCREF((PyObject *)(void *)&EVENTLOGEOF_Type);
	PyModule_AddObject(m, "EVENTLOGEOF", (PyObject *)(void *)&EVENTLOGEOF_Type);
	Py_INCREF((PyObject *)(void *)&EVENTLOG_EVT_FILE_Type);
	PyModule_AddObject(m, "EVENTLOG_EVT_FILE", (PyObject *)(void *)&EVENTLOG_EVT_FILE_Type);
	Py_INCREF((PyObject *)(void *)&EVENTLOG_FULL_INFORMATION_Type);
	PyModule_AddObject(m, "EVENTLOG_FULL_INFORMATION", (PyObject *)(void *)&EVENTLOG_FULL_INFORMATION_Type);
	Py_INCREF((PyObject *)(void *)&eventlog_InterfaceType);
	PyModule_AddObject(m, "eventlog", (PyObject *)(void *)&eventlog_InterfaceType);
#ifdef PY_MOD_EVENTLOG_PATCH
	PY_MOD_EVENTLOG_PATCH(m);
#endif

}
