/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "ntdomain.h"
#include "autoconf/librpc/gen_ndr/srv_dcom.h"

static bool api_UseProtSeq(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct UseProtSeq *r;

	call = &ndr_table_dcom_Unknown.calls[NDR_USEPROTSEQ];

	r = talloc(talloc_tos(), struct UseProtSeq);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(UseProtSeq, NDR_IN, r);
	}

	_UseProtSeq(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(UseProtSeq, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetCustomProtseqInfo(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetCustomProtseqInfo *r;

	call = &ndr_table_dcom_Unknown.calls[NDR_GETCUSTOMPROTSEQINFO];

	r = talloc(talloc_tos(), struct GetCustomProtseqInfo);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetCustomProtseqInfo, NDR_IN, r);
	}

	_GetCustomProtseqInfo(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetCustomProtseqInfo, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_UpdateResolverBindings(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct UpdateResolverBindings *r;

	call = &ndr_table_dcom_Unknown.calls[NDR_UPDATERESOLVERBINDINGS];

	r = talloc(talloc_tos(), struct UpdateResolverBindings);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(UpdateResolverBindings, NDR_IN, r);
	}

	_UpdateResolverBindings(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(UpdateResolverBindings, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_dcom_Unknown_cmds[] = 
{
	{"USEPROTSEQ", NDR_USEPROTSEQ, api_UseProtSeq},
	{"GETCUSTOMPROTSEQINFO", NDR_GETCUSTOMPROTSEQINFO, api_GetCustomProtseqInfo},
	{"UPDATERESOLVERBINDINGS", NDR_UPDATERESOLVERBINDINGS, api_UpdateResolverBindings},
};

void dcom_Unknown_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_dcom_Unknown_cmds;
	*n_fns = sizeof(api_dcom_Unknown_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_dcom_Unknown_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "dcom_Unknown", "dcom_Unknown", &ndr_table_dcom_Unknown, api_dcom_Unknown_cmds, sizeof(api_dcom_Unknown_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_dcom_Unknown_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_dcom_Unknown);
}
static bool api_QueryInterface(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct QueryInterface *r;

	call = &ndr_table_IUnknown.calls[NDR_QUERYINTERFACE];

	r = talloc(talloc_tos(), struct QueryInterface);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.data == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _QueryInterface(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_AddRef(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct AddRef *r;

	call = &ndr_table_IUnknown.calls[NDR_ADDREF];

	r = talloc(talloc_tos(), struct AddRef);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _AddRef(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_Release(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Release *r;

	call = &ndr_table_IUnknown.calls[NDR_RELEASE];

	r = talloc(talloc_tos(), struct Release);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Release(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IUnknown_cmds[] = 
{
	{"QUERYINTERFACE", NDR_QUERYINTERFACE, api_QueryInterface},
	{"ADDREF", NDR_ADDREF, api_AddRef},
	{"RELEASE", NDR_RELEASE, api_Release},
};

void IUnknown_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IUnknown_cmds;
	*n_fns = sizeof(api_IUnknown_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IUnknown_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IUnknown", "IUnknown", &ndr_table_IUnknown, api_IUnknown_cmds, sizeof(api_IUnknown_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IUnknown_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IUnknown);
}
static bool api_CreateInstance(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct CreateInstance *r;

	call = &ndr_table_IClassFactory.calls[NDR_CREATEINSTANCE];

	r = talloc(talloc_tos(), struct CreateInstance);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateInstance, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppv = talloc_zero(r, struct MInterfacePointer);
	if (r->out.ppv == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateInstance(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateInstance, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_RemoteCreateInstance(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RemoteCreateInstance *r;

	call = &ndr_table_IClassFactory.calls[NDR_REMOTECREATEINSTANCE];

	r = talloc(talloc_tos(), struct RemoteCreateInstance);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemoteCreateInstance, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemoteCreateInstance(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemoteCreateInstance, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_LockServer(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct LockServer *r;

	call = &ndr_table_IClassFactory.calls[NDR_LOCKSERVER];

	r = talloc(talloc_tos(), struct LockServer);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(LockServer, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _LockServer(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(LockServer, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_RemoteLockServer(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RemoteLockServer *r;

	call = &ndr_table_IClassFactory.calls[NDR_REMOTELOCKSERVER];

	r = talloc(talloc_tos(), struct RemoteLockServer);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemoteLockServer, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemoteLockServer(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemoteLockServer, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IClassFactory_cmds[] = 
{
	{"CREATEINSTANCE", NDR_CREATEINSTANCE, api_CreateInstance},
	{"REMOTECREATEINSTANCE", NDR_REMOTECREATEINSTANCE, api_RemoteCreateInstance},
	{"LOCKSERVER", NDR_LOCKSERVER, api_LockServer},
	{"REMOTELOCKSERVER", NDR_REMOTELOCKSERVER, api_RemoteLockServer},
};

void IClassFactory_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IClassFactory_cmds;
	*n_fns = sizeof(api_IClassFactory_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IClassFactory_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IClassFactory", "IClassFactory", &ndr_table_IClassFactory, api_IClassFactory_cmds, sizeof(api_IClassFactory_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IClassFactory_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IClassFactory);
}
static bool api_RemQueryInterface(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RemQueryInterface *r;

	call = &ndr_table_IRemUnknown.calls[NDR_REMQUERYINTERFACE];

	r = talloc(talloc_tos(), struct RemQueryInterface);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ip = talloc_zero_array(r, struct MInterfacePointer, r->in.cIids);
	if (r->out.ip == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemQueryInterface(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_RemAddRef(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RemAddRef *r;

	call = &ndr_table_IRemUnknown.calls[NDR_REMADDREF];

	r = talloc(talloc_tos(), struct RemAddRef);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemAddRef, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pResults = talloc_zero_array(r, WERROR, r->in.cInterfaceRefs);
	if (r->out.pResults == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemAddRef(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemAddRef, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_RemRelease(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RemRelease *r;

	call = &ndr_table_IRemUnknown.calls[NDR_REMRELEASE];

	r = talloc(talloc_tos(), struct RemRelease);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemRelease, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemRelease(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemRelease, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IRemUnknown_cmds[] = 
{
	{"REMQUERYINTERFACE", NDR_REMQUERYINTERFACE, api_RemQueryInterface},
	{"REMADDREF", NDR_REMADDREF, api_RemAddRef},
	{"REMRELEASE", NDR_REMRELEASE, api_RemRelease},
};

void IRemUnknown_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IRemUnknown_cmds;
	*n_fns = sizeof(api_IRemUnknown_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IRemUnknown_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IRemUnknown", "IRemUnknown", &ndr_table_IRemUnknown, api_IRemUnknown_cmds, sizeof(api_IRemUnknown_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IRemUnknown_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IRemUnknown);
}
static bool api_GetClassObject(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetClassObject *r;

	call = &ndr_table_IClassActivator.calls[NDR_GETCLASSOBJECT];

	r = talloc(talloc_tos(), struct GetClassObject);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data = talloc_zero(r, struct MInterfacePointer);
	if (r->out.data == NULL) {
		talloc_free(r);
		return false;
	}

	_GetClassObject(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IClassActivator_cmds[] = 
{
	{"GETCLASSOBJECT", NDR_GETCLASSOBJECT, api_GetClassObject},
};

void IClassActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IClassActivator_cmds;
	*n_fns = sizeof(api_IClassActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IClassActivator_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IClassActivator", "IClassActivator", &ndr_table_IClassActivator, api_IClassActivator_cmds, sizeof(api_IClassActivator_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IClassActivator_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IClassActivator);
}
static bool api_ISCMLocalActivator_CreateInstance(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ISCMLocalActivator_CreateInstance *r;

	call = &ndr_table_ISCMLocalActivator.calls[NDR_ISCMLOCALACTIVATOR_CREATEINSTANCE];

	r = talloc(talloc_tos(), struct ISCMLocalActivator_CreateInstance);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ISCMLocalActivator_CreateInstance, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ISCMLocalActivator_CreateInstance(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ISCMLocalActivator_CreateInstance, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ISCMLocalActivator_cmds[] = 
{
	{"ISCMLOCALACTIVATOR_CREATEINSTANCE", NDR_ISCMLOCALACTIVATOR_CREATEINSTANCE, api_ISCMLocalActivator_CreateInstance},
};

void ISCMLocalActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ISCMLocalActivator_cmds;
	*n_fns = sizeof(api_ISCMLocalActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ISCMLocalActivator_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ISCMLocalActivator", "ISCMLocalActivator", &ndr_table_ISCMLocalActivator, api_ISCMLocalActivator_cmds, sizeof(api_ISCMLocalActivator_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_ISCMLocalActivator_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_ISCMLocalActivator);
}
static bool api_IMachineLocalActivator_foo(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct IMachineLocalActivator_foo *r;

	call = &ndr_table_IMachineLocalActivator.calls[NDR_IMACHINELOCALACTIVATOR_FOO];

	r = talloc(talloc_tos(), struct IMachineLocalActivator_foo);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IMachineLocalActivator_foo, NDR_IN, r);
	}

	r->out.result = _IMachineLocalActivator_foo(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IMachineLocalActivator_foo, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IMachineLocalActivator_cmds[] = 
{
	{"IMACHINELOCALACTIVATOR_FOO", NDR_IMACHINELOCALACTIVATOR_FOO, api_IMachineLocalActivator_foo},
};

void IMachineLocalActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IMachineLocalActivator_cmds;
	*n_fns = sizeof(api_IMachineLocalActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IMachineLocalActivator_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IMachineLocalActivator", "IMachineLocalActivator", &ndr_table_IMachineLocalActivator, api_IMachineLocalActivator_cmds, sizeof(api_IMachineLocalActivator_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IMachineLocalActivator_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IMachineLocalActivator);
}
static bool api_ILocalObjectExporter_Foo(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ILocalObjectExporter_Foo *r;

	call = &ndr_table_ILocalObjectExporter.calls[NDR_ILOCALOBJECTEXPORTER_FOO];

	r = talloc(talloc_tos(), struct ILocalObjectExporter_Foo);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ILocalObjectExporter_Foo, NDR_IN, r);
	}

	r->out.result = _ILocalObjectExporter_Foo(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ILocalObjectExporter_Foo, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ILocalObjectExporter_cmds[] = 
{
	{"ILOCALOBJECTEXPORTER_FOO", NDR_ILOCALOBJECTEXPORTER_FOO, api_ILocalObjectExporter_Foo},
};

void ILocalObjectExporter_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ILocalObjectExporter_cmds;
	*n_fns = sizeof(api_ILocalObjectExporter_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ILocalObjectExporter_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ILocalObjectExporter", "ILocalObjectExporter", &ndr_table_ILocalObjectExporter, api_ILocalObjectExporter_cmds, sizeof(api_ILocalObjectExporter_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_ILocalObjectExporter_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_ILocalObjectExporter);
}
static bool api_ISystemActivatorRemoteCreateInstance(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ISystemActivatorRemoteCreateInstance *r;

	call = &ndr_table_ISystemActivator.calls[NDR_ISYSTEMACTIVATORREMOTECREATEINSTANCE];

	r = talloc(talloc_tos(), struct ISystemActivatorRemoteCreateInstance);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ISystemActivatorRemoteCreateInstance, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.unknown3 = talloc_zero(r, uint32_t);
	if (r->out.unknown3 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.iface2 = talloc_zero(r, struct MInterfacePointer);
	if (r->out.iface2 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ISystemActivatorRemoteCreateInstance(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ISystemActivatorRemoteCreateInstance, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ISystemActivator_cmds[] = 
{
	{"ISYSTEMACTIVATORREMOTECREATEINSTANCE", NDR_ISYSTEMACTIVATORREMOTECREATEINSTANCE, api_ISystemActivatorRemoteCreateInstance},
};

void ISystemActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ISystemActivator_cmds;
	*n_fns = sizeof(api_ISystemActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ISystemActivator_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ISystemActivator", "ISystemActivator", &ndr_table_ISystemActivator, api_ISystemActivator_cmds, sizeof(api_ISystemActivator_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_ISystemActivator_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_ISystemActivator);
}
static bool api_RemQueryInterface2(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RemQueryInterface2 *r;

	call = &ndr_table_IRemUnknown2.calls[NDR_REMQUERYINTERFACE2];

	r = talloc(talloc_tos(), struct RemQueryInterface2);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface2, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.phr = talloc_zero_array(r, WERROR, r->in.cIids);
	if (r->out.phr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppMIF = talloc_zero_array(r, struct MInterfacePointer, r->in.cIids);
	if (r->out.ppMIF == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemQueryInterface2(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface2, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IRemUnknown2_cmds[] = 
{
	{"REMQUERYINTERFACE2", NDR_REMQUERYINTERFACE2, api_RemQueryInterface2},
};

void IRemUnknown2_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IRemUnknown2_cmds;
	*n_fns = sizeof(api_IRemUnknown2_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IRemUnknown2_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IRemUnknown2", "IRemUnknown2", &ndr_table_IRemUnknown2, api_IRemUnknown2_cmds, sizeof(api_IRemUnknown2_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IRemUnknown2_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IRemUnknown2);
}
static bool api_GetTypeInfoCount(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetTypeInfoCount *r;

	call = &ndr_table_IDispatch.calls[NDR_GETTYPEINFOCOUNT];

	r = talloc(talloc_tos(), struct GetTypeInfoCount);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetTypeInfoCount, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pctinfo = talloc_zero(r, uint16_t);
	if (r->out.pctinfo == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetTypeInfoCount(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetTypeInfoCount, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetTypeInfo(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetTypeInfo *r;

	call = &ndr_table_IDispatch.calls[NDR_GETTYPEINFO];

	r = talloc(talloc_tos(), struct GetTypeInfo);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetTypeInfo, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppTInfo = talloc_zero(r, struct REF_ITypeInfo);
	if (r->out.ppTInfo == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetTypeInfo(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetTypeInfo, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetIDsOfNames(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetIDsOfNames *r;

	call = &ndr_table_IDispatch.calls[NDR_GETIDSOFNAMES];

	r = talloc(talloc_tos(), struct GetIDsOfNames);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetIDsOfNames, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rgDispId = talloc_zero_array(r, uint32_t, r->in.cNames);
	if (r->out.rgDispId == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetIDsOfNames(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetIDsOfNames, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_Invoke(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Invoke *r;

	call = &ndr_table_IDispatch.calls[NDR_INVOKE];

	r = talloc(talloc_tos(), struct Invoke);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Invoke, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pDispParams = r->in.pDispParams;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pVarResult = talloc_zero(r, struct VARIANT);
	if (r->out.pVarResult == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pExcepInfo = talloc_zero(r, struct EXCEPINFO);
	if (r->out.pExcepInfo == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.puArgErr = talloc_zero(r, uint16_t);
	if (r->out.puArgErr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Invoke(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Invoke, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IDispatch_cmds[] = 
{
	{"GETTYPEINFOCOUNT", NDR_GETTYPEINFOCOUNT, api_GetTypeInfoCount},
	{"GETTYPEINFO", NDR_GETTYPEINFO, api_GetTypeInfo},
	{"GETIDSOFNAMES", NDR_GETIDSOFNAMES, api_GetIDsOfNames},
	{"INVOKE", NDR_INVOKE, api_Invoke},
};

void IDispatch_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IDispatch_cmds;
	*n_fns = sizeof(api_IDispatch_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IDispatch_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IDispatch", "IDispatch", &ndr_table_IDispatch, api_IDispatch_cmds, sizeof(api_IDispatch_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IDispatch_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IDispatch);
}
static bool api_MarshalInterface(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct MarshalInterface *r;

	call = &ndr_table_IMarshal.calls[NDR_MARSHALINTERFACE];

	r = talloc(talloc_tos(), struct MarshalInterface);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(MarshalInterface, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _MarshalInterface(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(MarshalInterface, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_UnMarshalInterface(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct UnMarshalInterface *r;

	call = &ndr_table_IMarshal.calls[NDR_UNMARSHALINTERFACE];

	r = talloc(talloc_tos(), struct UnMarshalInterface);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(UnMarshalInterface, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _UnMarshalInterface(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(UnMarshalInterface, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IMarshal_cmds[] = 
{
	{"MARSHALINTERFACE", NDR_MARSHALINTERFACE, api_MarshalInterface},
	{"UNMARSHALINTERFACE", NDR_UNMARSHALINTERFACE, api_UnMarshalInterface},
};

void IMarshal_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IMarshal_cmds;
	*n_fns = sizeof(api_IMarshal_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IMarshal_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IMarshal", "IMarshal", &ndr_table_IMarshal, api_IMarshal_cmds, sizeof(api_IMarshal_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IMarshal_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IMarshal);
}
static bool api_MakeCoffee(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct MakeCoffee *r;

	call = &ndr_table_ICoffeeMachine.calls[NDR_MAKECOFFEE];

	r = talloc(talloc_tos(), struct MakeCoffee);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(MakeCoffee, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _MakeCoffee(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(MakeCoffee, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ICoffeeMachine_cmds[] = 
{
	{"MAKECOFFEE", NDR_MAKECOFFEE, api_MakeCoffee},
};

void ICoffeeMachine_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ICoffeeMachine_cmds;
	*n_fns = sizeof(api_ICoffeeMachine_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ICoffeeMachine_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ICoffeeMachine", "ICoffeeMachine", &ndr_table_ICoffeeMachine, api_ICoffeeMachine_cmds, sizeof(api_ICoffeeMachine_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_ICoffeeMachine_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_ICoffeeMachine);
}
static bool api_Read(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Read *r;

	call = &ndr_table_IStream.calls[NDR_READ];

	r = talloc(talloc_tos(), struct Read);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Read, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pv = talloc_zero_array(r, uint8_t, r->in.num_requested);
	if (r->out.pv == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_read = talloc_zero(r, uint32_t);
	if (r->out.num_read == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Read(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Read, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_Write(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Write *r;

	call = &ndr_table_IStream.calls[NDR_WRITE];

	r = talloc(talloc_tos(), struct Write);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Write, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_written = talloc_zero(r, uint32_t);
	if (r->out.num_written == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Write(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Write, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IStream_cmds[] = 
{
	{"READ", NDR_READ, api_Read},
	{"WRITE", NDR_WRITE, api_Write},
};

void IStream_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IStream_cmds;
	*n_fns = sizeof(api_IStream_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IStream_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IStream", "IStream", &ndr_table_IStream, api_IStream_cmds, sizeof(api_IStream_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IStream_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IStream);
}
