/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_oxidresolver.h"

static bool api_ResolveOxid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ResolveOxid *r;

	call = &ndr_table_IOXIDResolver.calls[NDR_RESOLVEOXID];

	r = talloc(talloc_tos(), struct ResolveOxid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ResolveOxid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppdsaOxidBindings = talloc_zero(r, struct DUALSTRINGARRAY *);
	if (r->out.ppdsaOxidBindings == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pipidRemUnknown = talloc_zero(r, struct GUID);
	if (r->out.pipidRemUnknown == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pAuthnHint = talloc_zero(r, uint32_t);
	if (r->out.pAuthnHint == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ResolveOxid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ResolveOxid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_SimplePing(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct SimplePing *r;

	call = &ndr_table_IOXIDResolver.calls[NDR_SIMPLEPING];

	r = talloc(talloc_tos(), struct SimplePing);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(SimplePing, r);
	}

	r->out.result = _SimplePing(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(SimplePing, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ComplexPing(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ComplexPing *r;

	call = &ndr_table_IOXIDResolver.calls[NDR_COMPLEXPING];

	r = talloc(talloc_tos(), struct ComplexPing);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ComplexPing, r);
	}

	ZERO_STRUCT(r->out);
	r->out.SetId = r->in.SetId;
	r->out.PingBackoffFactor = talloc_zero(r, uint16_t);
	if (r->out.PingBackoffFactor == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ComplexPing(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ComplexPing, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ServerAlive(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ServerAlive *r;

	call = &ndr_table_IOXIDResolver.calls[NDR_SERVERALIVE];

	r = talloc(talloc_tos(), struct ServerAlive);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ServerAlive, r);
	}

	r->out.result = _ServerAlive(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ServerAlive, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ResolveOxid2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ResolveOxid2 *r;

	call = &ndr_table_IOXIDResolver.calls[NDR_RESOLVEOXID2];

	r = talloc(talloc_tos(), struct ResolveOxid2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ResolveOxid2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pdsaOxidBindings = talloc_zero(r, struct DUALSTRINGARRAY *);
	if (r->out.pdsaOxidBindings == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ipidRemUnknown = talloc_zero(r, struct GUID);
	if (r->out.ipidRemUnknown == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.AuthnHint = talloc_zero(r, uint32_t);
	if (r->out.AuthnHint == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ComVersion = talloc_zero(r, struct COMVERSION);
	if (r->out.ComVersion == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ResolveOxid2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ResolveOxid2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_ServerAlive2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ServerAlive2 *r;

	call = &ndr_table_IOXIDResolver.calls[NDR_SERVERALIVE2];

	r = talloc(talloc_tos(), struct ServerAlive2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ServerAlive2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct COMINFO);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.dualstring = talloc_zero(r, struct DUALSTRINGARRAY);
	if (r->out.dualstring == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.unknown2 = talloc_zero(r, uint8_t);
	if (r->out.unknown2 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.unknown3 = talloc_zero(r, uint8_t);
	if (r->out.unknown3 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.unknown4 = talloc_zero(r, uint8_t);
	if (r->out.unknown4 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ServerAlive2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ServerAlive2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IOXIDResolver_cmds[] = 
{
	{"RESOLVEOXID", NDR_RESOLVEOXID, api_ResolveOxid},
	{"SIMPLEPING", NDR_SIMPLEPING, api_SimplePing},
	{"COMPLEXPING", NDR_COMPLEXPING, api_ComplexPing},
	{"SERVERALIVE", NDR_SERVERALIVE, api_ServerAlive},
	{"RESOLVEOXID2", NDR_RESOLVEOXID2, api_ResolveOxid2},
	{"SERVERALIVE2", NDR_SERVERALIVE2, api_ServerAlive2},
};

void IOXIDResolver_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IOXIDResolver_cmds;
	*n_fns = sizeof(api_IOXIDResolver_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IOXIDResolver_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_RESOLVEOXID: {
			struct ResolveOxid *r = (struct ResolveOxid *)_r;
			ZERO_STRUCT(r->out);
			r->out.ppdsaOxidBindings = talloc_zero(mem_ctx, struct DUALSTRINGARRAY *);
			if (r->out.ppdsaOxidBindings == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.pipidRemUnknown = talloc_zero(mem_ctx, struct GUID);
			if (r->out.pipidRemUnknown == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.pAuthnHint = talloc_zero(mem_ctx, uint32_t);
			if (r->out.pAuthnHint == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ResolveOxid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SIMPLEPING: {
			struct SimplePing *r = (struct SimplePing *)_r;
			r->out.result = _SimplePing(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_COMPLEXPING: {
			struct ComplexPing *r = (struct ComplexPing *)_r;
			ZERO_STRUCT(r->out);
			r->out.SetId = r->in.SetId;
			r->out.PingBackoffFactor = talloc_zero(mem_ctx, uint16_t);
			if (r->out.PingBackoffFactor == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ComplexPing(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SERVERALIVE: {
			struct ServerAlive *r = (struct ServerAlive *)_r;
			r->out.result = _ServerAlive(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_RESOLVEOXID2: {
			struct ResolveOxid2 *r = (struct ResolveOxid2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.pdsaOxidBindings = talloc_zero(mem_ctx, struct DUALSTRINGARRAY *);
			if (r->out.pdsaOxidBindings == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ipidRemUnknown = talloc_zero(mem_ctx, struct GUID);
			if (r->out.ipidRemUnknown == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.AuthnHint = talloc_zero(mem_ctx, uint32_t);
			if (r->out.AuthnHint == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.ComVersion = talloc_zero(mem_ctx, struct COMVERSION);
			if (r->out.ComVersion == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ResolveOxid2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_SERVERALIVE2: {
			struct ServerAlive2 *r = (struct ServerAlive2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, struct COMINFO);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.dualstring = talloc_zero(mem_ctx, struct DUALSTRINGARRAY);
			if (r->out.dualstring == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.unknown2 = talloc_zero(mem_ctx, uint8_t);
			if (r->out.unknown2 == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.unknown3 = talloc_zero(mem_ctx, uint8_t);
			if (r->out.unknown3 == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.unknown4 = talloc_zero(mem_ctx, uint8_t);
			if (r->out.unknown4 == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _ServerAlive2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_IOXIDResolver_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IOXIDResolver", "IOXIDResolver", &ndr_table_IOXIDResolver, api_IOXIDResolver_cmds, sizeof(api_IOXIDResolver_cmds) / sizeof(struct api_struct));
}
