/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_xattr.h"

static bool api_xattr_parse_DOSATTRIB(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct xattr_parse_DOSATTRIB *r;

	call = &ndr_table_xattr.calls[NDR_XATTR_PARSE_DOSATTRIB];

	r = talloc(talloc_tos(), struct xattr_parse_DOSATTRIB);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(xattr_parse_DOSATTRIB, r);
	}

	_xattr_parse_DOSATTRIB(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(xattr_parse_DOSATTRIB, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_xattr_cmds[] = 
{
	{"XATTR_PARSE_DOSATTRIB", NDR_XATTR_PARSE_DOSATTRIB, api_xattr_parse_DOSATTRIB},
};

void xattr_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_xattr_cmds;
	*n_fns = sizeof(api_xattr_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_xattr_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_XATTR_PARSE_DOSATTRIB: {
			struct xattr_parse_DOSATTRIB *r = (struct xattr_parse_DOSATTRIB *)_r;
			_xattr_parse_DOSATTRIB(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_xattr_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "xattr", "xattr", &ndr_table_xattr, api_xattr_cmds, sizeof(api_xattr_cmds) / sizeof(struct api_struct));
}
