/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_eventlog.h"

#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_eventlog_OpenUnknown0(struct ndr_push *ndr, int ndr_flags, const struct eventlog_OpenUnknown0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown0));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenUnknown0(struct ndr_pull *ndr, int ndr_flags, struct eventlog_OpenUnknown0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown0));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenUnknown0(struct ndr_print *ndr, const char *name, const struct eventlog_OpenUnknown0 *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenUnknown0");
	ndr->depth++;
	ndr_print_uint16(ndr, "unknown0", r->unknown0);
	ndr_print_uint16(ndr, "unknown1", r->unknown1);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_eventlog_Record(struct ndr_push *ndr, int ndr_flags, const struct eventlog_Record *r)
{
	uint32_t cntr_strings_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->record_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time_generated));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time_written));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->event_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->event_type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_of_strings));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->event_category));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reserved_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->closing_record_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->stringoffset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_offset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->data_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->data_offset));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->source_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			for (cntr_strings_0 = 0; cntr_strings_0 < r->num_of_strings; cntr_strings_0++) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->strings[cntr_strings_0]));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->raw_data));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_eventlog_Record(struct ndr_pull *ndr, int ndr_flags, struct eventlog_Record *r)
{
	uint32_t cntr_strings_0;
	TALLOC_CTX *_mem_save_strings_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->record_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time_generated));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time_written));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->event_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->event_type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_of_strings));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->event_category));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->closing_record_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->stringoffset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_offset));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->source_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->computer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_PULL_ALLOC_N(ndr, r->strings, r->num_of_strings);
			_mem_save_strings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->strings, 0);
			for (cntr_strings_0 = 0; cntr_strings_0 < r->num_of_strings; cntr_strings_0++) {
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->strings[cntr_strings_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_0, 0);
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->raw_data));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_Record(struct ndr_print *ndr, const char *name, const struct eventlog_Record *r)
{
	uint32_t cntr_strings_0;
	ndr_print_struct(ndr, name, "eventlog_Record");
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_uint32(ndr, "record_number", r->record_number);
	ndr_print_uint32(ndr, "time_generated", r->time_generated);
	ndr_print_uint32(ndr, "time_written", r->time_written);
	ndr_print_uint32(ndr, "event_id", r->event_id);
	ndr_print_uint16(ndr, "event_type", r->event_type);
	ndr_print_uint16(ndr, "num_of_strings", r->num_of_strings);
	ndr_print_uint16(ndr, "event_category", r->event_category);
	ndr_print_uint16(ndr, "reserved_flags", r->reserved_flags);
	ndr_print_uint32(ndr, "closing_record_number", r->closing_record_number);
	ndr_print_uint32(ndr, "stringoffset", r->stringoffset);
	ndr_print_uint32(ndr, "sid_length", r->sid_length);
	ndr_print_uint32(ndr, "sid_offset", r->sid_offset);
	ndr_print_uint32(ndr, "data_length", r->data_length);
	ndr_print_uint32(ndr, "data_offset", r->data_offset);
	ndr_print_string(ndr, "source_name", r->source_name);
	ndr_print_string(ndr, "computer_name", r->computer_name);
	ndr->print(ndr, "%s: ARRAY(%d)", "strings", (int)r->num_of_strings);
	ndr->depth++;
	for (cntr_strings_0=0;cntr_strings_0<r->num_of_strings;cntr_strings_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_strings_0) != -1) {
			ndr_print_string(ndr, "strings", r->strings[cntr_strings_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr_print_string(ndr, "raw_data", r->raw_data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ClearEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_ClearEventLogW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.backupfile));
		if (r->in.backupfile) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backupfile));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ClearEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_ClearEventLogW *r)
{
	uint32_t _ptr_backupfile;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_backupfile_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_backupfile));
		if (_ptr_backupfile) {
			NDR_PULL_ALLOC(ndr, r->in.backupfile);
		} else {
			r->in.backupfile = NULL;
		}
		if (r->in.backupfile) {
			_mem_save_backupfile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.backupfile, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backupfile));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_backupfile_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ClearEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ClearEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_ClearEventLogW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ClearEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "backupfile", r->in.backupfile);
		ndr->depth++;
		if (r->in.backupfile) {
			ndr_print_lsa_String(ndr, "backupfile", r->in.backupfile);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ClearEventLogW");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_BackupEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_BackupEventLogW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_BackupEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_BackupEventLogW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_BackupEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_BackupEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_BackupEventLogW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_BackupEventLogW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_BackupEventLogW");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_CloseEventLog(struct ndr_push *ndr, int flags, const struct eventlog_CloseEventLog *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_CloseEventLog(struct ndr_pull *ndr, int flags, struct eventlog_CloseEventLog *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_CloseEventLog(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_CloseEventLog *r)
{
	ndr_print_struct(ndr, name, "eventlog_CloseEventLog");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_CloseEventLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_CloseEventLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_DeregisterEventSource(struct ndr_push *ndr, int flags, const struct eventlog_DeregisterEventSource *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_DeregisterEventSource(struct ndr_pull *ndr, int flags, struct eventlog_DeregisterEventSource *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_DeregisterEventSource(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_DeregisterEventSource *r)
{
	ndr_print_struct(ndr, name, "eventlog_DeregisterEventSource");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_DeregisterEventSource");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_DeregisterEventSource");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_GetNumRecords(struct ndr_push *ndr, int flags, const struct eventlog_GetNumRecords *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.number == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.number));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_GetNumRecords(struct ndr_pull *ndr, int flags, struct eventlog_GetNumRecords *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_number_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.number);
		ZERO_STRUCTP(r->out.number);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.number);
		}
		_mem_save_number_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.number, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.number));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_number_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_GetNumRecords(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_GetNumRecords *r)
{
	ndr_print_struct(ndr, name, "eventlog_GetNumRecords");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_GetNumRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_GetNumRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "number", r->out.number);
		ndr->depth++;
		ndr_print_uint32(ndr, "number", *r->out.number);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_GetOldestRecord(struct ndr_push *ndr, int flags, const struct eventlog_GetOldestRecord *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.oldest_entry == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.oldest_entry));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_GetOldestRecord(struct ndr_pull *ndr, int flags, struct eventlog_GetOldestRecord *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_oldest_entry_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.oldest_entry);
		ZERO_STRUCTP(r->out.oldest_entry);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.oldest_entry);
		}
		_mem_save_oldest_entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.oldest_entry, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.oldest_entry));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_oldest_entry_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_GetOldestRecord(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_GetOldestRecord *r)
{
	ndr_print_struct(ndr, name, "eventlog_GetOldestRecord");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_GetOldestRecord");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_GetOldestRecord");
		ndr->depth++;
		ndr_print_ptr(ndr, "oldest_entry", r->out.oldest_entry);
		ndr->depth++;
		ndr_print_uint32(ndr, "oldest_entry", *r->out.oldest_entry);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ChangeNotify(struct ndr_push *ndr, int flags, const struct eventlog_ChangeNotify *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ChangeNotify(struct ndr_pull *ndr, int flags, struct eventlog_ChangeNotify *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ChangeNotify(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ChangeNotify *r)
{
	ndr_print_struct(ndr, name, "eventlog_ChangeNotify");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ChangeNotify");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ChangeNotify");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_OpenEventLogW *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown0));
		if (r->in.unknown0) {
			NDR_CHECK(ndr_push_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
		}
		if (r->in.logname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logname));
		if (r->in.servername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown3));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_OpenEventLogW *r)
{
	uint32_t _ptr_unknown0;
	TALLOC_CTX *_mem_save_unknown0_0;
	TALLOC_CTX *_mem_save_logname_0;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown0));
		if (_ptr_unknown0) {
			NDR_PULL_ALLOC(ndr, r->in.unknown0);
		} else {
			r->in.unknown0 = NULL;
		}
		if (r->in.unknown0) {
			_mem_save_unknown0_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown0, 0);
			NDR_CHECK(ndr_pull_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown0_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logname);
		}
		_mem_save_logname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logname));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logname_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		}
		_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown3));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenEventLogW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown0", r->in.unknown0);
		ndr->depth++;
		if (r->in.unknown0) {
			ndr_print_eventlog_OpenUnknown0(ndr, "unknown0", r->in.unknown0);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "logname", r->in.logname);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "logname", r->in.logname);
		ndr->depth--;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "servername", r->in.servername);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr_print_uint32(ndr, "unknown3", r->in.unknown3);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_RegisterEventSourceW(struct ndr_push *ndr, int flags, const struct eventlog_RegisterEventSourceW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_RegisterEventSourceW(struct ndr_pull *ndr, int flags, struct eventlog_RegisterEventSourceW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_RegisterEventSourceW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_RegisterEventSourceW *r)
{
	ndr_print_struct(ndr, name, "eventlog_RegisterEventSourceW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_RegisterEventSourceW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_RegisterEventSourceW");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenBackupEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_OpenBackupEventLogW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenBackupEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_OpenBackupEventLogW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenBackupEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenBackupEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenBackupEventLogW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenBackupEventLogW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenBackupEventLogW");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReadEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_ReadEventLogW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.number_of_bytes));
	}
	if (flags & NDR_OUT) {
		if (r->out.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.number_of_bytes));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.data, r->in.number_of_bytes));
		if (r->out.sent_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.sent_size));
		if (r->out.real_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.real_size));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReadEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_ReadEventLogW *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sent_size_0;
	TALLOC_CTX *_mem_save_real_size_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.number_of_bytes));
		if (r->in.number_of_bytes < 0 || r->in.number_of_bytes > 0x7FFFF) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC_N(ndr, r->out.data, r->in.number_of_bytes);
		memset(r->out.data, 0, (r->in.number_of_bytes) * sizeof(*r->out.data));
		NDR_PULL_ALLOC(ndr, r->out.sent_size);
		ZERO_STRUCTP(r->out.sent_size);
		NDR_PULL_ALLOC(ndr, r->out.real_size);
		ZERO_STRUCTP(r->out.real_size);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.data));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.data, ndr_get_array_size(ndr, &r->out.data));
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.data, ndr_get_array_size(ndr, &r->out.data)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sent_size);
		}
		_mem_save_sent_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sent_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.sent_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sent_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.real_size);
		}
		_mem_save_real_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.real_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.real_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_real_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.data, r->in.number_of_bytes));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReadEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReadEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_ReadEventLogW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReadEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "offset", r->in.offset);
		ndr_print_uint32(ndr, "number_of_bytes", r->in.number_of_bytes);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReadEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->out.data, r->in.number_of_bytes);
		ndr->depth--;
		ndr_print_ptr(ndr, "sent_size", r->out.sent_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "sent_size", *r->out.sent_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "real_size", r->out.real_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "real_size", *r->out.real_size);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReportEventW(struct ndr_push *ndr, int flags, const struct eventlog_ReportEventW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReportEventW(struct ndr_pull *ndr, int flags, struct eventlog_ReportEventW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReportEventW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReportEventW *r)
{
	ndr_print_struct(ndr, name, "eventlog_ReportEventW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReportEventW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReportEventW");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ClearEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_ClearEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ClearEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_ClearEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ClearEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ClearEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_ClearEventLogA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ClearEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ClearEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_BackupEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_BackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_BackupEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_BackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_BackupEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_BackupEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_BackupEventLogA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_BackupEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_BackupEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_OpenEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_OpenEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenEventLogA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_RegisterEventSourceA(struct ndr_push *ndr, int flags, const struct eventlog_RegisterEventSourceA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_RegisterEventSourceA(struct ndr_pull *ndr, int flags, struct eventlog_RegisterEventSourceA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_RegisterEventSourceA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_RegisterEventSourceA *r)
{
	ndr_print_struct(ndr, name, "eventlog_RegisterEventSourceA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_RegisterEventSourceA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_RegisterEventSourceA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenBackupEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_OpenBackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenBackupEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_OpenBackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenBackupEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenBackupEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenBackupEventLogA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenBackupEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenBackupEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReadEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_ReadEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReadEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_ReadEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReadEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReadEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_ReadEventLogA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReadEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReadEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReportEventA(struct ndr_push *ndr, int flags, const struct eventlog_ReportEventA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReportEventA(struct ndr_pull *ndr, int flags, struct eventlog_ReportEventA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReportEventA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReportEventA *r)
{
	ndr_print_struct(ndr, name, "eventlog_ReportEventA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReportEventA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReportEventA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_RegisterClusterSvc(struct ndr_push *ndr, int flags, const struct eventlog_RegisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_RegisterClusterSvc(struct ndr_pull *ndr, int flags, struct eventlog_RegisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_RegisterClusterSvc(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_RegisterClusterSvc *r)
{
	ndr_print_struct(ndr, name, "eventlog_RegisterClusterSvc");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_RegisterClusterSvc");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_RegisterClusterSvc");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_DeregisterClusterSvc(struct ndr_push *ndr, int flags, const struct eventlog_DeregisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_DeregisterClusterSvc(struct ndr_pull *ndr, int flags, struct eventlog_DeregisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_DeregisterClusterSvc(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_DeregisterClusterSvc *r)
{
	ndr_print_struct(ndr, name, "eventlog_DeregisterClusterSvc");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_DeregisterClusterSvc");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_DeregisterClusterSvc");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_WriteClusterEvents(struct ndr_push *ndr, int flags, const struct eventlog_WriteClusterEvents *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_WriteClusterEvents(struct ndr_pull *ndr, int flags, struct eventlog_WriteClusterEvents *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_WriteClusterEvents(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_WriteClusterEvents *r)
{
	ndr_print_struct(ndr, name, "eventlog_WriteClusterEvents");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_WriteClusterEvents");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_WriteClusterEvents");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_GetLogIntormation(struct ndr_push *ndr, int flags, const struct eventlog_GetLogIntormation *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_GetLogIntormation(struct ndr_pull *ndr, int flags, struct eventlog_GetLogIntormation *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_GetLogIntormation(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_GetLogIntormation *r)
{
	ndr_print_struct(ndr, name, "eventlog_GetLogIntormation");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_GetLogIntormation");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_GetLogIntormation");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_FlushEventLog(struct ndr_push *ndr, int flags, const struct eventlog_FlushEventLog *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_FlushEventLog(struct ndr_pull *ndr, int flags, struct eventlog_FlushEventLog *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_FlushEventLog(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_FlushEventLog *r)
{
	ndr_print_struct(ndr, name, "eventlog_FlushEventLog");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_FlushEventLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_FlushEventLog");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call eventlog_calls[] = {
	{
		"eventlog_ClearEventLogW",
		sizeof(struct eventlog_ClearEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ClearEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ClearEventLogW,
		(ndr_print_function_t) ndr_print_eventlog_ClearEventLogW,
		false,
	},
	{
		"eventlog_BackupEventLogW",
		sizeof(struct eventlog_BackupEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_BackupEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_BackupEventLogW,
		(ndr_print_function_t) ndr_print_eventlog_BackupEventLogW,
		false,
	},
	{
		"eventlog_CloseEventLog",
		sizeof(struct eventlog_CloseEventLog),
		(ndr_push_flags_fn_t) ndr_push_eventlog_CloseEventLog,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_CloseEventLog,
		(ndr_print_function_t) ndr_print_eventlog_CloseEventLog,
		false,
	},
	{
		"eventlog_DeregisterEventSource",
		sizeof(struct eventlog_DeregisterEventSource),
		(ndr_push_flags_fn_t) ndr_push_eventlog_DeregisterEventSource,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_DeregisterEventSource,
		(ndr_print_function_t) ndr_print_eventlog_DeregisterEventSource,
		false,
	},
	{
		"eventlog_GetNumRecords",
		sizeof(struct eventlog_GetNumRecords),
		(ndr_push_flags_fn_t) ndr_push_eventlog_GetNumRecords,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_GetNumRecords,
		(ndr_print_function_t) ndr_print_eventlog_GetNumRecords,
		false,
	},
	{
		"eventlog_GetOldestRecord",
		sizeof(struct eventlog_GetOldestRecord),
		(ndr_push_flags_fn_t) ndr_push_eventlog_GetOldestRecord,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_GetOldestRecord,
		(ndr_print_function_t) ndr_print_eventlog_GetOldestRecord,
		false,
	},
	{
		"eventlog_ChangeNotify",
		sizeof(struct eventlog_ChangeNotify),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ChangeNotify,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ChangeNotify,
		(ndr_print_function_t) ndr_print_eventlog_ChangeNotify,
		false,
	},
	{
		"eventlog_OpenEventLogW",
		sizeof(struct eventlog_OpenEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenEventLogW,
		(ndr_print_function_t) ndr_print_eventlog_OpenEventLogW,
		false,
	},
	{
		"eventlog_RegisterEventSourceW",
		sizeof(struct eventlog_RegisterEventSourceW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_RegisterEventSourceW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_RegisterEventSourceW,
		(ndr_print_function_t) ndr_print_eventlog_RegisterEventSourceW,
		false,
	},
	{
		"eventlog_OpenBackupEventLogW",
		sizeof(struct eventlog_OpenBackupEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenBackupEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenBackupEventLogW,
		(ndr_print_function_t) ndr_print_eventlog_OpenBackupEventLogW,
		false,
	},
	{
		"eventlog_ReadEventLogW",
		sizeof(struct eventlog_ReadEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReadEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReadEventLogW,
		(ndr_print_function_t) ndr_print_eventlog_ReadEventLogW,
		false,
	},
	{
		"eventlog_ReportEventW",
		sizeof(struct eventlog_ReportEventW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReportEventW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReportEventW,
		(ndr_print_function_t) ndr_print_eventlog_ReportEventW,
		false,
	},
	{
		"eventlog_ClearEventLogA",
		sizeof(struct eventlog_ClearEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ClearEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ClearEventLogA,
		(ndr_print_function_t) ndr_print_eventlog_ClearEventLogA,
		false,
	},
	{
		"eventlog_BackupEventLogA",
		sizeof(struct eventlog_BackupEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_BackupEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_BackupEventLogA,
		(ndr_print_function_t) ndr_print_eventlog_BackupEventLogA,
		false,
	},
	{
		"eventlog_OpenEventLogA",
		sizeof(struct eventlog_OpenEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenEventLogA,
		(ndr_print_function_t) ndr_print_eventlog_OpenEventLogA,
		false,
	},
	{
		"eventlog_RegisterEventSourceA",
		sizeof(struct eventlog_RegisterEventSourceA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_RegisterEventSourceA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_RegisterEventSourceA,
		(ndr_print_function_t) ndr_print_eventlog_RegisterEventSourceA,
		false,
	},
	{
		"eventlog_OpenBackupEventLogA",
		sizeof(struct eventlog_OpenBackupEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenBackupEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenBackupEventLogA,
		(ndr_print_function_t) ndr_print_eventlog_OpenBackupEventLogA,
		false,
	},
	{
		"eventlog_ReadEventLogA",
		sizeof(struct eventlog_ReadEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReadEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReadEventLogA,
		(ndr_print_function_t) ndr_print_eventlog_ReadEventLogA,
		false,
	},
	{
		"eventlog_ReportEventA",
		sizeof(struct eventlog_ReportEventA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReportEventA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReportEventA,
		(ndr_print_function_t) ndr_print_eventlog_ReportEventA,
		false,
	},
	{
		"eventlog_RegisterClusterSvc",
		sizeof(struct eventlog_RegisterClusterSvc),
		(ndr_push_flags_fn_t) ndr_push_eventlog_RegisterClusterSvc,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_RegisterClusterSvc,
		(ndr_print_function_t) ndr_print_eventlog_RegisterClusterSvc,
		false,
	},
	{
		"eventlog_DeregisterClusterSvc",
		sizeof(struct eventlog_DeregisterClusterSvc),
		(ndr_push_flags_fn_t) ndr_push_eventlog_DeregisterClusterSvc,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_DeregisterClusterSvc,
		(ndr_print_function_t) ndr_print_eventlog_DeregisterClusterSvc,
		false,
	},
	{
		"eventlog_WriteClusterEvents",
		sizeof(struct eventlog_WriteClusterEvents),
		(ndr_push_flags_fn_t) ndr_push_eventlog_WriteClusterEvents,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_WriteClusterEvents,
		(ndr_print_function_t) ndr_print_eventlog_WriteClusterEvents,
		false,
	},
	{
		"eventlog_GetLogIntormation",
		sizeof(struct eventlog_GetLogIntormation),
		(ndr_push_flags_fn_t) ndr_push_eventlog_GetLogIntormation,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_GetLogIntormation,
		(ndr_print_function_t) ndr_print_eventlog_GetLogIntormation,
		false,
	},
	{
		"eventlog_FlushEventLog",
		sizeof(struct eventlog_FlushEventLog),
		(ndr_push_flags_fn_t) ndr_push_eventlog_FlushEventLog,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_FlushEventLog,
		(ndr_print_function_t) ndr_print_eventlog_FlushEventLog,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const eventlog_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\eventlog]", 
};

static const struct ndr_interface_string_array eventlog_endpoints = {
	.count	= 1,
	.names	= eventlog_endpoint_strings
};

static const char * const eventlog_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array eventlog_authservices = {
	.count	= 1,
	.names	= eventlog_authservice_strings
};


const struct ndr_interface_table ndr_table_eventlog = {
	.name		= "eventlog",
	.syntax_id	= {
		{0x82273fdc,0xe32a,0x18c3,{0x3f,0x78},{0x82,0x79,0x29,0xdc,0x23,0xea}},
		NDR_EVENTLOG_VERSION
	},
	.helpstring	= NDR_EVENTLOG_HELPSTRING,
	.num_calls	= 24,
	.calls		= eventlog_calls,
	.endpoints	= &eventlog_endpoints,
	.authservices	= &eventlog_authservices
};

