#include "../librpc/gen_ndr/ndr_netlogon.h"
#ifndef __CLI_NETLOGON__
#define __CLI_NETLOGON__
struct tevent_req *rpccli_netr_LogonUasLogon_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_server_name /* [in] [unique,charset(UTF16)] */,
						  const char *_account_name /* [in] [ref,charset(UTF16)] */,
						  const char *_workstation /* [in] [ref,charset(UTF16)] */,
						  struct netr_UasInfo **_info /* [out] [ref] */);
NTSTATUS rpccli_netr_LogonUasLogon_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result);
NTSTATUS rpccli_netr_LogonUasLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *account_name /* [in] [ref,charset(UTF16)] */,
				   const char *workstation /* [in] [ref,charset(UTF16)] */,
				   struct netr_UasInfo **info /* [out] [ref] */,
				   WERROR *werror);
struct tevent_req *rpccli_netr_LogonUasLogoff_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_server_name /* [in] [unique,charset(UTF16)] */,
						   const char *_account_name /* [in] [ref,charset(UTF16)] */,
						   const char *_workstation /* [in] [ref,charset(UTF16)] */,
						   struct netr_UasLogoffInfo *_info /* [out] [ref] */);
NTSTATUS rpccli_netr_LogonUasLogoff_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result);
NTSTATUS rpccli_netr_LogonUasLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *account_name /* [in] [ref,charset(UTF16)] */,
				    const char *workstation /* [in] [ref,charset(UTF16)] */,
				    struct netr_UasLogoffInfo *info /* [out] [ref] */,
				    WERROR *werror);
struct tevent_req *rpccli_netr_LogonSamLogon_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_server_name /* [in] [unique,charset(UTF16)] */,
						  const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						  struct netr_Authenticator *_credential /* [in] [unique] */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
						  enum netr_LogonInfoClass _logon_level /* [in]  */,
						  union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
						  uint16_t _validation_level /* [in]  */,
						  union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
						  uint8_t *_authoritative /* [out] [ref] */);
NTSTATUS rpccli_netr_LogonSamLogon_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result);
NTSTATUS rpccli_netr_LogonSamLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *computer_name /* [in] [unique,charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [unique] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				   enum netr_LogonInfoClass logon_level /* [in]  */,
				   union netr_LogonLevel *logon /* [in] [ref,switch_is(logon_level)] */,
				   uint16_t validation_level /* [in]  */,
				   union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				   uint8_t *authoritative /* [out] [ref] */);
struct tevent_req *rpccli_netr_LogonSamLogoff_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_server_name /* [in] [unique,charset(UTF16)] */,
						   const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						   struct netr_Authenticator *_credential /* [in] [unique] */,
						   struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
						   enum netr_LogonInfoClass _logon_level /* [in]  */,
						   union netr_LogonLevel _logon /* [in] [switch_is(logon_level)] */);
NTSTATUS rpccli_netr_LogonSamLogoff_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result);
NTSTATUS rpccli_netr_LogonSamLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [unique] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				    enum netr_LogonInfoClass logon_level /* [in]  */,
				    union netr_LogonLevel logon /* [in] [switch_is(logon_level)] */);
struct tevent_req *rpccli_netr_ServerReqChallenge_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Credential *_credentials /* [in] [ref] */,
						       struct netr_Credential *_return_credentials /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerReqChallenge_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result);
NTSTATUS rpccli_netr_ServerReqChallenge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */);
struct tevent_req *rpccli_netr_ServerAuthenticate_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_account_name /* [in] [ref,charset(UTF16)] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Credential *_credentials /* [in] [ref] */,
						       struct netr_Credential *_return_credentials /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerAuthenticate_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result);
NTSTATUS rpccli_netr_ServerAuthenticate(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [ref,charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */);
struct tevent_req *rpccli_netr_ServerPasswordSet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      const char *_server_name /* [in] [unique,charset(UTF16)] */,
						      const char *_account_name /* [in] [ref,charset(UTF16)] */,
						      enum netr_SchannelType _secure_channel_type /* [in]  */,
						      const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						      struct netr_Authenticator *_credential /* [in] [ref] */,
						      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						      struct samr_Password *_new_password /* [in] [ref] */);
NTSTATUS rpccli_netr_ServerPasswordSet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result);
NTSTATUS rpccli_netr_ServerPasswordSet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [ref,charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [ref,charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *new_password /* [in] [ref] */);
struct tevent_req *rpccli_netr_DatabaseDeltas_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						   const char *_computername /* [in] [ref,charset(UTF16)] */,
						   struct netr_Authenticator *_credential /* [in] [ref] */,
						   struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						   enum netr_SamDatabaseID _database_id /* [in]  */,
						   uint64_t *_sequence_num /* [in,out] [ref] */,
						   struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						   uint32_t _preferredmaximumlength /* [in]  */);
NTSTATUS rpccli_netr_DatabaseDeltas_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result);
NTSTATUS rpccli_netr_DatabaseDeltas(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *logon_server /* [in] [ref,charset(UTF16)] */,
				    const char *computername /* [in] [ref,charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [ref] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				    enum netr_SamDatabaseID database_id /* [in]  */,
				    uint64_t *sequence_num /* [in,out] [ref] */,
				    struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				    uint32_t preferredmaximumlength /* [in]  */);
struct tevent_req *rpccli_netr_DatabaseSync_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						 const char *_computername /* [in] [ref,charset(UTF16)] */,
						 struct netr_Authenticator *_credential /* [in] [ref] */,
						 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						 enum netr_SamDatabaseID _database_id /* [in]  */,
						 uint32_t *_sync_context /* [in,out] [ref] */,
						 struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						 uint32_t _preferredmaximumlength /* [in]  */);
NTSTATUS rpccli_netr_DatabaseSync_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result);
NTSTATUS rpccli_netr_DatabaseSync(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [ref,charset(UTF16)] */,
				  const char *computername /* [in] [ref,charset(UTF16)] */,
				  struct netr_Authenticator *credential /* [in] [ref] */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  enum netr_SamDatabaseID database_id /* [in]  */,
				  uint32_t *sync_context /* [in,out] [ref] */,
				  struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				  uint32_t preferredmaximumlength /* [in]  */);
struct tevent_req *rpccli_netr_AccountDeltas_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						  const char *_computername /* [in] [ref,charset(UTF16)] */,
						  struct netr_Authenticator _credential /* [in]  */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						  struct netr_UAS_INFO_0 _uas /* [in]  */,
						  uint32_t _count /* [in]  */,
						  uint32_t _level /* [in]  */,
						  uint32_t _buffersize /* [in]  */,
						  struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
						  uint32_t *_count_returned /* [out] [ref] */,
						  uint32_t *_total_entries /* [out] [ref] */,
						  struct netr_UAS_INFO_0 *_recordid /* [out] [ref] */);
NTSTATUS rpccli_netr_AccountDeltas_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result);
NTSTATUS rpccli_netr_AccountDeltas(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   const char *computername /* [in] [ref,charset(UTF16)] */,
				   struct netr_Authenticator credential /* [in]  */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   struct netr_UAS_INFO_0 uas /* [in]  */,
				   uint32_t count /* [in]  */,
				   uint32_t level /* [in]  */,
				   uint32_t buffersize /* [in]  */,
				   struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				   uint32_t *count_returned /* [out] [ref] */,
				   uint32_t *total_entries /* [out] [ref] */,
				   struct netr_UAS_INFO_0 *recordid /* [out] [ref] */);
struct tevent_req *rpccli_netr_AccountSync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						const char *_computername /* [in] [ref,charset(UTF16)] */,
						struct netr_Authenticator _credential /* [in]  */,
						struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						uint32_t _reference /* [in]  */,
						uint32_t _level /* [in]  */,
						uint32_t _buffersize /* [in]  */,
						struct netr_AccountBuffer *_buffer /* [out] [ref,subcontext(4)] */,
						uint32_t *_count_returned /* [out] [ref] */,
						uint32_t *_total_entries /* [out] [ref] */,
						uint32_t *_next_reference /* [out] [ref] */,
						struct netr_UAS_INFO_0 *_recordid /* [in,out] [ref] */);
NTSTATUS rpccli_netr_AccountSync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result);
NTSTATUS rpccli_netr_AccountSync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *logon_server /* [in] [unique,charset(UTF16)] */,
				 const char *computername /* [in] [ref,charset(UTF16)] */,
				 struct netr_Authenticator credential /* [in]  */,
				 struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				 uint32_t reference /* [in]  */,
				 uint32_t level /* [in]  */,
				 uint32_t buffersize /* [in]  */,
				 struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				 uint32_t *count_returned /* [out] [ref] */,
				 uint32_t *total_entries /* [out] [ref] */,
				 uint32_t *next_reference /* [out] [ref] */,
				 struct netr_UAS_INFO_0 *recordid /* [in,out] [ref] */);
struct tevent_req *rpccli_netr_GetDcName_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      const char *_logon_server /* [in] [ref,charset(UTF16)] */,
					      const char *_domainname /* [in] [unique,charset(UTF16)] */,
					      const char **_dcname /* [out] [ref,charset(UTF16)] */);
NTSTATUS rpccli_netr_GetDcName_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_netr_GetDcName(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       const char *logon_server /* [in] [ref,charset(UTF16)] */,
			       const char *domainname /* [in] [unique,charset(UTF16)] */,
			       const char **dcname /* [out] [ref,charset(UTF16)] */,
			       WERROR *werror);
struct tevent_req *rpccli_netr_LogonControl_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						 enum netr_LogonControlCode _function_code /* [in]  */,
						 uint32_t _level /* [in]  */,
						 union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */);
NTSTATUS rpccli_netr_LogonControl_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_netr_LogonControl(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  enum netr_LogonControlCode function_code /* [in]  */,
				  uint32_t level /* [in]  */,
				  union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				  WERROR *werror);
struct tevent_req *rpccli_netr_GetAnyDCName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						 const char *_domainname /* [in] [unique,charset(UTF16)] */,
						 const char **_dcname /* [out] [ref,charset(UTF16)] */);
NTSTATUS rpccli_netr_GetAnyDCName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_netr_GetAnyDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  const char *domainname /* [in] [unique,charset(UTF16)] */,
				  const char **dcname /* [out] [ref,charset(UTF16)] */,
				  WERROR *werror);
struct tevent_req *rpccli_netr_LogonControl2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						  enum netr_LogonControlCode _function_code /* [in]  */,
						  uint32_t _level /* [in]  */,
						  union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
						  union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */);
NTSTATUS rpccli_netr_LogonControl2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result);
NTSTATUS rpccli_netr_LogonControl2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   enum netr_LogonControlCode function_code /* [in]  */,
				   uint32_t level /* [in]  */,
				   union netr_CONTROL_DATA_INFORMATION *data /* [in] [ref,switch_is(function_code)] */,
				   union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				   WERROR *werror);
struct tevent_req *rpccli_netr_ServerAuthenticate2_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							const char *_server_name /* [in] [unique,charset(UTF16)] */,
							const char *_account_name /* [in] [ref,charset(UTF16)] */,
							enum netr_SchannelType _secure_channel_type /* [in]  */,
							const char *_computer_name /* [in] [ref,charset(UTF16)] */,
							struct netr_Credential *_credentials /* [in] [ref] */,
							struct netr_Credential *_return_credentials /* [out] [ref] */,
							uint32_t *_negotiate_flags /* [in,out] [ref] */);
NTSTATUS rpccli_netr_ServerAuthenticate2_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result);
NTSTATUS rpccli_netr_ServerAuthenticate2(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [ref,charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [ref,charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in] [ref] */,
					 struct netr_Credential *return_credentials /* [out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */);
struct tevent_req *rpccli_netr_DatabaseSync2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						  const char *_computername /* [in] [ref,charset(UTF16)] */,
						  struct netr_Authenticator *_credential /* [in] [ref] */,
						  struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						  enum netr_SamDatabaseID _database_id /* [in]  */,
						  enum SyncStateEnum _restart_state /* [in]  */,
						  uint32_t *_sync_context /* [in,out] [ref] */,
						  struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */,
						  uint32_t _preferredmaximumlength /* [in]  */);
NTSTATUS rpccli_netr_DatabaseSync2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result);
NTSTATUS rpccli_netr_DatabaseSync2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [ref,charset(UTF16)] */,
				   const char *computername /* [in] [ref,charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [ref] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   enum netr_SamDatabaseID database_id /* [in]  */,
				   enum SyncStateEnum restart_state /* [in]  */,
				   uint32_t *sync_context /* [in,out] [ref] */,
				   struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				   uint32_t preferredmaximumlength /* [in]  */);
struct tevent_req *rpccli_netr_DatabaseRedo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_logon_server /* [in] [ref,charset(UTF16)] */,
						 const char *_computername /* [in] [ref,charset(UTF16)] */,
						 struct netr_Authenticator *_credential /* [in] [ref] */,
						 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						 struct netr_ChangeLogEntry _change_log_entry /* [in] [subcontext_size(change_log_entry_size),subcontext(4)] */,
						 uint32_t _change_log_entry_size /* [in] [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->iconv_convenience,ndr->flags))] */,
						 struct netr_DELTA_ENUM_ARRAY **_delta_enum_array /* [out] [ref] */);
NTSTATUS rpccli_netr_DatabaseRedo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result);
NTSTATUS rpccli_netr_DatabaseRedo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [ref,charset(UTF16)] */,
				  const char *computername /* [in] [ref,charset(UTF16)] */,
				  struct netr_Authenticator *credential /* [in] [ref] */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  struct netr_ChangeLogEntry change_log_entry /* [in] [subcontext_size(change_log_entry_size),subcontext(4)] */,
				  uint32_t change_log_entry_size /* [in] [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->iconv_convenience,ndr->flags))] */,
				  struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */);
struct tevent_req *rpccli_netr_LogonControl2Ex_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_logon_server /* [in] [unique,charset(UTF16)] */,
						    enum netr_LogonControlCode _function_code /* [in]  */,
						    uint32_t _level /* [in]  */,
						    union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
						    union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */);
NTSTATUS rpccli_netr_LogonControl2Ex_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result);
NTSTATUS rpccli_netr_LogonControl2Ex(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *logon_server /* [in] [unique,charset(UTF16)] */,
				     enum netr_LogonControlCode function_code /* [in]  */,
				     uint32_t level /* [in]  */,
				     union netr_CONTROL_DATA_INFORMATION *data /* [in] [ref,switch_is(function_code)] */,
				     union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				     WERROR *werror);
struct tevent_req *rpccli_netr_NetrEnumerateTrustedDomains_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli,
								const char *_server_name /* [in] [unique,charset(UTF16)] */,
								struct netr_Blob *_trusted_domains_blob /* [out] [ref] */);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomains_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomains(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 struct netr_Blob *trusted_domains_blob /* [out] [ref] */,
						 WERROR *werror);
struct tevent_req *rpccli_netr_DsRGetDCName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						 struct GUID *_domain_guid /* [in] [unique] */,
						 struct GUID *_site_guid /* [in] [unique] */,
						 uint32_t _flags /* [in]  */,
						 struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRGetDCName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_netr_DsRGetDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc /* [in] [unique,charset(UTF16)] */,
				  const char *domain_name /* [in] [unique,charset(UTF16)] */,
				  struct GUID *domain_guid /* [in] [unique] */,
				  struct GUID *site_guid /* [in] [unique] */,
				  uint32_t flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				  WERROR *werror);
struct tevent_req *rpccli_netr_LogonGetCapabilities_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 const char *_server_name /* [in] [ref,charset(UTF16)] */,
							 const char *_computer_name /* [in] [unique,charset(UTF16)] */,
							 struct netr_Authenticator *_credential /* [in] [ref] */,
							 struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
							 uint32_t _query_level /* [in]  */,
							 union netr_Capabilities *_capabilities /* [out] [ref,switch_is(query_level)] */);
NTSTATUS rpccli_netr_LogonGetCapabilities_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result);
NTSTATUS rpccli_netr_LogonGetCapabilities(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_name /* [in] [ref,charset(UTF16)] */,
					  const char *computer_name /* [in] [unique,charset(UTF16)] */,
					  struct netr_Authenticator *credential /* [in] [ref] */,
					  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
					  uint32_t query_level /* [in]  */,
					  union netr_Capabilities *capabilities /* [out] [ref,switch_is(query_level)] */);
struct tevent_req *rpccli_netr_NETRLOGONSETSERVICEBITS_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli);
NTSTATUS rpccli_netr_NETRLOGONSETSERVICEBITS_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result);
NTSTATUS rpccli_netr_NETRLOGONSETSERVICEBITS(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror);
struct tevent_req *rpccli_netr_LogonGetTrustRid_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     const char *_server_name /* [in] [unique,charset(UTF16)] */,
						     const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						     uint32_t *_rid /* [out] [ref] */);
NTSTATUS rpccli_netr_LogonGetTrustRid_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_netr_LogonGetTrustRid(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_name /* [in] [unique,charset(UTF16)] */,
				      const char *domain_name /* [in] [unique,charset(UTF16)] */,
				      uint32_t *rid /* [out] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
struct tevent_req *rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
struct tevent_req *rpccli_netr_ServerAuthenticate3_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							const char *_server_name /* [in] [unique,charset(UTF16)] */,
							const char *_account_name /* [in] [ref,charset(UTF16)] */,
							enum netr_SchannelType _secure_channel_type /* [in]  */,
							const char *_computer_name /* [in] [ref,charset(UTF16)] */,
							struct netr_Credential *_credentials /* [in] [ref] */,
							struct netr_Credential *_return_credentials /* [out] [ref] */,
							uint32_t *_negotiate_flags /* [in,out] [ref] */,
							uint32_t *_rid /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerAuthenticate3_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result);
NTSTATUS rpccli_netr_ServerAuthenticate3(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [ref,charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [ref,charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in] [ref] */,
					 struct netr_Credential *return_credentials /* [out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */,
					 uint32_t *rid /* [out] [ref] */);
struct tevent_req *rpccli_netr_DsRGetDCNameEx_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						   const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						   struct GUID *_domain_guid /* [in] [unique] */,
						   const char *_site_name /* [in] [unique,charset(UTF16)] */,
						   uint32_t _flags /* [in]  */,
						   struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRGetDCNameEx_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result);
NTSTATUS rpccli_netr_DsRGetDCNameEx(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    const char *domain_name /* [in] [unique,charset(UTF16)] */,
				    struct GUID *domain_guid /* [in] [unique] */,
				    const char *site_name /* [in] [unique,charset(UTF16)] */,
				    uint32_t flags /* [in]  */,
				    struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				    WERROR *werror);
struct tevent_req *rpccli_netr_DsRGetSiteName_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						   const char **_site /* [out] [ref,charset(UTF16)] */);
NTSTATUS rpccli_netr_DsRGetSiteName_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result);
NTSTATUS rpccli_netr_DsRGetSiteName(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    const char **site /* [out] [ref,charset(UTF16)] */,
				    WERROR *werror);
struct tevent_req *rpccli_netr_LogonGetDomainInfo_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [ref,charset(UTF16)] */,
						       const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [in,out] [ref] */,
						       uint32_t _level /* [in]  */,
						       union netr_WorkstationInfo *_query /* [in] [ref,switch_is(level)] */,
						       union netr_DomainInfo *_info /* [out] [ref,switch_is(level)] */);
NTSTATUS rpccli_netr_LogonGetDomainInfo_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result);
NTSTATUS rpccli_netr_LogonGetDomainInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [ref,charset(UTF16)] */,
					const char *computer_name /* [in] [unique,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
					uint32_t level /* [in]  */,
					union netr_WorkstationInfo *query /* [in] [ref,switch_is(level)] */,
					union netr_DomainInfo *info /* [out] [ref,switch_is(level)] */);
struct tevent_req *rpccli_netr_ServerPasswordSet2_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_account_name /* [in] [ref,charset(UTF16)] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       struct netr_CryptPassword *_new_password /* [in] [ref] */);
NTSTATUS rpccli_netr_ServerPasswordSet2_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result);
NTSTATUS rpccli_netr_ServerPasswordSet2(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [ref,charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					struct netr_CryptPassword *new_password /* [in] [ref] */);
struct tevent_req *rpccli_netr_ServerPasswordGet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      const char *_server_name /* [in] [unique,charset(UTF16)] */,
						      const char *_account_name /* [in] [ref,charset(UTF16)] */,
						      enum netr_SchannelType _secure_channel_type /* [in]  */,
						      const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						      struct netr_Authenticator *_credential /* [in] [ref] */,
						      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						      struct samr_Password *_password /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerPasswordGet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result);
NTSTATUS rpccli_netr_ServerPasswordGet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [ref,charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [ref,charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *password /* [out] [ref] */,
				       WERROR *werror);
struct tevent_req *rpccli_netr_NETRLOGONSENDTOSAM_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli);
NTSTATUS rpccli_netr_NETRLOGONSENDTOSAM_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result);
NTSTATUS rpccli_netr_NETRLOGONSENDTOSAM(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror);
struct tevent_req *rpccli_netr_DsRAddressToSitenamesW_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   const char *_server_name /* [in] [unique,charset(UTF16)] */,
							   uint32_t _count /* [in] [range(0,32000)] */,
							   struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
							   struct netr_DsRAddressToSitenamesWCtr **_ctr /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRAddressToSitenamesW_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_netr_DsRAddressToSitenamesW(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    uint32_t count /* [in] [range(0,32000)] */,
					    struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					    struct netr_DsRAddressToSitenamesWCtr **ctr /* [out] [ref] */,
					    WERROR *werror);
struct tevent_req *rpccli_netr_DsRGetDCNameEx2_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						    const char *_client_account /* [in] [unique,charset(UTF16)] */,
						    uint32_t _mask /* [in]  */,
						    const char *_domain_name /* [in] [unique,charset(UTF16)] */,
						    struct GUID *_domain_guid /* [in] [unique] */,
						    const char *_site_name /* [in] [unique,charset(UTF16)] */,
						    uint32_t _flags /* [in]  */,
						    struct netr_DsRGetDCNameInfo **_info /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRGetDCNameEx2_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result);
NTSTATUS rpccli_netr_DsRGetDCNameEx2(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     const char *client_account /* [in] [unique,charset(UTF16)] */,
				     uint32_t mask /* [in]  */,
				     const char *domain_name /* [in] [unique,charset(UTF16)] */,
				     struct GUID *domain_guid /* [in] [unique] */,
				     const char *site_name /* [in] [unique,charset(UTF16)] */,
				     uint32_t flags /* [in]  */,
				     struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				     WERROR *werror);
struct tevent_req *rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct rpc_pipe_client *cli);
NTSTATUS rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      WERROR *result);
NTSTATUS rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx,
							 WERROR *werror);
struct tevent_req *rpccli_netr_NetrEnumerateTrustedDomainsEx_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct rpc_pipe_client *cli,
								  const char *_server_name /* [in] [unique,charset(UTF16)] */,
								  struct netr_DomainTrustList *_dom_trust_list /* [out] [ref] */);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomainsEx_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							WERROR *result);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomainsEx(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   const char *server_name /* [in] [unique,charset(UTF16)] */,
						   struct netr_DomainTrustList *dom_trust_list /* [out] [ref] */,
						   WERROR *werror);
struct tevent_req *rpccli_netr_DsRAddressToSitenamesExW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     const char *_server_name /* [in] [unique,charset(UTF16)] */,
							     uint32_t _count /* [in] [range(0,32000)] */,
							     struct netr_DsRAddress *_addresses /* [in] [ref,size_is(count)] */,
							     struct netr_DsRAddressToSitenamesExWCtr **_ctr /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRAddressToSitenamesExW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_netr_DsRAddressToSitenamesExW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t count /* [in] [range(0,32000)] */,
					      struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					      struct netr_DsRAddressToSitenamesExWCtr **ctr /* [out] [ref] */,
					      WERROR *werror);
struct tevent_req *rpccli_netr_DsrGetDcSiteCoverageW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  const char *_server_name /* [in] [unique,charset(UTF16)] */,
							  struct DcSitesCtr **_ctr /* [out] [ref] */);
NTSTATUS rpccli_netr_DsrGetDcSiteCoverageW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_netr_DsrGetDcSiteCoverageW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_name /* [in] [unique,charset(UTF16)] */,
					   struct DcSitesCtr **ctr /* [out] [ref] */,
					   WERROR *werror);
struct tevent_req *rpccli_netr_LogonSamLogonEx_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_server_name /* [in] [unique,charset(UTF16)] */,
						    const char *_computer_name /* [in] [unique,charset(UTF16)] */,
						    enum netr_LogonInfoClass _logon_level /* [in]  */,
						    union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
						    uint16_t _validation_level /* [in]  */,
						    union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
						    uint8_t *_authoritative /* [out] [ref] */,
						    uint32_t *_flags /* [in,out] [ref] */);
NTSTATUS rpccli_netr_LogonSamLogonEx_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result);
NTSTATUS rpccli_netr_LogonSamLogonEx(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_name /* [in] [unique,charset(UTF16)] */,
				     const char *computer_name /* [in] [unique,charset(UTF16)] */,
				     enum netr_LogonInfoClass logon_level /* [in]  */,
				     union netr_LogonLevel *logon /* [in] [ref,switch_is(logon_level)] */,
				     uint16_t validation_level /* [in]  */,
				     union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				     uint8_t *authoritative /* [out] [ref] */,
				     uint32_t *flags /* [in,out] [ref] */);
struct tevent_req *rpccli_netr_DsrEnumerateDomainTrusts_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     const char *_server_name /* [in] [unique,charset(UTF16)] */,
							     uint32_t _trust_flags /* [in]  */,
							     struct netr_DomainTrustList *_trusts /* [out] [ref] */);
NTSTATUS rpccli_netr_DsrEnumerateDomainTrusts_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_netr_DsrEnumerateDomainTrusts(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t trust_flags /* [in]  */,
					      struct netr_DomainTrustList *trusts /* [out] [ref] */,
					      WERROR *werror);
struct tevent_req *rpccli_netr_DsrDeregisterDNSHostRecords_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli,
								const char *_server_name /* [in] [unique,charset(UTF16)] */,
								const char *_domain /* [in] [unique,charset(UTF16)] */,
								struct GUID *_domain_guid /* [in] [unique] */,
								struct GUID *_dsa_guid /* [in] [unique] */,
								const char *_dns_host /* [in] [ref,charset(UTF16)] */);
NTSTATUS rpccli_netr_DsrDeregisterDNSHostRecords_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result);
NTSTATUS rpccli_netr_DsrDeregisterDNSHostRecords(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 const char *domain /* [in] [unique,charset(UTF16)] */,
						 struct GUID *domain_guid /* [in] [unique] */,
						 struct GUID *dsa_guid /* [in] [unique] */,
						 const char *dns_host /* [in] [ref,charset(UTF16)] */,
						 WERROR *werror);
struct tevent_req *rpccli_netr_ServerTrustPasswordsGet_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    const char *_server_name /* [in] [unique,charset(UTF16)] */,
							    const char *_account_name /* [in] [ref,charset(UTF16)] */,
							    enum netr_SchannelType _secure_channel_type /* [in]  */,
							    const char *_computer_name /* [in] [ref,charset(UTF16)] */,
							    struct netr_Authenticator *_credential /* [in] [ref] */,
							    struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
							    struct samr_Password *_password /* [out] [ref] */,
							    struct samr_Password *_password2 /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerTrustPasswordsGet_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  NTSTATUS *result);
NTSTATUS rpccli_netr_ServerTrustPasswordsGet(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     const char *server_name /* [in] [unique,charset(UTF16)] */,
					     const char *account_name /* [in] [ref,charset(UTF16)] */,
					     enum netr_SchannelType secure_channel_type /* [in]  */,
					     const char *computer_name /* [in] [ref,charset(UTF16)] */,
					     struct netr_Authenticator *credential /* [in] [ref] */,
					     struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					     struct samr_Password *password /* [out] [ref] */,
					     struct samr_Password *password2 /* [out] [ref] */);
struct tevent_req *rpccli_netr_DsRGetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli,
								 const char *_server_name /* [in] [unique,charset(UTF16)] */,
								 const char *_trusted_domain_name /* [in] [unique,charset(UTF16)] */,
								 uint32_t _flags /* [in]  */,
								 struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRGetForestTrustInformation_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result);
NTSTATUS rpccli_netr_DsRGetForestTrustInformation(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  const char *server_name /* [in] [unique,charset(UTF16)] */,
						  const char *trusted_domain_name /* [in] [unique,charset(UTF16)] */,
						  uint32_t flags /* [in]  */,
						  struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
						  WERROR *werror);
struct tevent_req *rpccli_netr_GetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      const char *_server_name /* [in] [unique,charset(UTF16)] */,
							      const char *_trusted_domain_name /* [in] [ref,charset(UTF16)] */,
							      struct netr_Authenticator *_credential /* [in] [ref] */,
							      struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
							      uint32_t _flags /* [in]  */,
							      struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */);
NTSTATUS rpccli_netr_GetForestTrustInformation_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result);
NTSTATUS rpccli_netr_GetForestTrustInformation(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_name /* [in] [unique,charset(UTF16)] */,
					       const char *trusted_domain_name /* [in] [ref,charset(UTF16)] */,
					       struct netr_Authenticator *credential /* [in] [ref] */,
					       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					       uint32_t flags /* [in]  */,
					       struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
					       WERROR *werror);
struct tevent_req *rpccli_netr_LogonSamLogonWithFlags_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   const char *_server_name /* [in] [unique,charset(UTF16)] */,
							   const char *_computer_name /* [in] [unique,charset(UTF16)] */,
							   struct netr_Authenticator *_credential /* [in] [unique] */,
							   struct netr_Authenticator *_return_authenticator /* [in,out] [unique] */,
							   enum netr_LogonInfoClass _logon_level /* [in]  */,
							   union netr_LogonLevel *_logon /* [in] [ref,switch_is(logon_level)] */,
							   uint16_t _validation_level /* [in]  */,
							   union netr_Validation *_validation /* [out] [ref,switch_is(validation_level)] */,
							   uint8_t *_authoritative /* [out] [ref] */,
							   uint32_t *_flags /* [in,out] [ref] */);
NTSTATUS rpccli_netr_LogonSamLogonWithFlags_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result);
NTSTATUS rpccli_netr_LogonSamLogonWithFlags(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    const char *computer_name /* [in] [unique,charset(UTF16)] */,
					    struct netr_Authenticator *credential /* [in] [unique] */,
					    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
					    enum netr_LogonInfoClass logon_level /* [in]  */,
					    union netr_LogonLevel *logon /* [in] [ref,switch_is(logon_level)] */,
					    uint16_t validation_level /* [in]  */,
					    union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
					    uint8_t *authoritative /* [out] [ref] */,
					    uint32_t *flags /* [in,out] [ref] */);
struct tevent_req *rpccli_netr_ServerGetTrustInfo_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_server_name /* [in] [unique,charset(UTF16)] */,
						       const char *_account_name /* [in] [ref,charset(UTF16)] */,
						       enum netr_SchannelType _secure_channel_type /* [in]  */,
						       const char *_computer_name /* [in] [ref,charset(UTF16)] */,
						       struct netr_Authenticator *_credential /* [in] [ref] */,
						       struct netr_Authenticator *_return_authenticator /* [out] [ref] */,
						       struct samr_Password *_new_owf_password /* [out] [ref] */,
						       struct samr_Password *_old_owf_password /* [out] [ref] */,
						       struct netr_TrustInfo **_trust_info /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerGetTrustInfo_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result);
NTSTATUS rpccli_netr_ServerGetTrustInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [ref,charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [ref,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					struct samr_Password *new_owf_password /* [out] [ref] */,
					struct samr_Password *old_owf_password /* [out] [ref] */,
					struct netr_TrustInfo **trust_info /* [out] [ref] */);
#endif /* __CLI_NETLOGON__ */
