/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "librpc/gen_ndr/srv_wbint.h"

static bool api_wbint_Ping(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_Ping *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_PING];

	r = talloc(talloc_tos(), struct wbint_Ping);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_Ping, r);
	}

	ZERO_STRUCT(r->out);
	r->out.out_data = talloc_zero(r, uint32_t);
	if (r->out.out_data == NULL) {
		talloc_free(r);
		return false;
	}

	_wbint_Ping(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_Ping, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_LookupSid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_LookupSid *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_LOOKUPSID];

	r = talloc(talloc_tos(), struct wbint_LookupSid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_LookupSid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.type = talloc_zero(r, enum lsa_SidType);
	if (r->out.type == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.domain = talloc_zero(r, const char *);
	if (r->out.domain == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.name = talloc_zero(r, const char *);
	if (r->out.name == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_LookupSid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_LookupSid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_LookupName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_LookupName *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_LOOKUPNAME];

	r = talloc(talloc_tos(), struct wbint_LookupName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_LookupName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.type = talloc_zero(r, enum lsa_SidType);
	if (r->out.type == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.sid = talloc_zero(r, struct dom_sid);
	if (r->out.sid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_LookupName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_LookupName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_Sid2Uid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_Sid2Uid *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_SID2UID];

	r = talloc(talloc_tos(), struct wbint_Sid2Uid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_Sid2Uid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.uid = talloc_zero(r, uint64_t);
	if (r->out.uid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_Sid2Uid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_Sid2Uid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_Sid2Gid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_Sid2Gid *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_SID2GID];

	r = talloc(talloc_tos(), struct wbint_Sid2Gid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_Sid2Gid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.gid = talloc_zero(r, uint64_t);
	if (r->out.gid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_Sid2Gid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_Sid2Gid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_Uid2Sid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_Uid2Sid *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_UID2SID];

	r = talloc(talloc_tos(), struct wbint_Uid2Sid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_Uid2Sid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sid = talloc_zero(r, struct dom_sid);
	if (r->out.sid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_Uid2Sid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_Uid2Sid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_Gid2Sid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_Gid2Sid *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_GID2SID];

	r = talloc(talloc_tos(), struct wbint_Gid2Sid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_Gid2Sid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sid = talloc_zero(r, struct dom_sid);
	if (r->out.sid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_Gid2Sid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_Gid2Sid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_AllocateUid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_AllocateUid *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_ALLOCATEUID];

	r = talloc(talloc_tos(), struct wbint_AllocateUid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_AllocateUid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.uid = talloc_zero(r, uint64_t);
	if (r->out.uid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_AllocateUid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_AllocateUid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_AllocateGid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_AllocateGid *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_ALLOCATEGID];

	r = talloc(talloc_tos(), struct wbint_AllocateGid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_AllocateGid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.gid = talloc_zero(r, uint64_t);
	if (r->out.gid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_AllocateGid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_AllocateGid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_QueryUser(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_QueryUser *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_QUERYUSER];

	r = talloc(talloc_tos(), struct wbint_QueryUser);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_QueryUser, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct wbint_userinfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_QueryUser(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_QueryUser, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_LookupUserAliases(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_LookupUserAliases *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_LOOKUPUSERALIASES];

	r = talloc(talloc_tos(), struct wbint_LookupUserAliases);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_LookupUserAliases, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rids = talloc_zero(r, struct wbint_RidArray);
	if (r->out.rids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_LookupUserAliases(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_LookupUserAliases, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_LookupUserGroups(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_LookupUserGroups *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_LOOKUPUSERGROUPS];

	r = talloc(talloc_tos(), struct wbint_LookupUserGroups);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_LookupUserGroups, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sids = talloc_zero(r, struct wbint_SidArray);
	if (r->out.sids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_LookupUserGroups(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_LookupUserGroups, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_QuerySequenceNumber(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_QuerySequenceNumber *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_QUERYSEQUENCENUMBER];

	r = talloc(talloc_tos(), struct wbint_QuerySequenceNumber);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_QuerySequenceNumber, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sequence = talloc_zero(r, uint32_t);
	if (r->out.sequence == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_QuerySequenceNumber(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_QuerySequenceNumber, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_LookupGroupMembers(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_LookupGroupMembers *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_LOOKUPGROUPMEMBERS];

	r = talloc(talloc_tos(), struct wbint_LookupGroupMembers);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_LookupGroupMembers, r);
	}

	ZERO_STRUCT(r->out);
	r->out.members = talloc_zero(r, struct wbint_Principals);
	if (r->out.members == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_LookupGroupMembers(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_LookupGroupMembers, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_QueryUserList(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_QueryUserList *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_QUERYUSERLIST];

	r = talloc(talloc_tos(), struct wbint_QueryUserList);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_QueryUserList, r);
	}

	ZERO_STRUCT(r->out);
	r->out.users = talloc_zero(r, struct wbint_userinfos);
	if (r->out.users == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_QueryUserList(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_QueryUserList, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_QueryGroupList(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_QueryGroupList *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_QUERYGROUPLIST];

	r = talloc(talloc_tos(), struct wbint_QueryGroupList);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_QueryGroupList, r);
	}

	ZERO_STRUCT(r->out);
	r->out.groups = talloc_zero(r, struct wbint_Principals);
	if (r->out.groups == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_QueryGroupList(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_QueryGroupList, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_DsGetDcName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_DsGetDcName *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_DSGETDCNAME];

	r = talloc(talloc_tos(), struct wbint_DsGetDcName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_DsGetDcName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.dc_info = talloc_zero(r, struct netr_DsRGetDCNameInfo *);
	if (r->out.dc_info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_DsGetDcName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_DsGetDcName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_LookupRids(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_LookupRids *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_LOOKUPRIDS];

	r = talloc(talloc_tos(), struct wbint_LookupRids);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_LookupRids, r);
	}

	ZERO_STRUCT(r->out);
	r->out.domain_name = talloc_zero(r, const char *);
	if (r->out.domain_name == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.names = talloc_zero(r, struct wbint_Principals);
	if (r->out.names == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _wbint_LookupRids(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_LookupRids, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_CheckMachineAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_CheckMachineAccount *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_CHECKMACHINEACCOUNT];

	r = talloc(talloc_tos(), struct wbint_CheckMachineAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_CheckMachineAccount, r);
	}

	r->out.result = _wbint_CheckMachineAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_CheckMachineAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_ChangeMachineAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_ChangeMachineAccount *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_CHANGEMACHINEACCOUNT];

	r = talloc(talloc_tos(), struct wbint_ChangeMachineAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_ChangeMachineAccount, r);
	}

	r->out.result = _wbint_ChangeMachineAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_ChangeMachineAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_PingDc(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_PingDc *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_PINGDC];

	r = talloc(talloc_tos(), struct wbint_PingDc);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_PingDc, r);
	}

	r->out.result = _wbint_PingDc(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_PingDc, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_SetMapping(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_SetMapping *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_SETMAPPING];

	r = talloc(talloc_tos(), struct wbint_SetMapping);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_SetMapping, r);
	}

	r->out.result = _wbint_SetMapping(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_SetMapping, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_RemoveMapping(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_RemoveMapping *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_REMOVEMAPPING];

	r = talloc(talloc_tos(), struct wbint_RemoveMapping);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_RemoveMapping, r);
	}

	r->out.result = _wbint_RemoveMapping(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_RemoveMapping, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_wbint_SetHWM(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct wbint_SetHWM *r;

	call = &ndr_table_wbint.calls[NDR_WBINT_SETHWM];

	r = talloc(talloc_tos(), struct wbint_SetHWM);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(wbint_SetHWM, r);
	}

	r->out.result = _wbint_SetHWM(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(wbint_SetHWM, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_wbint_cmds[] = 
{
	{"WBINT_PING", NDR_WBINT_PING, api_wbint_Ping},
	{"WBINT_LOOKUPSID", NDR_WBINT_LOOKUPSID, api_wbint_LookupSid},
	{"WBINT_LOOKUPNAME", NDR_WBINT_LOOKUPNAME, api_wbint_LookupName},
	{"WBINT_SID2UID", NDR_WBINT_SID2UID, api_wbint_Sid2Uid},
	{"WBINT_SID2GID", NDR_WBINT_SID2GID, api_wbint_Sid2Gid},
	{"WBINT_UID2SID", NDR_WBINT_UID2SID, api_wbint_Uid2Sid},
	{"WBINT_GID2SID", NDR_WBINT_GID2SID, api_wbint_Gid2Sid},
	{"WBINT_ALLOCATEUID", NDR_WBINT_ALLOCATEUID, api_wbint_AllocateUid},
	{"WBINT_ALLOCATEGID", NDR_WBINT_ALLOCATEGID, api_wbint_AllocateGid},
	{"WBINT_QUERYUSER", NDR_WBINT_QUERYUSER, api_wbint_QueryUser},
	{"WBINT_LOOKUPUSERALIASES", NDR_WBINT_LOOKUPUSERALIASES, api_wbint_LookupUserAliases},
	{"WBINT_LOOKUPUSERGROUPS", NDR_WBINT_LOOKUPUSERGROUPS, api_wbint_LookupUserGroups},
	{"WBINT_QUERYSEQUENCENUMBER", NDR_WBINT_QUERYSEQUENCENUMBER, api_wbint_QuerySequenceNumber},
	{"WBINT_LOOKUPGROUPMEMBERS", NDR_WBINT_LOOKUPGROUPMEMBERS, api_wbint_LookupGroupMembers},
	{"WBINT_QUERYUSERLIST", NDR_WBINT_QUERYUSERLIST, api_wbint_QueryUserList},
	{"WBINT_QUERYGROUPLIST", NDR_WBINT_QUERYGROUPLIST, api_wbint_QueryGroupList},
	{"WBINT_DSGETDCNAME", NDR_WBINT_DSGETDCNAME, api_wbint_DsGetDcName},
	{"WBINT_LOOKUPRIDS", NDR_WBINT_LOOKUPRIDS, api_wbint_LookupRids},
	{"WBINT_CHECKMACHINEACCOUNT", NDR_WBINT_CHECKMACHINEACCOUNT, api_wbint_CheckMachineAccount},
	{"WBINT_CHANGEMACHINEACCOUNT", NDR_WBINT_CHANGEMACHINEACCOUNT, api_wbint_ChangeMachineAccount},
	{"WBINT_PINGDC", NDR_WBINT_PINGDC, api_wbint_PingDc},
	{"WBINT_SETMAPPING", NDR_WBINT_SETMAPPING, api_wbint_SetMapping},
	{"WBINT_REMOVEMAPPING", NDR_WBINT_REMOVEMAPPING, api_wbint_RemoveMapping},
	{"WBINT_SETHWM", NDR_WBINT_SETHWM, api_wbint_SetHWM},
};

void wbint_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_wbint_cmds;
	*n_fns = sizeof(api_wbint_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_wbint_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_WBINT_PING: {
			struct wbint_Ping *r = (struct wbint_Ping *)_r;
			ZERO_STRUCT(r->out);
			r->out.out_data = talloc_zero(mem_ctx, uint32_t);
			if (r->out.out_data == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			_wbint_Ping(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_LOOKUPSID: {
			struct wbint_LookupSid *r = (struct wbint_LookupSid *)_r;
			ZERO_STRUCT(r->out);
			r->out.type = talloc_zero(mem_ctx, enum lsa_SidType);
			if (r->out.type == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.domain = talloc_zero(mem_ctx, const char *);
			if (r->out.domain == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.name = talloc_zero(mem_ctx, const char *);
			if (r->out.name == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_LookupSid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_LOOKUPNAME: {
			struct wbint_LookupName *r = (struct wbint_LookupName *)_r;
			ZERO_STRUCT(r->out);
			r->out.type = talloc_zero(mem_ctx, enum lsa_SidType);
			if (r->out.type == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.sid = talloc_zero(mem_ctx, struct dom_sid);
			if (r->out.sid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_LookupName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_SID2UID: {
			struct wbint_Sid2Uid *r = (struct wbint_Sid2Uid *)_r;
			ZERO_STRUCT(r->out);
			r->out.uid = talloc_zero(mem_ctx, uint64_t);
			if (r->out.uid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_Sid2Uid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_SID2GID: {
			struct wbint_Sid2Gid *r = (struct wbint_Sid2Gid *)_r;
			ZERO_STRUCT(r->out);
			r->out.gid = talloc_zero(mem_ctx, uint64_t);
			if (r->out.gid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_Sid2Gid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_UID2SID: {
			struct wbint_Uid2Sid *r = (struct wbint_Uid2Sid *)_r;
			ZERO_STRUCT(r->out);
			r->out.sid = talloc_zero(mem_ctx, struct dom_sid);
			if (r->out.sid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_Uid2Sid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_GID2SID: {
			struct wbint_Gid2Sid *r = (struct wbint_Gid2Sid *)_r;
			ZERO_STRUCT(r->out);
			r->out.sid = talloc_zero(mem_ctx, struct dom_sid);
			if (r->out.sid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_Gid2Sid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_ALLOCATEUID: {
			struct wbint_AllocateUid *r = (struct wbint_AllocateUid *)_r;
			ZERO_STRUCT(r->out);
			r->out.uid = talloc_zero(mem_ctx, uint64_t);
			if (r->out.uid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_AllocateUid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_ALLOCATEGID: {
			struct wbint_AllocateGid *r = (struct wbint_AllocateGid *)_r;
			ZERO_STRUCT(r->out);
			r->out.gid = talloc_zero(mem_ctx, uint64_t);
			if (r->out.gid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_AllocateGid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_QUERYUSER: {
			struct wbint_QueryUser *r = (struct wbint_QueryUser *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, struct wbint_userinfo);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_QueryUser(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_LOOKUPUSERALIASES: {
			struct wbint_LookupUserAliases *r = (struct wbint_LookupUserAliases *)_r;
			ZERO_STRUCT(r->out);
			r->out.rids = talloc_zero(mem_ctx, struct wbint_RidArray);
			if (r->out.rids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_LookupUserAliases(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_LOOKUPUSERGROUPS: {
			struct wbint_LookupUserGroups *r = (struct wbint_LookupUserGroups *)_r;
			ZERO_STRUCT(r->out);
			r->out.sids = talloc_zero(mem_ctx, struct wbint_SidArray);
			if (r->out.sids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_LookupUserGroups(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_QUERYSEQUENCENUMBER: {
			struct wbint_QuerySequenceNumber *r = (struct wbint_QuerySequenceNumber *)_r;
			ZERO_STRUCT(r->out);
			r->out.sequence = talloc_zero(mem_ctx, uint32_t);
			if (r->out.sequence == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_QuerySequenceNumber(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_LOOKUPGROUPMEMBERS: {
			struct wbint_LookupGroupMembers *r = (struct wbint_LookupGroupMembers *)_r;
			ZERO_STRUCT(r->out);
			r->out.members = talloc_zero(mem_ctx, struct wbint_Principals);
			if (r->out.members == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_LookupGroupMembers(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_QUERYUSERLIST: {
			struct wbint_QueryUserList *r = (struct wbint_QueryUserList *)_r;
			ZERO_STRUCT(r->out);
			r->out.users = talloc_zero(mem_ctx, struct wbint_userinfos);
			if (r->out.users == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_QueryUserList(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_QUERYGROUPLIST: {
			struct wbint_QueryGroupList *r = (struct wbint_QueryGroupList *)_r;
			ZERO_STRUCT(r->out);
			r->out.groups = talloc_zero(mem_ctx, struct wbint_Principals);
			if (r->out.groups == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_QueryGroupList(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_DSGETDCNAME: {
			struct wbint_DsGetDcName *r = (struct wbint_DsGetDcName *)_r;
			ZERO_STRUCT(r->out);
			r->out.dc_info = talloc_zero(mem_ctx, struct netr_DsRGetDCNameInfo *);
			if (r->out.dc_info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_DsGetDcName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_LOOKUPRIDS: {
			struct wbint_LookupRids *r = (struct wbint_LookupRids *)_r;
			ZERO_STRUCT(r->out);
			r->out.domain_name = talloc_zero(mem_ctx, const char *);
			if (r->out.domain_name == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.names = talloc_zero(mem_ctx, struct wbint_Principals);
			if (r->out.names == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _wbint_LookupRids(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_CHECKMACHINEACCOUNT: {
			struct wbint_CheckMachineAccount *r = (struct wbint_CheckMachineAccount *)_r;
			r->out.result = _wbint_CheckMachineAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_CHANGEMACHINEACCOUNT: {
			struct wbint_ChangeMachineAccount *r = (struct wbint_ChangeMachineAccount *)_r;
			r->out.result = _wbint_ChangeMachineAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_PINGDC: {
			struct wbint_PingDc *r = (struct wbint_PingDc *)_r;
			r->out.result = _wbint_PingDc(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_SETMAPPING: {
			struct wbint_SetMapping *r = (struct wbint_SetMapping *)_r;
			r->out.result = _wbint_SetMapping(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_REMOVEMAPPING: {
			struct wbint_RemoveMapping *r = (struct wbint_RemoveMapping *)_r;
			r->out.result = _wbint_RemoveMapping(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_WBINT_SETHWM: {
			struct wbint_SetHWM *r = (struct wbint_SetHWM *)_r;
			r->out.result = _wbint_SetHWM(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_wbint_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "wbint", "wbint", &ndr_table_wbint, api_wbint_cmds, sizeof(api_wbint_cmds) / sizeof(struct api_struct));
}
