
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "librpc/gen_ndr/ndr_dnsp.h"
#include "librpc/gen_ndr/ndr_dnsp_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject dnsp_soa_Type;
staticforward PyTypeObject dnsp_mx_Type;
staticforward PyTypeObject dnsp_hinfo_Type;
staticforward PyTypeObject dnsp_srv_Type;
staticforward PyTypeObject dnsp_DnssrvRpcRecord_Type;
staticforward PyTypeObject dnsp_InterfaceType;

void initdnsp(void);static PyTypeObject *Object_Type;
static PyTypeObject *ClientConnection_Type;

static PyObject *py_dnsp_soa_get_serial(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(obj);
	PyObject *py_serial;
	py_serial = PyInt_FromLong(object->serial);
	return py_serial;
}

static int py_dnsp_soa_set_serial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_soa_get_refresh(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(obj);
	PyObject *py_refresh;
	py_refresh = PyInt_FromLong(object->refresh);
	return py_refresh;
}

static int py_dnsp_soa_set_refresh(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->refresh = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_soa_get_retry(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(obj);
	PyObject *py_retry;
	py_retry = PyInt_FromLong(object->retry);
	return py_retry;
}

static int py_dnsp_soa_set_retry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->retry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_soa_get_expire(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(obj);
	PyObject *py_expire;
	py_expire = PyInt_FromLong(object->expire);
	return py_expire;
}

static int py_dnsp_soa_set_expire(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->expire = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_soa_get_minimum(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(obj);
	PyObject *py_minimum;
	py_minimum = PyInt_FromLong(object->minimum);
	return py_minimum;
}

static int py_dnsp_soa_set_minimum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->minimum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_soa_get_mname(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(obj);
	PyObject *py_mname;
	py_mname = PyString_FromStringOrNULL(object->mname);
	return py_mname;
}

static int py_dnsp_soa_set_mname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	object->mname = PyString_AS_STRING(value);
	return 0;
}

static PyObject *py_dnsp_soa_get_rname(PyObject *obj, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(obj);
	PyObject *py_rname;
	py_rname = PyString_FromStringOrNULL(object->rname);
	return py_rname;
}

static int py_dnsp_soa_set_rname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	object->rname = PyString_AS_STRING(value);
	return 0;
}

static PyGetSetDef py_dnsp_soa_getsetters[] = {
	{ discard_const_p(char, "serial"), py_dnsp_soa_get_serial, py_dnsp_soa_set_serial },
	{ discard_const_p(char, "refresh"), py_dnsp_soa_get_refresh, py_dnsp_soa_set_refresh },
	{ discard_const_p(char, "retry"), py_dnsp_soa_get_retry, py_dnsp_soa_set_retry },
	{ discard_const_p(char, "expire"), py_dnsp_soa_get_expire, py_dnsp_soa_set_expire },
	{ discard_const_p(char, "minimum"), py_dnsp_soa_get_minimum, py_dnsp_soa_set_minimum },
	{ discard_const_p(char, "mname"), py_dnsp_soa_get_mname, py_dnsp_soa_set_mname },
	{ discard_const_p(char, "rname"), py_dnsp_soa_get_rname, py_dnsp_soa_set_rname },
	{ NULL }
};

static PyObject *py_dnsp_soa_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dnsp_soa, type);
}

static PyObject *py_dnsp_soa_ndr_pack(PyObject *py_obj)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dnsp_soa);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dnsp_soa_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_soa);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_soa_ndr_print(PyObject *py_obj)
{
	struct dnsp_soa *object = (struct dnsp_soa *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_soa, "dnsp_soa", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_soa_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_soa_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dnsp_soa_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_soa_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_soa_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsp.soa",
	.tp_getset = py_dnsp_soa_getsetters,
	.tp_methods = py_dnsp_soa_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dnsp_soa_new,
};


static PyObject *py_dnsp_mx_get_wPriority(PyObject *obj, void *closure)
{
	struct dnsp_mx *object = (struct dnsp_mx *)py_talloc_get_ptr(obj);
	PyObject *py_wPriority;
	py_wPriority = PyInt_FromLong(object->wPriority);
	return py_wPriority;
}

static int py_dnsp_mx_set_wPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_mx *object = (struct dnsp_mx *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wPriority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_mx_get_nameTarget(PyObject *obj, void *closure)
{
	struct dnsp_mx *object = (struct dnsp_mx *)py_talloc_get_ptr(obj);
	PyObject *py_nameTarget;
	py_nameTarget = PyString_FromStringOrNULL(object->nameTarget);
	return py_nameTarget;
}

static int py_dnsp_mx_set_nameTarget(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_mx *object = (struct dnsp_mx *)py_talloc_get_ptr(py_obj);
	object->nameTarget = PyString_AS_STRING(value);
	return 0;
}

static PyGetSetDef py_dnsp_mx_getsetters[] = {
	{ discard_const_p(char, "wPriority"), py_dnsp_mx_get_wPriority, py_dnsp_mx_set_wPriority },
	{ discard_const_p(char, "nameTarget"), py_dnsp_mx_get_nameTarget, py_dnsp_mx_set_nameTarget },
	{ NULL }
};

static PyObject *py_dnsp_mx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dnsp_mx, type);
}

static PyObject *py_dnsp_mx_ndr_pack(PyObject *py_obj)
{
	struct dnsp_mx *object = (struct dnsp_mx *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dnsp_mx);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dnsp_mx_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dnsp_mx *object = (struct dnsp_mx *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_mx);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_mx_ndr_print(PyObject *py_obj)
{
	struct dnsp_mx *object = (struct dnsp_mx *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_mx, "dnsp_mx", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_mx_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_mx_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dnsp_mx_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_mx_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_mx_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsp.mx",
	.tp_getset = py_dnsp_mx_getsetters,
	.tp_methods = py_dnsp_mx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dnsp_mx_new,
};


static PyObject *py_dnsp_hinfo_get_cpu(PyObject *obj, void *closure)
{
	struct dnsp_hinfo *object = (struct dnsp_hinfo *)py_talloc_get_ptr(obj);
	PyObject *py_cpu;
	py_cpu = PyString_FromStringOrNULL(object->cpu);
	return py_cpu;
}

static int py_dnsp_hinfo_set_cpu(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_hinfo *object = (struct dnsp_hinfo *)py_talloc_get_ptr(py_obj);
	object->cpu = PyString_AS_STRING(value);
	return 0;
}

static PyObject *py_dnsp_hinfo_get_os(PyObject *obj, void *closure)
{
	struct dnsp_hinfo *object = (struct dnsp_hinfo *)py_talloc_get_ptr(obj);
	PyObject *py_os;
	py_os = PyString_FromStringOrNULL(object->os);
	return py_os;
}

static int py_dnsp_hinfo_set_os(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_hinfo *object = (struct dnsp_hinfo *)py_talloc_get_ptr(py_obj);
	object->os = PyString_AS_STRING(value);
	return 0;
}

static PyGetSetDef py_dnsp_hinfo_getsetters[] = {
	{ discard_const_p(char, "cpu"), py_dnsp_hinfo_get_cpu, py_dnsp_hinfo_set_cpu },
	{ discard_const_p(char, "os"), py_dnsp_hinfo_get_os, py_dnsp_hinfo_set_os },
	{ NULL }
};

static PyObject *py_dnsp_hinfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dnsp_hinfo, type);
}

static PyObject *py_dnsp_hinfo_ndr_pack(PyObject *py_obj)
{
	struct dnsp_hinfo *object = (struct dnsp_hinfo *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dnsp_hinfo);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dnsp_hinfo_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dnsp_hinfo *object = (struct dnsp_hinfo *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_hinfo);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_hinfo_ndr_print(PyObject *py_obj)
{
	struct dnsp_hinfo *object = (struct dnsp_hinfo *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_hinfo, "dnsp_hinfo", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_hinfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_hinfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dnsp_hinfo_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_hinfo_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_hinfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsp.hinfo",
	.tp_getset = py_dnsp_hinfo_getsetters,
	.tp_methods = py_dnsp_hinfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dnsp_hinfo_new,
};


static PyObject *py_dnsp_srv_get_wPriority(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(obj);
	PyObject *py_wPriority;
	py_wPriority = PyInt_FromLong(object->wPriority);
	return py_wPriority;
}

static int py_dnsp_srv_set_wPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wPriority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_srv_get_wWeight(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(obj);
	PyObject *py_wWeight;
	py_wWeight = PyInt_FromLong(object->wWeight);
	return py_wWeight;
}

static int py_dnsp_srv_set_wWeight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wWeight = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_srv_get_wPort(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(obj);
	PyObject *py_wPort;
	py_wPort = PyInt_FromLong(object->wPort);
	return py_wPort;
}

static int py_dnsp_srv_set_wPort(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wPort = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_srv_get_nameTarget(PyObject *obj, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(obj);
	PyObject *py_nameTarget;
	py_nameTarget = PyString_FromStringOrNULL(object->nameTarget);
	return py_nameTarget;
}

static int py_dnsp_srv_set_nameTarget(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(py_obj);
	object->nameTarget = PyString_AS_STRING(value);
	return 0;
}

static PyGetSetDef py_dnsp_srv_getsetters[] = {
	{ discard_const_p(char, "wPriority"), py_dnsp_srv_get_wPriority, py_dnsp_srv_set_wPriority },
	{ discard_const_p(char, "wWeight"), py_dnsp_srv_get_wWeight, py_dnsp_srv_set_wWeight },
	{ discard_const_p(char, "wPort"), py_dnsp_srv_get_wPort, py_dnsp_srv_set_wPort },
	{ discard_const_p(char, "nameTarget"), py_dnsp_srv_get_nameTarget, py_dnsp_srv_set_nameTarget },
	{ NULL }
};

static PyObject *py_dnsp_srv_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dnsp_srv, type);
}

static PyObject *py_dnsp_srv_ndr_pack(PyObject *py_obj)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dnsp_srv);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dnsp_srv_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_srv);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_srv_ndr_print(PyObject *py_obj)
{
	struct dnsp_srv *object = (struct dnsp_srv *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_srv, "dnsp_srv", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_srv_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_srv_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dnsp_srv_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_srv_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_srv_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsp.srv",
	.tp_getset = py_dnsp_srv_getsetters,
	.tp_methods = py_dnsp_srv_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dnsp_srv_new,
};

PyObject *py_import_dnsRecordData(TALLOC_CTX *mem_ctx, int level, union dnsRecordData *in)
{
	PyObject *ret;

	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			ret = PyLong_FromLongLong(in->timestamp);
			return ret;

		case DNS_TYPE_A:
			ret = PyString_FromStringOrNULL(in->ipv4);
			return ret;

		case DNS_TYPE_NS:
			ret = PyString_FromStringOrNULL(in->ns);
			return ret;

		case DNS_TYPE_CNAME:
			ret = PyString_FromStringOrNULL(in->cname);
			return ret;

		case DNS_TYPE_SOA:
			ret = py_talloc_reference_ex(&dnsp_soa_Type, mem_ctx, &in->soa);
			return ret;

		case DNS_TYPE_MX:
			ret = py_talloc_reference_ex(&dnsp_mx_Type, mem_ctx, &in->mx);
			return ret;

		case DNS_TYPE_TXT:
			ret = PyString_FromStringOrNULL(in->txt);
			return ret;

		case DNS_TYPE_PTR:
			ret = PyString_FromStringOrNULL(in->ptr);
			return ret;

		case DNS_TYPE_HINFO:
			ret = py_talloc_reference_ex(&dnsp_hinfo_Type, mem_ctx, &in->hinfo);
			return ret;

		case DNS_TYPE_AAAA:
			ret = PyString_FromStringOrNULL(in->ipv6);
			return ret;

		case DNS_TYPE_SRV:
			ret = py_talloc_reference_ex(&dnsp_srv_Type, mem_ctx, &in->srv);
			return ret;

		default:
			ret = PyString_FromStringAndSize((char *)(in->data).data, (in->data).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dnsRecordData *py_export_dnsRecordData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dnsRecordData *ret = talloc_zero(mem_ctx, union dnsRecordData);
	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			if (PyLong_Check(in)) {
				ret->timestamp = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->timestamp = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case DNS_TYPE_A:
			ret->ipv4 = PyString_AS_STRING(in);
			break;

		case DNS_TYPE_NS:
			ret->ns = PyString_AS_STRING(in);
			break;

		case DNS_TYPE_CNAME:
			ret->cname = PyString_AS_STRING(in);
			break;

		case DNS_TYPE_SOA:
			PY_CHECK_TYPE(&dnsp_soa_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->soa = *(struct dnsp_soa *)py_talloc_get_ptr(in);
			break;

		case DNS_TYPE_MX:
			PY_CHECK_TYPE(&dnsp_mx_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mx = *(struct dnsp_mx *)py_talloc_get_ptr(in);
			break;

		case DNS_TYPE_TXT:
			ret->txt = PyString_AS_STRING(in);
			break;

		case DNS_TYPE_PTR:
			ret->ptr = PyString_AS_STRING(in);
			break;

		case DNS_TYPE_HINFO:
			PY_CHECK_TYPE(&dnsp_hinfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->hinfo = *(struct dnsp_hinfo *)py_talloc_get_ptr(in);
			break;

		case DNS_TYPE_AAAA:
			ret->ipv6 = PyString_AsString(in);
			break;

		case DNS_TYPE_SRV:
			PY_CHECK_TYPE(&dnsp_srv_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv = *(struct dnsp_srv *)py_talloc_get_ptr(in);
			break;

		default:
			ret->data = data_blob_talloc(mem_ctx, PyString_AS_STRING(in), PyString_GET_SIZE(in));
			break;

	}

	return ret;
}


static PyObject *py_dnsp_DnssrvRpcRecord_get_wDataLength(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_wDataLength;
	py_wDataLength = PyInt_FromLong(object->wDataLength);
	return py_wDataLength;
}

static int py_dnsp_DnssrvRpcRecord_set_wDataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wDataLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_wType(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_wType;
	py_wType = PyInt_FromLong(object->wType);
	return py_wType;
}

static int py_dnsp_DnssrvRpcRecord_set_wType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->wType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->wType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_version(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dnsp_DnssrvRpcRecord_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_rank(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_rank;
	py_rank = PyInt_FromLong(object->rank);
	return py_rank;
}

static int py_dnsp_DnssrvRpcRecord_set_rank(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rank = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rank = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_flags(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_dnsp_DnssrvRpcRecord_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwSerial(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_dwSerial;
	py_dwSerial = PyInt_FromLong(object->dwSerial);
	return py_dwSerial;
}

static int py_dnsp_DnssrvRpcRecord_set_dwSerial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwSerial = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwTtlSeconds(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_dwTtlSeconds;
	py_dwTtlSeconds = PyInt_FromLong(object->dwTtlSeconds);
	return py_dwTtlSeconds;
}

static int py_dnsp_DnssrvRpcRecord_set_dwTtlSeconds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwTtlSeconds = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwReserved(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyInt_FromLong(object->dwReserved);
	return py_dwReserved;
}

static int py_dnsp_DnssrvRpcRecord_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_dwTimeStamp(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_dwTimeStamp;
	py_dwTimeStamp = PyInt_FromLong(object->dwTimeStamp);
	return py_dwTimeStamp;
}

static int py_dnsp_DnssrvRpcRecord_set_dwTimeStamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwTimeStamp = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dnsp_DnssrvRpcRecord_get_data(PyObject *obj, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	py_data = py_import_dnsRecordData(py_talloc_get_mem_ctx(obj), object->wType, &object->data);
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_dnsp_DnssrvRpcRecord_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	{
		union dnsRecordData *data_switch_0;
		data_switch_0 = py_export_dnsRecordData(py_talloc_get_mem_ctx(py_obj), object->wType, value);
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dnsp_DnssrvRpcRecord_getsetters[] = {
	{ discard_const_p(char, "wDataLength"), py_dnsp_DnssrvRpcRecord_get_wDataLength, py_dnsp_DnssrvRpcRecord_set_wDataLength },
	{ discard_const_p(char, "wType"), py_dnsp_DnssrvRpcRecord_get_wType, py_dnsp_DnssrvRpcRecord_set_wType },
	{ discard_const_p(char, "version"), py_dnsp_DnssrvRpcRecord_get_version, py_dnsp_DnssrvRpcRecord_set_version },
	{ discard_const_p(char, "rank"), py_dnsp_DnssrvRpcRecord_get_rank, py_dnsp_DnssrvRpcRecord_set_rank },
	{ discard_const_p(char, "flags"), py_dnsp_DnssrvRpcRecord_get_flags, py_dnsp_DnssrvRpcRecord_set_flags },
	{ discard_const_p(char, "dwSerial"), py_dnsp_DnssrvRpcRecord_get_dwSerial, py_dnsp_DnssrvRpcRecord_set_dwSerial },
	{ discard_const_p(char, "dwTtlSeconds"), py_dnsp_DnssrvRpcRecord_get_dwTtlSeconds, py_dnsp_DnssrvRpcRecord_set_dwTtlSeconds },
	{ discard_const_p(char, "dwReserved"), py_dnsp_DnssrvRpcRecord_get_dwReserved, py_dnsp_DnssrvRpcRecord_set_dwReserved },
	{ discard_const_p(char, "dwTimeStamp"), py_dnsp_DnssrvRpcRecord_get_dwTimeStamp, py_dnsp_DnssrvRpcRecord_set_dwTimeStamp },
	{ discard_const_p(char, "data"), py_dnsp_DnssrvRpcRecord_get_data, py_dnsp_DnssrvRpcRecord_set_data },
	{ NULL }
};

static PyObject *py_dnsp_DnssrvRpcRecord_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dnsp_DnssrvRpcRecord, type);
}

static PyObject *py_dnsp_DnssrvRpcRecord_ndr_pack(PyObject *py_obj)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dnsp_DnssrvRpcRecord);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dnsp_DnssrvRpcRecord_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dnsp_DnssrvRpcRecord);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dnsp_DnssrvRpcRecord_ndr_print(PyObject *py_obj)
{
	struct dnsp_DnssrvRpcRecord *object = (struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dnsp_DnssrvRpcRecord, "dnsp_DnssrvRpcRecord", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dnsp_DnssrvRpcRecord_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dnsp_DnssrvRpcRecord_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dnsp_DnssrvRpcRecord_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dnsp_DnssrvRpcRecord_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsp_DnssrvRpcRecord_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsp.DnssrvRpcRecord",
	.tp_getset = py_dnsp_DnssrvRpcRecord_getsetters,
	.tp_methods = py_dnsp_DnssrvRpcRecord_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dnsp_DnssrvRpcRecord_new,
};


static bool pack_py_decode_DnssrvRpcRecord_args_in(PyObject *args, PyObject *kwargs, struct decode_DnssrvRpcRecord *r)
{
	PyObject *py_blob;
	const char *kwnames[] = {
		"blob", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:decode_DnssrvRpcRecord", discard_const_p(char *, kwnames), &py_blob)) {
		return false;
	}

	PY_CHECK_TYPE(&dnsp_DnssrvRpcRecord_Type, py_blob, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_blob)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.blob = *(struct dnsp_DnssrvRpcRecord *)py_talloc_get_ptr(py_blob);
	return true;
}

static PyObject *unpack_py_decode_DnssrvRpcRecord_args_out(struct decode_DnssrvRpcRecord *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_dnsp_methods[] = {
	{ "decode_DnssrvRpcRecord", "S.decode_DnssrvRpcRecord(blob) -> None", (py_dcerpc_call_fn)dcerpc_decode_DnssrvRpcRecord_r, (py_data_pack_fn)pack_py_decode_DnssrvRpcRecord_args_in, (py_data_unpack_fn)unpack_py_decode_DnssrvRpcRecord_args_out, 0, &ndr_table_dnsp },
	{ NULL }
};

static PyObject *interface_dnsp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_dnsp);
}

#define PY_DOC_DNSP "DNSP interfaces"
static PyTypeObject dnsp_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsp.dnsp",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "dnsp(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_DNSP,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_dnsp_new,
};

static PyMethodDef dnsp_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initdnsp(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_base;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	dnsp_soa_Type.tp_base = Object_Type;

	dnsp_mx_Type.tp_base = Object_Type;

	dnsp_hinfo_Type.tp_base = Object_Type;

	dnsp_srv_Type.tp_base = Object_Type;

	dnsp_DnssrvRpcRecord_Type.tp_base = Object_Type;

	dnsp_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&dnsp_soa_Type) < 0)
		return;
	if (PyType_Ready(&dnsp_mx_Type) < 0)
		return;
	if (PyType_Ready(&dnsp_hinfo_Type) < 0)
		return;
	if (PyType_Ready(&dnsp_srv_Type) < 0)
		return;
	if (PyType_Ready(&dnsp_DnssrvRpcRecord_Type) < 0)
		return;
	if (PyType_Ready(&dnsp_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&dnsp_InterfaceType, py_ndr_dnsp_methods))
		return;

#ifdef PY_SOA_PATCH
	PY_SOA_PATCH(&dnsp_soa_Type);
#endif
#ifdef PY_MX_PATCH
	PY_MX_PATCH(&dnsp_mx_Type);
#endif
#ifdef PY_HINFO_PATCH
	PY_HINFO_PATCH(&dnsp_hinfo_Type);
#endif
#ifdef PY_SRV_PATCH
	PY_SRV_PATCH(&dnsp_srv_Type);
#endif
#ifdef PY_DNSSRVRPCRECORD_PATCH
	PY_DNSSRVRPCRECORD_PATCH(&dnsp_DnssrvRpcRecord_Type);
#endif
#ifdef PY_DNSP_PATCH
	PY_DNSP_PATCH(&dnsp_InterfaceType);
#endif

	m = Py_InitModule3("dnsp", dnsp_methods, "dnsp DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DNS_RANK_CACHE_NA_ANSWER", PyInt_FromLong(DNS_RANK_CACHE_NA_ANSWER));
	PyModule_AddObject(m, "DNS_TYPE_WINSR", PyInt_FromLong(DNS_TYPE_WINSR));
	PyModule_AddObject(m, "DNS_RANK_ZONE", PyInt_FromLong(DNS_RANK_ZONE));
	PyModule_AddObject(m, "DNS_TYPE_AAAA", PyInt_FromLong(DNS_TYPE_AAAA));
	PyModule_AddObject(m, "DNS_RANK_CACHE_A_AUTHORITY", PyInt_FromLong(DNS_RANK_CACHE_A_AUTHORITY));
	PyModule_AddObject(m, "DNS_RANK_NONE", PyInt_FromLong(DNS_RANK_NONE));
	PyModule_AddObject(m, "DNS_TYPE_SIG", PyInt_FromLong(DNS_TYPE_SIG));
	PyModule_AddObject(m, "DNS_RANK_OUTSIDE_GLUE", PyInt_FromLong(DNS_RANK_OUTSIDE_GLUE));
	PyModule_AddObject(m, "DNS_TYPE_HINFO", PyInt_FromLong(DNS_TYPE_HINFO));
	PyModule_AddObject(m, "DNS_RANK_CACHE_A_ADDITIONAL", PyInt_FromLong(DNS_RANK_CACHE_A_ADDITIONAL));
	PyModule_AddObject(m, "DNS_TYPE_SRV", PyInt_FromLong(DNS_TYPE_SRV));
	PyModule_AddObject(m, "DNS_TYPE_X25", PyInt_FromLong(DNS_TYPE_X25));
	PyModule_AddObject(m, "DNS_TYPE_NULL", PyInt_FromLong(DNS_TYPE_NULL));
	PyModule_AddObject(m, "DNS_TYPE_RP", PyInt_FromLong(DNS_TYPE_RP));
	PyModule_AddObject(m, "DNS_TYPE_MG", PyInt_FromLong(DNS_TYPE_MG));
	PyModule_AddObject(m, "DNS_TYPE_DNAME", PyInt_FromLong(DNS_TYPE_DNAME));
	PyModule_AddObject(m, "DNS_TYPE_MB", PyInt_FromLong(DNS_TYPE_MB));
	PyModule_AddObject(m, "DNS_TYPE_MD", PyInt_FromLong(DNS_TYPE_MD));
	PyModule_AddObject(m, "DNS_TYPE_NS", PyInt_FromLong(DNS_TYPE_NS));
	PyModule_AddObject(m, "DNS_TYPE_KEY", PyInt_FromLong(DNS_TYPE_KEY));
	PyModule_AddObject(m, "DNS_TYPE_WINS", PyInt_FromLong(DNS_TYPE_WINS));
	PyModule_AddObject(m, "DNS_TYPE_DHCID", PyInt_FromLong(DNS_TYPE_DHCID));
	PyModule_AddObject(m, "DNS_TYPE_DS", PyInt_FromLong(DNS_TYPE_DS));
	PyModule_AddObject(m, "DNS_TYPE_ATMA", PyInt_FromLong(DNS_TYPE_ATMA));
	PyModule_AddObject(m, "DNS_TYPE_NAPTR", PyInt_FromLong(DNS_TYPE_NAPTR));
	PyModule_AddObject(m, "DNS_TYPE_LOC", PyInt_FromLong(DNS_TYPE_LOC));
	PyModule_AddObject(m, "DNS_TYPE_PTR", PyInt_FromLong(DNS_TYPE_PTR));
	PyModule_AddObject(m, "DNS_TYPE_MINFO", PyInt_FromLong(DNS_TYPE_MINFO));
	PyModule_AddObject(m, "DNS_RANK_CACHE_BIT", PyInt_FromLong(DNS_RANK_CACHE_BIT));
	PyModule_AddObject(m, "DNS_TYPE_WKS", PyInt_FromLong(DNS_TYPE_WKS));
	PyModule_AddObject(m, "DNS_TYPE_ISDN", PyInt_FromLong(DNS_TYPE_ISDN));
	PyModule_AddObject(m, "DNS_TYPE_MF", PyInt_FromLong(DNS_TYPE_MF));
	PyModule_AddObject(m, "DNS_TYPE_DNSKEY", PyInt_FromLong(DNS_TYPE_DNSKEY));
	PyModule_AddObject(m, "DNS_TYPE_CNAME", PyInt_FromLong(DNS_TYPE_CNAME));
	PyModule_AddObject(m, "DNS_RANK_GLUE", PyInt_FromLong(DNS_RANK_GLUE));
	PyModule_AddObject(m, "DNS_TYPE_SOA", PyInt_FromLong(DNS_TYPE_SOA));
	PyModule_AddObject(m, "DNS_TYPE_TOMBSTONE", PyInt_FromLong(DNS_TYPE_TOMBSTONE));
	PyModule_AddObject(m, "DNS_RANK_CACHE_NA_ADDITIONAL", PyInt_FromLong(DNS_RANK_CACHE_NA_ADDITIONAL));
	PyModule_AddObject(m, "DNS_RANK_ROOT_HINT", PyInt_FromLong(DNS_RANK_ROOT_HINT));
	PyModule_AddObject(m, "DNS_TYPE_RRSIG", PyInt_FromLong(DNS_TYPE_RRSIG));
	PyModule_AddObject(m, "DNS_TYPE_ALL", PyInt_FromLong(DNS_TYPE_ALL));
	PyModule_AddObject(m, "DNS_TYPE_A", PyInt_FromLong(DNS_TYPE_A));
	PyModule_AddObject(m, "DNS_TYPE_TXT", PyInt_FromLong(DNS_TYPE_TXT));
	PyModule_AddObject(m, "DNS_TYPE_AFSDB", PyInt_FromLong(DNS_TYPE_AFSDB));
	PyModule_AddObject(m, "DNS_RANK_NS_GLUE", PyInt_FromLong(DNS_RANK_NS_GLUE));
	PyModule_AddObject(m, "DNS_RANK_CACHE_NA_AUTHORITY", PyInt_FromLong(DNS_RANK_CACHE_NA_AUTHORITY));
	PyModule_AddObject(m, "DNS_TYPE_NXT", PyInt_FromLong(DNS_TYPE_NXT));
	PyModule_AddObject(m, "DNS_TYPE_NSEC", PyInt_FromLong(DNS_TYPE_NSEC));
	PyModule_AddObject(m, "DNS_TYPE_MR", PyInt_FromLong(DNS_TYPE_MR));
	PyModule_AddObject(m, "DNS_RANK_CACHE_A_ANSWER", PyInt_FromLong(DNS_RANK_CACHE_A_ANSWER));
	PyModule_AddObject(m, "DNS_TYPE_MX", PyInt_FromLong(DNS_TYPE_MX));
	PyModule_AddObject(m, "DNS_TYPE_RT", PyInt_FromLong(DNS_TYPE_RT));
	Py_INCREF((PyObject *)(void *)&dnsp_soa_Type);
	PyModule_AddObject(m, "soa", (PyObject *)(void *)&dnsp_soa_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_mx_Type);
	PyModule_AddObject(m, "mx", (PyObject *)(void *)&dnsp_mx_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_hinfo_Type);
	PyModule_AddObject(m, "hinfo", (PyObject *)(void *)&dnsp_hinfo_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_srv_Type);
	PyModule_AddObject(m, "srv", (PyObject *)(void *)&dnsp_srv_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_DnssrvRpcRecord_Type);
	PyModule_AddObject(m, "DnssrvRpcRecord", (PyObject *)(void *)&dnsp_DnssrvRpcRecord_Type);
	Py_INCREF((PyObject *)(void *)&dnsp_InterfaceType);
	PyModule_AddObject(m, "dnsp", (PyObject *)(void *)&dnsp_InterfaceType);
#ifdef PY_MOD_DNSP_PATCH
	PY_MOD_DNSP_PATCH(m);
#endif

}
