/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "ntdomain.h"
#include "librpc/gen_ndr/srv_wmi.h"

static bool api_Delete(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Delete *r;

	call = &ndr_table_IWbemClassObject.calls[NDR_DELETE];

	r = talloc(talloc_tos(), struct Delete);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Delete, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Delete(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Delete, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemClassObject_cmds[] = 
{
	{"DELETE", NDR_DELETE, api_Delete},
};

void IWbemClassObject_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemClassObject_cmds;
	*n_fns = sizeof(api_IWbemClassObject_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemClassObject_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemClassObject", "IWbemClassObject", &ndr_table_IWbemClassObject, api_IWbemClassObject_cmds, sizeof(api_IWbemClassObject_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemClassObject_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemClassObject);
}
static bool api_OpenNamespace(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct OpenNamespace *r;

	call = &ndr_table_IWbemServices.calls[NDR_OPENNAMESPACE];

	r = talloc(talloc_tos(), struct OpenNamespace);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(OpenNamespace, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppWorkingNamespace = r->in.ppWorkingNamespace;
	r->out.ppResult = r->in.ppResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _OpenNamespace(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(OpenNamespace, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_CancelAsyncCall(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct CancelAsyncCall *r;

	call = &ndr_table_IWbemServices.calls[NDR_CANCELASYNCCALL];

	r = talloc(talloc_tos(), struct CancelAsyncCall);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CancelAsyncCall, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CancelAsyncCall(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CancelAsyncCall, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_QueryObjectSink(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct QueryObjectSink *r;

	call = &ndr_table_IWbemServices.calls[NDR_QUERYOBJECTSINK];

	r = talloc(talloc_tos(), struct QueryObjectSink);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(QueryObjectSink, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppResponseHandler = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppResponseHandler == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _QueryObjectSink(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(QueryObjectSink, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetObject(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetObject *r;

	call = &ndr_table_IWbemServices.calls[NDR_GETOBJECT];

	r = talloc(talloc_tos(), struct GetObject);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetObject, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppObject = r->in.ppObject;
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetObject(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetObject, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetObjectAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetObjectAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_GETOBJECTASYNC];

	r = talloc(talloc_tos(), struct GetObjectAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetObjectAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetObjectAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetObjectAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_PutClass(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct PutClass *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTCLASS];

	r = talloc(talloc_tos(), struct PutClass);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutClass, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutClass(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutClass, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_PutClassAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct PutClassAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTCLASSASYNC];

	r = talloc(talloc_tos(), struct PutClassAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutClassAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutClassAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutClassAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DeleteClass(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DeleteClass *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETECLASS];

	r = talloc(talloc_tos(), struct DeleteClass);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteClass, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteClass(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteClass, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DeleteClassAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DeleteClassAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETECLASSASYNC];

	r = talloc(talloc_tos(), struct DeleteClassAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteClassAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteClassAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteClassAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_CreateClassEnum(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct CreateClassEnum *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATECLASSENUM];

	r = talloc(talloc_tos(), struct CreateClassEnum);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateClassEnum, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateClassEnum(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateClassEnum, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_CreateClassEnumAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct CreateClassEnumAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATECLASSENUMASYNC];

	r = talloc(talloc_tos(), struct CreateClassEnumAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateClassEnumAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateClassEnumAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateClassEnumAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_PutInstance(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct PutInstance *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTINSTANCE];

	r = talloc(talloc_tos(), struct PutInstance);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutInstance, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutInstance, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_PutInstanceAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct PutInstanceAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_PUTINSTANCEASYNC];

	r = talloc(talloc_tos(), struct PutInstanceAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutInstanceAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _PutInstanceAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(PutInstanceAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DeleteInstance(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DeleteInstance *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETEINSTANCE];

	r = talloc(talloc_tos(), struct DeleteInstance);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteInstance, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteInstance, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DeleteInstanceAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DeleteInstanceAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_DELETEINSTANCEASYNC];

	r = talloc(talloc_tos(), struct DeleteInstanceAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteInstanceAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteInstanceAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteInstanceAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_CreateInstanceEnum(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct CreateInstanceEnum *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATEINSTANCEENUM];

	r = talloc(talloc_tos(), struct CreateInstanceEnum);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateInstanceEnum, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateInstanceEnum(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateInstanceEnum, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_CreateInstanceEnumAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct CreateInstanceEnumAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_CREATEINSTANCEENUMASYNC];

	r = talloc(talloc_tos(), struct CreateInstanceEnumAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateInstanceEnumAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateInstanceEnumAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(CreateInstanceEnumAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_ExecQuery(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ExecQuery *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECQUERY];

	r = talloc(talloc_tos(), struct ExecQuery);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecQuery, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecQuery(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecQuery, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_ExecQueryAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ExecQueryAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECQUERYASYNC];

	r = talloc(talloc_tos(), struct ExecQueryAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecQueryAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecQueryAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecQueryAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_ExecNotificationQuery(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ExecNotificationQuery *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECNOTIFICATIONQUERY];

	r = talloc(talloc_tos(), struct ExecNotificationQuery);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecNotificationQuery, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecNotificationQuery(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecNotificationQuery, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_ExecNotificationQueryAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ExecNotificationQueryAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECNOTIFICATIONQUERYASYNC];

	r = talloc(talloc_tos(), struct ExecNotificationQueryAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecNotificationQueryAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecNotificationQueryAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecNotificationQueryAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_ExecMethod(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ExecMethod *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECMETHOD];

	r = talloc(talloc_tos(), struct ExecMethod);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecMethod, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppOutParams = r->in.ppOutParams;
	r->out.ppCallResult = r->in.ppCallResult;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecMethod(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecMethod, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_ExecMethodAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct ExecMethodAsync *r;

	call = &ndr_table_IWbemServices.calls[NDR_EXECMETHODASYNC];

	r = talloc(talloc_tos(), struct ExecMethodAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecMethodAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ExecMethodAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(ExecMethodAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemServices_cmds[] = 
{
	{"OPENNAMESPACE", NDR_OPENNAMESPACE, api_OpenNamespace},
	{"CANCELASYNCCALL", NDR_CANCELASYNCCALL, api_CancelAsyncCall},
	{"QUERYOBJECTSINK", NDR_QUERYOBJECTSINK, api_QueryObjectSink},
	{"GETOBJECT", NDR_GETOBJECT, api_GetObject},
	{"GETOBJECTASYNC", NDR_GETOBJECTASYNC, api_GetObjectAsync},
	{"PUTCLASS", NDR_PUTCLASS, api_PutClass},
	{"PUTCLASSASYNC", NDR_PUTCLASSASYNC, api_PutClassAsync},
	{"DELETECLASS", NDR_DELETECLASS, api_DeleteClass},
	{"DELETECLASSASYNC", NDR_DELETECLASSASYNC, api_DeleteClassAsync},
	{"CREATECLASSENUM", NDR_CREATECLASSENUM, api_CreateClassEnum},
	{"CREATECLASSENUMASYNC", NDR_CREATECLASSENUMASYNC, api_CreateClassEnumAsync},
	{"PUTINSTANCE", NDR_PUTINSTANCE, api_PutInstance},
	{"PUTINSTANCEASYNC", NDR_PUTINSTANCEASYNC, api_PutInstanceAsync},
	{"DELETEINSTANCE", NDR_DELETEINSTANCE, api_DeleteInstance},
	{"DELETEINSTANCEASYNC", NDR_DELETEINSTANCEASYNC, api_DeleteInstanceAsync},
	{"CREATEINSTANCEENUM", NDR_CREATEINSTANCEENUM, api_CreateInstanceEnum},
	{"CREATEINSTANCEENUMASYNC", NDR_CREATEINSTANCEENUMASYNC, api_CreateInstanceEnumAsync},
	{"EXECQUERY", NDR_EXECQUERY, api_ExecQuery},
	{"EXECQUERYASYNC", NDR_EXECQUERYASYNC, api_ExecQueryAsync},
	{"EXECNOTIFICATIONQUERY", NDR_EXECNOTIFICATIONQUERY, api_ExecNotificationQuery},
	{"EXECNOTIFICATIONQUERYASYNC", NDR_EXECNOTIFICATIONQUERYASYNC, api_ExecNotificationQueryAsync},
	{"EXECMETHOD", NDR_EXECMETHOD, api_ExecMethod},
	{"EXECMETHODASYNC", NDR_EXECMETHODASYNC, api_ExecMethodAsync},
};

void IWbemServices_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemServices_cmds;
	*n_fns = sizeof(api_IWbemServices_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemServices_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemServices", "IWbemServices", &ndr_table_IWbemServices, api_IWbemServices_cmds, sizeof(api_IWbemServices_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemServices_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemServices);
}
static bool api_Reset(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Reset *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_RESET];

	r = talloc(talloc_tos(), struct Reset);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Reset, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Reset(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Reset, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_IEnumWbemClassObject_Next(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct IEnumWbemClassObject_Next *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_IENUMWBEMCLASSOBJECT_NEXT];

	r = talloc(talloc_tos(), struct IEnumWbemClassObject_Next);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IEnumWbemClassObject_Next, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.apObjects = talloc_zero_array(r, struct MInterfacePointer *, r->in.uCount);
	if (r->out.apObjects == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.puReturned = talloc_zero(r, uint32_t);
	if (r->out.puReturned == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _IEnumWbemClassObject_Next(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IEnumWbemClassObject_Next, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_NextAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct NextAsync *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_NEXTASYNC];

	r = talloc(talloc_tos(), struct NextAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(NextAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _NextAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(NextAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_IEnumWbemClassObject_Clone(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct IEnumWbemClassObject_Clone *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_IENUMWBEMCLASSOBJECT_CLONE];

	r = talloc(talloc_tos(), struct IEnumWbemClassObject_Clone);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IEnumWbemClassObject_Clone, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _IEnumWbemClassObject_Clone(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IEnumWbemClassObject_Clone, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_Skip(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Skip *r;

	call = &ndr_table_IEnumWbemClassObject.calls[NDR_SKIP];

	r = talloc(talloc_tos(), struct Skip);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Skip, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Skip(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Skip, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IEnumWbemClassObject_cmds[] = 
{
	{"RESET", NDR_RESET, api_Reset},
	{"IENUMWBEMCLASSOBJECT_NEXT", NDR_IENUMWBEMCLASSOBJECT_NEXT, api_IEnumWbemClassObject_Next},
	{"NEXTASYNC", NDR_NEXTASYNC, api_NextAsync},
	{"IENUMWBEMCLASSOBJECT_CLONE", NDR_IENUMWBEMCLASSOBJECT_CLONE, api_IEnumWbemClassObject_Clone},
	{"SKIP", NDR_SKIP, api_Skip},
};

void IEnumWbemClassObject_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IEnumWbemClassObject_cmds;
	*n_fns = sizeof(api_IEnumWbemClassObject_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IEnumWbemClassObject_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IEnumWbemClassObject", "IEnumWbemClassObject", &ndr_table_IEnumWbemClassObject, api_IEnumWbemClassObject_cmds, sizeof(api_IEnumWbemClassObject_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IEnumWbemClassObject_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IEnumWbemClassObject);
}
static bool api_Clone(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Clone *r;

	call = &ndr_table_IWbemContext.calls[NDR_CLONE];

	r = talloc(talloc_tos(), struct Clone);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Clone, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppNewCopy = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppNewCopy == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Clone(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Clone, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetNames(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetNames *r;

	call = &ndr_table_IWbemContext.calls[NDR_GETNAMES];

	r = talloc(talloc_tos(), struct GetNames);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetNames, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetNames(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetNames, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_BeginEnumeration(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct BeginEnumeration *r;

	call = &ndr_table_IWbemContext.calls[NDR_BEGINENUMERATION];

	r = talloc(talloc_tos(), struct BeginEnumeration);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(BeginEnumeration, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _BeginEnumeration(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(BeginEnumeration, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_Next(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Next *r;

	call = &ndr_table_IWbemContext.calls[NDR_NEXT];

	r = talloc(talloc_tos(), struct Next);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Next, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Next(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Next, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_EndEnumeration(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct EndEnumeration *r;

	call = &ndr_table_IWbemContext.calls[NDR_ENDENUMERATION];

	r = talloc(talloc_tos(), struct EndEnumeration);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(EndEnumeration, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _EndEnumeration(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(EndEnumeration, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_SetValue(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct SetValue *r;

	call = &ndr_table_IWbemContext.calls[NDR_SETVALUE];

	r = talloc(talloc_tos(), struct SetValue);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(SetValue, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _SetValue(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(SetValue, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetValue(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetValue *r;

	call = &ndr_table_IWbemContext.calls[NDR_GETVALUE];

	r = talloc(talloc_tos(), struct GetValue);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetValue, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetValue(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetValue, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DeleteValue(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DeleteValue *r;

	call = &ndr_table_IWbemContext.calls[NDR_DELETEVALUE];

	r = talloc(talloc_tos(), struct DeleteValue);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteValue, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteValue(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteValue, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DeleteAll(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DeleteAll *r;

	call = &ndr_table_IWbemContext.calls[NDR_DELETEALL];

	r = talloc(talloc_tos(), struct DeleteAll);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteAll, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _DeleteAll(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DeleteAll, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemContext_cmds[] = 
{
	{"CLONE", NDR_CLONE, api_Clone},
	{"GETNAMES", NDR_GETNAMES, api_GetNames},
	{"BEGINENUMERATION", NDR_BEGINENUMERATION, api_BeginEnumeration},
	{"NEXT", NDR_NEXT, api_Next},
	{"ENDENUMERATION", NDR_ENDENUMERATION, api_EndEnumeration},
	{"SETVALUE", NDR_SETVALUE, api_SetValue},
	{"GETVALUE", NDR_GETVALUE, api_GetValue},
	{"DELETEVALUE", NDR_DELETEVALUE, api_DeleteValue},
	{"DELETEALL", NDR_DELETEALL, api_DeleteAll},
};

void IWbemContext_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemContext_cmds;
	*n_fns = sizeof(api_IWbemContext_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemContext_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemContext", "IWbemContext", &ndr_table_IWbemContext, api_IWbemContext_cmds, sizeof(api_IWbemContext_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemContext_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemContext);
}
static bool api_EstablishPosition(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct EstablishPosition *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_ESTABLISHPOSITION];

	r = talloc(talloc_tos(), struct EstablishPosition);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(EstablishPosition, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.reserved = talloc_zero(r, uint32_t);
	if (r->out.reserved == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _EstablishPosition(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(EstablishPosition, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_RequestChallenge(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RequestChallenge *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_REQUESTCHALLENGE];

	r = talloc(talloc_tos(), struct RequestChallenge);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RequestChallenge, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.Nonce = talloc_zero_array(r, uint8_t, 16);
	if (r->out.Nonce == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RequestChallenge(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RequestChallenge, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_WBEMLogin(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct WBEMLogin *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_WBEMLOGIN];

	r = talloc(talloc_tos(), struct WBEMLogin);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(WBEMLogin, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppNamespace = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppNamespace == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _WBEMLogin(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(WBEMLogin, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_NTLMLogin(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct NTLMLogin *r;

	call = &ndr_table_IWbemLevel1Login.calls[NDR_NTLMLOGIN];

	r = talloc(talloc_tos(), struct NTLMLogin);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(NTLMLogin, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppNamespace = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppNamespace == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _NTLMLogin(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(NTLMLogin, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemLevel1Login_cmds[] = 
{
	{"ESTABLISHPOSITION", NDR_ESTABLISHPOSITION, api_EstablishPosition},
	{"REQUESTCHALLENGE", NDR_REQUESTCHALLENGE, api_RequestChallenge},
	{"WBEMLOGIN", NDR_WBEMLOGIN, api_WBEMLogin},
	{"NTLMLOGIN", NDR_NTLMLOGIN, api_NTLMLogin},
};

void IWbemLevel1Login_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemLevel1Login_cmds;
	*n_fns = sizeof(api_IWbemLevel1Login_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemLevel1Login_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemLevel1Login", "IWbemLevel1Login", &ndr_table_IWbemLevel1Login, api_IWbemLevel1Login_cmds, sizeof(api_IWbemLevel1Login_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemLevel1Login_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemLevel1Login);
}
static bool api_IWbemWCOSmartEnum_Next(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct IWbemWCOSmartEnum_Next *r;

	call = &ndr_table_IWbemWCOSmartEnum.calls[NDR_IWBEMWCOSMARTENUM_NEXT];

	r = talloc(talloc_tos(), struct IWbemWCOSmartEnum_Next);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IWbemWCOSmartEnum_Next, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.puReturned = talloc_zero(r, uint32_t);
	if (r->out.puReturned == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pSize = talloc_zero(r, uint32_t);
	if (r->out.pSize == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pData = talloc_zero(r, uint8_t *);
	if (r->out.pData == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _IWbemWCOSmartEnum_Next(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(IWbemWCOSmartEnum_Next, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemWCOSmartEnum_cmds[] = 
{
	{"IWBEMWCOSMARTENUM_NEXT", NDR_IWBEMWCOSMARTENUM_NEXT, api_IWbemWCOSmartEnum_Next},
};

void IWbemWCOSmartEnum_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemWCOSmartEnum_cmds;
	*n_fns = sizeof(api_IWbemWCOSmartEnum_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemWCOSmartEnum_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemWCOSmartEnum", "IWbemWCOSmartEnum", &ndr_table_IWbemWCOSmartEnum, api_IWbemWCOSmartEnum_cmds, sizeof(api_IWbemWCOSmartEnum_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemWCOSmartEnum_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemWCOSmartEnum);
}
static bool api_Fetch(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Fetch *r;

	call = &ndr_table_IWbemFetchSmartEnum.calls[NDR_FETCH];

	r = talloc(talloc_tos(), struct Fetch);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Fetch, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Fetch(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Fetch, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_Test(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Test *r;

	call = &ndr_table_IWbemFetchSmartEnum.calls[NDR_TEST];

	r = talloc(talloc_tos(), struct Test);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Test, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppEnum = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppEnum == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Test(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Test, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemFetchSmartEnum_cmds[] = 
{
	{"FETCH", NDR_FETCH, api_Fetch},
	{"TEST", NDR_TEST, api_Test},
};

void IWbemFetchSmartEnum_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemFetchSmartEnum_cmds;
	*n_fns = sizeof(api_IWbemFetchSmartEnum_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemFetchSmartEnum_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemFetchSmartEnum", "IWbemFetchSmartEnum", &ndr_table_IWbemFetchSmartEnum, api_IWbemFetchSmartEnum_cmds, sizeof(api_IWbemFetchSmartEnum_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemFetchSmartEnum_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemFetchSmartEnum);
}
static bool api_GetResultObject(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetResultObject *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETRESULTOBJECT];

	r = talloc(talloc_tos(), struct GetResultObject);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetResultObject, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppResultObject = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppResultObject == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetResultObject(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetResultObject, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetResultString(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetResultString *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETRESULTSTRING];

	r = talloc(talloc_tos(), struct GetResultString);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetResultString, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pstrResultString = talloc_zero(r, struct BSTR);
	if (r->out.pstrResultString == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetResultString(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetResultString, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetResultServices(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetResultServices *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETRESULTSERVICES];

	r = talloc(talloc_tos(), struct GetResultServices);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetResultServices, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppServices = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.ppServices == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetResultServices(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetResultServices, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_GetCallStatus(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct GetCallStatus *r;

	call = &ndr_table_IWbemCallResult.calls[NDR_GETCALLSTATUS];

	r = talloc(talloc_tos(), struct GetCallStatus);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetCallStatus, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.plStatus = talloc_zero(r, int32_t);
	if (r->out.plStatus == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetCallStatus(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(GetCallStatus, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemCallResult_cmds[] = 
{
	{"GETRESULTOBJECT", NDR_GETRESULTOBJECT, api_GetResultObject},
	{"GETRESULTSTRING", NDR_GETRESULTSTRING, api_GetResultString},
	{"GETRESULTSERVICES", NDR_GETRESULTSERVICES, api_GetResultServices},
	{"GETCALLSTATUS", NDR_GETCALLSTATUS, api_GetCallStatus},
};

void IWbemCallResult_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemCallResult_cmds;
	*n_fns = sizeof(api_IWbemCallResult_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemCallResult_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemCallResult", "IWbemCallResult", &ndr_table_IWbemCallResult, api_IWbemCallResult_cmds, sizeof(api_IWbemCallResult_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemCallResult_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemCallResult);
}
static bool api_SetStatus(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct SetStatus *r;

	call = &ndr_table_IWbemObjectSink.calls[NDR_SETSTATUS];

	r = talloc(talloc_tos(), struct SetStatus);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(SetStatus, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _SetStatus(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(SetStatus, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_Indicate(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct Indicate *r;

	call = &ndr_table_IWbemObjectSink.calls[NDR_INDICATE];

	r = talloc(talloc_tos(), struct Indicate);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Indicate, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Indicate(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(Indicate, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IWbemObjectSink_cmds[] = 
{
	{"SETSTATUS", NDR_SETSTATUS, api_SetStatus},
	{"INDICATE", NDR_INDICATE, api_Indicate},
};

void IWbemObjectSink_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IWbemObjectSink_cmds;
	*n_fns = sizeof(api_IWbemObjectSink_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IWbemObjectSink_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IWbemObjectSink", "IWbemObjectSink", &ndr_table_IWbemObjectSink, api_IWbemObjectSink_cmds, sizeof(api_IWbemObjectSink_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IWbemObjectSink_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IWbemObjectSink);
}
