
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_fsrvp.h"
#include "autoconf/librpc/gen_ndr/ndr_fsrvp_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject fssagent_share_mapping_1_Type;
staticforward PyTypeObject FileServerVssAgent_InterfaceType;

void initfsrvp(void);static PyTypeObject *Object_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *ClientConnection_Type;

static PyObject *py_fssagent_share_mapping_1_get_ShadowCopySetId(PyObject *obj, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(obj);
	PyObject *py_ShadowCopySetId;
	py_ShadowCopySetId = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->ShadowCopySetId);
	return py_ShadowCopySetId;
}

static int py_fssagent_share_mapping_1_set_ShadowCopySetId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_fssagent_share_mapping_1_get_ShadowCopyId(PyObject *obj, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(obj);
	PyObject *py_ShadowCopyId;
	py_ShadowCopyId = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->ShadowCopyId);
	return py_ShadowCopyId;
}

static int py_fssagent_share_mapping_1_set_ShadowCopyId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ShadowCopyId = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_fssagent_share_mapping_1_get_ShareNameUNC(PyObject *obj, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(obj);
	PyObject *py_ShareNameUNC;
	if (object->ShareNameUNC == NULL) {
		py_ShareNameUNC = Py_None;
		Py_INCREF(py_ShareNameUNC);
	} else {
		if (object->ShareNameUNC == NULL) {
			py_ShareNameUNC = Py_None;
			Py_INCREF(py_ShareNameUNC);
		} else {
			py_ShareNameUNC = PyUnicode_Decode(object->ShareNameUNC, strlen(object->ShareNameUNC), "utf-8", "ignore");
		}
	}
	return py_ShareNameUNC;
}

static int py_fssagent_share_mapping_1_set_ShareNameUNC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->ShareNameUNC = NULL;
	} else {
		object->ShareNameUNC = NULL;
		if (PyUnicode_Check(value)) {
			object->ShareNameUNC = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->ShareNameUNC = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_fssagent_share_mapping_1_get_ShadowCopyShareName(PyObject *obj, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(obj);
	PyObject *py_ShadowCopyShareName;
	if (object->ShadowCopyShareName == NULL) {
		py_ShadowCopyShareName = Py_None;
		Py_INCREF(py_ShadowCopyShareName);
	} else {
		if (object->ShadowCopyShareName == NULL) {
			py_ShadowCopyShareName = Py_None;
			Py_INCREF(py_ShadowCopyShareName);
		} else {
			py_ShadowCopyShareName = PyUnicode_Decode(object->ShadowCopyShareName, strlen(object->ShadowCopyShareName), "utf-8", "ignore");
		}
	}
	return py_ShadowCopyShareName;
}

static int py_fssagent_share_mapping_1_set_ShadowCopyShareName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->ShadowCopyShareName = NULL;
	} else {
		object->ShadowCopyShareName = NULL;
		if (PyUnicode_Check(value)) {
			object->ShadowCopyShareName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->ShadowCopyShareName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_fssagent_share_mapping_1_get_tstamp(PyObject *obj, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(obj);
	PyObject *py_tstamp;
	py_tstamp = PyLong_FromLongLong(object->tstamp);
	return py_tstamp;
}

static int py_fssagent_share_mapping_1_set_tstamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fssagent_share_mapping_1 *object = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->tstamp = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->tstamp = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_fssagent_share_mapping_1_getsetters[] = {
	{ discard_const_p(char, "ShadowCopySetId"), py_fssagent_share_mapping_1_get_ShadowCopySetId, py_fssagent_share_mapping_1_set_ShadowCopySetId },
	{ discard_const_p(char, "ShadowCopyId"), py_fssagent_share_mapping_1_get_ShadowCopyId, py_fssagent_share_mapping_1_set_ShadowCopyId },
	{ discard_const_p(char, "ShareNameUNC"), py_fssagent_share_mapping_1_get_ShareNameUNC, py_fssagent_share_mapping_1_set_ShareNameUNC },
	{ discard_const_p(char, "ShadowCopyShareName"), py_fssagent_share_mapping_1_get_ShadowCopyShareName, py_fssagent_share_mapping_1_set_ShadowCopyShareName },
	{ discard_const_p(char, "tstamp"), py_fssagent_share_mapping_1_get_tstamp, py_fssagent_share_mapping_1_set_tstamp },
	{ NULL }
};

static PyObject *py_fssagent_share_mapping_1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct fssagent_share_mapping_1, type);
}


static PyTypeObject fssagent_share_mapping_1_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "fsrvp.fssagent_share_mapping_1",
	.tp_getset = py_fssagent_share_mapping_1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_fssagent_share_mapping_1_new,
};

PyObject *py_import_fssagent_share_mapping(TALLOC_CTX *mem_ctx, int level, union fssagent_share_mapping *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->ShareMapping1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&fssagent_share_mapping_1_Type, in->ShareMapping1, in->ShareMapping1);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union fssagent_share_mapping *py_export_fssagent_share_mapping(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union fssagent_share_mapping *ret = talloc_zero(mem_ctx, union fssagent_share_mapping);
	switch (level) {
		case 1:
			if (in == Py_None) {
				ret->ShareMapping1 = NULL;
			} else {
				ret->ShareMapping1 = NULL;
				PY_CHECK_TYPE(&fssagent_share_mapping_1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ShareMapping1 = (struct fssagent_share_mapping_1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}


static bool pack_py_fss_GetSupportedVersion_args_in(PyObject *args, PyObject *kwargs, struct fss_GetSupportedVersion *r)
{
	PyObject *py_magic;
	const char *kwnames[] = {
		"magic", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:fss_GetSupportedVersion", discard_const_p(char *, kwnames), &py_magic)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_magic, return false;);
	{
		int magic_cntr_0;
		for (magic_cntr_0 = 0; magic_cntr_0 < PyList_GET_SIZE(py_magic); magic_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_magic, magic_cntr_0), return false;);
			r->in.magic[magic_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(py_magic, magic_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_fss_GetSupportedVersion_args_out(struct fss_GetSupportedVersion *r)
{
	PyObject *result;
	PyObject *py_MinVersion;
	PyObject *py_MaxVersion;
	result = PyTuple_New(3);
	py_MinVersion = PyInt_FromLong(*r->out.MinVersion);
	PyTuple_SetItem(result, 0, py_MinVersion);
	py_MaxVersion = PyInt_FromLong(*r->out.MaxVersion);
	PyTuple_SetItem(result, 1, py_MaxVersion);
	PyTuple_SetItem(result, 2, PyInt_FromLong(r->out.result));
	return result;
}

static bool pack_py_fss_SetContext_args_in(PyObject *args, PyObject *kwargs, struct fss_SetContext *r)
{
	PyObject *py_Context;
	const char *kwnames[] = {
		"Context", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:fss_SetContext", discard_const_p(char *, kwnames), &py_Context)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_Context, return false;);
	r->in.Context = PyInt_AsLong(py_Context);
	return true;
}

static PyObject *unpack_py_fss_SetContext_args_out(struct fss_SetContext *r)
{
	PyObject *result;
	result = PyInt_FromLong(r->out.result);
	return result;
}

static bool pack_py_fss_StartShadowCopySet_args_in(PyObject *args, PyObject *kwargs, struct fss_StartShadowCopySet *r)
{
	PyObject *py_ClientShadowCopySetId;
	const char *kwnames[] = {
		"ClientShadowCopySetId", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:fss_StartShadowCopySet", discard_const_p(char *, kwnames), &py_ClientShadowCopySetId)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ClientShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ClientShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ClientShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ClientShadowCopySetId);
	return true;
}

static PyObject *unpack_py_fss_StartShadowCopySet_args_out(struct fss_StartShadowCopySet *r)
{
	PyObject *result;
	PyObject *py_pShadowCopySetId;
	result = PyTuple_New(2);
	py_pShadowCopySetId = pytalloc_reference_ex(GUID_Type, r->out.pShadowCopySetId, r->out.pShadowCopySetId);
	PyTuple_SetItem(result, 0, py_pShadowCopySetId);
	PyTuple_SetItem(result, 1, PyInt_FromLong(r->out.result));
	return result;
}

static bool pack_py_fss_AddToShadowCopySet_args_in(PyObject *args, PyObject *kwargs, struct fss_AddToShadowCopySet *r)
{
	PyObject *py_ClientShadowCopyId;
	PyObject *py_ShadowCopySetId;
	PyObject *py_ShareName;
	const char *kwnames[] = {
		"ClientShadowCopyId", "ShadowCopySetId", "ShareName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:fss_AddToShadowCopySet", discard_const_p(char *, kwnames), &py_ClientShadowCopyId, &py_ShadowCopySetId, &py_ShareName)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ClientShadowCopyId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ClientShadowCopyId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ClientShadowCopyId = *(struct GUID *)pytalloc_get_ptr(py_ClientShadowCopyId);
	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	r->in.ShareName = talloc_ptrtype(r, r->in.ShareName);
	if (PyUnicode_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_ShareName, "utf-8", "ignore"));
	} else if (PyString_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(py_ShareName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ShareName)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_fss_AddToShadowCopySet_args_out(struct fss_AddToShadowCopySet *r)
{
	PyObject *result;
	PyObject *py_pShadowCopyId;
	result = PyTuple_New(2);
	py_pShadowCopyId = pytalloc_reference_ex(GUID_Type, r->out.pShadowCopyId, r->out.pShadowCopyId);
	PyTuple_SetItem(result, 0, py_pShadowCopyId);
	PyTuple_SetItem(result, 1, PyInt_FromLong(r->out.result));
	return result;
}

static bool pack_py_fss_CommitShadowCopySet_args_in(PyObject *args, PyObject *kwargs, struct fss_CommitShadowCopySet *r)
{
	PyObject *py_ShadowCopySetId;
	PyObject *py_TimeOutInMilliseconds;
	const char *kwnames[] = {
		"ShadowCopySetId", "TimeOutInMilliseconds", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:fss_CommitShadowCopySet", discard_const_p(char *, kwnames), &py_ShadowCopySetId, &py_TimeOutInMilliseconds)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	PY_CHECK_TYPE(&PyInt_Type, py_TimeOutInMilliseconds, return false;);
	r->in.TimeOutInMilliseconds = PyInt_AsLong(py_TimeOutInMilliseconds);
	return true;
}

static PyObject *unpack_py_fss_CommitShadowCopySet_args_out(struct fss_CommitShadowCopySet *r)
{
	PyObject *result;
	result = PyInt_FromLong(r->out.result);
	return result;
}

static bool pack_py_fss_ExposeShadowCopySet_args_in(PyObject *args, PyObject *kwargs, struct fss_ExposeShadowCopySet *r)
{
	PyObject *py_ShadowCopySetId;
	PyObject *py_TimeOutInMilliseconds;
	const char *kwnames[] = {
		"ShadowCopySetId", "TimeOutInMilliseconds", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:fss_ExposeShadowCopySet", discard_const_p(char *, kwnames), &py_ShadowCopySetId, &py_TimeOutInMilliseconds)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	PY_CHECK_TYPE(&PyInt_Type, py_TimeOutInMilliseconds, return false;);
	r->in.TimeOutInMilliseconds = PyInt_AsLong(py_TimeOutInMilliseconds);
	return true;
}

static PyObject *unpack_py_fss_ExposeShadowCopySet_args_out(struct fss_ExposeShadowCopySet *r)
{
	PyObject *result;
	result = PyInt_FromLong(r->out.result);
	return result;
}

static bool pack_py_fss_RecoveryCompleteShadowCopySet_args_in(PyObject *args, PyObject *kwargs, struct fss_RecoveryCompleteShadowCopySet *r)
{
	PyObject *py_ShadowCopySetId;
	const char *kwnames[] = {
		"ShadowCopySetId", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:fss_RecoveryCompleteShadowCopySet", discard_const_p(char *, kwnames), &py_ShadowCopySetId)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	return true;
}

static PyObject *unpack_py_fss_RecoveryCompleteShadowCopySet_args_out(struct fss_RecoveryCompleteShadowCopySet *r)
{
	PyObject *result;
	result = PyInt_FromLong(r->out.result);
	return result;
}

static bool pack_py_fss_AbortShadowCopySet_args_in(PyObject *args, PyObject *kwargs, struct fss_AbortShadowCopySet *r)
{
	PyObject *py_ShadowCopySetId;
	const char *kwnames[] = {
		"ShadowCopySetId", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:fss_AbortShadowCopySet", discard_const_p(char *, kwnames), &py_ShadowCopySetId)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	return true;
}

static PyObject *unpack_py_fss_AbortShadowCopySet_args_out(struct fss_AbortShadowCopySet *r)
{
	PyObject *result;
	result = PyInt_FromLong(r->out.result);
	return result;
}

static bool pack_py_fss_IsPathSupported_args_in(PyObject *args, PyObject *kwargs, struct fss_IsPathSupported *r)
{
	PyObject *py_ShareName;
	PyObject *py_magic;
	const char *kwnames[] = {
		"ShareName", "magic", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:fss_IsPathSupported", discard_const_p(char *, kwnames), &py_ShareName, &py_magic)) {
		return false;
	}

	r->in.ShareName = talloc_ptrtype(r, r->in.ShareName);
	if (PyUnicode_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_ShareName, "utf-8", "ignore"));
	} else if (PyString_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(py_ShareName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ShareName)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_magic, return false;);
	{
		int magic_cntr_0;
		for (magic_cntr_0 = 0; magic_cntr_0 < PyList_GET_SIZE(py_magic); magic_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_magic, magic_cntr_0), return false;);
			r->in.magic[magic_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(py_magic, magic_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_fss_IsPathSupported_args_out(struct fss_IsPathSupported *r)
{
	PyObject *result;
	PyObject *py_SupportedByThisProvider;
	PyObject *py_OwnerMachineName;
	result = PyTuple_New(3);
	py_SupportedByThisProvider = PyInt_FromLong(*r->out.SupportedByThisProvider);
	PyTuple_SetItem(result, 0, py_SupportedByThisProvider);
	if (*r->out.OwnerMachineName == NULL) {
		py_OwnerMachineName = Py_None;
		Py_INCREF(py_OwnerMachineName);
	} else {
		if (*r->out.OwnerMachineName == NULL) {
			py_OwnerMachineName = Py_None;
			Py_INCREF(py_OwnerMachineName);
		} else {
			py_OwnerMachineName = PyUnicode_Decode(*r->out.OwnerMachineName, strlen(*r->out.OwnerMachineName), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 1, py_OwnerMachineName);
	PyTuple_SetItem(result, 2, PyInt_FromLong(r->out.result));
	return result;
}

static bool pack_py_fss_IsPathShadowCopied_args_in(PyObject *args, PyObject *kwargs, struct fss_IsPathShadowCopied *r)
{
	PyObject *py_ShareName;
	const char *kwnames[] = {
		"ShareName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:fss_IsPathShadowCopied", discard_const_p(char *, kwnames), &py_ShareName)) {
		return false;
	}

	r->in.ShareName = talloc_ptrtype(r, r->in.ShareName);
	if (PyUnicode_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_ShareName, "utf-8", "ignore"));
	} else if (PyString_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(py_ShareName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ShareName)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_fss_IsPathShadowCopied_args_out(struct fss_IsPathShadowCopied *r)
{
	PyObject *result;
	PyObject *py_ShadowCopyPresent;
	PyObject *py_ShadowCopyCompatibility;
	result = PyTuple_New(3);
	py_ShadowCopyPresent = PyInt_FromLong(*r->out.ShadowCopyPresent);
	PyTuple_SetItem(result, 0, py_ShadowCopyPresent);
	py_ShadowCopyCompatibility = PyInt_FromLong(*r->out.ShadowCopyCompatibility);
	PyTuple_SetItem(result, 1, py_ShadowCopyCompatibility);
	PyTuple_SetItem(result, 2, PyInt_FromLong(r->out.result));
	return result;
}

static bool pack_py_fss_GetShareMapping_args_in(PyObject *args, PyObject *kwargs, struct fss_GetShareMapping *r)
{
	PyObject *py_ShadowCopyId;
	PyObject *py_ShadowCopySetId;
	PyObject *py_ShareName;
	PyObject *py_Level;
	const char *kwnames[] = {
		"ShadowCopyId", "ShadowCopySetId", "ShareName", "Level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:fss_GetShareMapping", discard_const_p(char *, kwnames), &py_ShadowCopyId, &py_ShadowCopySetId, &py_ShareName, &py_Level)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ShadowCopyId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopyId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopyId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopyId);
	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	r->in.ShareName = talloc_ptrtype(r, r->in.ShareName);
	if (PyUnicode_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_ShareName, "utf-8", "ignore"));
	} else if (PyString_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(py_ShareName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ShareName)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_Level, return false;);
	r->in.Level = PyInt_AsLong(py_Level);
	return true;
}

static PyObject *unpack_py_fss_GetShareMapping_args_out(struct fss_GetShareMapping *r)
{
	PyObject *result;
	PyObject *py_ShareMapping;
	result = PyTuple_New(2);
	py_ShareMapping = py_import_fssagent_share_mapping(r->out.ShareMapping, r->in.Level, r->out.ShareMapping);
	if (py_ShareMapping == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 0, py_ShareMapping);
	PyTuple_SetItem(result, 1, PyInt_FromLong(r->out.result));
	return result;
}

static bool pack_py_fss_DeleteShareMapping_args_in(PyObject *args, PyObject *kwargs, struct fss_DeleteShareMapping *r)
{
	PyObject *py_ShadowCopySetId;
	PyObject *py_ShadowCopyId;
	PyObject *py_ShareName;
	const char *kwnames[] = {
		"ShadowCopySetId", "ShadowCopyId", "ShareName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:fss_DeleteShareMapping", discard_const_p(char *, kwnames), &py_ShadowCopySetId, &py_ShadowCopyId, &py_ShareName)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	PY_CHECK_TYPE(GUID_Type, py_ShadowCopyId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopyId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopyId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopyId);
	r->in.ShareName = talloc_ptrtype(r, r->in.ShareName);
	if (PyUnicode_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_ShareName, "utf-8", "ignore"));
	} else if (PyString_Check(py_ShareName)) {
		r->in.ShareName = PyString_AS_STRING(py_ShareName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ShareName)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_fss_DeleteShareMapping_args_out(struct fss_DeleteShareMapping *r)
{
	PyObject *result;
	result = PyInt_FromLong(r->out.result);
	return result;
}

static bool pack_py_fss_PrepareShadowCopySet_args_in(PyObject *args, PyObject *kwargs, struct fss_PrepareShadowCopySet *r)
{
	PyObject *py_ShadowCopySetId;
	PyObject *py_TimeOutInMilliseconds;
	const char *kwnames[] = {
		"ShadowCopySetId", "TimeOutInMilliseconds", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:fss_PrepareShadowCopySet", discard_const_p(char *, kwnames), &py_ShadowCopySetId, &py_TimeOutInMilliseconds)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_ShadowCopySetId, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ShadowCopySetId)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ShadowCopySetId = *(struct GUID *)pytalloc_get_ptr(py_ShadowCopySetId);
	PY_CHECK_TYPE(&PyInt_Type, py_TimeOutInMilliseconds, return false;);
	r->in.TimeOutInMilliseconds = PyInt_AsLong(py_TimeOutInMilliseconds);
	return true;
}

static PyObject *unpack_py_fss_PrepareShadowCopySet_args_out(struct fss_PrepareShadowCopySet *r)
{
	PyObject *result;
	result = PyInt_FromLong(r->out.result);
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_FileServerVssAgent_methods[] = {
	{ "fss_GetSupportedVersion", "S.fss_GetSupportedVersion(magic) -> (MinVersion, MaxVersion, result)", (py_dcerpc_call_fn)dcerpc_fss_GetSupportedVersion_r, (py_data_pack_fn)pack_py_fss_GetSupportedVersion_args_in, (py_data_unpack_fn)unpack_py_fss_GetSupportedVersion_args_out, 0, &ndr_table_FileServerVssAgent },
	{ "fss_SetContext", "S.fss_SetContext(Context) -> result", (py_dcerpc_call_fn)dcerpc_fss_SetContext_r, (py_data_pack_fn)pack_py_fss_SetContext_args_in, (py_data_unpack_fn)unpack_py_fss_SetContext_args_out, 1, &ndr_table_FileServerVssAgent },
	{ "fss_StartShadowCopySet", "S.fss_StartShadowCopySet(ClientShadowCopySetId) -> (pShadowCopySetId, result)", (py_dcerpc_call_fn)dcerpc_fss_StartShadowCopySet_r, (py_data_pack_fn)pack_py_fss_StartShadowCopySet_args_in, (py_data_unpack_fn)unpack_py_fss_StartShadowCopySet_args_out, 2, &ndr_table_FileServerVssAgent },
	{ "fss_AddToShadowCopySet", "S.fss_AddToShadowCopySet(ClientShadowCopyId, ShadowCopySetId, ShareName) -> (pShadowCopyId, result)", (py_dcerpc_call_fn)dcerpc_fss_AddToShadowCopySet_r, (py_data_pack_fn)pack_py_fss_AddToShadowCopySet_args_in, (py_data_unpack_fn)unpack_py_fss_AddToShadowCopySet_args_out, 3, &ndr_table_FileServerVssAgent },
	{ "fss_CommitShadowCopySet", "S.fss_CommitShadowCopySet(ShadowCopySetId, TimeOutInMilliseconds) -> result", (py_dcerpc_call_fn)dcerpc_fss_CommitShadowCopySet_r, (py_data_pack_fn)pack_py_fss_CommitShadowCopySet_args_in, (py_data_unpack_fn)unpack_py_fss_CommitShadowCopySet_args_out, 4, &ndr_table_FileServerVssAgent },
	{ "fss_ExposeShadowCopySet", "S.fss_ExposeShadowCopySet(ShadowCopySetId, TimeOutInMilliseconds) -> result", (py_dcerpc_call_fn)dcerpc_fss_ExposeShadowCopySet_r, (py_data_pack_fn)pack_py_fss_ExposeShadowCopySet_args_in, (py_data_unpack_fn)unpack_py_fss_ExposeShadowCopySet_args_out, 5, &ndr_table_FileServerVssAgent },
	{ "fss_RecoveryCompleteShadowCopySet", "S.fss_RecoveryCompleteShadowCopySet(ShadowCopySetId) -> result", (py_dcerpc_call_fn)dcerpc_fss_RecoveryCompleteShadowCopySet_r, (py_data_pack_fn)pack_py_fss_RecoveryCompleteShadowCopySet_args_in, (py_data_unpack_fn)unpack_py_fss_RecoveryCompleteShadowCopySet_args_out, 6, &ndr_table_FileServerVssAgent },
	{ "fss_AbortShadowCopySet", "S.fss_AbortShadowCopySet(ShadowCopySetId) -> result", (py_dcerpc_call_fn)dcerpc_fss_AbortShadowCopySet_r, (py_data_pack_fn)pack_py_fss_AbortShadowCopySet_args_in, (py_data_unpack_fn)unpack_py_fss_AbortShadowCopySet_args_out, 7, &ndr_table_FileServerVssAgent },
	{ "fss_IsPathSupported", "S.fss_IsPathSupported(ShareName, magic) -> (SupportedByThisProvider, OwnerMachineName, result)", (py_dcerpc_call_fn)dcerpc_fss_IsPathSupported_r, (py_data_pack_fn)pack_py_fss_IsPathSupported_args_in, (py_data_unpack_fn)unpack_py_fss_IsPathSupported_args_out, 8, &ndr_table_FileServerVssAgent },
	{ "fss_IsPathShadowCopied", "S.fss_IsPathShadowCopied(ShareName) -> (ShadowCopyPresent, ShadowCopyCompatibility, result)", (py_dcerpc_call_fn)dcerpc_fss_IsPathShadowCopied_r, (py_data_pack_fn)pack_py_fss_IsPathShadowCopied_args_in, (py_data_unpack_fn)unpack_py_fss_IsPathShadowCopied_args_out, 9, &ndr_table_FileServerVssAgent },
	{ "fss_GetShareMapping", "S.fss_GetShareMapping(ShadowCopyId, ShadowCopySetId, ShareName, Level) -> (ShareMapping, result)", (py_dcerpc_call_fn)dcerpc_fss_GetShareMapping_r, (py_data_pack_fn)pack_py_fss_GetShareMapping_args_in, (py_data_unpack_fn)unpack_py_fss_GetShareMapping_args_out, 10, &ndr_table_FileServerVssAgent },
	{ "fss_DeleteShareMapping", "S.fss_DeleteShareMapping(ShadowCopySetId, ShadowCopyId, ShareName) -> result", (py_dcerpc_call_fn)dcerpc_fss_DeleteShareMapping_r, (py_data_pack_fn)pack_py_fss_DeleteShareMapping_args_in, (py_data_unpack_fn)unpack_py_fss_DeleteShareMapping_args_out, 11, &ndr_table_FileServerVssAgent },
	{ "fss_PrepareShadowCopySet", "S.fss_PrepareShadowCopySet(ShadowCopySetId, TimeOutInMilliseconds) -> result", (py_dcerpc_call_fn)dcerpc_fss_PrepareShadowCopySet_r, (py_data_pack_fn)pack_py_fss_PrepareShadowCopySet_args_in, (py_data_unpack_fn)unpack_py_fss_PrepareShadowCopySet_args_out, 12, &ndr_table_FileServerVssAgent },
	{ NULL }
};

static PyObject *interface_FileServerVssAgent_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_FileServerVssAgent);
}

#define PY_DOC_FILESERVERVSSAGENT "File Server Remote VSS Protocol"
static PyTypeObject FileServerVssAgent_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "fsrvp.FileServerVssAgent",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "FileServerVssAgent(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_FILESERVERVSSAGENT,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_FileServerVssAgent_new,
};

static PyMethodDef fsrvp_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initfsrvp(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_base;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	fssagent_share_mapping_1_Type.tp_base = Object_Type;

	FileServerVssAgent_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&fssagent_share_mapping_1_Type) < 0)
		return;
	if (PyType_Ready(&FileServerVssAgent_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&FileServerVssAgent_InterfaceType, py_ndr_FileServerVssAgent_methods))
		return;

#ifdef PY_FSSAGENT_SHARE_MAPPING_1_PATCH
	PY_FSSAGENT_SHARE_MAPPING_1_PATCH(&fssagent_share_mapping_1_Type);
#endif
#ifdef PY_FILESERVERVSSAGENT_PATCH
	PY_FILESERVERVSSAGENT_PATCH(&FileServerVssAgent_InterfaceType);
#endif

	m = Py_InitModule3("fsrvp", fsrvp_methods, "fsrvp DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "FSRVP_CTX_APP_ROLLBACK", PyInt_FromLong(0x00000009));
	PyModule_AddObject(m, "ATTR_NO_AUTO_RECOVERY", PyInt_FromLong(0x00000002));
	PyModule_AddObject(m, "FSRVP_E_OBJECT_ALREADY_EXISTS", PyInt_FromLong(0x8004230D));
	PyModule_AddObject(m, "E_INVALIDARG", PyInt_FromLong(0x80070057));
	PyModule_AddObject(m, "FSRVP_E_OBJECT_NOT_FOUND", PyInt_FromLong(0x80042308));
	PyModule_AddObject(m, "ATTR_PERSISTENT", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "FSRVP_E_BAD_ID", PyInt_FromLong(0x80042302));
	PyModule_AddObject(m, "FSRVP_E_BAD_STATE", PyInt_FromLong(0x80042301));
	PyModule_AddObject(m, "FSRVP_E_SHADOW_COPY_SET_IN_PROGRESS", PyInt_FromLong(0x80042316));
	PyModule_AddObject(m, "FSRVP_E_NOT_SUPPORTED", PyInt_FromLong(0x8004230C));
	PyModule_AddObject(m, "FSRVP_CTX_FILE_SHARE_BACKUP", PyInt_FromLong(0x00000010));
	PyModule_AddObject(m, "FSRVP_E_WAIT_TIMEOUT", PyInt_FromLong(0x00000102));
	PyModule_AddObject(m, "FSRVP_CTX_BACKUP", PyInt_FromLong(0x00000000));
	PyModule_AddObject(m, "ATTR_AUTO_RECOVERY", PyInt_FromLong(0x00400000));
	PyModule_AddObject(m, "E_ACCESSDENIED", PyInt_FromLong(0x80070005));
	PyModule_AddObject(m, "FSRVP_RPC_VERSION_1", PyInt_FromLong(0x000000001));
	PyModule_AddObject(m, "ATTR_FILE_SHARE", PyInt_FromLong(0x04000000));
	PyModule_AddObject(m, "FSRVP_CTX_NAS_ROLLBACK", PyInt_FromLong(0x00000019));
	PyModule_AddObject(m, "E_OUTOFMEMORY", PyInt_FromLong(0x80000002));
	PyModule_AddObject(m, "FSRVP_E_WAIT_FAILED", PyInt_FromLong(0xFFFFFFFF));
	PyModule_AddObject(m, "ATTR_NO_AUTO_RELEASE", PyInt_FromLong(0x00000008));
	PyModule_AddObject(m, "ATTR_NO_WRITERS", PyInt_FromLong(0x00000010));
	Py_INCREF((PyObject *)(void *)&fssagent_share_mapping_1_Type);
	PyModule_AddObject(m, "fssagent_share_mapping_1", (PyObject *)(void *)&fssagent_share_mapping_1_Type);
	Py_INCREF((PyObject *)(void *)&FileServerVssAgent_InterfaceType);
	PyModule_AddObject(m, "FileServerVssAgent", (PyObject *)(void *)&FileServerVssAgent_InterfaceType);
#ifdef PY_MOD_FSRVP_PATCH
	PY_MOD_FSRVP_PATCH(m);
#endif

}
