
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_printcap.h"
#include "autoconf/librpc/gen_ndr/ndr_printcap_c.h"

staticforward PyTypeObject pcap_printer_Type;
staticforward PyTypeObject pcap_data_Type;

void initprintcap(void);static PyTypeObject *Object_Type;

static PyObject *py_pcap_printer_get_name(PyObject *obj, void *closure)
{
	struct pcap_printer *object = (struct pcap_printer *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_pcap_printer_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct pcap_printer *object = (struct pcap_printer *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		if (PyUnicode_Check(value)) {
			object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_pcap_printer_get_info(PyObject *obj, void *closure)
{
	struct pcap_printer *object = (struct pcap_printer *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		if (object->info == NULL) {
			py_info = Py_None;
			Py_INCREF(py_info);
		} else {
			py_info = PyUnicode_Decode(object->info, strlen(object->info), "utf-8", "ignore");
		}
	}
	return py_info;
}

static int py_pcap_printer_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct pcap_printer *object = (struct pcap_printer *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		if (PyUnicode_Check(value)) {
			object->info = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->info = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_pcap_printer_get_location(PyObject *obj, void *closure)
{
	struct pcap_printer *object = (struct pcap_printer *)pytalloc_get_ptr(obj);
	PyObject *py_location;
	if (object->location == NULL) {
		py_location = Py_None;
		Py_INCREF(py_location);
	} else {
		if (object->location == NULL) {
			py_location = Py_None;
			Py_INCREF(py_location);
		} else {
			py_location = PyUnicode_Decode(object->location, strlen(object->location), "utf-8", "ignore");
		}
	}
	return py_location;
}

static int py_pcap_printer_set_location(PyObject *py_obj, PyObject *value, void *closure)
{
	struct pcap_printer *object = (struct pcap_printer *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->location = NULL;
	} else {
		object->location = NULL;
		if (PyUnicode_Check(value)) {
			object->location = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->location = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_pcap_printer_getsetters[] = {
	{ discard_const_p(char, "name"), py_pcap_printer_get_name, py_pcap_printer_set_name },
	{ discard_const_p(char, "info"), py_pcap_printer_get_info, py_pcap_printer_set_info },
	{ discard_const_p(char, "location"), py_pcap_printer_get_location, py_pcap_printer_set_location },
	{ NULL }
};

static PyObject *py_pcap_printer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct pcap_printer, type);
}


static PyTypeObject pcap_printer_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "printcap.pcap_printer",
	.tp_getset = py_pcap_printer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_pcap_printer_new,
};


static PyObject *py_pcap_data_get_status(PyObject *obj, void *closure)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_pcap_data_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(py_obj);
	object->status = NT_STATUS(PyInt_AsLong(value));
	return 0;
}

static PyObject *py_pcap_data_get_count(PyObject *obj, void *closure)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_pcap_data_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_pcap_data_get_printers(PyObject *obj, void *closure)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(obj);
	PyObject *py_printers;
	py_printers = PyList_New(object->count);
	if (py_printers == NULL) {
		return NULL;
	}
	{
		int printers_cntr_0;
		for (printers_cntr_0 = 0; printers_cntr_0 < object->count; printers_cntr_0++) {
			PyObject *py_printers_0;
			py_printers_0 = pytalloc_reference_ex(&pcap_printer_Type, object->printers, &object->printers[printers_cntr_0]);
			PyList_SetItem(py_printers, printers_cntr_0, py_printers_0);
		}
	}
	return py_printers;
}

static int py_pcap_data_set_printers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int printers_cntr_0;
		object->printers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->printers, PyList_GET_SIZE(value));
		if (!object->printers) { return -1;; }
		talloc_set_name_const(object->printers, "ARRAY: object->printers");
		for (printers_cntr_0 = 0; printers_cntr_0 < PyList_GET_SIZE(value); printers_cntr_0++) {
			PY_CHECK_TYPE(&pcap_printer_Type, PyList_GET_ITEM(value, printers_cntr_0), return -1;);
			if (talloc_reference(object->printers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, printers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->printers[printers_cntr_0] = *(struct pcap_printer *)pytalloc_get_ptr(PyList_GET_ITEM(value, printers_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_pcap_data_getsetters[] = {
	{ discard_const_p(char, "status"), py_pcap_data_get_status, py_pcap_data_set_status },
	{ discard_const_p(char, "count"), py_pcap_data_get_count, py_pcap_data_set_count },
	{ discard_const_p(char, "printers"), py_pcap_data_get_printers, py_pcap_data_set_printers },
	{ NULL }
};

static PyObject *py_pcap_data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct pcap_data, type);
}

static PyObject *py_pcap_data_ndr_pack(PyObject *py_obj)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_pcap_data);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_pcap_data_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_pcap_data);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_pcap_data);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_pcap_data_ndr_print(PyObject *py_obj)
{
	struct pcap_data *object = (struct pcap_data *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_pcap_data, "pcap_data", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_pcap_data_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_pcap_data_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_pcap_data_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_pcap_data_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject pcap_data_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "printcap.pcap_data",
	.tp_getset = py_pcap_data_getsetters,
	.tp_methods = py_pcap_data_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_pcap_data_new,
};

static PyMethodDef printcap_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initprintcap(void)
{
	PyObject *m;
	PyObject *dep_talloc;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	pcap_printer_Type.tp_base = Object_Type;

	pcap_data_Type.tp_base = Object_Type;

	if (PyType_Ready(&pcap_printer_Type) < 0)
		return;
	if (PyType_Ready(&pcap_data_Type) < 0)
		return;
#ifdef PY_PCAP_PRINTER_PATCH
	PY_PCAP_PRINTER_PATCH(&pcap_printer_Type);
#endif
#ifdef PY_PCAP_DATA_PATCH
	PY_PCAP_DATA_PATCH(&pcap_data_Type);
#endif

	m = Py_InitModule3("printcap", printcap_methods, "printcap DCE/RPC");
	if (m == NULL)
		return;

	Py_INCREF((PyObject *)(void *)&pcap_printer_Type);
	PyModule_AddObject(m, "pcap_printer", (PyObject *)(void *)&pcap_printer_Type);
	Py_INCREF((PyObject *)(void *)&pcap_data_Type);
	PyModule_AddObject(m, "pcap_data", (PyObject *)(void *)&pcap_data_Type);
#ifdef PY_MOD_PRINTCAP_PATCH
	PY_MOD_PRINTCAP_PATCH(m);
#endif

}
