# 陷阱和挑战

\newpage
## 您能够信任您的计算机吗？

> Copyright © 2002, 2007, 2014, 2015 Richard Stallman 本文首先于 2002 年发表于 <http://gnu.org>。

您的计算机应该听从谁的命令？大多数人认为他们自己的计算机应当听从他们自己的命令而非他人的。但是，大型媒体公司（包括电影公司和唱片公司）正在联合大型计算机公司，诸如英特尔和微软，试图通过一项它们称之为“信任计算”的阴谋使得您的计算机听命于它们而非您（这种阴谋的微软版本称为 Palladium）。以前的私有软件本来就包含恶意功能，但现在这项阴谋将会使它们变为无恶不作的恶意软件。

从本质上说，私有软件意味着您不能控制它们的所作所为；您不能研究它们的源代码也不能修改它们。精明的商业人士总会找到办法以便利用他们的控制权将您置于不利地位，这并不令人感到丝毫惊讶。微软曾经多次这样做：某个版本的 Windows 被设计为能够向微软报告您的硬盘驱动器上安装的所有软件；最近的一项用于 Windows Media Player 的“安全”更新强制用户接受新的限制。但是，微软并不是唯一一家正在如此做的：例如 KaZaa 音乐共享软件被设计为使得 KaZaa 的业务合作伙伴可以将您的计算机使用状况出卖给它们的客户。这些恶意的功能通常是隐秘的，但即使您能够知道它们的存在，也难以移除它们，由于您不能访问它们的源代码。

在过去，这些行为只是孤立事件。然而，所谓的“信任计算”将会使得这种行为无处不在。“背叛计算”无疑是一个更为贴切的名字，由于这个阴谋被设计的初衷是确保您的计算机系统性地不再听命于您。事实上，它被设计为使您的计算机不再成为通用目的计算机。任何一项操作都可能要求得到它们的明确授权。

背叛计算的基本技术思想是使计算机包含一个数字加密与签名设备，而它所用的密钥对您是绝密的。私有软件将会利用这一设备来控制您可以运行哪些其他程序，您可以访问哪些文档或数据，以及您可以把它们传给什么程序。这些程序将会不断从互联网上下载更多的认证限制规则，并且自动将这些限制强加到您的工作中。如果您不想让您的计算机定期从互联网上获取新的限制规则，一些功能将会自动停止工作。

当然，好莱坞和唱片公司计划将背叛计算用于数字限制管理（DRM），这样，您下载到的视频和音乐将只能在某一台特定的计算机上播放。分享将会完全成为不可能，至少是对于那些您从这些公司获得的经过认证的文件。您，作为公众的一员，理应拥有分享这些内容的自由和能力（我期望某些人能够找到一种方式来制作未加密的版本并且上传分享它们，这样 DRM 将不能完全得逞，但是，这不能成为我们原谅它的理由）。

禁止分享已经足够恶劣了，但是事情正在向着更坏的方向发展。已经有计划将这种机制用于邮件和文档——使得邮件将会在两周之后消失，或者文档只能被某家公司的计算机读取。

假设您收到上司的邮件，对方要求您去做某些您认为过于激进冒险的事情。一个月之后，当事情产生相反的效果时，您不能利用那封消失了的邮件证明这一决策并非您所做出。此时的白纸黑字并不能证明您的清白，如果它是用会褪色的墨水写的。

假设您收到上司的邮件，邮件中说明了一种非法的或者通常是令人无法容忍的政策，例如销毁您的公司的审计档案，或者放任某种对您的国家的威胁发展坐大。今天，您还可以将其发送给记者并曝光这种行为。但是，一旦有了背叛计算，记者将不能读取您的文档；由于记者的计算机拒绝听命于本人。背叛计算将会成为腐败和犯罪的渊薮。

诸如微软 Word 等文字处理器可能会使用背叛计算来保存您的文档，以使得竞争对手的文字处理器不能读取它们。如今，我们必须试图通过耗时费力的试验来破解 Word 格式的秘密，以使得自由的文字处理器能够读取 Word 文档。但如果 Word 在保存文档时使用背叛计算加密文档内容，自由软件社区将毫无机会开发出能够读取它们的软件——即使我们能够开发出来，这样的软件也可能甚至会被数字千年版权法案（DMCA）判定为非法。

使用背叛计算的软件将会持续从互联网下载新的认证限制规则，并且将其强加于您的工作。如果微软或者美国政府不喜欢您在文档中所写的内容，它们可以发送新的指令通知所有计算机拒绝任何人读取该文档。每台计算机在下载到新的指令时都会执行它。这样，您所写的内容将会遭受《一九八四》式的反动的抹除，甚至您自己都可能再也不能读取它。

您可能认为您能够通过某种方式发现一款背叛计算的应用程序会做出哪些龌龊的事情，了解那些行为是多么地让人痛苦，然后决定是否接受它们。但即使您能够发现这些，对您来说接受这些协议也是愚蠢的，您甚至不能指望这些条款会维持现状而不是变得更坏。您一旦依赖于使用这些软件，您已经对此成瘾并且它们知道这一点；然后它们可以更改条款使其对您更加不利。一些应用程序会自动下载更新，而这些更新会在暗中做一些其他事情——而它们不会给您是否接受更新的选择权。

如今，您仍然可以通过拒绝使用私有软件来避免受其限制。如果您运行 GNU/Linux 或者其他的自由操作系统，并且您避免在其上安装私有软件，那么您仍然掌控着您的计算机的行为。如果一款自由软件包含恶意功能，社区中的其他开发者将会将其移除，您将能够使用修正后的版本。您也可以在非自由操作系统上运行自由软件和工具；这并不能完全赋予您自由，但很多用户确实如此做。

背叛计算将自由操作系统和自由软件置于绝境，因为您甚至可能完全不能运行它们。某些版本的背叛计算将会要求操作系统必须是由某家特定公司所具体认证的。这时自由操作系统将不被允许安装。某些版本的背叛计算可能会要求每个应用程序都要经过操作系统开发厂商具体认证。这时，您不能在这样的操作系统上运行自由软件。如果您设法找到破解方法并且告知他人，这将被视为犯罪行为。

事实上，美国法律已经有提案要求所有计算机支持背叛计算，并且禁止老旧计算机接入互联网。美国消费者宽带和数字电视推广法案（CBDTPA，我们称之为 Consume But Don't Try Programming Act，即“消费但不要尝试编程法案”）就是其中之一。但即使它们还没有从法律层面完全强制您转向背叛计算，这也会为您施加巨大压力以迫使您最终接受。如今，人们通常在通讯中使用 Word 文档格式，尽管这会导致诸多问题[^canyoutrust-1]。如果只有支持背叛计算的机器才能读取最新的 Word 文档，那么很多人将会转向它，如果他们仅仅将这种情况看作个人行为（即“爱用不用”）。为了反对背叛计算[^canyoutrust-2]，我们必须联合起来，并且作为一种集体的抉择来勇敢面对这一困境。

阻止背叛计算将会需要大量的公民来组织参与。我们需要您的帮助！请支持 [DefectiveByDesign.org](DefectiveByDesign.org) ，自由软件基金会反对数字限制管理的运动。

### 补篇

1.  计算机安全领域以另一种方式使用短语“信任计算”——注意不要混淆二者的涵义。

2.  GNU 计划发布了 GNU 隐私卫士（GPG），这是一款能够实施公钥加密和数字签名的软件，您可以使用它发送安全私密的邮件。您需要认清 GPG 和背叛计算的本质区别，并且知道为何前者是有益的而后者是极度阴险的。

    当某人使用 GPG 向您发送一份加密文档，并且您使用 GPG 对其解密，将会得到一份未加密的文档。您可以读取、复制、回复甚至重新对其加密并且安全地发送给他人。而背叛计算应用程序只是让您可以读取屏幕上的单词，但并不允许您生成一份未加密的文档副本用于其他用途。GPG，作为一款自由软件，使安全特性对用户可用，即“他们利用它”。而背叛计算被设计为向用户施加限制，即“它利用他们”。

3.  背叛计算的支持者总是着重论述其好处。他们所说的往往是正确的，但并不重要。

    同大多数硬件一样，背叛计算硬件也可以被用于非恶意用途，但这些功能也可由不带背叛计算的硬件以其他方式实现。基本的区别在于背叛计算对用户所做的是这样龌龊的事情：让您的计算机以对您不利的方式运行。

    他们说的是事实，而我说的也是事实。将二者放在一起考虑将会得出什么结论？背叛计算是一套剥夺我们的自由的阴谋，它提供了一些小恩小惠以吸引我们的注意力，使我们忽视我们将会因此失去的更为重要的东西。

4.  微软将 Palladium 作为一项安全措施推出，并宣称它将提供反病毒保护，但这是确凿的谎言。由微软研究院于 2002 年十月提供的一份演示文稿指出 Palladium 的特性之一现存的操作系统和应用程序仍然能够运行；因此，病毒自然可以继续做它们现在所能做的一切。

    当微软员工提及与 Palladium 相关联的“安全”概念时，它并非指的是我们通常理解的安全：保护您的机器免受您不想要的东西的危害。相反，他们指的是保护您的计算机上的数据，并且阻止您以其他人不喜欢的方式访问它们。演示文稿的一页幻灯片列出了 Palladium 可用于保守的几类机密，包括“第三方机密”和“用户机密”——但它将“用户机密”置于引号之中，指出这在 Palladium 的语境中是一种荒谬的东西。

    该演示文稿频繁使用一些我们经常与安全语境相关联的短语，诸如“攻击”、“恶意代码”、“冒名顶替”，当然还有“信任”。它们在这里的涵义都不是其通常的涵义。例如，“攻击”不是指某人试图伤害您，而是指您试图复制受保护的音乐；“恶意代码”指您自行安装的代码，用于使您的机器去做那些其他人不希望您做的事情；“冒名顶替”不是指其他人愚弄您，而是指您愚弄 Palladium，等等。

5.  先前由 Palladium 开发者发出的一份声明提出了一种基本的前提条件，即信息的任何制造者和收集者对于您如何使用该信息应当拥有完全控制权。这意味着对已有的伦理和法律系统理念的彻底颠覆，并且将会创建一个史无前例的控制体系。这些系统的具体问题绝非偶然，因为它是基于上述基本目标的。这种基本目标是我们必须坚决反对的。

6.  直至 2015 年，背叛计算在个人计算机（PC）中以“信任平台模块”（TPM）的形式实现；然而由于实践上的原因，TPM 被证实完全未能实现其目标：为数字限制管理（DRM）提供远程认证平台。因此，计算机公司以其他方式实现 DRM。现在，TPM 完全没有被用于实现 DRM，并且有理由怀疑将它们用于 DRM 是根本不可行的。讽刺的是，这意味着只有当前的 TPM 应用是无害的非重要应用——例如，证实没有人偷偷地更改了计算机中的系统。

    因此，我们得出结论：PC 中的 TPM 并不危险，没有理由不在 PC 中安装一块 TPM，或者不对其提供任何系统软件支持。

    这并不意味着所有事情都是美好的。其他禁止计算机的所有者改变其中的软件的硬件系统正在某些 ARM PC 以及移动电话、汽车、电视机和其他设备的处理器上使用，这与我们所预期的一样坏。

    这也不意味着远程认证是无害的。如果一旦有一款设备成功实施了它，它将对用户的自由造成毁灭性的影响。当前的 TPM 无害，仅仅是因为它暂时未能实现其使远程认证成为可能的企图。我们一定不要假设它在未来的所有企图都将失败。

[^canyoutrust-1]: 参见我的文章 “We Can Put an End to Word Attachments,” 位于 <http://gnu.org/philosophy/no-word-attachments.html>, 以获知 Word 文档所能导致的一系列问题的描述以及我们关于如何解决它们的一些建议。

[^canyoutrust-2]: 如需获得更多信息，参见 “‘Trusted Computing’ Frequently Asked Questions,” 一文，位于 <http://www.cl.cam.ac.uk/users/rja14/tcpa-faq.html>.
