# 第一版序言

>Copyright © 2002 自由软件基金会。

每一个时代都有引领时代发展的哲学家——也许是一个作家亦或一个艺术家。有时这些人家喻户晓，有些则是需要几代人的努力将其理念变为现实。无论是否为人熟知，一个时代会为这些抒发理想的人留下印记，他们或是盈盈细语于诗歌，或是揭竿而起于政治运动。

我们这个时代有一位哲学家。他不是艺术家，也不是专职作家。他是一位程序员。理查德·斯托曼（Richard Stallman）是 MIT 的程序员以及操作系统架构师。作为程序员和架构师，他创立了一项在这个日益由“代码”决定的世界里争取自由的运动，从此开始了他在大众生活舞台上的职业生涯。

“代码”是一项使计算机运行的技术。无论是写在软件里或者烧在硬件上，都是由一系列指挥机器运行并写成文字的指令组成。这些机器——计算机日益定义并控制了我们的生活。它们决定了电话如何接通，电视上播什么节目；它们决定了视频是否能够通过视频流传到计算机上；它们也控制了计算机汇报给其制造商哪些信息。这些机器为我们服务，而代码控制这些机器。

我们应该如何控制这些代码？怎么理解它们？启用控制时应该有什么自由与之匹配？有什么样的权力？

这些问题也挑战着斯托曼的生活。通过他及他的作品，让我们明白了代码“自由”的重要性。这里的 free 并非表示写代码的人不能得到报偿，而是意味着程序员将代码透明给所有人，任何人都可以控制代码，并按照自己的需求修改。这就是“自由软件”；“自由软件”为这个由代码构成的世界做了回答。

"Free"，斯托曼在解释这个词的时候颇有怨言。然而这并没有什么可悲叹的，模糊的概念迫使人们去思考，"Free"这个词着实足够启发思考。对当代美国人而言，“自由软件”听起来像是乌托邦，完全无法实现的，空洞的，甚至连午餐，也是免费的。那些控制着世界上最重要机器的代码怎么能是“免费的”。一个理性的社会怎么能主张这样的理想？

但“free”一词的奇怪意思只是对我们而言，而不是这个词汇本身。Free 一词有很多意思，只有一个是表示免费。更多的则表示是自由。斯托曼说，把它称为“言论自由”，或者更准确地说是“自由劳动”较为恰当，并不是表示没有花费，而是表示没有被他人控制和限制。

这种机制通过一种“copyleft”模式的 GPL 许可证得以体现。基于 copyleft 条款赋予的权力，“自由软件”不仅仅是开放的，更保证了修改自由，且其他使用自由软件（技术上称为“派生”）的也必须是自由的。如果你使用了一个自由软件程序，并公开发布了修改版，那么修改版也和原版一样是自由的。这是必须的，否则会违反版权法。

“自由软件”与自由社会一样，也有其敌人。微软发起了针对 GPL 的战争，警告所有人 GPL 是一种“危险的”许可证。事实上，它说的危险性很大程度上是欺骗性的。还有反对者认为 GPL “强迫”修改版也必须是自由的。光看这一条不能判断是否强迫。微软拒绝允许用户发布修改过的 Office 软件而不需要支付（假设）数百万的费用，如果这还不是强迫的话，那么 GPL 坚持的修改自自由软件的软件也必须是自由的，也不是强迫。

有些人认为斯托曼的言论太过极端，然而并不极端。事实上，显而易见的，斯托曼的作品只是将代码出现之前世界的自由简单翻译过来了。“自由软件”能确保代码世界的秩序与之前的传统是一样“自由的”。

比如：一个“自由的社会”是由法律来规范的。然而任何自由社会的法律对这些都有限制：没有自由社会可以用秘密法律。在传统上没有政府可以对其治理的对象隐藏规范。法律能够起效，只在明显公平正义的情况下才可以。只有当法律的条款是可以被其监管的人或其管理的管理者（律师，立法机构）知悉和控制时，法律才是可见的。

法律的这种条件超出了立法者的工作。来想想美国法院的司法实践吧。当事人雇用律师来提高利益，有时候这种利益通过诉讼得以提升。在诉讼过程中，律师写出诉讼状，这些诉讼状反过来影响法官写下的意见。这些意见决定谁能够在案件中获胜，或者某法律条文是否符合宪法的精神。

这个过程中的所有材料都符合斯托曼所说的自由。诉讼简报是公开的，别人可以自由使用。论据是透明的（不等于说就是好的），论证过程也无需原律师的允许就可以拿走。法官意见可以在之后的诉讼摘要里引用，并可以复制或综合到别的诉讼简报或意见中。美国法律的“源代码”在设计上和原则上，对任何使用它的人都是开放和自由的。拿律师来说，借由重复使用之前案件的材料，律师发挥了创造力，可以作出最佳的诉讼简报。原始资料是自由的，创新和经济都是在其上建立的。

自由代码（这里指法律代码）的经济并没有扼杀律师。尽管任何人都可以使用和复制他们做成的东西，律师事务所仍然有足够动机来作出好的诉讼简报。律师也是手艺人，他或她的产品是公开的。但是这种工艺不是慈善行为。律师能得到收入，公众没有不给他们工作报酬。相反，这种经济能够蓬勃发展恰是因为之后的工作可以弥补前面的。

我们来设想一种不同的法律实践——案情和证据都是保密的，判决只有结果而没有论证，法律只由警方把持而其他人看不到，法规条令也不经解释如何执行。

我们尽可以设想这样的社会，但却不能称其为“自由”。无论是否有更好的动机，或更有效率的分配，这样的社会都无法认为是自由的。自由社会中的自由生活理想并不仅仅只是高效的分配。而是在开放和透明的前提下建立法律的限制，不能因为对领导人有利就加入相应的选项。由软件代码治理的生活也不能比这个更差。

编写代码不是诉讼。它更好，更丰富也更有建设性。创造性和动机并不依赖于对创作产品的完全控制，法律就是一个明显的例子。类似爵士乐、小说或者建筑，法律条文是基于既有的基础而建立的。这种增补和改变一直是创新的体现。一个自由的社会必须保证其最重要的资源一直是自由的，这才像话。

这本书以一种使之更微妙且权力更明确的方式，收录了理查德·斯托曼的著作和演讲。这些文章跨度很大，从版权到自由软件运动的历史，包含了许多不为人知的论点，其中尤其是对数字世界中版权受到怀疑的变化的情况的深刻见解。这些文章是理解他思想的源泉，理解他的激情和他的正直，即使其他方面都不及此。这些文章将会启发那些接受他的理念并将之发扬光大的人们。

我并不十分了解斯托曼，但我很清楚他是一个严厉的人。他求胜心切，常常不耐烦。他对朋友可以像对敌人一样火冒三丈。他很强硬，不屈不挠，但却也很有耐心。

当我们的世界最终理解了代码的威力和危险，终于认识到代码和法律、政府一样，必须透明才能获得自由时，不妨回首看着这位强硬且不屈不挠的程序员，会发现他终身奋斗的景象终于实现：自由和知识可以在编译器下幸存。我们会认识到没有人能像斯托曼这样，可以为社会获得自由而奋斗和发声。

然而我们尚没有获得自由。我们在捍卫自由的时候也许会失败。然而无论胜败，这些作品都展现了自由的景象。创作这些作品的生活中，会启发那些就像斯托曼一样，为自由而战的人们。

\ 

劳伦斯·莱斯格[^f1-1]

LAWRENCE LESSIG

[^f1-1]: 劳伦斯·莱斯格（Lawrence Lessig），是一位美国学者暨学术与政治的行动主义者，哈佛法学院法学教授。他还是知识共享（Creative Commons）发起委员、软件自由法律中心（SFLC）委员、阳光基金会咨询委员与电子前哨基金会（EFF）前任委员。——译者注

