\newpage
## 如今自由软件更加重要

> Copyright © 2015 理查德·斯托曼（Richard Stallman）。此文大幅修改后发表于《连线》杂志（Wired）网站，标题是[“Why Free Software Is More Important Now Than Ever Before”](http://wired.com/opinion/2013/09/why-free-software-is-more-important-now-than-ever-before)，2013年9月28日。

自1983年以来，自由软件运动一直在为计算机用户的自由而战——用户控制他们使用的软件，而不是相反。当一个程序尊重用户和社区的自由时，我们把它称为“自由软件”。

我们有时也称之为“libre software”以便澄清我们关注的是自由，而不是价格。一些专有（非自由）软件比如 Photoshop，非常昂贵；而其他比如 Flash 播放器则免费提供——所以价格并不是大问题。无论高价还是免费，它们都将程序开发者的权力凌驾于用户之上，而这种权力是不应该存在的。

同时这些软件还有个共同点：他们都是*恶意软件*。也就是说从功能上都是设计用来虐待用户的。今天的专有软件往往是恶意软件，因为开发者的权力腐化了它们[^fsemi-1]。而自由软件，用户控制着程序，既是单独用户控制同时也是群体控制。这样他们就控制着计算机做的事情（假设这些程序都是忠实完成用户的指令）。

专有软件程序控制着用户，另一些（开发者或“所有者”）则完全控制着程序。因此专有程序给了开发者凌驾用户的权力。而这本身就是不公平的，并且诱使开发者用其他方式虐待用户。

自由意味着你控制着自己的生活。如果你使用程序来打理你的生活，你的自由就取决于你如何控制着这些程序。你应该拥有对程序的控制权，更何况这些程序控制着你生活中重要的事情。

用户对程序的控制需要四项基本的自由[^fsemi-2]。

1. 基于任何目的，按你的意愿运行软件的自由。

2. 学习软件“源代码”并修改的自由，这样可以让程序执行你想做的事情。程序是由程序员使用编程语言编写的（比如结合英语和代数），这种形式称为“源代码”。任何熟悉编程，并能以源代码形式编程的人，都可以读源代码，懂得其逻辑，并可以修改之。当你只能得到可执行格式，也就是对计算机来说能理解，但对人类极难读懂的一系列数字时，读懂并修改该形式的程序难如登天。

3. 将当前副本重新分发的自由（这不是一种义务，这样做是你的选择。如果程序是自由的，并不意味着别人有义务提供给你一份副本，或者你有义务为其他人提供副本。分发程序而没有自由，会虐待用户。然而如果不分发软件——只是私下使用——则不会虐待任何人）。

4. 随时分发你修改过的版本的自由。

前两个自由表示用户可以实际控制程序。而剩下的自由，表示任何用户团体都可以*集体控制*程序。具备这四个自由，用户就可以完全控制程序。这四个自由缺一不可，否则程序就是专有的（非自由的），并且不道德。

任何实用性的作品都可以适用，包括烹饪菜谱，教育作品比如教科书，参考书比如字典和百科全书，显示文章的字体，硬件设计的电路程序，3D 打印用的（不只是装饰品）模型文件。因为这些并不是软件，所以自由软件运动严格上来说并不包括它们，但同理可证：这些作品也需要符合上面这四项自由。

一个自由的程序允许你按照自己的想法去改造。对于将专有软件看成密封盒子的人来说，改造软件看起来很荒谬，然而在自由的世界里则是非常普遍，并且对学习编程非常有利。传统美国消费者对汽车的改造并不顺畅，恰是因为汽车包含非自由的软件。

### 专有化的不公

如果用户没有控制程序，那么程序就在控制用户。对专有软件，有一些实体比如开发者或者程序“所有者”，控制着程序，将权力凌驾于用户之上。一个非自由的程序就像个操纵杆，是一把操纵不公权力的工具。

令人发指的是（这种情况很常见）专有程序设计用来窥视、限制、审查甚至虐待用户[^fsemi-3]。例如苹果的 iThings 操作系统做了所有这些，同样的基于 ARM 芯片移动设备上的 Windows 系统也是如此。Windows 手机固件以及 Google Chrome 的 Windows 版包含了通用后门，可以让一些公司不经过用户同意就远程修改程序。亚马逊的 Kindle 则通过后门删除用户的电子书。

“物联网”（internet of things）产品上使用的非自由程序会将物联网变成“骗联网”（internet of telemarketers）[^fsemi-4]或“窥联网”（internet of snoopers）。

为了结束非自由程序的不公，自由软件运动开发了自由的程序，这样用户可以解放自己。我们首先在 1984 年开始开发自由的操作系统 GNU。现在数以万计的计算机运行着 GNU，主要是 GNU/Linux 结合体[^fsemi-5]。

分发非自由的程序给用户是残害用户的行为；然而如果不分发程序则不会伤害任何人。如果你写了一个程序并私下使用，不会伤害到任何人。你也许会失去做好事的机会，但这与做错事是不一样的。因此，我们说所有程序都应该自由，意思是所有副本都应该遵循这四个自由，但并不意味着别人有义务提供给你一份副本。

### 非自由软件与 SaaSS

非自由软件是公司控制人们电脑的首选方案。今天，还有另外一种方式，称为“替代软件的服务”（SaaSS，Service as a Software Substitute）。这意思是让别人的服务器去做你自己的计算任务。

SaaSS 并不意味着运行在服务器上的程序是非自由的（虽然大多数确实是非自由的）。然而，使用 SaaSS 会导致与使用非自由程序一样的不公：殊途同归。就拿 SaaSS 翻译服务为例：用户发送文本到服务器，服务器将其翻译好发回用户（比如从英文翻译为西班牙文）。那么翻译的工作是由服务器运营商控制的，而不是用户。

如果你使用 SaaSS，服务器运营商控制着你的计算过程。它需要委托所有数据到服务器运营商那里，而这些数据也可能会被迫出让给国家——毕竟谁是服务器真正服务的人[^fsemi-6]？

### 主要和次要的不公

当你使用专有软件或者 SaaSS，首先你对自己不好，因为这给了别的实体可以用不公的权力凌驾你之上。所以为你着想，你必须远离非自由的程序。如果你承诺不分享程序，你就在对他人不好。这个承诺本身就是罪恶，不那么罪恶的是打破承诺；最好的做法就是你应该完全不作出这样的承诺。

有一些非自由的程序会直接给用户施压。Skype 就是一个例子：当用户使用了一个非自由的 Skype 客户端软件，它会要求其他人使用同样的软件——这样两个人都将自由放弃了（Google Hangouts 也有同样的问题）。建议使用这样的软件也是同样的错误。我们必须坚决拒绝它们，即使是短时间，即使是在别人的电脑上。

另一个使用非自由程序和 SaaSS 的害处是会嘉奖肇事者，鼓励他们开发更多这样的程序或“服务”，导致更多人掉入公司的陷阱。

所有这些间接伤害发生在公共实体或学校的时候会更加显著。

### 自由软件与国家

公共机构是为人民服务的，而不是为他们自己。在计算机领域也是如此。他们有义务完全控制计算过程以确保恰当地为人民服务（也就是所谓的国家计算主权）。他们决不能让计算机的控制权落入私人之手。

为了维持对为人民服务的计算过程的控制，公共机构必须不能使用专有软件（一个由国家之外的实体掌控的软件），同时不能委托国家机构以外的实体编写或运行服务，因为这会是 SaaSS。

专有软件在非常时期是没有安全可言的——因为无力抵抗其开发者。甚至开发者会帮助其他人攻击。微软会在修复 Windows 的 bug 之前将其展示给 NSA[^fsemi-7]（美国数字间谍机构）。我们不知道苹果是不是也这样做，但他们同样受到与微软一样的政府压力。如果其他国家政府使用这样的软件，会危害国家安全[^fsemi-8]。你会希望 NSA 攻入你自己国家政府的计算机吗？

### 自由软件与教育

学校（包括所有这类教育活动）通过他们的教学会影响社会的未来。为了做善事他们必须只教自由软件。教授专有程序会产生依赖性，这与教育的使命是相悖的。通过培训使用自由软件，学校会将社会的未来转向自由，并帮助天才的程序员掌握这门手艺。

他们同时也教育了学生协作的习惯，帮助其他人。每个班级都要有这样的规则：“对学生而言，这个班级是分享知识的地方，如果你将一个软件带来，不仅仅是你自己用，同时你必须将副本分享给班里其他人——包括源代码——以备其他人想要学习。因此，不允许将专有软件带到课堂，除非学习逆向工程。”

专有软件的开发者会惩罚那些好心分享软件的学生，并阻挠学生企图修改的好奇心。这是很烂的教育[^fsemi-9]。

### 自由软件：不止“优势”

经常有人让我描述自由软件的“优势”。然而“优势”这个词对自由而言太弱了。没有自由的生活是一种压迫，无论是我们平时的生活还是计算机领域。我们必须拒绝让软件或计算机服务的开发者控制我们的计算机。这才是我们要做的事情，虽然有自私的因素；但不仅仅是自私的考量。

自由包括与其他人协作的自由。拒绝人们的这项自由意味着让人孤立，会成为对人压迫的开始。在自由软件社区，我们深刻的意识到与他人协作的重要性因为我们的工作正是有组织的协作。如果一个朋友看到你在用一个程序，她也许会要一份副本。而禁止人们再分发，或者说你“不应该”这么做的程序，是反社会的。

在计算机领域，协作包括向用户再分发原始副本，也包括分发你修改过的版本。自由软件鼓励所有这些协作，而专有软件禁止这些。专有软件禁止再分发副本，并拒绝提供给用户源代码，封锁人们对软件的修改。SaaSS 也有同样的效果：如果你的计算过程是由互联网上其他人的服务器，其他人的程序副本做出的，你不能看到或碰触到这些计算用的软件，因此你就不能再分发或修改了。

### 结论

我们应该控制我们自己的计算机，如何赢回控制权？可以拒绝使用我们自己或平时所用计算机上的非自由软件，拒绝 SaaSS。对于我们这些程序员而言，可以开发自由软件[^fsemi-10]，还可以拒绝开发或者推广非自由软件或 SaaSS，并广泛散播这些理念给其他人[^fsemi-11]。

我们以及上千用户从1984年开始就这么做，这样才有了现在我们使用的自由的 GNU/Linux 操作系统，所有人——无论是否是程序员——都可以使用。以一个程序员或活动家的身份，加入我们的事业。让我们一起解放所有计算机用户吧。

[^fsemi-1]: 参见<http://gnu.org/proprietary/proprietary.html>可知这些不断增加的威胁。

[^fsemi-2]: 自由软件的完整定义可参见《什么是自由软件》一文。

[^fsemi-3]: 参见《自由和非自由软件分类》一文中关于专有软件的脚注 1。

[^fsemi-4]: 参见 Marcelo Rinesi 于2015年8月6日发表的文章"The Telemarketer Singularity"<http://ieet.org/index.php/IEET/more/rinesi20150806>

[^fsemi-5]: 关于 GNU 操作系统的历史可参见《GNU 工程》一文，以及“GNU/Linux FAQ”<http://gnu.org/gnu/gnu-linux-faq.html>。

[^fsemi-6]: 参见《服务器真正为谁服务？》一文。

[^fsemi-7]: 参见 Sean Gallagher 于2013年6月14日发表的文章“NSA Gets Early Access to Zero-Day Data from Microsoft, Others” <http://arstechnica.com/security/2013/06/nsa-gets-Eearly-access-to-zero-day-data-from-microsoft-others/>

[^fsemi-8]: 关于我们建议的政策可参见《政府推动自由软件的措施》一文

[^fsemi-9]: 有关自由软件在学校的讨论可参见 <http://gnu.org/education>

[^fsemi-10]: 关于许可证的建议可参见《如何为你自己的作品选择许可证》一文中的推荐许可证。

[^fsemi-11]: 各种帮助的方式可参见 <http://gnu.org/help>
