# GNU 计划和自由软件

\newpage
## 什么是自由软件？

> Copyright © 1996–2002,2004–2007, 2009–2015 自由软件基金会。此文最初于1996年发表在<http://gnu.org>。
 
### 自由软件的定义

> 自由软件的定义给出了一个标准，即一个特定的软件是否有资格被称为自由软件。我们时不时修改这一定义，以澄清和解决与之相关的各种细微问题。关于我们对自由软件定义所作的修改记录，请参阅 <http://gnu.org/philosophy/free-sw.html> “历史”部分。

“自由软件”（Free Software）表示的是那些尊重用户和社区自由的软件。粗略的说，它赋予**用户运行、复制、分发、学习、修改并改进软件的自由**。因此，“自由软件”是有关用户的自由权益（liberty），而不是指免费（free）的价格。为了理解这个概念，你需要将“free”一词理解成“言论自由”中的“自由”，而不是“免费啤酒”里的“免费”。有时我们会称之为“Libre Software”，以避免带有免费的意思。

我们争取这些自由，是因为每个人都应该拥有它。有了这些自由，用户（包括个体和团体）就可以控制程序为己所用。当用户无法控制程序时，我们称这样的软件为“非自由”（Nonfree）或“专有”（Proprietary）程序。非自由的程序控制了用户，而开发者控制着程序：这就让程序成为了非正义权力的帮凶[^freesw-1]。

如果一个软件的用户拥有以下四项基本自由，那么该软件可以被称为自由软件：

-   基于任何目的，按你的意愿运行软件的自由（自由之零）。

-   学习软件如何工作的自由，按你的意愿修改软件以符合你的计算的自由（自由之一）。可访问源代码是此项自由的先决条件。

-   分发软件副本的自由，因此你可以帮助你的邻居（自由之二）。

-   将你修改过的软件版本再分发给其他人的自由（自由之三）。这样可以让整个社区有机会共享你对软件的改动。可访问源代码是此项自由的先决条件。

如果一个软件可以充分授予用户所有这些自由，它就是自由软件，否则就是非自由软件。即使我们可以依据它们与这四项自由有多大的差异来区分不同的非自由发行方式，我们依然认为这些非自由软件是不符合伦理的。

在任何情况下，这些自由都必须应用于所有要使用的代码，或引导其他人使用这些软件。例如，程序 A 会自动调用程序 B 来处理一些事情，如果我们独立发布 A 也意味着用户还需要 B，因此我们需要判断 A 和 B 是否都是自由的。如果我们修改了 A 使得它不再需要 B，那么只需要 A 是自由的，就可以忽略 B。

本文余下的内容，将会澄清关于特定自由是否适用的一些关键点。

再分发软件的自由（自由之二和自由之三）表示你可以在任何地方发布软件的副本给任何人，无论是否有过修改，无论是免费或收取费用。自由地再分发意味着（排除其他因素）你不需要必须事前征得任何发行许可或为此支付额外费用。

你应该有修改软件的自由并将软件用于私人的工作或娱乐，甚至不需要提到你的修改。如果你发布了自己的修改版，你不应被要求通知特定的人或以特定的方式发布。

运行软件的自由，即赋予任何个人或组织在任何计算机系统上，基于任何工作方式或任何目的运行软件，而无需与任何开发者或特定实体沟通的自由。在这个自由中，重要的只是*用户的*目的，而非*开发者的*的目的；你作为用户有基于任何目的运行软件的自由；如果你将软件发布给了其他人，则她也有按自己目的运行软件的自由，但你不能将自己的目的强加给她。

以你的意愿运行软件的自由也表示你不能被要求禁止或停止运行该程序，这无关软件的功能，或对你来说它是否有用。

再分发软件副本的自由，表示分发该程序的二进制或可执行格式时必须附带源代码，包括修改过的和未修改版（以可运行格式发布程序可以方便在自由的操作系统上安装）。对特定程序也可以不发布和产生二进制可执行格式（因为一些编程语言不支持这个特性），但你仍有发布这些格式，或开发一种方法来产生这些格式文件的自由。

为了实现自由之一和自由之三（修改软件并发布修改版的自由），你必须能够访问程序的源代码，因此有权力访问程序的源代码对自由软件来说是一个必要条件。而混淆过的“源代码”不能算真正的源代码[^freesw-n]。

[^freesw-n]: 这里指的是“混淆代码”（Obfuscated code）的做法，是将计算机程序的代码，转换成一种功能上等价，但是难于阅读和理解的形式的行为。——译者注，摘自维基百科

自由之一允许用你修改的版本来替代原始的版本。如果一个程序从产品设计的角度发布只能用其他人修过的版本而不能用你的修改版——例如所谓的“Tivo化”[^freesw-tivo]或“锁定”，或者（用行业内的话来说）“安全启动”（Secure Boot）——这样自由之一就被架空而无法实现，即便这些软件的二进制是从自由的源代码编译而来，也不能算是自由软件。

[^freesw-tivo]: “Tivo”是美国一大有线电视机顶盒产品，“Tivo化”（Tivoization）是指该产品包含了以 GPL 许可证发布的软件，但实际上用户不能修改，因为一旦设备发现软件经过修改就会自动关机。相关内容可参考本书《为何升级到 GPLv3》一文。

修改软件的一个重要方法是合并可用的自由子程序或模块。如果一个程序的许可证让你不能将一个合理授权发布的现有模块融合进来——例如要求你成为你修改过代码的版权所有者，那么该许可证过于严苛以致不能被视为自由的。

自由之三允许你以自由软件的方式发布修改版。一个自由许可证可允许以其他形式发布；也就是说，这不一定是 copyleft 许可证。不过如果一个许可证要求以非自由的方式发布修改版，则是非自由的。

为了让这些自由得以实现，在你遵守许可的条件下，这些条款必须是永久且不可撤销的。如果软件的开发者有权力撤销，或者添加限制性条款。在你遵守许可的情况下，那么该软件就不是自由的。

然而，一些对自由软件发布方式的限制规则是可以接受的，前提是与核心自由不冲突。例如，copyleft（最简单的说）规定你不能在分发程序的时候添加限制性条款以拒绝其他人的核心自由。这一规则与核心自由并不冲突，反而是在保护核心自由。

在 GNU 工程中，我们用 copyleft 合法保护每个人的四项基本自由，我们相信使用 copyleft 是非常重要的。然而非 copyleft 的许可证也是合乎伦理的。有关“自由软件”、“copyleft 软件”和其他类型软件的话题可以参见本书《自由与非自由软件的分类》一文。

"自由软件"并不意味着“非商业”。一个自由软件允许商业使用，商业开发以及商业发布。自由软件的商业开发已经不是一件特殊的事情。这对自由软件是非常重要的，你可能需要为获取自由软件的副本而付费，也可能不需要付费。但是无论如何获得副本，你都有复制并修改软件的自由，甚至有重新销售的自由。

对程序的修改是不是改进程序，这只是一个主观判断。如果你对软件的修改权实际上仅限于作出被他人认作改进的修改，该程序并不自由。

不过，规范修改版打包行为的条款是可以接受的，因为实质上这没有限制你发布修改版的自由，或者私下使用的自由。因此，许可证的一些条款是可以接受的，比如要求你改变修改版的名字，移除商标（LOGO），或者修改版为你自己所有。只要这些要求不那么繁冗以至于影响了正常发布，都是可以接受的。既然你都已经做过一些修改，也就无所谓再多做一些了。

“如果你的版本在这种方式下可用，也必须能够在另一种方式下可用”，类似这样的条款也是可以接受的。同样的，比如有规则要求如果你发布了修改版，也必须给前一个开发者发送一份，也是可以接受的（注意这样的条款仍然让你有自由选择是否公开发布的权力）。要求你为公开发布版的程序附带源代码，也是可以接受的。

这里有个特殊问题，如果许可证要求你改变程序被其他程序调用时的名字。这样做实际上阻碍了你修改版的发布，以便通过修改名字来取代原始版。这种情况仅当通过一种别名机制来标示原始程序名是修改版的别名时才可被接受。

有时政府的出口管制或者贸易制裁会影响你国际范围内发布软件的自由。软件的开发者没有权力消除或覆盖这些限制，但他们可以做的是拒绝强制要求使用程序时接受这些条件。这样，这些限制就不会影响到那些政府管辖以外的国家和人民的活动。因此自由软件许可证为了行使这些必要的自由，不能要求服从任何这些出口限制条款。

我们仅仅只是提及这些出口限制条款，而没有将这些条款作为软件许可证的条件，因为这样并没有限制用户所以也是可以接受的。如果该出口限制条款对自由软件来说是非常普遍的，将其作为需要的条件也不是一个问题。然而这会产生一个潜在问题，出口限制法规若之后有一定修改，可能会让软件变成非自由的。

自由的许可证不能要求遵守非自由程序的许可证。所以，比如，如果一个许可证要求你必须遵守“你使用的所有程序”的许可证，那么运行非自由程序的用户在这种情况下意味着需要遵守非自由程序的许可证，那么这将使得该许可证变成非自由的。

自由软件许可证可以指定与软件相关的诉讼需要遵守哪个地区的法律，或需要在哪里提起诉讼。

大多数自由软件许可证是基于版权的，而何种要求能通过版权施加是有限制的。如果一个基于版权的许可证尊重如上文所述的自由，那么也就不会发生我们意料之外的问题（尽管这也许会发生）。然而有些自由软件许可证是基于合同的，而合同可以增加更大范围的限制。这样就有更大可能性使得该许可证出现无法接受的限制或非自由。

我们无法将这些可能的情形一一列出。如果一个基于合同的许可证以不同于基于版权许可证的方式限制了用户，此处也没有表明其为合法，那么我们就需要考察这个许可证，并且很可能会将之视为非自由的。

在谈到自由软件的时候，尽量不要用“赠予”（Give Away）或“免费”（For Free），因为这些词都是暗示价格上的免费而非自由的。一些常用语比如“盗版”也体现了一些我们希望你不会认同的意见。相关详情参见本书《应避免使用（或慎用）的词语，由于它们是不公正的或者引起混淆的》一文。我们同时还根据不同语言列出了“自由软件”（Free Software）一词的翻译，请参见本书附录 B。

最后，这些有关自由软件的标准需要谨慎的解读。判断一个软件许可证是否是自由软件许可证，标准就是看它是否符合自由软件精神以及用语是否精确。如果一个许可证包含了不合理的限制，即便是此文中我们没有预料到的问题，我们也会拒绝它。有些时候一个许可证会带来新的问题和思考，这需要我们与律师咨询以后，共同思考和研判。我们最终得出结论以后，将会更新这份标准以使其能更容易体现特定的许可证是否符合标准。

如果你对特定的许可证感兴趣，可以参考我们的许可证列表，位于 <http://gnu.org/licenses/license-list.html>。如果里面没有列出你所关心的，可以发邮件询问我们：<licensing@gnu.org>。

如果你打算起草一份新的许可证，请首先通过上面这个邮箱联系自由软件基金会。不同的自由软件许可证意味着用户需要花费更多精力来理解；我们也许可以帮你从现有的自由软件许可证里找到符合你需要的。

如果这样依然不行，你真的需要一份新的许可证，有了我们的帮助也可以确保许可证符合自由软件标准并避免一些现实问题。

### 软件之外

软件手册必须是自由的[^freesw-2]，就如同软件必须是自由的一样，因为手册会对软件产生一部分影响。

同理可证其他各种具有实用功能的作品，也就是说，任何体现知识可用性的作品也应该如此，比如教育资源和参考资料。维基百科（Wikipedia）就是最著名的例子。

任何领域的作品都*可以*是自由的，对自由软件的定义已经扩展为了对自由文化的定义，可应用于任何领域的作品[^freesw-3]。

### 开放源代码？

另一些用户使用“开放源代码”（“开源”，Open Source）一词来表示与“自由软件”相近（但不尽相同）的意思。我们倾向于使用“自由软件”一词，因为一旦你理解它表示自由而不是价格，这么称呼可以表达自由。“开放”（Open）一词并不能表达自由之要义[^freesw-4]。


[^freesw-1]: 可参见《如今自由软件更加重要》一文。

[^freesw-2]: 可参加《为什么自由软件需要自由文档》一文

[^freesw-3]: 可参见 <http://freedomdefined.org>

[^freesw-4]: 可参见《为什么说开源漏掉了自由软件的要点》一文


