\newpage
## 政府推动自由软件的措施

> Copyright © 2011–2014 自由软件基金会，此文于2011年首次发表在 <http://gnu.org>。

本文提出了一些推动自由软件在国内发展的强力政策，并引领国内其他方面转向软件自由。

国家的使命是通过整合社会资源为人民自由谋福祉。这个使命在计算机领域的一个方面就是鼓励用户使用自由软件：代表用户自由的软件[^gov-1]。而专有（非自由）软件则践踏了人民的自由；这是一个国家应该努力去根除的社会问题。

从国家的计算主权角度来说，国家需要坚持自由软件的主张（国家控制其计算过程）。所有用户理所应当控制自己的计算过程，但国家有代表人民对计算过程维持控制的责任。现在大多数政府活动都依赖计算过程，而对这些活动的控制则依赖于对计算过程的控制。而在任务很关键的机构里失去这种控制将会极大危害国家安全。

将国家机构转向自由软件同时也会提供额外的好处，比如节省经费和鼓励本地的软件支持行业等等。

本文中，“国家实体”指代各级政府，以及公共机构包括学校，公共—私立伙伴关系，大型国有活动比如特许公立学校，以及由国家控制或由国家特许经营或注资的“私营”企业。

### 教育领域

教育领域的政策非常重要，因为会影响国家的未来

- **只能教授自由软件**

  教育活动或者至少这些国立教育实体，必须只教授自由软件（因此，他们决不能引导学生使用非自由程序），并教育学生坚持使用自由软件背后的公民原因。教授非自由程序就是在教授依赖性，这与学校的使命是相悖的。

### 国家与公众

这些政策对个人与组织使用软件的影响也很巨大：

- **永远不要求非自由程序**

  法律和公共部门实践活动必须改革永远不能要求或施压给个人或组织使用非自由程序。他们还必须不能在通信或出版行业引入类似的规定（包括数字限制管理 Digital Restrictions Management[^gov-2]）。

- **只散播自由软件**

  国家实体无论在什么时候将软件公开散播，包括网页中包含或附带的程序，必须作为自由软件散播，且必须与只运行自由软件的平台兼容。

- **政府网站**

  政府实体的网站和网络服务必须设计成用户能够只用自由软件使用，（相对专有软件——译者注）没有劣势。

- **自由的格式和通信协议**

  国家实体必须只使用自由软件广泛支持的文件格式和通信协议，特别是已经公开的规格（我们并不说“标准”，因为它应该适用于标准和非标准的接口）。例如，他们必须不能散播使用 Flash 或者非自由解码器播放的音频或视频文件，对外公布的库必须不能包含数字限制管理。

- **解除对计算机的限制性许可证**

  销售计算机必须不能要求购买一份专有软件许可证。必须通过法律来约束销售方提供给消费者购买计算机时不需要专有软件以及不需要为此付费的选项。强制付费是另一个错误，不能让我们从专有软件的不公中分散注意力，应更关注失去自由而导致的损失。虽然如此，强迫用户为其付费等于是给了特定专有软件开发者一个额外的不平等优势——让他们来决定用户的自由。国家应该防止这种情况发生。

### 国家计算主权

很多政策会影响到国家计算主权。国家实体必须维持对它们的计算资源的控制，而不是放弃控制而委之于私人之手。这一点适用于所有计算机，包括智能手机。

- **迁移到自由软件**

  国家实体必须迁移到自由软件，并且不能安装和继续使用非自由软件，除非临时例外。只有一个机构可以有权授予这些临时例外，且需要令人信服的理由。这个机构的目标是将这些例外必须减少到零。

- **开发自由的 IT 解决方案**

  当政府实体需要为开发计算机解决方案付费时，合同必须要求以自由软件形式交付，并且方案必须设计为可以在百分之百自由软件环境中运行和开发。所有合同都需要这条，这样如果开发商一旦不符合需求，作品就不给报酬。

- **为自由软件选配计算机**

  当政府实体购买或租借计算机时，必须在其等级中选择几乎无需专有软件即可运行的型号。政府需要为每个等级的计算机维护一个按此标准授过权的型号的列表。对于公开型号和政府采购型号，应该选择只对政府开放的型号。

- **与厂商协商**

  国家必须经常与厂商协商市场（对外销售或/和面向政府）上适合的硬件产品，在所有相关产品领域，都不能需要专有软件。

- **与其他国家联合**

  本国需邀请其他国家来和厂商一同协商适合的硬件产品。联合它们获得更多影响力。

### 国家计算主权之二

国家计算主权（和安全）包括控制计算机做国家的事情。这需要避免“替代软件的服务”（Service as a Software Substitute）[^gov-3]——除非这类服务是运行在国家机关的同一分支机构，以及其他降低国家对计算资源控制的实用形式。因此：

- **国家必须控制其计算机**

  每一台国家使用的计算机必须从属于政府的同一个要使用它们的分支机构或由此机构租借，而这个政府分支机构必须不能把谁有权物理访问计算机，谁能维护（软件和硬件），或者能够安装什么软件的权力放弃给外人。如果计算机不可移动，那么计算机所在的物理空间必须是国家所有（无论是所有者或者承租人）。

### 对开发的影响

国家政策会影响自由和非自由软件的开发：

- **鼓励自由**

  国家需要鼓励开发者创立或完善自由软件并将其公开，比如通过减税或其他财政补贴的方式。相反，对非自由软件的开发者则没有此类财政补贴。

- **不要鼓励非自由**

  特别的，专有软件开发者不应该“捐献”软件副本给学校，并根据软件的售价申请减税优惠。专有软件在学校是不合法的。

### 电子垃圾

自由不应意味着产生更多电子垃圾：

- **可替代性软件**

  很多现在计算机设计为无法用自由软件替代其预装的软件。因此唯一解放它们的方式就是丢掉，而这对社会不利。

  因此，对凡是大量销售、进口或分发硬件接口保密或有意设限的，阻碍用户开发、安装或阻碍用户使用任何可替代内部由制造方升级预装软件的，无论新（即，非二手）计算机或基于计算机的产品都应该是非法的，或者至少课以重税来劝退。这特别适用于任何需要“越狱”方可在其上安装不同操作系统的设备，或包含保密接口外设的设备。

### 技术中立

通过本文中给出的措施，政府可以恢复对其计算过程的控制，并引导国家公民、商业和组织控制自己的计算过程。然而，很多反对意见认为这会违反技术中立的“原则”。

技术中立是指国家不应该在技术选型时强加干涉。无论这是不是有效的原则或是争议，这仅仅只涉及到技术问题。而这里提出来的措施解决的是道义、社会和政治问题，因此超出了*技术*中立的范畴[^gov-4]。除非他们觉得其政府需要在主权和公民自由上保持“中立”。

[^gov-1]: 参见《什么是自由软件？》一文了解自由软件的定义

[^gov-2]: 参见反 DRM 活动网站[http://defectivebydesign.org/what_is_drm](http://defectivebydesign.org/what_is_drm)以及《应避免使用(或慎用)的词语》一文中有关 DRM 的章节了解相关问题。

[^gov-3]: 参见《服务器真正为谁服务？》一文的相关章节，了解 SaaSS。

[^gov-4]: 参见我的文章“Technological Neutrality and Free Software” [http://www.gnu.org/philosophy/technological-neutrality.html](http://www.gnu.org/philosophy/technological-neutrality.html)
