# 自由软件许可证

\newpage
## 许可证简介

> Copyright © 2010 自由软件基金会。由 Brett Smith 和 Richard Stallman 撰写。

这部分包括了最新版的 GNU 主要许可证：GNU 通用公共许可证（GNU GPL），GNU 宽通用公共许可证（LGPL）以及 GNU 自由文档许可证（FDL）。虽然都是法律文书，依然放到本书里是因为这些是自由软件理念的具体呈现形式。

GNU 操作系统的软件开发始于1984年。当时理查德·斯托曼的一部分 GNU 系统组件已经可以发布，它需要一份许可证来保护。当时很多自由软件许可证已经存在，这些给了用户修改和再分发的权限，但同时也允许代码可以用于专有版本和程序。使用这些许可证，GNU 可能无法再向所有用户带去自由，因为中间人可以将 GNU 代码放到专有软件里。

因此斯托曼设计了一款许可证来保证每个用户都有修改和再分发软件的自由。它通过一个关键条件来授予这些权限：无论谁发布软件都必须将修改和再分发的授权传递下去，同时包含源代码以完成这个目标。斯托曼创造了“Copyleft”（参见《什么是 Copyleft?》一文）来表述这个关键转折，即使用法律权利，来保护所有用户的自由。

GNU 的 Copyleft 许可证最初的发行是针对软件，之后拓展到了相关领域比如软件文档。这些将自由软件运动的原则放到了实践领域，也都在本书中有解释。这些许可证的每一次修订都体现了自由软件法律与实际障碍之间的斗争，并体现了自由软件理念是如何变成法律条款的。

### 原始版本的 GPL

第一版 GNU 通用公共许可证发布于 1989 年——然而早在 1985 年，斯托曼就已经在用 copyleft 许可证发布 GNU 工程中的一部分软件了。到 1989 年时，每一个已经发布的 GNU 程序都有其自己的许可证。比如 GNU CC 通用公共许可证，GDB 通用公共许可证等等，而不是统一的 GNU 通用公共许可证。这些许可证除了细微差别几乎一样：比如给用户显示许可证时提示的信息只是不同的程序不同而已，除非只包含一个源文件，且每个程序文件都包含了许可证的名字。

到 1989 年，斯托曼已经在不同 GNU 软件包的许可证上有足够多的经验，因此一个关键问题是将这些许可证集合在一起，以便能覆盖到所有软件包。他与在帕金斯史密斯和科恩律师事务所供职的律师杰里·科恩（Jerry Cohen）一起，将之前所有这些许可证的理念汇集起来，并将之合并成一个许可证。这样 1989 年 2 月 1 日，GNU 通用公共许可证诞生了。

第一版的许可证力求达到两个成果：第一，所有派生软件都可以使用相同许可证，第二，获得该软件的任何人都有机会获得源代码。这就要求实现强而有力的 Copyleft 以避免这三种使程序专有化的方式：版权，最终用户许可协议以及不发布源代码。

与之前特定程序的许可证相比，GPL 第一版有很多实质性变化——GPL是一种进化而不是革命——然而确实有实质性不同。之前，开发者若想发布一个 copyleft 的程序需要修改既有的许可证，许多人都没有这么做。GPL 发布以后，这些开发者有了直接就可以用的许可证，给了所有用户分享和修改软件的自由。这是个强而有力的工具。

### 第二版

1981 年美国最高法院对 Diamond 诉讼 Diehr 一案做出判决之后，美国专利和商标局开始为软件发放专利。软件专利既侵害了自由软件也侵害了专有软件（参见本书第四部分），斯托曼意识到需要将 GNU GPL 里的 copyleft 做大幅修改。

通过选择性地发放专利许可，专利持有人可以随心所欲地控制如何根据它们的软件分发或修改。专利持有人可以给一部分人转售程序的权限，给另一部分人在其公司开放和使用修改版的权限，而给另一部分人符合 GPL 允许的活动。为换取这些权限他们会狮子大开口。他们将权力凌驾于任何想实现这个软件专利的人，无论他们自己是否开发或分发软件。而这个权力会损害自由软件，因为专利持有的第三方可以给自由软件的用户和开发者强制增加限制。

如果一个专利持有者没有分发或修改软件，而一个使用 GPL 这种 copyleft 许可证的软件是不能控制其行为的：他们没有索要任何许可证上的权限。但是专利持有人可以通过在软件许可证中增加限制性条款的方式停止每一个程序发行商的行为。而 GPL 第二版中增加了一个新的许可证章节（第七节），明确说如果要增加新的法律许可——比如专利许可证——与 GPL 条款冲突的话，那么这个许可证必须在软件发行时完全撤销。结果就是，任何想发布和修改软件的人都会获得一份专利许可，而条款必须保证与 GPL 条款完全兼容：这样软件的使用者必须收到相同的条款，没有额外限制，同时也意味着获得源代码。

这一章节力图保护 GPL 软件的完整性。这个许可证的基本原则是希望覆盖从卑微个体到大型企业都有相同的分享和修改软件的权利。那些不分发软件的专利持有者有选择地提出专利许可，会潜在干扰这一目标的实现，虽然将许可条款分开，但他们却认为是合适的。GPL 第二版的第七部分在力图避免这种情况。

### LGPL

在 GNU 工程早期，GPL 许可证在编程工具、实用程序和游戏方面都可以很好地被使用。然而，斯托曼发现以同样的方式发布新开发的 GNU C 库的时候会事与愿违。除了一些扩展，GNU C 库可以看成是 Unix C 库的兼容性替代，因此任何 C 程序都可以与这两个任何一个链接。而如果一个专有的 C 程序不能允许使用 GNU C 库的话，他们就只能去使用 Unix 库。如此严格却没有什么好处。

斯托曼决定通过修改一个 copyleft 许可证让步：既能保护库本身的自由，又不能限制程序使用。这个想法最开始被称为 GNU 库通用公共许可证（GNU Library General Public License），于1991年六月首发 2.0 版。最初的 LGPL 和 GPL 相似，只有一处例外：如果其他人只是以库的形式使用这个该库，那么程序代码的许可证可以按照作者的选择。然而，可执行程序与库结合以后需要同时发布 LGPL 许可证文本和库的源代码，并需要为用户提供一些机制，让用户修改以后的库可以更新可执行程序。

如何让开发者在使用库的时候享受 LGPLv2 的好处呢？若把计算机程序想成执行特定工作的一系列指令：程序与库一起编译或链接就相当于说，“当程序执行到这一点，其他指令可以去库里找，执行完后再回到这里”。在软件开发中，使用库是非常普遍的，这样可以减少的大量重复开发，同时也减少了错误的发生：程序员不需要重复造轮子——也可以减少在此过程中产生的问题。正是因为库的广泛创建和使用，开发者可以很容易地利用 LGPL 的额外权限。

2.0 版许可证的初衷是：在一些情况下，专有软件开发者使用 LGPL 保护库而不是专有库，这样用户就可以自由地去分享和修改库。而这并没有产生“理想”的结果——用户并没有完全控制程序——当然 GPL 也不能达到理想的结果。LGPL 需要保障用户在其他地方没有的自由。

许可证名字里的“库”导致一些自由软件开发者假设所有的库原则上都应该用此许可证，但这不是设立此许可证的初衷——当一个自由的库没有专有竞争者的时候，将其以 GPL 许可证发布会对自由软件有益。为了避免造成的误解，斯托曼将许可证改名为“宽通用公共许可证”，并增加版本到 2.1 表示这只是文本上的小幅修改：许可证增加了一些前言，一小段声明，允许程序通过特定的系统设备以共享库的方式调用库。宽通用公共许可证 2.1 版于1999年2月发布。

### FDL

进入新世纪以后，自由软件的发展比最初还要快；然而文档却没有受到重视。于时斯托曼认为“自由软件需要自由的文档”（参见本书《自由软件需要自由文档》一文）。

诚然软件和文档有一些相似——都是指导实践的作品——但在使用方式上却有很多重要的不同点。GPL 和 LGPL 对手册并不适用。

一段时间以来，GNU 软件包对每个手册一直在使用一个未命名的，简单的，临时性的 copyleft 许可证。因为每一个手册的许可证都不同，这样无法在不同手册之间复制文本。因此斯托曼写了 GNU 自由文档许可证，一个为软件手册和其它实践作品设计的 copyleft 许可证。

FDL 首发于 2000 年3月。而 copyleft 则保持一致：每个收到作品副本的人都可以修改和再发布。FDL 与软件许可证不同的地方在于实现细节：关于如何指明作品的原作者以及提供“源代码”——可编辑的文档——是不同的。

### 第三版

20世纪90年代，因为自由软件的迅速普及，GPL 成为社区首选的清晰的 copyleft 许可证，并应用在了主流的自由软件项目里；然而同时，专有软件开发者想出了在不违反 GPL 的情况下，有效地否定 GPL 所保护的用户的自由的方法。此外还有其他做法，且 GPL 处理起来并不方便。为了处理这种情况，一个新版本的许可证就呼之欲出了。

2002年左右，斯托曼和其他自由软件基金会（Free Software Foundation，以下简称 FSF）成员开始讨论如何更新 GPL，还有 LGPL。FSF 建立了公众复核流程，并与自由软件法律中心（Software Freedom Law Center）的律师合作，尽可能在发布之前解决潜在的问题。社区的顾问委员参考了由公众提交给斯托曼的观点和争论，并决定什么需要采纳。然后他基于律师的建议和意见写了许可证的文本，关于其中的修改解释，可参见本书《为什么升级到 GPLv3》一文。

第三版使用了新的术语来推动使用统一的司法解释，并修改了一些需求以适应自由软件社区新的实践需要。除了这些，这一版还引入很多新条件以加强 copyleft ，从而使自由软件社区成为一个整体。比如：

- 禁用限制用户修改硬件并拒绝用户修改版的发行商（所谓“tivoization”）；

- 允许代码加入有限的额外需求，以兼容一些流行的自由软件许可证；

- 并通过提供清晰的术语加强了对专利的需求来处理跨许可证的专利问题，这在大的专利持有公司是很常见的合约形式。

GPLv3 和 LGPLv3 都包括了解决这些问题的所有方法，并最终在 2007 年 6 月 29 日发布。这些许可证都是 copyleft 艺术的一部分，以后会有更多其他的软件许可证保护用户的自由，并最终达到本书理想中的世界大同。
