\newpage
##  程序不得限制它们的自由运行

> Copyright © 2012 自由软件基金会。此文2012年首发于<http://gnu.org>

自由软件意味着软件被其用户所控制，而不是相反。具体的说，这意味着软件在到达用户手中时，就具有用户应该得到的四大基本自由。列表[^program-1]中的第一条自由是自由之零：按照你的意愿运行程序来做你自己想做的事情。

一些开发者提议在软件许可证中对某些使用加以限制，来禁止程序的某些用途，但这种做法是灾难性的。这篇文章解释了为何不得限制自由之零。限制程序用途的许可条件几乎不能实现它们的目的，而且还可能破坏自由软件社区。

首先，我们要明确自由之零的含义，即软件的分发并不限制你的使用方式。但这并不能使你在法律上免责。例如，诈骗在美国法律中是犯罪行为——我认为这法律是正确且适当的。无论自由软件许可证里写了些什么，你如果使用自由程序行骗并不能保护你不被逮捕。

在诈骗是犯罪的国家，用许可证条款来打击诈骗显然是多余的累赘。但在很多国家，“安全部队”实施的酷刑可是常常被纵容的，为什么不加入一项禁止酷刑的条款呢？

禁止酷刑的条款是不会有用的，因为任何自由软件许可证的实施都是通过国家政权进行的。一个希望实施酷刑的国家将会忽略许可协议。当美国酷刑的收害者试图起诉美国政府时，法院以涉密、威胁国家安全为由驳回了案件。如果一个软件开发者试图起诉美国政府，说他的程序被用来实施酷刑，违反了其许可证，这纸诉状也会被驳回的。通常，国家对它们所做的任何恶毒的事情，总能“聪明”得找到法律上的借口。游说力量强大的企业也能这么做。

那加入一些禁止某些特定私人行为的条款又如何呢？例如，善待动物组织（PETA）提议了禁止使用软件于脊柱，造成动物痛苦的许可证。或者禁止使用某程序制作或发表穆罕默德画像的条款又如何呢？又或者禁止将程序用于胚胎干细胞实验？亦或禁止利用程序未经授权复制音乐录音？

这些条款能否实施是不明确的。自由软件许可协议是基于版权法的，试图以这样的方式施加使用上的限制，延伸了版权法的允许范围，这种延伸是非常危险的。你愿意让书籍限制你使用其信息的方式吗？

那假如条款是合法可实施的，这又会有好处吗？

事实是，人们对于使用软件应当完成的活动有许多不同的道德见解。顺便一说，我认为上述四类不寻常的社会活动是合法且不应当禁止的。具体说，我支持使用软件进行动物医学实验或者加工肉类。我捍卫动物权利活动人士的人权，但我并不支持它们的观点——我也不希望善待动物组织以它们的方式限制软件的使用。

由于我不是和平主义者，我同样反对“非军用”的条款。我谴责侵略战争，但我不谴责反击。事实上，我支持说服多支军队切换到自由软件的努力，以便它们检查危害国家安全的后门和监控特性。

由于我并不反对一切商业，我反对限制商用的条款。一个只能用于娱乐、爱好和学校的系统很大程度上限制了我们通过计算机能做的事情。

我刚才已经表述了我对许多其他政治问题，和某些政治活动是否正当的看法。你自己的观点可能有所不同，而这恰恰准确表明了我的论点。如果我们接受这些带有使用限制的程序作为一个自由操作系统，例如 GNU 的一部分，人们将最终制定出一大堆不同的使用限制。到时候会存在禁止用于肉类加工的程序；仅禁止加工猪肉的程序；仅禁止加工牛肉的程序；仅允许加工“洁净”食物程序。讨厌菠菜的人可能会编写一个允许加工任何蔬菜，除了菠菜的食物；而《大力水手》的粉丝可能只允许程序用来加工菠菜。而只允许说唱音乐的音乐程序也会出现；而其他音乐程序则只允许古典音乐。

这么做的结果是产生一个你不能指望它用于任何目的的系统。你每做一件事情，你就得检查一大堆的许可证来看看系统的什么部分对你的任务各有什么限制。

用户将会怎么回应呢？我想大部分用户将转而使用私有系统。允许在自由软件中对使用方式施加各自限制，总的来说将会驱使用户使用非自由软件。试图利用自由软件中的限制条款来阻止用户做什么，就好比使用一根又长又软又直的意大利面条推动一个物体一样，没有效果。

它甚至比“无效”更加糟糕：它同样是错误的，因为软件开发者不得在用户想做的事情上行使这种权力。想象一下出售一支笔，笔上附有你能够用它来写什么的条款吧。对通用的软件而言也是一样的道理。如果你制造了一样非常有用的物品，例如一支笔，人们将用它做各种各样的事情，包括那些最恶毒的事，例如对异见人士实施酷刑的命令。但你不应该拥有通过笔来控制他们行为的权力。这对于一个文本编辑器、编译器或者内核来说也是同理。

你所拥有的是决定软件能够用来做什么的机会——当你决定实现什么功能的时候。你可以编写一个主要被你认为行为正当的人使用的软件，你也没有任何义务去编写任何可能被别人用于你不认同的行为的功能。

结论是明确的：程序不应当限制用户利用它所完成的工作。自由之零必须完整无缺。我们需要禁止酷刑，但我们不能通过软件许可协议来做到这点。软件许可协议的正确职责是建立与保护用户的自由。

[^program-1]: 参见《什么是自由软件》一文来了解自由软件的完整定义

