\newpage
## 科学必须摆脱版权束缚

> Copyright © 2001, 2012 Richard Stallman。本文最初于 2001 年 6 月 8 日发表于 Nature 杂志的 Web Debates 论坛。

> 很多观点都指向这一结论：软件自由必须是普遍性的，这一结论通常同样适用于其他形式的表达性的工作，尽管是以多种不同的方式。本文专注于讨论将这些软件自由领域相关的原理应用于文献领域的情况。通常地，这些议题与软件自由相正交，但我们仍然决定将与本文类似的几篇文章添加进来，由于诸多对自由软件感兴趣的人们也想获知关于如何才能将这些原理应用于除了软件之外的其他领域的细节。

科学文献存在的理由应当是传播科学知识，并且科学期刊存在的理由应当是促进这一进程，这应该是一种不言自明的真理。由此可以推论，使用这些科学文献的规则应当被设计为有助于实现这一目标。

我们现在所拥有的规则，称之为版权，最初建立于印刷机时代，这是一种从本质上来说相对中心化的印刷量产方式。在这样一种印刷环境下，期刊文章的版权仅仅约束期刊发行者——要求它们获得出版文章的许可——以及潜在的抄袭者。它有助于期刊运营以及传播知识，而并未影响科学家们或者学生们的有用成果，不论对于文章的作者还是读者。这种规则可以很好地适应这种体系。

但是，用于科学文献发表的现代技术是万维网（World Wide Web）。那么，什么样的规则才能确保在网络上传播科学文献和知识的效果最大化呢？文献应当以非私有格式发布，并且对所有人开放访问权限。而且每个人应当有权利为文献提供“镜像”，即在满足适当署名的条件下逐字发表原文。

这些规则应当同样适用于过去与未来的文献，只要它们是以电子形式发布的。但是，现在并不急迫需要改变当前的版权体系，由于它们仍然适合于纸版期刊，此处的问题不属于那个领域。

不幸的是，看起来并非所有人都认可本文开头提出的那种不言自明的理念。很多期刊发行者看起来所坚信的是，科学文献存在的目的是使它们能够出版期刊以便收取科学家们和学生们的订阅费用。这种想法可称为“方法与目的的混淆”。

它们采取的方式是仅仅允许那些能够并且愿意为之付费的人们访问，甚至只是允许他们阅读科学文献。它们以版权法为理由禁止科学家们选择新的规则。尽管版权法对于计算机网络时代有着诸多不妥，它们仍然具有法律效力。

以科研协作与人类未来之名，我们必须从根本上拒绝这种方式——不仅仅是在其上建立起来的阻碍进步的体系，还有那些促成了这些体系形成的错误前提。

期刊出版商有时宣称在线访问需要昂贵并且耗能的服务器，于是它们必须收取订阅访问费用以维持其服务器开销。这个“问题”是其自身的“解决方案”所造成的。如果赋予每个人镜像的自由，世界各地的图书馆将会建立其自己的镜像站点以满足此要求。这种去中心化的解决方案将会减少网络带宽开销并且提供更快速的访问，还能防止学术记录意外丢失。

出版商还会争论它们需要收取订阅访问费用以支付编辑的薪酬。我们姑且接受这一假设，即编辑必须得到薪酬；然而这是本末倒置的。编辑一篇普通论文的成本大约是产出它们的科研项目经费支出的 1% 到 3%。这样小的支出比例很难使得以此为理由阻碍对其结果的使用的行为合理化。

与之相反，编辑的成本可以通过诸如按版面向作者收费的方式得到补偿，作者则可以从科研项目赞助者那里得到补偿。赞助者应当不会介意，即使它们当前不得不以一种繁杂的方式支付论文发表费用，例如通过大学图书馆订阅期刊产生的间接费用。通过改为向科研赞助者征收编辑费用，我们可以消除以此支持限制访问的表面理由。对于作者不属于某一科研机构或公司，以及作者没有科研赞助的少数情形，可免除其版面费用，这部分成本改为向附属于科研机构的作者征收。

另一种支持征收在线出版物访问费用的理由是需要资金支持以便将期刊的印刷归档转换为在线形式。这项工作需要完成，但我们需要寻找其他的资金支持方式，使其不会造成阻碍访问的结果。这项工作本身将不再是困难并且耗资巨大的。将印刷归档数字化但又通过限制访问使其成果被浪费，这种做法是自相矛盾的。

美国宪法宣称版权存在的理由是“促进科学进步”。而当版权阻碍了科学进步的时候，科学必须摆脱版权的束缚。

### 后期的发展

某些大学——例如麻省理工学院（MIT）[^push-1]——已经采纳了某些政策以限制出版者的权力。然而，更加强有力的政策是必需的，就像 MIT 允许个人作者“退出”（屈服）。

美国政府对某些受资金支持的科研项目提出了称为“公共访问”的要求。这要求在一定时期内的出版物发表在某个允许任何人查看论文的网站上。这种要求是积极的一步，但并不足够，由于它并不包含再分发该论文的自由。

有趣的是，2002 年布达佩斯开放存取倡议（BOAI）所提出的“开放访问”确实包含了再分发的自由。我还是签署了该声明，尽管我对“开放”一词极其厌恶，但其立场是正确的。

然而，关于“开放”一词还有一个笑话。具有影响力的“开放访问”运动的支持者后来在其目标中放弃了再分发的自由。我站在 BOAI[^push-2] 的立场上，但现在“开放访问”已经是其他意思了。我将其称为“可再分发出版物”或“自由镜像出版物”。

[^push-1]: “MIT Faculty Open Access Policy,” 于 2009 年三月 18 日经教学科研人员无记名投票通过。[http://libraries.mit.edu/scholarly/mit-open-access/open-access-at-mit/mit-open-access-policy/](http://libraries.mit.edu/scholarly/mit-open-access/open-access-at-mit/mit-open-access-policy/). 

[^push-2]: 参见 <http://www.budapestopenaccessinitiative.org/> 以获知 BOAI 指导思想。 

