\newpage
## 为何升级到 GPLv3

> Copyright © 2007, 2009 理查德·斯托曼（Richard Stallman）本文首发于2007年在 <http://gnu.org>。

GNU 通用公共许可证（GNU GPL）第三版已经发布，使得自由的软件包可以从 GPL 第二版升级到第三版。本文章阐述了升级许可证的必要性。

首先要说明重要的一点，是否升级许可证完全是一个选择上的考虑。GPL 第二版依然会是一份有效的许可证，就算一些程序依然留守 GPLv2 而另一些升级到 GPLv3，也完全不是什么灾难。这两份协议固然是不兼容的，但这并不是根本性的问题。

当我们说 GPLv2 和 GPLv3 不兼容时，我们的意思是指没有合法的方法将 GPLv2 发布的代码与 GPLv3 发布的代码合并到同一个程序中。这是由于两份许可证都是 copyleft 许可证，都各自要求“如果你将以本协议发布的代码合并到一个更大的程序中，那么这个程序也必须遵守该许可。”因此使它们兼容是不可能的。我们固然可以在 GPLv3 许可证中加入一项兼容 GPLv2 的豁免条款，但这是没有用的，因为 GPLv2 也需要一项类似条款。

幸运的是，许可证兼容性问题仅仅在你希望链接、合并或组合两个不同程序的代码到一起时才是问题。在操作系统中 GPLv2 与 GPLv3 的程序共存是没有任何问题的。例如，TeX 许可证与 Apache 许可证都和 GPLv2 不兼容，但是这并不能阻止我们把它们与 Linux、Bash 和 GCC 共同运行在系统中。这是因为它们都是独立的程序，同理，如果 Bash 和 GCC 升级到了 GPLv3 但 Linux 依然使用 GPLv2，也不会有任何冲突。

将程序保留 GPLv2 的许可不会创造新的问题。迁移到 GPLv3 的理由是，GPLv3 解决了目前现有的问题。

GPLv3 能够阻止的一大危险就是“机顶盒化”（Tivoization，译者注：Tivo 是美国一大有线电视机顶盒产品），机顶盒化的意思是，某些“电器”（带有计算机在内）包含了以 GPL 许可证发布的软件，但你实际上却不可能修改它们，因为一旦设备发现了任何软件修改，就会自动关机。通常，厂商进行“机顶盒化”行为的动机是：厂商知道其软件可以被人们修改，因此力图避免这样的修改。这些设备厂商享受了自由软件带来的自由，却不允许你也这样做。

有些人认为，自由市场中不同电器的自由竞争能够使这种恶心的特性尽可能的少。单靠竞争大概也确实能够避免像“每周二下午1点到5点强制关机”这样的反特性出现，但即使这样，主人的选择依然不是自由的。自由意味着*你自己*控制你软件的所作所为，而不仅仅是你能祈求或者威胁那个替你做出决定的人。

在那些被数字限制管理（DRM）——一个用来限制你使用自己电脑中数据的恶心功能——所控制的关键领域，市场竞争毫无作用，因为相关的竞争是被禁止的：《千年数字版权法案》（DMCA）和类似的法律下，在美国和许多国家，发布 DVD 播放器是非法的，除非播放器遵守由 DVD 利益团体制定的规则去限制用户（它们的网站是<http://www.dvdcca.org/>，但那些规则却似乎没有刊登其上）。公众们没有办法购买没有 DRM 的播放器将 DRM 拒之门外，因为市场上根本就没有啊。无论有多少产品可供你选择，它们都带有相同的数字手铐。

GPLv3 则确保你具有去除这些手铐的自由。它本身并没有禁止 DRM 或者任何类似的特性。它没有对你可以加入到程序中的实质性功能做任何的限制，同样也没有限制你删除这些功能。也就是说，发行商有权利加入这些恶心的功能，你也有权利去除这些功能。而“机顶盒化”则是厂商拒绝你自由的方式，而为了保护你的自由，GPLv3 禁止了“机顶盒化”。

对“机顶盒化”的取缔包括了消费者所能购买到的任何产品，即使是不常见的产品。GPLv3 仅仅在产品几乎完全被企业和机构独占时才对“机顶盒化”网开一面。

GPLv3 所能抵御的另一个威胁就是像 Novell 和 Microsoft 这样的专利交易。微软希望通过它的数千项专利，被迫用户为获得运行 GNU/Linux 的特权而交费，而签订了这样一份协议来实现这个目标。这笔交易给 Novell 的消费者在微软的专利面前提供了相当有限的保护。

然而微软在与 Novell 的交易中犯了一些错误，而 GPLv3 旨在利用它们反击微软，排除这种对整个社区相当有限的专利保护。为了得益于这个保护措施，程序需要使用 GPLv3。

微软的律师们当然也不是傻子，它们下次的时候肯定会设法避免错误。因此，GPLv3 中也明确表示，他们没有“下次”了。将程序以 GPL 第三版发布，将保护发行商免于微软向最终用户的程序征收专利费。

GPLv3 同样提供了明确的专利保护，让用户免受程序的贡献者与分发者的侵扰。在GPLv2 中仅仅规定用户可以从公司获得一份程序拷贝，或者分发程序拷贝而免于起诉，专利保护仅仅是隐含在其中的。

然而，GPLv3 中的专利保护并没有我们希望的那么强力。在理想的状态下，我们当然希望任何分发 GPL 许可软件的人，和不使用 GPL 许可证份发软件的人，都放弃他们全部的软件专利，因为软件专利根本就不应该存在。软件专利的体制是恶毒的、荒谬的，将所有软件开发者都置于被一个闻所未闻的公司起诉的危险之下，更别说那些大型集团了。大型程序往往包含了成百上千的思想，因此这些思想被上百个专利所涵盖就不足为奇了。大型集团公司收集这些成千上万的专利，然后利用它们欺压中小开发者。专利已经对自由软件的发展形成了阻碍。

使软件开发变得安全的唯一方式就是废除软件专利，而我们希望在未来的某一天实现。然而，我们不能够通过一份软件许可证就能做到这一点。任何程序，无论自由与否，都能够被八杆子打不着的一个人手中的专利杀死，而这是程序的许可协议本身所不能避免的。唯一能够使软件开发免于专利威胁的，只有法院的一纸判决，或者专利法律的修订。如果我们试图靠 GPLv3 来做到这点，这必然是会失败的。

因此，GPLv3 力求限制与“疏导”危险，更具体的说，就是我们试图将自由软件从比死亡更加悲惨的命运中拯救，避免自由软件通过专利都变为了事实上的私有软件。GPLv3 中明确的专利协议确保了使用 GPL 的公司能给予用户四大自由，而不能通过专利来改变这点，对用户说“自由不属于你”。这同时也避免了勾结其他专利持有人做这种事情的可能性。

GPLv3 的更多优点包括了更好的国际化、更温和的权利终止、对 BitTorrent 的支持，以及对 Apache 许可证的兼容。所有的这一切都是升级的众多理由。

变化，在 GPLv3 发布之后显然是不会停止的。如果产生了对用户的危险，我们将研发 GPL 第四版。因此，假如我们写好了 GPLv4，确保程序能顺利升级显然就很重要了。

做到这一切的方式之一就是将程序以“GPL 第三版或任何更新的版本”发布；另一个方法是让项目所有的贡献者指定一位可以解决是否升级 GPL 版本的代理人；而第三种方式则是让所有的贡献者将各自的版权统一移交给一位版权持有人，这位版权持有人将负责升级协议版本。无论采用何种方式，程序应当能灵活升级到未来的 GPL 版本。

