\newpage
## 关于出售例外对GNU GPL的影响

> Copyright © 2009, 2010 理查德·斯托曼（Richard Stallman）

> 当我参与联合签署知识生态国际（Knowledge Ecology International）发起的公开信，警告 Oracle 收购 MySQL（加上 Sun 公司剩下的部分）可能不利于 MySQL 的时候，出售许可证例外便成为了一个热门话题。
>
> 就像以下文章解释的那样，我对出售许可证例外的感觉是混杂的。明显的是，不出售例外在 GNU GPL 下开发强大而复杂的软件包是可能的，我们在做这个。MySQL 也可以这样的方式开发。然而，MySQL 开发者已经用到出售例外的做法了。谁应该决定是否继续这样做呢？我认为把关于一个自由软件项目的主要决定交给一个大型私有竞争者是不明智的，它会自然地使项目缩减，而不是更多地开发。
>
> 一件不合理的事情是更改 MySQL 的许可证到某种非 copyleft 许可证的想法。那样会消除出售例外的可能，但允许所有种类的私有修改版本。无论MySQL应该走到哪里，都不应选择非 copyleft 许可证。

当我共同签署了反对 Oracle 计划好的 MySQL 收购[^sellex-1]（还有Sun公司剩下的部分）的信件的时候，一些自由软件支持者很惊讶我会赞成 MySQL 开发者用过的出售许可证例外的行为。他们期望我完全地谴责这种行为。这篇文章解释了我对这种行为的想法，以及原因。

出售例外的意思是代码的版权所有者以自由软件许可证将代码发布至公众，然后让顾客为在不同条款下使用同样代码的许可付款，例如允许它包括在私有应用里面。

我们必须把出售例外的做法和另一件至关重要的不同事情区分开：一个自由程序的完全私有的扩展或版本。这两种行动，即使是同时被一个公司所实行，都是不同的问题。在出售例外中，例外所用于的相同代码是以自由软件的形式对公众可用的。只在私有许可证下的一个扩展或者修改后的版本是完全的私有软件，并且不会优于任何其他私有软件。这篇文章关心的是严格地并且只涉及例外出售的情形。

我从20世纪90年代开始就认为出售例外是可以接受的，并且有时我已经对公司建议过。有时这种做法已经让重要的程序成为自由软件成为可能。

KDE 桌面在90年代基于 Qt 库开发。Qt 那时是私有软件，并且 TrollTech 公司对把它嵌入在私有应用中的许可收费。TrollTech 允许 Qt 在自由应用中免费使用，但这不会让它成为自由软件。因此完全自由的操作系统不会包括 Qt，所以它们也不能用 KDE.

1998年，TrollTech 的管理层认识到他们可以让 Qt 成为自由软件并且继续对把它嵌入在私有软件中的许可收费。我不记得这个建议是不是从我来的，但看到了这个改变我当然高兴，它让在自由软件世界中使用 Qt 和 KDE 成为可能。

开始的时候，他们用自己的许可证，Q 公共许可证（QPL）——就自由软件许可证来说是很有限制性的，并且和 GNU GPL 不兼容。之后，他们转到了 GNU GPL；我想我已经给他们解释了这可以为这种目的起作用。

出售例外从根本上依赖于为自由软件的发布使用一个 copyleft 许可证，如 GNU GPL. 一个 copyleft 许可证允许嵌入一个更大的程序仅当整个合并后的程序是以那个许可证发布的；这是它确保扩展版本也自由的做法。因此，想让合并后的程序私有化的用户需要特殊的许可。只有版权所有者可以授予那个许可，而出售例外就是这样做的一种方式。其他人，在 GNU GPL 或者另一个 copyleft 许可证下收到代码的，不能授予例外。

当我第一次听说出售例外的做法时，我问自己这种行为是否符合伦理。如果某人买一个例外来把一个程序嵌入一个更大的私有程序，他正在做错误的事情（换句话说，制作私有软件）。是否出售例外的开发者也在做错误的事情呢？

如果那个含义是有效的，那么它也能用于发布同样软件于非 copyleft 自由许可证下的行为，如 X11 许可证，那也允许了这样的嵌入。所以我们要么不得不得出结论，以 X11 许可证发布任何东西都是错误的，或者拒绝这种含义。使用一个非 copyleft 许可证是不好的，并且通常是一个次等的选择，但它不是错误的。

换句话说，出售例外允许私有软件中有限地嵌入代码，但 X11 许可证走得更远，允许无限制地在私有软件中使用代码（及其修改后的版本）。如果这不让 X11 许可证不可接受，那么它不能让出售例外不可接受。

FSF 不实行出售例外有三个原因。一个是它不会通往 FSF 的目标：确保我们软件的每个用户是自由的。那是我们写 GNU GPL 的目的，最彻底地实现这个的方法就是在GPL版本3或后续版本下发布，并且不允许嵌入于私有软件。出售例外不能实现这个，就像在X11许可证下发布不能做到一样。所以正常我们不会做那两种事情。我们只在GPL下发布。

我们只在 GPL 下发布的另一个原因是为了不允许在我们自由程序上出现会呈现实用优势的私有扩展。不把自由看作价值的用户可能会选择那些非自由的版本，而不是它们所基于的自由的版本——从而失去他们的自由。我们不想鼓励那种情况。

但会有偶然的情况，为了特定的战略原因，我们判定在一个特定的程序用更宽松的许可证对自由的事业更为有利。在那些情形，我们在那个宽松许可证下给每个人发布这个程序。

这是因为另一个 FSF 跟随的伦理准则：无差别地对待所有用户。为了自由的理想主义运动不应当歧视，所以 FSF 致力于给所有用户同样的许可证。FSF 从来不出售例外；无论我们以什么许可证发布一个程序，它都是所有人能够获得的。

但我们不需要坚持公司们遵循那条原则。对于公司我认为出售例外是可以接受的，并且我会在合适的时候建议这样做，作为让程序自由化的一种方式。

[^sellex-1]: James Love and Malini Aisola (Knowledge Ecology International), Richard Stallman (FSF), Jim Killock (Open Rights Group), letter to Neelie Kroes (Commissioner for Competition, European Commission), 19 October 2009, <http://keionline.org/sites/default/files/ec_letter_mysql_oct19.pdf>.

