# 软件专利：对程序员的威胁

\newpage
## 软件专利和文学专利

>Copyright © 2005, 2007, 2008 Richard Stallman 本文最初于 2005 年 6 月 23 日以标题“Patent Absurdity”发表于英国卫报，并且针对当时被提出的“欧洲软件专利指导意见”。

当政治家们考虑软件专利的问题的时候，他们通常会盲目地进行表决；由于他们不是程序员，他们并不了解软件专利真正在做什么。他们通常认为专利法与版权法类似（“除了少数细节以外”）——然而事实并非如此。例如，当我公开询问法国工业部长 Patrick Devedjian 关于法国将如何针对软件专利问题进行表决的时候，Devedjian 用一段对版权法的充满激情的辩护作为回应，并且盛赞维克多•雨果为了使版权这一概念为人类所接纳所做出的贡献。（“知识产权”这一带有误导性的短语加深了这种混淆——这是它永远不应该被使用的原因之一）。

那些认为软件专利将会产生与版权法类似效果的人们未能抓住并认清软件专利所可能带来的灾难性后果。我们可以以维克多•雨果为例，说明这二者的区别。

一部小说和一个现代化复杂程序具有某些共同点：其一是大型化，以及在实现它的过程中需要将诸多设计思想融会贯通。于是，让我们沿着这个类比，假设专利法已经于 19 世纪被应用于小说；并且假设诸如法国这样的国家允许对文学创意进行专利保护。这将会对维克多•雨果的写作带来怎样的影响？文学专利带来的影响与文学版权带来的影响相比又会如何呢？

考虑维克多•雨果的名著《悲惨世界》。由于他是作者，该书的版权属于他本人。他完全无需担心某些陌生人对他进行侵犯版权诉讼并且胜诉。那是不可能的，由于版权仅仅覆盖一篇作品的作者身份的细节，而非蕴含在作品中的思想创意，并且仅仅限制对作品的抄袭。维克多•雨果并未抄袭《悲惨世界》，所以他不会受到版权的威胁。

专利发挥作用的方式则与之不同。专利将会覆盖想法和灵感；每一项专利都是对实施某种想法的垄断，这是描述在专利本身的内容之中的。以下是一项假想的文学专利案例：

-   要求 1：一种在读者脑海中表达了这样一种概念的交流过程：某一角色在监狱中被监禁了很长时间，由此对社会和人性产生怨恨；

-   要求 2：一种基于要求 1 的交流过程：该角色随后在他人的关怀下得到了道德的救赎；

-   要求 3：一种基于要求 1 和要求 2 的交流过程：该角色在故事发展过程中改名换姓。

如果这样一项专利存在于 1862 年《悲惨世界》发表之时，该著作将会与上述全部三项专利要求相冲突，由于所有这些事情都发生在小说中的冉阿让（Jean Valjean）[^sl-1]一个角色身上。维克多•雨果可能会因此被起诉，而且一旦被起诉，他将会败诉。这部小说可能会被禁止——事实上是被审查了——由专利拥有者。

[^sl-1]: 这里选用了人民文学出版社出版的《悲惨世界》（李丹、方于译）对小说主人公的翻译——冉阿让。《悲惨世界》讲述了主人公冉阿让因偷窃面包而获刑长达十九年，出狱后被米里哀主教救赎，之后他多次改名换姓重获新生，并试图赎罪的故事。小说人物丰富，时间跨度大，涵盖拿破仑战争和1832年巴黎共和党人起义等政治现象。——译者注

现在考虑这样一项假想的文学专利：

-   要求 1：一种在读者脑海中表达了这样一种概念的交流过程：一位角色在监狱中被监禁了很长时间，并且随后改名换姓。

《悲惨世界》同样会被这项文学专利禁止，由于这一描述同样适用于冉阿让的人生故事。现在还有这样一项假想的文学专利：

-   要求 1：一种在读者脑海中表达了这样一种概念的交流过程：一位角色得到了道德的救赎并且随后改名换姓。

冉阿让同样会被这项专利所禁止。

所有这三项专利都将覆盖并且禁止这一角色的人生故事。它们相互重叠，但它们又都不是对其他专利的精确复制，因此它们可以共存；三项专利的持有人都可以起诉维克多•雨果，而他们中的任何一位都可以禁止《悲惨世界》。

这项专利同样会被违反：

-   要求 1：一种交流过程表现了这样一位角色，其名字与其姓氏的最后一个音节相同。

这是通过角色的姓名“冉阿让”而产生的，然而至少这项专利是容易回避的。

您可能认为这些想法过于简单，以至于没有任何一家专利机构会去批准它们。我们作为程序员通常也会对于真实的软件专利所覆盖的想法是如此地简单而感到惊讶——例如欧洲版权厅（EPO）批准了一项关于进度条的专利，以及一项接受信用卡支付的专利。这些专利看起来将会显得非常可笑，如果它们并非如此阴险。

《悲惨世界》的其他方面也可能与专利产生冲突。例如，可能有关于对滑铁卢战役进行小说化描写的专利，或是关于在小说中使用巴黎俚语的专利。这将带来两场新的法律诉讼。事实上，并没有关于同时适用于对某一作品诸如《悲惨世界》的作者进行起诉的专利数量的限制，所有那些专利持有人都会宣称他们理应得到奖励，由于他们那些受专利保护的思想和灵感为文学发展所带来的贡献；然而，这些障碍并不能促进文学发展，反而只会阻碍文学的发展。

然而，一项非常宽泛的专利将会使得以上这些问题失去意义。考虑一项带有宽泛要求的专利：

-   一种交流过程，带有连续数页的旁白结构；

-   一种旁白结构，有时类似于赋格曲或者即兴作品；

-   一种围绕特定角色之间的冲突所展开，随后又依次为其他人布下机关的阴谋；

-   一种表现了诸多社会阶层的旁白；

-   一种揭示了隐藏的阴谋的旁白。

谁会是这些专利的持有人？可能是其他小说家，也许是大仲马或者巴尔扎克，由于他们写过这样的小说——但并不一定。要想为软件创意申请专利，其本人不需要进行编程，因此如果我们假想的文学专利符合真实的专利体系，其持有人不需要自己写小说，或者故事，或者任何东西——除了专利申请。那些除了威胁和法律诉讼，没有创造任何东西的专利寄生虫公司、企业正在日渐繁荣。

如果有了这些宽泛的专利，维克多•雨果也许不会走到询问他所使用冉阿让这一角色将会受到哪些专利起诉这一步，由于他根本不会考虑去写这样一部小说。

这种类比可以让非程序员看清软件专利到底在做什么。软件专利覆盖了功能，例如在文字处理器中定义缩写，或是在电子表格中自然顺序的重新计算。专利也覆盖了程序设计所需要使用的算法。专利还覆盖了文件格式的方方面面，例如微软 Office 开放可扩展标记语言（OOXML），而 MPEG 2 视频格式被多达 39 项美国专利所覆盖。

正如一部小说可以同时与许多不同的文学专利相冲突，一个程序也可以同时被许多项软件专利所禁止。想要鉴定所有可能与某个大型程序相关的专利的工作量如此之大，以至于只有一项这样的研究被实施。在 2004 年关于 Linux，即 GNU/Linux 操作系统的内核，的研究发现 283 项不同的美国软件专利可能对其进行覆盖。也就是说，这 283 项专利中的任何一项都可能禁止可以在 Linux 的数千页源代码中的某处找到的计算过程。与此同时，Linux 内核只占整个 GNU/Linux 操作系统的 1%。那么，这样一个系统的发布者又将会受到多少项专利的起诉呢？

要想阻止软件专利对软件发展造成的危害的方法很简单：不要批准它们。这应该是容易做到的，由于大部分专利法都拥有反对软件专利的条款。它们通常会说“软件本身”不能被专利保护。但是，全世界的版权机构正在试图曲解其涵义并且为程序设计中实现的想法和创意提供专利保护。除非我们能够阻止这一趋势，这种趋势将会将所有软件开发者置于险境。
