\newpage
## 服务器真正是在为谁服务？

> Copyright © 2010, 2013, 2015 理查德·斯托曼（Richard Stallman）。本文最初于 2010 年三月 8 日以标题“What Does That Server Really Serve?”发表于 Boston Review 在线版。

**在互联网环境中，私有软件并非剥夺您的自由的唯一方式。“服务作为软件替代品”（Service as a Software Substitute），或者 SaaSS，是另一种赋予其他人支配您的计算的权力的途径。**

SaaSS 指的是使用某种由其他人实现的服务来替代您所运行的软件副本。这是我们创造的短语，文章和广告并不会使用它，它们也不会告知您某种服务是否为 SaaSS。与之相反，它们很可能蔽之以一种含混不清并且旨在转移您的注意力的短语：云。这将 SaaSS 与其他实现，不论是恶意的还是有益的，混为一谈。不过，看了本文的解释和示例之后，您将能够区分某种服务是否为 SaaSS。

### 背景知识：私有软件是如何剥夺您的自由的

数字技术可以赋予您自由，也可以剥夺您的自由。对于我们掌控自己计算的首要威胁来自*私有软件*：私有软件是用户所不能控制的，由于它受其拥有者（例如苹果或微软这样的商业公司）控制。其拥有者通常利用这种不公的权力向其中植入恶意功能，诸如间谍软件、后门、数字限制管理（DRM，它们将其鼓吹为数字版权管理）[^server-1]。

> 如需获得关于此问题的更多信息，参见“The Bug Nobody Is Allowed to Understand,”一文，它位于 <http://gnu.org/philosophy/bug-nobody-allowed-to-understand.html>。

我们针对这个问题的解决方案是开发*自由软件*并且拒绝私有软件。自由软件意味着您作为用户拥有四项基本自由：（0）以任何目的运行该软件的自由；（1）研究和修改源代码使其以您所期望的方式工作的自由；（2）再发布相同副本的自由；（3）再发布您的修改版本的自由（参见《什么是自由软件？》一文中有关自由软件定义）。

只要有了自由软件，我们作为用户就能夺回我们计算的控制权。私有软件仍然存在，但我们可以将其排除在生活之外，并且我们中的很多人已经在这么做。然而现在，我们对自己的计算的控制权面临新的威胁：服务作为软件的替代品（SaaSS）。为了捍卫我们的自由，我们必须像拒绝私有软件那样拒绝 SaaSS。

### 服务作为软件替代品是如何剥夺您的自由的

服务作为软件替代品（SaaSS）指的是使用某种服务作为运行您的软件副本的替代品。具体地说，它指的是由某人架设一台网络服务器以实现某种计算任务——例如，修改一幅照片，或者将文本翻译为另一种语言等——然后邀请用户通过那台服务器进行计算。服务器的用户会将其本人的数据上传至服务器，后者对用户所上传的数据进行*用户自己的计算*，再将计算结果返回用户，或者直接以用户的名义做什么事情。

假设满足这样的条件，这种计算可以称之为*用户自己的*，即用户原则上能够在其本人的计算机上通过运行某软件可以达到相同的目的（不论当时能够达到此目的的软件对于用户是否可获得）。当这种假设不成立时，这就不是 SaaSS。

这些服务器比私有软件更加残酷地剥夺用户对其计算的控制权。对于私有软件，用户一般会得到一份可执行文件而非源代码。这使得用户难以研究其所运行的代码，因而难以判定此程序真正在做什么，并且难以对其进行修改。

对于 SaaSS，用户连用于计算的可执行文件都得不到：它位于某些其他人的服务器上，用户不能企及。因此用户完全不可能确认它们到底在做什么，也完全不可能对其进行修改。

进一步讲，SaaSS 将会自然而然地引起与某些私有软件中的恶意功能相当的结果。

例如，一些私有软件是“间谍软件”：它们将会发送与用户的计算活动相关的数据[^server-2]。微软 Windows 向微软发送用户活动相关信息。微软 Windows 媒体播放器（Windows Media Player）向微软汇报每位用户播放过的内容。亚马逊 Kindle 汇报用户于何时阅读哪本书的第几页。愤怒的小鸟（Angry Birds）将会汇报用户地理位置的历史记录。

与私有软件不同的是，SaaSS 并不依赖隐秘的代码以获取用户数据。而是用户被强制要求将其数据上传到服务器以便使用 SaaSS。这与间谍软件具有相同的效果：服务器运营商可以不费吹灰之力得到用户数据——正因为 SaaSS 的天性。Amy Webb 曾经刻意避免发布她女儿的任何照片，但她犯了使用 SaaSS（Instagram）的错误，用它来编辑自己的照片。这些照片最终通过这条途径泄露[^server-3]。

一些私有操作系统拥有通用的后门，允许某人远程进行软件更改。例如，微软可以通过 Windows 的通用后门强制更改用户计算机上的软件。此类后门也存在于几乎所有的移动电话中。一些私有应用程序也拥有通用后门，例如 Steam 的 GNU/Linux 客户端允许其开发者远程安装修改版本。

对于 SaaSS，服务器的运营商可以更改服务器上所用的软件。他应该可以这么做，因为那是他自己的计算机；然而，使用这样的 SaaSS 与使用带有通用后门的私有应用程序，在结果上并无区别：某人拥有偷偷改变如何完成用户计算的权利。

因此，使用 SaaSS 相当于使用带有间谍软件和通用后门的私有应用程序，这赋予了其服务器运营商凌驾于用户之上的不公权力，这种权力是我们必须坚决反对的。

### SaaSS 和 SaaS

最初，我们将这种有问题的实践称为“SaaS”，意为 Software as a Service（软件即服务）。这个短语通常用于指代在服务器上部署软件而非向其用户提供副本。我们当时认为，在这些问题发生时，这一短语对实际情况做出了精确描述。

然后，我们开始意识到，短语 SaaS 有时用于通讯服务——而这一名称并不适用于这些活动。此外，短语“软件即服务”并不能解释为何这是一种坏的实践，于是我们打造了这一短语“服务作为软件替代品”，这一称谓对这种坏的实践给出了更为清晰的定义，并且解释了它*为什么*是坏的。

### 理清 SaaSS 带来的问题和私有软件带来的问题

SaaSS 和私有软件将会带来相似的后果，但二者的作用机制并不相同。对于私有软件，其机制是您拥有一份副本，但对其进行修改是困难或者非法的。而对于 SaaSS，其机制是您不能拥有一份您所用于计算的软件副本。

这两类问题通常被混淆，而混淆不仅仅是一种偶然。网络开发者使用含混不清的短语“网页应用”将服务器软件和您在计算机浏览器中运行的程序混为一谈。一些网页会在您的浏览器中安装非平凡甚至是大型的 JavaScript 程序而不会告知您。如果这些 JavaScript 程序是私有的[^server-4]，它们将会造成与任何其他私有软件类似的不公。然而，我们在此将会主要讨论使用服务本身带来的问题。

很多自由软件支持者设想：SaaSS 带来的问题将可以通过开发自由的服务器软件来解决。对于服务器运营商而言，其服务器上的软件最好是自由的；否则如果它们是私有的，其拥有者便可拥有控制服务器的权力。这对于服务器运营商是不公的，并且根本不会使用户受益。但是，即使服务器上运行的软件是自由的，这也不能保护*服务器的用户*免受 SaaSS 的影响。这些软件赋予了服务器运营商自由，但却不能赋予服务器用户自由。

公开发布服务器软件的源代码确实会使社区受益：这使得具有适当技能的用户能够架设类似的服务器，也许还能更改软件本身。我们建议对通常在服务器上运行的软件使用 GNU Affero 通用公共许可证（GNU Affero GPL）[^server-5]。

但是，这些服务器都不能使您能够控制由它进行的计算，除非那是*您自己的*服务器。也许，对于某些工作，您可以信任您的朋友的服务器，如同您可能会请求朋友维护您计算机上的软件。对于除此之外的任何情况，这些服务器对您来说都是 SaaSS。SaaSS 总是迫使您屈从于服务器运营商的权力。唯一的解决方式是：*坚决不要使用 SaaSS！*不要使用任何其他人的服务器来进行您自己的计算以处理由您自己提供的数据。

这个问题解释了“开放”和“自由”之间有着多大程度的区别。“开源”概念中的源代码几乎都是自由的[^server-6]。但是“开源软件”服务[^server-7]的理念并不能解决 SaaSS 的问题，由于它只意味着这种服务所依赖的服务器软件是开源的，并且/或者是自由的。

服务与软件有着本质区别，因而由服务引起的伦理问题与那些由软件引起的问题有着本质区别。为了避免这种混淆，我们避免将一项服务描述为“自由”或“私有”的[^server-8]。

### 区分 SaaSS 和其他网络服务

哪些在线服务是 SaaSS？最清楚的例子是翻译服务，例如将英文文本翻译为西班牙文。为您翻译一段文本是一种完全属于您自己的计算。您可以在您自己的计算机上运行相应软件进行翻译（为了符合伦理，这款软件应该是自由的）。翻译服务替代了那款程序，因此它是一种服务作为软件替代品，即 SaaSS。由于它拒绝您对您的计算的控制权，它对您作了恶。

另一个清楚的例子是使用诸如 Flickr 或者 Instagram 来修改照片。人们在自己的计算机上修改照片已有几十年时间了；在服务器而非您自己的计算机上进行这些工作是一种 SaaSS。

拒绝 SaaSS 并不意味着必须拒绝使用任何由他人而非您所运行的网络服务器。大部分服务器并非 SaaSS，由于它们所进行计算并非用户自己的计算。

设立网络服务器的初衷并非为您做计算，而是发布信息以供您访问。即使在今天，这也是大部分网站正在做的，这并不会带来 SaaSS 的问题，由于访问由某人发布的信息并非是在做您自己的计算。通过博客网站或者诸如 Twitter 或 StatusNet 等微博服务发布您的个人材料也都不是（当然，这些服务可能会有其他问题）。其他并非有意成为私密的通讯，例如群聊，也是如此。

从本质上说，社交网络是一种形式的通讯和信息发布，并非 SaaSS。然而，一项以社交网络为主要功能的服务可能拥有属于 SaaSS 的特性或扩展。

如果一项服务不属于 SaaSS，并不意味着它就是没有问题的。服务可能存在其他伦理问题。例如，Facebook 以 Flash 格式发布视频，这将迫使用户运行私有软件；它要求运行私有 JavaScript 代码；它给用户一种关于隐私的错误印象，同时引诱用户在 Facebook 上暴露他们的生活。那些都是重要的问题，但不属于 SaaSS 的问题。

诸如搜索引擎的服务会从网络上搜集数据以供您检索。浏览它们所收集的数据在通常意义上并不属于您自己的计算——由于您并不提供那些数据——因此使用这样的服务检索互联网并非 SaaSS。然而，使用他人的服务器来实现用于您自己网站的搜索工具*是*一种 SaaSS。

在线购物不是 SaaSS，由于这种计算不是*您自己的*；相反，这是由您和卖家为了共同的目的而共同实现的。在线购物的真正问题是您能否将您的钱财和其他个人信息（首当其冲的是您的名字）托付给对方。

仓库网站诸如 Savannah 或 SourceForge 本质上不是 SaaSS，由于它们的职责是发布那些提供给它的数据。

使用联合项目的服务器不是 SaaSS，由于您以这种方式所做的计算不是您自己的。例如，如果您编辑 Wikipedia 上的页面，您并非在进行您自己的计算；与之相反，您正在参与 Wikipedia 的计算。Wikipedia 控制其自己的服务器，但是如果任何个人或组织使用他人的服务器进行他们自己的计算，他们将会遇到 SaaSS 问题。

有些网站提供多种服务，如果其中之一不是 SaaSS，其他服务有可能是 SaaSS。例如，Facebook 的主要服务是社交网络，那不是 SaaSS；然而，它提供了第三方应用，其中的某些是 SaaSS。Flickr 的主要服务是发布照片，这不是 SaaSS，但它也会提供照片编辑功能，这就是 SaaSS。类似地，使用 Instagram 发布这些照片并非 SaaSS，但使用它转换照片则是。

Google Docs 向我们展示要评估单一服务到底可以有多么复杂。它邀请用户通过运行大量私有 JavaScript 程序[^server-9]以编辑文档，这无疑是坏的。然而，它还提供了用于标准格式上传或下载文档的应用程序接口（API）。自由的文档编辑器可以通过这个 API 工作，这种应用场景不是 SaaSS，由于它仅仅把 Google Docs 用作仓库。将您的所有数据展示给一家商业公司不是好事，但这属于隐私范畴，而非 SaaSS；依赖这样的服务来访问您的数据不是好事，但这属于风险范畴，而非 SaaSS。另一方面，使用这种服务转换文档格式*是*一种 SaaSS，因为您可以通过在您的计算机上运行适当的软件（最好是自由的）来实现这一目的。

当然，通过自由的文档编辑器使用 Google Docs 的情形并不常见。更为常见的情形是，人们通过私有 JavaScript 程序使用它，这类私有 JavaScript 程序和任何其他私有软件一样坏。而这种应用场景也可能涉及 SaaSS；这取决于文档编辑工作的哪些部分由 JavaScript 程序完成而哪些部分由服务器完成。我们并不清楚这个问题的答案，但既然 SaaSS 和私有软件都以相似的方式对用户作恶，我们并不急迫地想知道这个问题的答案。

通过他人的仓库发布信息并不会引起隐私泄露的问题，但是通过 Google Docs 发布则会遇到一个特别的问题：如果不借助运行私有 JavaScript 代码，甚至不可能在浏览器中*显示一段 Google Docs 中的文本*。因此，您应该避免使用 Google Docs 发布任何信息——然而其原因不属于 SaaSS 范畴。

信息技术（IT）业界试图阻止用户作出这样的区分，这正是他们用行话“云计算”来表达的用意所在。这个短语是那么地空泛，以至于它可以指代有关互联网的几乎所有应用。它包括了 SaaSS 以及许多其他网络应用实践。在任何给定的上下文语境中，一位作者（如果是一位技术工作者）在写出“云”这个词的时候，他的脑海中可能确实有一种确切的涵义，但通常并不会指出这个词在其他文章中可能具有的其他确切的涵义。这个短语将会诱导用户将那些他们本来应该分开单独考虑的实践概念一般化。

如果“云计算”确实有一种涵义，这种涵义并不是指一种进行计算的方式，与之相反，它应该指的是一种对计算的思考方式：一种不顾一切的极端思考方式可能会主张：“什么也不要问；不要关心谁控制您的计算，也不要关心谁掌控您的数据；在像鱼饵一样吞下我们的服务之前也不要去检查里面是否藏着鱼钩……什么都不要犹豫，只要信任我们的商业公司就好。”换言之，就是“做一个没有独立思想的傀儡任人摆布”。思想中的阴云是进行清晰思考的障碍。为了能够理清关于计算的思考，必须避免使用“云”这个概念。

### 应对 SaaSS 所带来的问题

只有少数的网站提供 SaaSS；大部分并不会带来这样的问题。但是，对于那些带来了 SaaSS 问题的网站，我们又该如何应对？

对于简单的情形，如果您使用您的双手进行您的计算，解决方案很简单：使用您自己的自由软件副本。例如编辑文本时，使用您自己的自由文本编辑器，比如 GNU Emacs，或者自由的文字处理器的副本。编辑照片时，使用您自己的自由软件的副本，比如 GIMP。如果没有可用的自由软件又当如何呢？由于私有软件和 SaaSS 都会剥夺您的自由，您不应当使用它们。您可以贡献您的时间或钱财来支持开发自由软件替代品。

与他人一起作为一个小组进行协作的情况又如何呢？直到现在，不借助服务器可能难以实现这一目的，并且您的用户组可能不知道如何架设自己的服务器。如果您使用他人的服务器，至少不要信任由商业公司运营的服务器。对于消费者而言，仅凭一纸合同并不能带来任何保护，除非您能够抓住其中的漏洞并且真正能够进行诉讼。即使如此，商业公司很可能在其编写的合同条款中允许其在较宽的范围内恣意妄为。国家可以从商业公司那里传唤您和任何其他人的数据，如同奥巴马对通讯公司所做的，假如那些公司不像之前那些为布什实施非法监听其客户的美国通讯公司那样主动就范。因此，如果您不得不使用服务器，选择那些运营商能够给予您基本信任而非仅仅是一层商业关系的服务器。

然而，在长远的时间尺度上，我们可以开发出替代服务器的解决方案。例如，我们可以开发一种端对端的程序使得协作者可以分享加密数据。自由软件社区应该试图为关键的“网页应用”开发出端对端的分布式替代品。并且将它们在 GNU Affero GPL 许可证下发布可能是明智的，由于它们可以作为候选者供其他人转换为基于服务器的软件[^server-10]。GNU 计划正在寻找志愿者以开发这些替代品。我们可以邀请其他自由软件项目在它们进行设计时考虑这一问题。

与此同时，如果一家商业公司邀请您使用它的服务器来进行您自己的计算任务，不要屈服；也不要使用 SaaSS。不要购买或安装所谓的“瘦客户机”，它们只不过是厂商为了使您在其服务器上进行真实工作而提供的低性能计算机，除非您将会在*您自己的*服务器上使用它们。使用一台真实的计算机来工作并且保存您的数据。使用您自己的自由软件副本来进行您自己的计算，这是为了您的自由。

 [^server-1]: 请加入我们的运动一起反对 DRM，它位于[DefectiveByDesign.org](DefectiveByDesign.org)。 

 [^server-2]: 如需获知监控正在通过哪些日益增加的方式在业界蔓延，参见 <http://gnu.org/philosophy/proprietary/proprietary-surveillance.html>。

 [^server-3]: Amy Webb, “Congratulations, You Found a Photo of My Daughter Online,” 12 September 2013, [http://slate.com/articles/technology/data_mine_1/2013/09/privacy_facebook_kids_don_t_post_photos_of_your_kids_on_social_media.html](http://slate.com/articles/technology/data_mine_1/2013/09/privacy_facebook_kids_don_t_post_photos_of_your_kids_on_social_media.html). 

 [^server-4]: 参见《JavaScript 陷阱》一文以获得更多信息。 

 [^server-5]: 参见《如何为你自己的作品选择一份许可证》一文以获得我们关于许可证选择的建议。

 [^server-6]: 参见 “How Free Software and Open Source Relate as Categories of Programs,”<http://gnu.org/philosophy/free-open-overlap.html> 一文以获得更多信息。 

 [^server-7]: 如需获知 “Open Software Service Definition,” 参见 <http://opendefinition.org/ossd/index.html> 一文。 

 [^server-8]: 如需获得更多信息，参见我的文章 “Network Services Aren’t Free or Nonfree; They Raise Other Issues,” 位于 [http://gnu.org/philosophy/network-services-arent-free-or-nonfree.html](http://gnu.org/philosophy/network-services-arent-free-or-nonfree.html)。

 [^server-9]: 参见《JavaScript 陷阱》一文以获得更多信息。

 [^server-10]: 参见 “Why the Affero GPL” <http://gnu.org/licenses/why-affero-gpl.html> 以获得完整解释。
