# 名字的含义

\newpage
## 名字的含义？

> Copyright © 2000, 2006, 2007 Richard Stallman。

>关于此主题了解更多，你也可以阅读我们的 GNU/Linux FAQ <http://gnu.org/gnu/gnu-linux-faq.html> 和本书的《Linux 和 GNU 操作系统》一文，它讲了 GNU/Linux 系统的历史，和这命名的问题有关。以及另一篇文章《从未听过 GNU 的 GNU 用户》<http://gnu.org/gnu/gnu-users-never-heard-of-gnu.html>。

顾名则思义；我们所选的名字代表了我们所要传达的思想。一个不恰当的名字会向人们传递错误的思想。玫瑰不管叫什么闻起来总是甜的——但是如果你把它叫作笔，当人们用它写字时将会很失望。同样地，如果你把笔叫作“玫瑰”，人们可能就不知道它能做什么了。如果你把我们的操作系统称为“Linux”，则会传达一些关于此系统起源、历史和目的的错误概念。如果你称之为 GNU/Linux，这将传达（虽然不详细）一个准确的概念。

这对我们的社区重要吗？人们是否了解系统的起源、历史和目的重要吗？是的——因为忘记历史的人往往注定要重蹈覆辙。目前围绕 GNU/Linux 建立起来的自由世界仍然无法保证生存；那些迫使我们开发 GNU 的问题并没有被彻底根除，而且他们总是想复辟。

当我解释为什么把这个操作系统称为“GNU/Linux”比“Linux”要好时，人们有时这样回应：

> 就算 GNU 工程因其工作而应该得到赞誉，但如果人们不给予它这种赞誉，就真的值得如此大惊小怪的吗？不管是谁做的，反正工作被完成了，这不是重要的事吗？你应该心态平和，以干好工作为荣，而不是对荣誉的问题耿耿于怀。 

这似乎是个明智的建议，如果所有的情况都像那样，大家干完工作后都不计得失，那这建议还真是对的！但现实充满挑战，现在还不是那样对未来想当然的时候。我们社区的力量靠的是保证自由与合作。使用 GNU/Linux 这个名字是一种让人们提醒自己和他人了解这些目标的方式。

虽然不考虑 GNU 也能写出优秀的自由软件；许多优秀的工作是在 Linux 的名义下完成的。但是“Linux”（这个名字）从它被创造的那一刻起，就与一种不对自由协作做承诺的哲学联系在一起。随着这个名字的广泛商业使用，当我们把它和社区精神相联系时，将会遇到更多的麻烦。

对自由软件来说，未来的一大挑战是来自于那些“Linux”发行版公司，为提高易用性和增强功能，将非自由的软件添加到 GNU/Linux 中。所有主要的商业发行版都这样做；没有一个让自己限于自由软件的。他们中的大多数都在其发行版中没有区分非自由软件包。很多甚至开发非自由软件并加入到其系统发行中。还有些甚至蛮横的地宣布那些“Linux“系统是“席位许可”的，也就是可以给用户和 Microsoft Windows 一样的“自由”。

人们用“普及 Linux ”的名义替这种加入非自由软件的行为辩护——事实是，更重视普及度而不是自由。有时这是被公开承认的。例如，《连线》杂志（Wired）对 Linux Magazine 期刊的编辑 Robert McMillan 说，“感觉推动开源软件应该用技术，而不是政治决策”。并且 Caldera 的 CEO 公开劝说用户放弃自由的目标，并转而为“普及 Linux”而工作[^whygnulinux-1]。

如果普及率指的是使用混合非自由软件的 GNU/Linux 的用户数量，添加非自由软件到 GNU/Linux 系统或许会增加普及率。但同时，它含蓄地鼓励社区将非自由软件当好东西接受，而忘记自由的目标。如果你的方向不对，那么车开得再快也没用。

当非自由的“附加组件”是一种库或者编程工具时，就会成为自由软件开发者的陷阱。当他们编写基于非自由软件包的自由软件时，他们的软件不能成为完全自由系统的一部分。Motif 和 Qt 曾以这种方式诱骗了大量的自由软件，导致的问题花费数年才能解决。Motif 的一些问题直到它被废弃并不再被使用都没有完全解决。Sun 公司实现的非自由 Java 直到现在也有类似的效果：Java 陷阱[^whygnulinux-2]，庆幸的是大多已经修复。如果我们的社区持续向这个方向发展，将会把 GNU/Linux 的未来引到自由和非自由拼接在一起的地步。从现在起的五年里，我们仍然确信将会有大量的自由软件产生；但如果我们不谨慎一些，用户所期望的自由软件就很难在脱离非自由软件的情况下使用。如果这事发生了，我们为自由做出的努力就前功尽弃了。

如果发布自由的替代品只是简单的编程问题，随着我们社区开发资源的增加，未来解决问题可能就变得愈加简单。但是我们面临的障碍使得这更加困难：法律禁止自由软件。当软件专利出现，并且像数字千年版权法案（DMCA） 这样的法律被用来阻止开发一些用于重要工作中的自由软件时（例如看 DVD 或者听 RealAudio 音频流），我们会发现，除了**拒绝使用调用它们的非自由程序**，我们自己并没有明确的方法来抵御专利和私密的数据形式。

面对这些挑战需要许多不同的努力。但是应对任何挑战，我们首先需要牢记自由协作的目标。我们不能仅仅依靠渴望强大、可靠的软件来激励人们作更多的努力。我们需要大家有一种决心，一种为他们的自由和他们的社区而战的决心——一种锲而不舍的决心。

在我们的社区里，这个目标和决心主要源自 GNU 工程。我们就是这样的人——把自由和社区当作不可让步的事情；而那些称之为“Linux”的组织通常不说这些。关于“Linux”的杂志更是打满了非自由软件的广告；打包“Linux”的公司把非自由软件添加进系统；其它公司通过开发在 GNU/Linux 上运行的非自由的应用来“支持 Linux”；连“Linux”的用户群也邀请推销员展示这些应用。人们在社区中最有可能接触到自由的理念和决心的地方，就是在 GNU 工程中。

但是当人们接触到它时，能体会到这与他们息息相关吗？

那些知道自己正在用的系统是源自 GNU 工程的人，能看到他们自身与 GNU 之间有一个直接的关系。他们不会自动地同意我们的哲学，但至少他们会看到一个严肃思考它的理由。相反，那些认为自己是“Linux 用户”的人，相信 GNU 工程只是“开发了被证实在 Linux 中非常有用的工具”，他们通常只了解 GNU 与其间接的关系。当他们接触到 GNU 哲学时，就会忽视它。

GNU 工程是理想主义的，但是那些鼓励理想主义的人面临很大的障碍：普遍的意识形态鼓励人们把理想主义当作“不现实的”而摒弃。我们的理想主义其实已经极其实用：这是我们拥有一个自由的 GNU/Linux 操作系统的原因。喜欢这个系统的人应该知道，正是我们的理想主义实现了它。

如果“工作”真的做了，如果除了信誉没有其他利害攸关，也许放弃可能会更明智。但是我们没有处在那个境地。为了鼓励人们做那些需要做的工作，我们需要让我们已经做了的工作被认可。要帮助我们就请将这个系统称为 GNU/Linux 吧。

[^whygnulinux-1]: 参见 Dietmar Muller 于 2001 年 7 月 10 日发表的文章《“Stallman: Love Is Not Free”》<http://zdnet.com/article/stallman-love-is-not-free/>

[^whygnulinux-2]: 参见《“自由的桎梏——Java 陷阱”》<http://gnu.org/philosophy/java-trap.html>一文
