\newpage
## 自由硬件和自由硬件设计
 
> Copyright © 2015 Richard Stallman。本文分成两部分，分别以标题“为什么我们需要自由的电子硬件设计” <http://wired.com/2015/03/need-free-digital-hardware-designs> 和“硬件设计必须自由，如何行动见此” <http://wired.com/2015/03/richard-stallman-how-to-make-hardware-designs-free>，发表于《连线》杂志网站。2015年本文发布于 <http://gnu.org> 。

> 自由软件的思想向硬件延伸到什么范围？让我们的硬件设计自由是不是个道德义务，正如使我们的软件自由那样？维持我们的自由是否需要抵制出自非自由设计的硬件？

### 定义

*自由软件*事关自由，而非价格；宽泛地讲，这意味着用户有使用软件的自由和复制并再分发软件的自由，免费或收费。更精确地，其定义可用这四项基本自由[^freehard-1]公式化的来考察。为强调“free”一词指的是自由而非价格，我们经常把法语和西班牙语中的“libre”一词和“free”一起使用。

将同样的概念直接应用于硬件，*自由硬件*意为用户有使用、复制和免费或收费地再分发硬件的自由。然而，除了钥匙、DNA、和塑料制品的外观之外，没有用于硬件的复制机制。大多数硬件是按照一定的设计装配出来。设计先于硬件存在。

因此，我们实际需要的概念是类似*自由硬件设计*的东西。很简单：其意指一种允许用户使用（即，在其指导下装配硬件）和复制并免费或收费地再分发的设计方案。这种设计方案必须提供和自由软件一致的四项基本自由。

这样我们可以将按照自由的设计装配出的硬件说成“自由硬件”，或“设计自由的硬件”以避免可能的误解。

首次接触自由软件思想的人们经常认为其含义是你可以免费获得一份副本。很多自由程序可以不要钱地获取，因为下载你自己的副本无需代价，但那不是“free”在此处的含义（事实上，有些间谍软件程序——例如 Flash 播放器和《愤怒的小鸟》是免费的，尽管它们不自由）。将“libre”一词和“free”一起使用有助于澄清观点[^freehard-2]。

对硬件，混淆趋于走向另一方向；硬件要花钱生产，故商业化生产硬件无法免费（除非是赔本赚吆喝或添头），但这并不妨碍其设计方案变得自由。由你的 3D 打印机生产出的东西可以非常便宜，但并非精确地免费因为你需要支付原料成本。在道德方面，自由的问题完全压倒了价格问题，因为对其用户拒绝自由的设备还不如没有。

由某些人使用的“开放硬件”和“开放源码硬件”的说法具有和“自由硬件”相同的具体含义，但这些说法降低了对自由议题的重视。它们由“开放源码软件”的说法派生而来，其多少指的是自由软件，但缺少了对自由的讨论或将自由的议题展示为关乎对错的事[^freehard-3]。为着重强调自由的重要性，一旦关乎自由我们就要注意谈到自由；因为“开放”做不到这一点，让我们不要用它来取代“自由”一词。

### 硬件和软件

硬件和软件在根本上不同。一个程序，即使取编译后的可执行形式，也是一组可被计算机解释为指令的数据集合。和任何其他数字作品相同，它可以用计算机来复制和改写。程序的副本没有固有的物理形式或化身。

与之相对，硬件是一个物理构造且其物质性是关键。虽然硬件的设计可以表示为数据，甚至在某些场合下表示为程序，设计仍然不是硬件本身。为 CPU 做的设计不能执行程序。你基本上不可能试着用为键盘做的设计打字或在为显示屏做的设计上显示像素。

更进一步，虽然你可以用计算机来修改或复制一份硬件设计，计算机并不能将这份设计转化为其描述的物理结构。那需要装配设备。

### 硬件和软件的边界

在数字设备中，硬件和软件的边界是什么？它遵从其定义。软件是计算机可以操作修改和复制的部分，而硬件则不可以。这是理清其区别的正确方法，因为关乎实际的后果。

在硬件和软件之间有一个包含*可*被更新或替换，却并未打算在产品售出后更新或替换的灰色地带——固件（Firmware）。从概念上说，这个灰色地带十分狭窄。在实践上，它很重要，因为很多产品落在其中。我们可以把这样的固件看作硬件的小小延伸。

有人会说原装的固件程序和场效应可编程逻辑门阵列（FPGA）“模糊了硬件和软件的边界”，但我认为这是对事实的误读。在使用过程中安装的固件是软件；设备自带并不可修改的固件虽天生是软件，但我们可以把它当成一种电路。如对 FPGA，FPGA 本身是硬件，但加载到 FPGA 中的逻辑门模式是一种固件。

在 FPGA 上运行自由的逻辑门模式可以是一种使得数字设备从电路层变自由的潜在有效方法。然而为了使 FPGA 在自由世界中可用，我们需要为其设计自由的开发工具。其障碍是加载进 FPGA 的逻辑门模式文件的格式是私密的。多年以来，没有一种 FPGA 的型号能够为其生成逻辑门模式文件而不需要不自由（私有）的工具。

到了2015年，用来给一种通用的 FPGA 型号—— Lattice iCE40[^freehard-4]用硬件描述语言（HDL）写成的输入文件编程的自由软件工具出现了。现在也可以用自由工具编译 C 程序并在 Xilinx Spartan 6 LX9 FPGA 上运行它们[^freehard-5]，但这些工具不支持 HDL 输入。我们建议您抵制其他型号的 FPGA 直到它们也能被自由的工具支持。

对 HDL 代码本身而言，它可以表现为软件（当运行于模拟器上或载入 FPGA 中），也可以表现为硬件设计（当实现为不可变的硅晶或电路板）。

### 3D 打印机的道德问题

道德上，软件必须自由[^freehard-6]；不自由的程序是不义的。我们是否应当对硬件设计取同样的观点？

我们肯定应该，在 3D 打印（或者，更普遍地，任何个人装配行为）可处理的领域。用于制造有用的、实用的物品（即，功能性而非装饰性）的打印模式*必须*是自由的，因为它们是为了实用而产生的作品。用户应得到对这些作品的控制，正如他们应得对他们使用的软件的控制。发布一个不自由的功能性物品的设计和发布非自由程序一样有错。

请仔细甄别，并选择那些只用自由软件就能驱动的 3D 打印机；自由软件基金会为这样的打印机背书[^freehard-7]。有的 3D 打印机是按照自由的硬件设计制成的，但 MakerBot 的硬件设计是不自由的[^freehard-8]。

### 我们是否必须抵制不自由的数字硬件？

不自由的数字[^freehard-9]硬件设计是否不义？我们是否必须为了我们的自由抵制所有按照不自由的设计制造出的数字硬件，如同我们必须抵制非自由软件？

因为硬件设计和软件源码在概念上是平行的，许多硬件黑客像对非自由软件那样迅速声讨非自由硬件设计。我对此并不同意因为硬件和软件的情况不同。

今天装配芯片和电路板的技术类似印刷业：它适于工厂中的大规模生产。比起今天的软件复制，它更类似 20 世纪 50 年代的书籍复印。

复制和修改软件的自由在道德上是必要的，因为那些活动对使用软件的人们来说是可行的：你能使用软件的设备（计算机）同样适合用来复制和改写它。今天的移动计算机太弱小而难以适用于此，但任何人都能找到足够有力的计算机。

而且，计算机足以用来下载并运行那些懂得如何修改软件的人修改的版本，即使你不是程序员。当然，非程序员每天都下载并运行软件。这就是为什么自由软件对非程序员有实在的贡献。

这些在多大程度上适用于硬件？并非使用数字硬件的每个人都知道如何修改电路设计，或芯片设计，但任何有 PC 的人都有这么做的必要设备。到目前为止，硬件平行于软件，但接下来区别就大了。

你不能在你的计算机上运行电路设计或芯片设计。构造大型电路是一系列艰苦的工作，之后你才能得到电路板。装配芯片在今天并不适合个人完成；只有规模化生产才能让它们足够便宜。以今天的硬件技术，用户们无法像运行软件黑客某甲（原文是John S Hacker——译者注）改造过的软件那样，下载并运行硬件黑客某乙（原文是John H Hacker——译者注）改造过的硬件设计。因此，四项基本自由无法像给与用户们对程序的集体控制那样给与对硬件设计的集体控制。这就是一切软件都必须自由的原因无法适用于硬件的地方。

1983年没有自由的操作系统，但显然如果有了，我们可以立刻用上它并拥有软件自由。缺少的只是这样一个操作系统的代码。

而到了 2014 年，就算我们有了适用于 PC 的 CPU 芯片的自由设计，按此设计大规模生产出来的芯片也不能为我们在硬件界给与我们同样的自由。如果我们要购买从工厂大规模生产出来的产品，对工厂的依赖会引发大多数和非自由设计相同的问题。我们需要未来更好的装配技术，这样才能让我们自由的设计得到硬件的自由。

可以展望这样的未来，我们的个人生产者能制造芯片，机器人可以把芯片和变压器、开关、按键、屏幕、风扇等组合焊接在一起。在这样的未来里，我们都可以制造自己的计算机（还有装配机和机器人），而且我们每个人都能从懂硬件的人做出的改造设计中得到好处。那时抵制非自由软件的议题才也能适用于硬件设计。

这个未来距今至少有数年之久。在此期间，原则上没有必要抵制设计不自由的硬件。

### 我们需要自由的硬件设计

尽管在今天的状况下我们无需抵制按照非自由设计制造出的数字硬件，不过我们仍需要开发自由的设计并在条件允许时使用它们。这些已经在今天提供了优势，而且在未来它们可能是使用自由软件的唯一方法。

自由的硬件设计提供了实用上的优势。很多公司可以装配，这减少了对单一卖家的依赖。集团可以安排大量装配。拥有电路图或 HDL 代码使得学习设计以寻找错误或恶意功能成为可能（NSA 在一些计算机中促成恶意弱点之事已被人所知）。并且，自由设计可作为设计计算机和其他复杂设备的构造砖块，其规格会被公开，对我们不利的部件也会更少。

在我们可以这样制造整台计算机之前，自由硬件设计可以用于计算机和网络的某些部件，还有嵌入式系统。

如果它成为阻止非自由软件的唯一方法，自由硬件设计甚至可能会在我们能以个人之力装配硬件以前就变得至关重要。因为一般的商业硬件正越发设计得使用户屈服，由于私密的规格，甚至需要你以外的某人签名代码，它们越发不兼容于自由软件。甚至蜂窝电话的调制解调器芯片和一些图形加速器已经需要制造商为固件签名。任何在你计算机上许别人改但不许你改的程序，都是强加于你不义强权的体现；强加了那种要求的硬件是恶意硬件。所以蜂窝电话调制解调器芯片，现在可用的所有型号都是恶意的。

某一天，自由设计的数字硬件可能是唯一可以让自由系统运行的平台。让我们专注于在那一天之前拥有必要的自由硬件设计，并希望我们有方法为所有用户将它们足够便宜地装配出来。

如果你设计硬件，请让你的设计变得自由。如果你使用硬件，请催促公司们并向其施压，让他们使硬件设计变得自由。

### 设计的层次

软件有实现的层次；例如，一个软件包可能包括库、命令和脚本。但这些层次对软件的自由没有明显的贡献，因为可以把所有这些层次都变得自由。设计程序的组件和设计把组件组合在一起的代码是同类的工作；与其类似，从源代码编译程序的组件和将这些从源代码编译出来的组件组合在一起的程序是同类的工作。使整个系统自由只需继续工作直到完成整件任务。

因此，我们坚持主张程序要在全部层次上自由。对一个分类为自由软件的程序，组成它的每一行源代码都得是自由的，这样你才能只用自由的代码重建这个程序。

与此相反，物理对象经常是由不同类型的工厂设计制造的组件所构造而成的。例如，计算机由芯片构成，但设计（或装配）芯片和从芯片设计（或装配）计算机是非常不同的。

因此，我们需要区分数字产品（可能还有其他类型的产品）的设计中的*层次*。连接芯片的电路是一个层次；每个芯片的设计是另一层次。在 FPGA 中，基本单元间的互联是一个层次，而基本单元本身是另一层次。理想的未来中我们会希望设计在所有层次上都是自由的。在当前状况下，仅仅使一个层次变得自由已经是一个明显的进步。

然而，如果一个设计在同一层次上组合了自由和非自由的部分——例如，一个结合了私有“软核”的“自由” HDL 电路——我们必须下结论说此设计作为一个整体在那个层次上是不自由的。类似地，对非自由的“向导”或“宏”，如果它们指的是芯片间的互联或芯片内部结构间的可编程互联的一部分。其自由部分可以是通向自由设计未来目标的一个步骤，但到达那一目标需要把不自由的部分替换掉。它们在自由的世界中决不能接受。

### 自由硬件设计的许可和版权 

你通过将一个硬件设计按照自由的许可发行来使其成为自由设计。我们建议您使用第三版或更新的 GNU 通用公共许可证。我们带着这种用途的视点设计了 GPL 第三版。

在电路和非装饰性的物体外观上的左版（Copyleft），不会像想象一般获得成功。这些设计的版权仅适用于这些设计是如何被画出或写下的。左版是一种利用版权法的手段，所以其效果仅限于版权法起效的范围。

例如，一个电路，作为一种拓扑关系，无法拥有版权（也因此无法使用左版）。由 HDL 写成的电路定义可以拥有版权（因此可以使用左版），但左版只能保护这 HDL 代码的具体表达方式，而非依其生成的电路拓扑。与此类似，电路的图纸或布局可以拥有版权，因此可以使用左版，但仅仅保护图纸或布局本身，而非电路拓扑。任何人都可以以不同的外观画出同样的电路拓扑，或写出生成相同电路的不同 HDL 定义。

版权不能保护物理电路，所以当人们构建电路的实例时，设计的许可证对他们能对他们构建出的设备做什么没有法律效力。

对物件的图纸而言和 3D 打印模型而言，版权不能阻止以不同的方式绘制同样功能性物体的外观，它也不能保护按照图纸制造功能性物质的实体。只要版权考虑到，每个人都可以自由地制造和使用它们（而这是我们十分需要的自由）。在美国，版权不涉及某个设计描述的功能特性[^freehard-10]，但却涉及装饰特性。当一个物体既有装饰特性又有功能特性时，你将进入一个棘手的境地[^freehard-11]。这一切也许在你的国家也是如此，也许不是。在商业性或大规模生产之前，你需要咨询当地的律师。你需要考虑的不只是版权。你可能会踩到专利地雷，其大部分被跟你正在使用的设计的诞生毫无关系的实体持有，而还可能有其他的法律问题。

切记版权法和专利法完全不同。假设他们有任何相同之处都是个错误。这就是“知识产权”的说法是完全的误导而应被彻底抵制的原因[^freehard-12]。

### 通过文件仓库提倡自由硬件

通过人们发表硬件设计的文件仓库的规则来劝说他们把已发表的设计变得自由是最有效的方式。仓库的操作员应当把将要使用设计的人们的自由置于设计者的偏好之上。这意味着要求有用物品的自由设计是在该仓库中发表它们的一个条件。

对装饰性物品，此论点不适用，所以我们不必须坚持它们必须是自由的。但是，我们必须坚持它们是可分享的。因此，一个既能处理装饰性物品模型也能处理功能性物品模型的仓库必对每一类存档都有合适的许可政策。

对数字设计，我建议仓库坚持使用“GNU GPL 第三版或更新”，Apache 2.0，或CC-0。对功能性三维设计，仓库要劝用户选择以下四种许可之一：“GNU GPL 第三版或更新”，Apache 2.0，CC-SA，CC-BY或CC-0。对装饰性设计，要选“GNU GPL 第三版或更新”，Apache 2.0，CC-0或任何 CC 族许可。

该仓库应当要求所有设计都以源代码形式发表，且只能被私有软件使用的私密格式源代码并不真正足够。对三维模型而言，STL 格式并不是用来修改设计的最佳格式因此不算源代码，所以仓库不该接受此格式，除非它们可能和真正的源代码一同发表。

没有理由为硬件设计的源代码只选择单一的格式，但尚未能被自由软件处理的源码格式应该充其量勉强接受。

### 自由硬件和担保

一般说来，自由硬件设计的作者没有对按其设计装配硬件者提供担保的道德义务。这和出于销售硬件实体的问题不同，销售硬件实体必须由其卖家和/或制造者提供担保。

### 结论

我们已经有了可以让我们的硬件设计自由的合适许可证。我们需要的是作为一个社区将其认作我们所必做之事而在我们自行装配物品时坚持自由的设计。



 [^freehard-1]: 参见《什么是自由软件？》以查看四项基本自由的列表。


 [^freehard-2]: 参见<http://gnu.org/philosophy/proprietary/proprietary-surveillance.html>以查看一个在工业中扩散的监视手段的快速增长的列表。


 [^freehard-3]: 参见《为什么说开源漏掉了自由软件的要点》一文

 [^freehard-4]: 参见 <http://clifford.at/icestorm/>. 

 [^freehard-5]: 参见 <https://github.com/Wolfgang-Spraul/fpgatools>

 [^freehard-6]: 参见《如今自由软件更加重要》一文

 [^freehard-7]: 参见 <http://fsf.org/resources/hw/endorsement>

 [^freehard-8]: Rich Brown, “Pulling Back from Open Source Hardware, MakerBot Angers Some Adherents,” 27 September 2012, <http://cnet.com/news/pulling-back-from-open-source-hardware-makerbot-angers-some-adherents/>.

 [^freehard-9]: 如本文中的用法，“数字硬件”包括在数字部分之外还有模拟部分的硬件。 

 [^freehard-10]: 参见美国版权局定义的“useful article”，于 <http://copyright.gov/register/va-useful.html>. 

 [^freehard-11]: 一篇由 Public Knowledge 所写的文章“为你的 3D 打印产物赋予许可的三个步骤”<https://publicknowledge.org/assets/uploads/documents/3_Steps_for_Licensing_Your_3D_Printed_Stuff.pdf>（2015年3月6日）。对其在美国的复杂性给出了很有用的信息，尽管该文落入了使用伪概念“知识产权”，和不应该和版权联用的宣传用语“保护”的常见谬误。若问为何，参见《应避免使用（或慎用）的词语，由于它们是不公正的或者引起混淆的》一文。 

 [^freehard-12]: 参见《您说过“知识产权”吗？这是一种迷惑性的幻景》一文。 

