\newpage
## GNU/Linux 上带有数字限制管理（DRM）的私有游戏：是好是坏？

> Copyright © 2013 自由软件基金会

Valve，一家知名的游戏公司，主要发布各种带有数字限制管理（DRM）的私有计算机游戏，最近它宣称将会为 GNU/Linux 平台发布游戏。这会带来哪些好的或者坏的影响？

我假设流行的私有软件在 GNU/Linux 上的可获得性，将会推动 GNU/Linux 操作系统的普及。然而，GNU 的终极目标并非仅限于获得“成功”；它的目的是赋予用户自由[^nonfreegame-1]。因此，更大的问题是，这种发展趋势将会怎样影响用户的自由。

这些游戏的问题并不在于它们是商业的[^nonfreegame-2]（我们不认为商业化有什么问题）。也不在于其开发者贩卖其副本[^nonfreegame-3]；这也没有问题。它们的真正问题在于这些游戏包含非自由软件（当然，指的是“freedom”中的自由）[^nonfreegame-4]。

（同其他私有软件一样）私有游戏软件是不符合伦理的，由于它们拒绝用户的自由（游戏艺术是另一个问题，由于它们不是软件）。如果您渴求自由，一个起码条件是不要拥有或者在自己的计算机上运行私有软件。这一点是很清楚的。

然而，如果您一定要玩这些游戏，您最好还是在 GNU/Linux 上进行而非在微软 Windows 上进行。至少您可以藉此避开 Windows 对您自由的践踏[^nonfreegame-5]。

因此，从直接的实践角度看，这种发展趋势既有好的影响又有坏的影响。这可能会鼓励 GNU/Linux 用户去安装这些游戏，也可能会鼓励这些游戏的玩家使用 GNU/Linux 来取代 Windows。我猜想直接的好处大于直接的坏处。但是，这里还有一种间接的影响：这些游戏的玩家将会向我们社区里的人传授什么？

任何自带软件以提供这些游戏的 GNU/Linux 发行版将会暗示用户：自由并不是关键。GNU/Linux 发行版中的私有软件[^nonfreegame-6]已经在破坏自由这一终极目标。向发行版中添加这类游戏将会加深这种危害。

自由软件的实质是自由而非价格。一款自由的游戏不必须是免费的。商业化开发自由的游戏软件是可行的，同时尊重您修改所使用软件的自由。由于游戏中的艺术不属于软件，它也不必须是免费的。事实上，确实有由商业公司开发自由的游戏软件，与那些由志愿者以非商业化方式开发的自由的游戏软件并存。众筹式的开发只会让开发变得更容易。

但是，如果我们假设在当前情况下开发某类自由游戏软件是*不可行的*——将会发生什么？将其作为一款私有游戏软件开发并无任何益处。想要在您的计算中拥有自由，必须拒绝私有软件，就是这么简单直白。您，作为热爱自由者，不会由于一款私有游戏的存在而去玩它，因此，您也不会由于它的不存在而失去任何东西。

如果您想要推进计算中的自由事业，请注意不要将这类游戏在 GNU/Linux 上的可获得性说成是对我们事业的支持。与之相反，您可以向人们介绍 LibreGameWiki[^nonfreegame-7]，那里试图列出所有自由的游戏软件，以及 FreeGameDev 论坛[^nonfreegame-8]，还有 LibrePlanet Gaming Collective 的自由游戏之夜[^nonfreegame-9]。

 [^nonfreegame-1]: 参见《如今自由软件更加重要》 一文以获得更多信息。

 [^nonfreegame-2]: 参见《应避免使用（或慎用）的词语》一文的“商业化”一节以获得关于“商业化”一词所带来的困惑的解释。

 [^nonfreegame-3]: 参见《售卖自由软件》 一文以获得更多信息。

 [^nonfreegame-4]: 参见《什么是自由软件？》 以获知自由软件的完整定义。

 [^nonfreegame-5]: 参见我们的运动位于 <http://upgradefromwindows8.org/> 以获得更多信息。

 [^nonfreegame-6]: 参见 <http://gnu.org/distros/common-distros.html> 以获知为何我们不推荐某些（通常是流行的）发行版。

 [^nonfreegame-7]: 参见 <https://libregamewiki.org/Main_Page>.

 [^nonfreegame-8]: 参见 <http://forum.freegamedev.net/index.php>.

 [^nonfreegame-9]: 参见 <http://libreplanet.org/wiki/Group:LibrePlanet_Gaming_Collective>.


