\newpage
## 应避免使用（或慎用）的词语，由于它们是不公正的或者引起混淆的

> Copyright © 1996–1999，2001–2004，2007–2015，自由软件基金会。本列单最初于 1996 年发表于 <http://gnu.org>。

有些单词或短语是我们建议避免使用或者避免在特定上下文或应用场景使用的。其中的一些词语具有歧义或误导性；而其他一些词语则预设了某种我们所不赞同的观点，并且我们希望您也不会同意那些观点。（参见《自由与非自由软件的分类》和《为何称之为诈骗（Swindle）？》两篇文章。）

### 可获得性（Access）

有一种普遍的误解认为，自由软件意味着公众必须可以获得某一程序。这并非自由软件的本意。

自由软件的准则[^wordtoavoid-1]并不是关于谁能够获得某一程序的；四项基本自由所关注的是拥有它的一份副本的用户可以用它做什么。例如，自由之二称该用户拥有为其复制一份副本并且送给或卖给您的自由。但是任何用户都没有为您复制副本的*义务*；并且您也没有*权利*强行要求任何用户为您提供副本。


特别地，如果您为您自己编写了一个程序并且完全不向任何人提供副本，该程序也是自由软件（尽管是在一种平凡的意义上），由于您（作为拥有它的唯一用户）拥有四项基本自由。

事实上，当很多用户拥有某一程序的副本时，某些人确实会将其发布到互联网上，并且供其他人访问。我们认为人们应当如此，如果该程序确实有用。但这并非自由软件的强制要求。

确实有一种特殊情况，此时是否拥有可获得性与自由软件直接相关：GNU 通用公共许可证（GNU GPL）允许赋予一位特定用户下载程序源代码的访问权，作为以实物载体的形式为该用户提供源代码副本的替代方案。这条规则也适用于用户已经拥有一份非源代码形式的副本这一特例。

### 选择（Alternative）


我们从不将自由软件描述为私有软件之外的选择，由于这一单词假设所有“选择”都是合法的，并且每增加一种“选择”都对用户有利。事实上，这一单词假设自由软件应该和那些不尊重用户自由的软件共存。

我们坚信以自由软件形式发布是发布软件以供他人使用的唯一符合伦理的方式。而其他方式，不论是私有软件还是“服务作为软件替代品”（SaaSS）都会迫使用户屈从[^wordtoavoid-2]。因此我们认为不向用户提供这些自由软件之外的“选择”才是好的。

### BSD 风格（BSD-Style）

“BSD 风格许可证”这一表述将会引起混淆，由于它将具有显著不同的许可证混为一谈[^wordtoavoid-3]。例如，最初的 BSD 许可证由于带有广告条款从而与 GNU GPL 不兼容，但是改进过的 BSD 许可证与 GPL 兼容。

为了避免混淆，最好在谈论中明确给出许可证的名字[^wordtoavoid-4]并且避免使用含混不清的短语“BSD 风格”。

### 闭源（Closed）

将私有软件描述为“闭源”很明显是与“开源”概念相对。在自由软件运动中，我们不希望被别人同开源阵营混为一谈，因此我们谨慎地避免使用那种促使人们将我们与他们混在一起的表达方式[^wordtoavoid-5]。例如，我们避免将非自由软件描述为“闭源”，我们称之为“非自由”或“私有”[^wordtoavoid-6]。

### 云计算（Cloud Computing）

“云计算”这一短语（或者在表示计算的上下文中进一步简称为“云”）是一种含混不清的市场化流行语，它没有任何合乎逻辑的涵义。它被用于指代一系列不同的活动，其唯一的共同点是它们都使用互联网进行文件传输以外的事情。因此，这一短语是在散布混淆。如果您基于它进行思考，您的思考将会是混乱的。

当您思考或是回应一个由他人提出的并且使用这一概念的论述时，第一步是要澄清话题。该论述是关于什么场景的？适用于此场景的恰当并且清晰的概念是什么？只有当话题被清晰阐述之时，合乎逻辑的讨论才是可能的。

“云计算”的众多可能的涵义之一是将您的数据存储于在线服务上。在大多数场景中，这是愚蠢的做法，由于这使您暴露在监控之下[^wordtoavoid-7]。

另一种可能的涵义（与上一条有所重叠但又不完全相同）是“服务作为软件替代品”（SaaSS），它拒绝了您对于您自己的计算的控制权。您应该从不使用 SaaSS[^wordtoavoid-8]。

另一种可能的涵义包括租赁远程的实体或虚拟服务器。这些实践在某些特定环境下是可以接受的。

另一种可能的涵义是通过您自己的移动设备访问您自己的服务器。这并不会产生特别的伦理问题。

美国国家标准技术研究所（NIST）为“云计算”的定义[^wordtoavoid-9]提出了三种场景，它们会带来不同的伦理问题：软件即服务（SaaS）、平台即服务（PaaS）、基础设施即服务（IaaS）。然而，这种定义与“云计算”通常的用法并不匹配，由于它并未包括向在线服务中存储数据。由 NIST 定义的 SaaS 在很大程度上与 SaaSS 重叠，后者虐待它的用户，但这两个概念并不等同。

这些不同的计算实践甚至不属于同一个讨论范围。避免使用“云计算”这一带来混淆的概念，最佳方式是不使用术语“云”与计算相关联。只谈论您想要表达的话题，并且以一种具体的概念称呼它。

有趣的是，Larry Ellison，一位私有软件开发者也注意到了“云计算”这一概念的空泛性[^wordtoavoid-10]。但他决定仍然使用这一概念，因为他是一位私有软件开发者，毕竟此人与我们不是由相同理念所驱使的。

### 商业（Commercial）

请不要将“商业”用作“非自由”的同义词。这将两种完全不同的问题混为一谈。

一个程序称为商业软件，如果它是作为一种商业行为而被开发的。一个商业软件可以是自由或非自由的，取决于它的发布方式。类似地，由学校或个人开发的程序也可以是自由或非自由的，取决于它的发布方式。这两个问题——程序由何种实体开发，以及它的用户应当拥有什么自由——是不相关的。

在自由软件运动的最初十年，自由软件包几乎都是非商业的；GNU/Linux 操作系统的组件由个人或者诸如自由软件基金会（FSF）和大学的非盈利性组织所开发。其后，在 20 世纪 90 年代，自由的商业软件开始出现。

自由的商业软件是对我们的社区的贡献，因此我们应当鼓励。但是那些认为“商业”等同于“非自由”的人们倾向于认为“自由商业”的组合是自相矛盾的并且否定其可能性。让我们小心对待，不要以这种方式使用“商业”一词。

### 补偿（Compensation）

当与版权联系在一起的时候谈论“补偿作者”将会带来以下两种假设：（1）版权是以作者之名而存在的；以及（2）每当我们阅读任何东西的时候，我们已经欠下了作者一笔债务并且必须补偿。第一个假设是错误的[^wordtoavoid-11]，而第二个假设是不可容忍的。

而“补偿版权持有人”的鬼话在此基础上又附加了一层诈骗：您很可能认为这是在补偿作者，尽管在少数情况下确实是这样，但是绝大多数情况下这是在补偿出版商，正是那些出版商对我们强行施加了不平等的法律。

### 消费（Consume）

消费是指我们对食物所做的事情：当我们消化了它以后，它就不再作为食物继续存在。作为类比，我们可以将相同的词语用于那些我们可以将其*消耗殆尽*的其他产品。将其用于耐用品诸如衣物或电器是一种涵义的延伸。然而，如果将其应用于发表的作品（计算机程序、保存于盘片或文件中的唱片、保存于纸上或文件中的书籍），这些作品的本质意义是永续保存并且可以被无限次地运行、播放或阅读，这显然就是一种错误。播放唱片或者运行程序这些行为并没有消费它们。

“消费”一词是与不可复制的实物产品的经济层面相关联的，而引导人们在毫无察觉的情况下将这一结论套用到可复制的数字作品上——这种错误正是私有软件开发者（以及其他出版商）所热切希望并且积极推动的。他们的这种扭曲的观点在一篇 Business Insider 文章中暴露无遗[^wordtoavoid-12]。这篇文章还将出版的作品称为“内容”（content）。

与我们“消费内容”相关的狭隘想法为诸如数字千年版权法案（DMCA）这样的法律奠定了基础，它们禁止用户破解数字设备中的数字限制管理（DRM）。如果用户认为他们对这些设备所做的事情是“消费”，他们就可以将这种限制视为自然的要求。

它还鼓励人们利用 DRM 对数字唱片的“流媒体”服务进行限制，这种形式也可以认为适用于“消费”这一概念。

为何这种不合理的用法广泛流传？有人也许认为这一概念过于高深；如果它吸引了您，用强有力的理由来拒绝它就会显得更为高深。其他人也许是出于（他们自己的或是其雇主的）商业利益。他们在各种有声望的地方对这一概念的使用将会给人以它是“正确”的错觉。

说“消费”音乐、小说或是任何其他艺术作品就是将它们视为产品而非艺术。如果您不想散播这种态度，您应当努力拒绝对它们使用“消费”这一概念。我们建议您说某人“体验”一件艺术作品或者一件表达观点的作品，以及某人“使用”一件实用作品。

### 消费者（Consumer）

当“消费者”一词被用于指代计算机用户的时候，它被附加了一种我们应当拒绝的假设。其中一些假设来自于使用程序就是“消费”程序这一理念（参见上一条目），这将会引导人们将那些从不可复制的实物产品中得出的结论也强行套用到可复制的数字作品上来。

此外，将软件用户描述为“消费者”指的是这样一种境地，人们被限制为只能在“市场”中可以买到的“产品”中做出选择。这里没有这种理念的容身之地，即用户可以对程序所做的事情直接行使控制权[^wordtoavoid-13]。

为了描述那些并不被限制为被动使用作品的人们，我们建议使用“个人”或者“公民”而非“消费者”。

“消费者”一词所带来的问题已经在此前有所注释[^wordtoavoid-14]。

### 内容（Content）

如果您想要描述一种舒适和满足的感觉，您一定会说“content”，但如果将这个词语用作名词以指代具有作者权的出版物和作品，这将服务于一种您可能很想避免的态度，这种态度将它们视为商品，其目的是装满包装盒并且用于赚钱。事实上，这贬低了作品本身。如果您不同意这种态度，您可以称之为“作品”或者“出版物”。

那些使用“内容”一词的人们通常是那些以作者（它们称之为“创造者”，creator）之名攫取更多版权权力的出版商。“内容”一词暴露了它们对于这些作品及其作者的真实态度（参见 Courtney Love 致 Steve Case 的公开信[^wordtoavoid-15]并且在页面中搜索 content provider（内容提供商）。哎呀，Love 女士没有注意到“知识产权”一词也是带有偏见和欺骗性的[^wordtoavoid-16]）。

然而，只要其他人仍然使用“内容提供商”这一概念，持不同政见者也可以称他们自己为“恶意内容提供商”。

“内容管理”（content management）这一短语的涵义空泛性无出其右。“内容”指代“某种信息”，而“管理”在此上下文中指代“对它们做一些事情”。因此某种“内容管理系统”是一种用于对某种信息做出某种事情的系统。几乎所有计算机程序都符合这个定义。

在大多数情况下，这一概念指代用于更新网站页面的系统。对于这种定义，我们推荐“网站修改系统”（WRS，web site revision system）这一概念。

### 创作共用许可的（Creative Commons Licensed）

对于一篇作品的许可证，最重要的方面是它是否自由。创作共用（CC）发布了七种许可证；其中三种（CC BY、CC BY-SA 和 CC0）是自由的，而其他几种则是非自由的。因此，将一篇作品描述为“创作共用许可的”未能说明它是否是自由的，并且暗示这个问题并不重要。这一论述也许是准确的，但它对于自由的省略是有害的。

为了鼓励人们关注最重要的区别，务必具体指定*哪种*创作共用许可证被使用，例如“使用 CC BY-SA 许可证”。如果您不知道一篇特定的作品应该使用哪种许可证，您需要设法获知这一点才能下定结论。

### 创造者（Creator）

当“创造者”一词应用于作者时，这是在暗含着将他们比作神（造物主，deity）。这一概念被出版商所使用，以便将作者的道德高度提升到普通人之上，进而以此为理由赋予他们更多的版权权力，然后出版商就能够以作者之名来行使这种权力。我们建议您仍然说“作者”。然而，在很多情况下，“版权持有人”才是您所真正想要表达的。这两个概念是不同的，“版权持有人”通常不是作者。

### 数字商品（Digital Goods）

当“数字商品”这一短语被应用于具有作者权的作品副本时，这将它们与实物商品等同起来了——这些实物商品是不可复制，并且因此必须被量产并且销售。这种比喻鼓励人们将他们用于评估实物商品的观点和直觉也套用到评估软件或者其他数字作品上来。这种比喻同样将问题限定在经济方面，其肤浅和有限的价值并不包括自由和社区。

### 数字锁（Digital Locks）

“数字锁”这一短语被某些批评者用于指代数字限制管理（DRM）。这一短语的问题在于它未能批判 DRM 的危害。而那些接受这一概念的人们未能对其进行透彻的思考。

锁并不一定是压迫性的或者坏的。您可能拥有很多把锁，以及它们的钥匙或代码；您可能觉得它们有用或是会带来麻烦，但它们并未压迫您，由于您可以自己打开或锁上它们。类似地，我们发现加密[^wordtoavoid-17]对于保护我们的数字文件是无价之宝。这也是一种数字锁，并且您拥有其控制权。

而 DRM 就像是由其他人为您安置的锁，他们拒绝给您钥匙——换言之，就像*手铐*。因此，对于 DRM 的恰当的比喻是“数字手铐”而非“数字锁”。

一系列反对 DRM 的运动为其选择了不明智的术语“数字锁”；为了让事情重回正轨，我们必须坚持改正这一错误。FSF 可以为一场反对“数字锁”的运动提供支持，如果我们同意其基本立场；然而，当我们表示我们的支持的时候，我们将会引人注目地将该短语更改为“数字手铐”，并且解释为何如此称呼。

### 数字版权管理（Digital Rights Management）

“数字版权管理”（简写为 DRM）是指那些被设计用于对计算机用户强行施加限制条件的技术机制。其中“权利”（rights）一词的使用是一种鼓吹，其用意是诱使您在不经意间用那些施加这些限制的少数人的观点来看待这一问题，并且忽略被强行施加了这些限制的公众。

较好的替代短语包括“数字限制管理”（Digital Restrictions Management）和“数字手铐”（digital handcuffs）。

请您签名支持我们致力于废除 DRM 的运动，它位于[DefectiveByDesign.org](DefectiveByDesign.org)。

### 生态系统（Ecosystem）

我们不建议将自由软件社区或是任何人类社区描述为“生态系统”，由于这一短语暗示伦理评价的缺失。

“生态系统”这一短语暗含着建议这样一种不加批判地服从态度：不要问什么*应该*发生，只要学习并理解*发生了*什么。在生态系统中，一些机体吃掉其他一些机体。在生态学中，我们从不追问一只猫头鹰吃掉一只老鼠或是一只老鼠吃掉一颗种子是好是坏，我们只需观察到它们这样做。物种种群的增长或衰退基于它的生存条件；这无所谓对错，这只是一种生态现象，即使到了某一物种灭绝的程度。

与之相反，对其生存环境持有伦理立场的人们可以决定保护那些如果没有人为干预就会消亡的东西——诸如公民社会、民主、人权、和平、公共卫生、稳定的气候、洁净的空气和水、濒危物种、传统艺术……以及计算机用户的自由。

### 自由和开源软件（FLOSS）

FLOSS 意指“自由和开源软件”（Free/Libre and Open Source Software），这一概念试图在自由和开源之间寻求中立[^wordtoavoid-18]。如果保持中立就是您的最终目标，使用 FLOSS 是保持中立的最佳方式。但如果您想要表达您对自由的支持，就不要使用这种中立性的短语。

### 免费（For Free）

如果您想要表述一个程序是自由软件，不要说它是可以“免费获得”的。这一短语明确表示“零价格”。自由软件关乎的是自由而非价格。

自由软件副本通常可以免费获得——例如，从文件传输协议（FTP）服务器下载。但自由软件副本也可以存储在只读光盘（CD-ROM）上贩卖；与此同时，私有软件副本有时也可以作为促销手段而免费获得，并且一些私有软件也通常免费提供给某些特定用户。

为了避免混淆，您可以称该程序可以“作为自由软件（而获得）”。

### 自由和开源软件（FOSS）

FOSS 意指“自由和开源软件”（Free and Open Source Software），这一概念试图在自由和开源之间寻求中立[^wordtoavoid-19]。如果保持中立就是您的最终目标，使用 FLOSS 更好。但如果您想要表达您对自由的支持，就不要使用这种中立性的短语。

### 可自由获得（Freely Available）

不要将“可自由获得的软件”用作自由软件的同义词。这两个短语并不等同。如果任何人可以轻松获得一份副本，就可称其为“可自由获得”。而自由软件的定义是基于那些拥有其一份副本的用户所拥有的自由。这是对于不同问题的回答。

### 免费软件（Freeware）

不要将“免费软件”用作自由软件的同义词。“免费软件”这一短语在 20 世纪 80 年代常用于指代那些仅以可执行文件形式发布的程序，其源代码不可获得。现在这一短语没有任何特别的公认定义。

当使用英语以外的语言时，请避免直接借用英语短语诸如“free software”或“freeware”。最好能将 free software 翻译为您所说的语言。（参见本书附录 B 以获得将 free software 无歧义地翻译为多种语言的方式。）

通过使用您自己语言中的词汇，您表明了真正想要表达的自由之意，而非只是对某些神秘的外国市场概念鹦鹉学舌。首次引用自由的概念可能会使您的同胞感到奇怪和不安，但是一旦他们发现它所表达的正是它所宣称的涵义，他们将会真正地理解问题的实质。

### 赠送软件（Give Away Software）

用“赠送”指代“将程序作为自由软件发布”是误导性的。这种表达方式与“免费”一词相似：它暗示问题的关键是价格而非自由。避免这种混淆的方式要说成“作为自由软件发布”。

### 谷歌（Google）

请不要将“谷歌”用作动词以指代在互联网上进行搜索。它只是众多搜索引擎中的一种。我们建议使用“网络搜索”这一短语。尽可能使用一种尊重您隐私的搜索引擎；DuckDuckGo 声称它不会跟踪其用户[^wordtoavoid-20]，尽管我们不能确认这一点。

### 黑客（Hacker）

黑客是指享受智慧乐趣的人们[^wordtoavoid-21]——并不一定与计算机有关。在 20 世纪 60 至 70 年代，麻省理工学院（MIT）的自由软件社区的程序员称他们自己为黑客。大约在 1980 年，那些发现了黑客社区的记者们错误地将这一词语用于指代“安全破坏者”。

请不要散播这种错误。那些破坏安全的人称为骇客（cracker）。

### 知识产权（Intellectual Property）

出版商和律师喜好将版权描述为“知识产权”——这一短语也被应用于专利、商标以及其他更为晦涩的法律领域。这些法律之间的共同特性如此之少，而它们之间的区别如此之大，以至于对它们进行广义化是无谋的。最好还是具体地讨论版权，或是专利，或是商标。

“知识产权”这一短语带有一种隐藏的假设——即对于那些不同类的问题的思考方式应当基于同实物对象的类比，以及我们关于它们的概念应当基于同实物产权的类比。

当涉及复制的时候，这种类比抹杀了实物对象和信息之间的本质区别：信息可以被毫不费力地复制，而实物对象则不能。

为了避免不必要的偏见和混淆，最好能够采取这样一种严格的策略，不允许将“知识产权”作为讨论甚至是思考的基础。

虚伪地将这些权力称为“权利”已经开始使得世界“知识产权”组织（WIPO）感到尴尬[^wordtoavoid-22]。

### LAMP 系统（LAMP System）

LAMP 是指“Linux，Apache，MySQL 和 PHP”——一种常用于网络服务器的软件组合，除了此上下文环境中的“Linux”实际上是指 GNU/Linux 操作系统。因此，LAMP 应该改为 GLAMP，即“GNU，Linux，Apache，MySQL 和 PHP”。

### Linux 系统（Linux System）

Linux 是 Linus Torvalds 于 1991 年开始开发的内核的名字，使用 Linux 内核的操作系统基本上是由 GNU 再加上 Linux 内核组成的。将整个操作系统称为“Linux”是不公平并且引起混淆的。请将此完整的操作系统称为 GNU/Linux，既尊重 GNU 计划，也将整个操作系统和它的内核区分开来[^wordtoavoid-23]。

### 市场（Market）

将自由软件用户，或者更普遍地将软件用户称为“市场”是误导性的。

这并不意味着自由软件社区之中没有市场的立锥之地。如果您拥有一项自由软件的支持业务，您就可以拥有客户，并且您可以在市场中同他们进行交易。只要您仍然尊重他们的自由，我们就会祝愿您在自己的市场中取得成功。

但是，自由软件运动是一场社会运动而非一项业务，其致力于的成功并非某种市场上的成功。我们试图通过赋予公众自由来服务于公众——而非通过竞争从对手手中夺取市场份额。将这场为自由而战的运动同某种仅仅是为了商业上的成功而进行的行为等量齐观，就是否认了自由的重要性，并且使得私有软件合法化了。

### 货币化（Monetize）

“monetize”一词的恰当定义是“将某物用作货币”。例如，人类社会曾经将金、银、铜、印刷的纸、某些种类的贝壳、大块的岩石等货币化。然而，我们现在见到一种趋势正在将这个词语用作另一种用途，即“将某物用作盈利的基础”。

这种用法将利润置于首要位置，而将用于盈利的东西置于次要位置。将这种态度用于软件工程是令人反感的，因为这将引导开发者将软件变为私有的，如果他们得出的结论是使其成为自由软件不能为其带来足够的利润。

一家富有生产力并且合乎伦理的企业也可以盈利，但只要它将所有其他东西置于利润之下，它就不再是合乎伦理的。

### MP3 播放器（MP3 Player）

在 20 世纪 90 年代后期，制造便携式、固态存储的数字音频播放器成为可能。其中的大部分支持受专利限制的 MP3 编码解码器（codec），但这并不是全部。某些播放器支持不受专利限制的音频编码解码器诸如 Ogg Vorbis 或者自由无损音频编码解码器（FLAC），还有些播放器甚至完全不支持 MP3 编码的文件，这显然是为了回避这些专利。将这些设备称为“MP3 播放器”不仅仅是引起混淆的，它也赋予了 MP3 额外的好处，而这正是我们应当拒绝的。我们建议使用“数字音频播放器”或者更简单的“音频播放器”，如果上下文允许如此简略。

### 开放（Open）

请不要将“开放”或者“开源”用作自由软件的替代词语。这些短语基于不同的价值观代表不同的立场[^wordtoavoid-24]。自由软件是一场政治运动；开源只是一种开发模式。

当指代开源的立场时，使用它的名字是恰当的；但不要为我们或我们的作品贴上“开源”的标签——那将会使人们误认为我们也持有那样的立场。

### 个人计算机（PC）

使用 PC 这一缩略词指代某一特定类型的计算机硬件是可以的，但是请您不要用它来暗示该计算机必须运行微软 Windows 操作系统。如果您在同一台计算机上安装 GNU/Linux，它仍然是一台 PC。

建议使用 WC 来称呼一台运行 Windows 的计算机。

### Photoshop（PS）

请不要将 photoshop（PS）用于动词以在普遍意义上指代任何照片处理或图像编辑。它只是一款特定的图像编辑软件的名字，我们应当尽量避免使用它，由于它是私有软件。有很多自由软件可用于图像编辑，例如 GIMP[^wordtoavoid-25]。

### 盗版（Piracy）

出版商通常将不被它们批准的复制行为称为“盗版”。通过这种形式，它们暗示这在伦理上与在外海攻击船只以及绑架谋杀船上的人一样坏。基于这样一种鼓吹，它们在世界上的大部分地区骗取到了法律支持以便在绝大多数（有时是全部）环境下进行复制（它们仍在继续施压以使得这些禁令更加完整）。

如果您不认可未经批准的复制行为就像绑架谋杀的理念，您可能也不愿意使用“盗版”一词来描述此行为。中立性的短语诸如“非授权复制”（或者“被禁止的复制”，用于此种行为不合法的情况）可作为替代。我们中的一些人甚至倾向于使用某种褒义词，诸如“与我们的邻居分享信息”。

一位主持了版权侵犯审判的美国法官认可“盗版”和“盗窃”属于诽谤性的词语[^wordtoavoid-26]。

### PowerPoint（PPT）

请不要使用 PowerPoint 指代任何类型的幻灯片演示文稿。它只是一款特定的用于制作演示文稿的私有软件的名字。为了您的自由，您应该只用自由软件来制作演示文稿。推荐的可选工具包括 TeX 的 beamer 类以及 OpenOffice.org （或 LibreOffice——译者注）的 Impress。

### 保护（Protection）

出版商的律师喜爱使用“保护”一词来描述版权。这个单词暗示防止破坏或者避免痛苦；因此，它鼓励人们去同情那些通过版权得利的版权持有人和出版商，而非那些受到版权限制的用户。

避免说“保护”而改用中立性的词语是容易做到的。例如，与其说“版权保护持续很长时间”，不如说“版权持续很长时间”。

类似地，与其说“受版权保护”，不如说“被版权覆盖”或者更简单的“具有版权”。

如果您想要批判版权制度而非只是想保持中立，您还可以使用“版权限制”这一短语。因此，您可以说“版权限制持续很长时间”。

“保护”一词还被用于描述恶意功能。例如，“复制保护”是一种干扰复制行为的功能。从用户的观点来看，这是一种阻碍。因此我们将此恶意功能称为“复制阻碍”。它更多地被称为数字限制管理（DRM）——参见 Defective by Design 运动， 它位于[DefectiveByDesign.org](DefectiveByDesign.org)。

### 合理与无差别（RAND，Reasonable and Non-Discriminatory）

一些标准化组织推广那些禁止自由软件实现的，受专利限制的标准，这些组织通常拥有这样的专利许可获得政策，它要求符合此标准的软件的每份副本支付一笔固定的专利费。它们通常将这样的专利许可条款称为 RAND，即“合理与无差别”。

这一短语洗白了一系列通常既不合理也并非无歧视的专利许可条款。确实，这些许可条款并不歧视任何特定的个人，但它们确实是在歧视自由软件社区，这使得它们成为不合理的。因此，RAND 的一半是欺骗性的，而另一半是带有偏见的。

标准化组织应该认识到这些许可条款是具有歧视性的，并且放弃使用“合理与无差别”或者 RAND 来描述它们。在它们这么做之后，那些不希望加入这种“洗白”说法的政策制定者才能拒绝这一短语。仅仅因为那些持有大量专利的商业公司使其变得普遍流行就接受并使用这一短语，将会允许那些商业公司支配您所表达的观点。

我们建议使用“仅限统一付费”（uniform fee only）或者简写为 UFO 来作为替代，这种描述是精准的，由于这些许可条款的唯一条件就是统一的权利金。

### 软件即服务（SaaS，Software as a Service）

我们曾经说“软件即服务”是一种不公，但我们随后发现人们对于哪些活动属于 SaaS 的理解还存在诸多分歧。于是我们转为使用一个新的短语，“服务作为软件替代品”，即 SaaSS。这个短语有两个优点：由于它从未被使用过，因此我们的定义是其唯一定义；另外它解释了这种不公包括哪些方面。

参见《服务器真正为谁服务？》一文以获得关于此问题的更多讨论。

在西班牙语中，我们继续使用“software como servicio”这一短语，这是由于“software como ser vicio”[^wordtoavoid-27]这个笑话太精妙绝伦了，以至于我们不舍得放弃它。

### 贩卖软件（Sell Software）

“贩卖软件”这一短语是含混不清的。严格地说，用一份自由软件副本换取一笔资金是在贩卖该软件，这样做也无可厚非。然而，人们通常将“贩卖软件”与对该软件的后续使用的私有限制相关联。您可以保持清醒并且拒绝混淆，通过说“有偿发布软件副本”或者“为软件的使用施加私有限制”。

参见《售卖自由软件》一文以获得关于此问题的更多讨论。

### 分享经济（Sharing Economy）

“分享经济”这一短语不是一种用于指代诸如 Uber 或者 Airbnb 这样的在人与人之间安排商业交易服务的好方式。我们使用“分享”这一词语来指代非商业合作，包括对已发布的作品的原始版本进行非商业性的再分发。将“分享”一词的涵义延伸至包含这些商业交易的程度破坏了它的本意，因此我们不会在这种上下文中使用它。

用于描述诸如 Uber 的业务的更好的短语是“计件工作服务经济”（piecework service economy）。

### Skype

请不要将 Skype 作为动词使用，用于从一般意义上指代任何类型的视频通讯或者网络电话。Skype 只是一种特定的私有软件的名字，它会窥探用户。[^wordtoavoid-28]如果您想要以一种同时尊重您的自由和隐私的方式进行网络音视频通话，您可以试用众多自由的 Skype 替代品，详情 <https://libreplanet.org/wiki/Group:Skype_Replacement>。

### 软件工业（Software Industry）

“软件工业”一词鼓励人们想象软件总是由某种工厂开发并且送达“消费者”手中的。自由软件社区已经证实了事情并非如此。软件企业确实存在，并且不同的企业开发自由和/或私有软件，但那些开发自由软件的企业并不是像工厂那样运营的。

“工业”一词正在被软件专利的倡导者用作一种鼓吹。他们将软件开发称为“工业”，然后试图争论这意味着它也应该受到专利垄断权的支配。欧洲议会于 2003 年拒绝软件专利，并且通过表决，将“工业”一词定义为“实物商品的自动化生产”[^wordtoavoid-29]。

### 源代码模型（Source Model）

维基百科（Wikipedia）以一种使人混淆的方式使用“源代码模型”这一概念。从表面看，它指的是程序的源代码如何分发，但其文本将这一概念与开发方法论混淆起来。它将区分“开放源代码”和“共享源代码”作为答案，但它们是重叠的——微软将后者作为一种市场概念以覆盖一系列实践，其中的一些也是“开放源代码”的。因此，这一概念实际上未能传达任何合乎逻辑的信息，但它却为连篇累牍地把自由软件描述为“开源”提供了机会。

### 终端（Terminal）

移动电话和平板设备是计算机，并且人们应当被允许在它们上面使用自由软件以进行他们的计算。将它们称为“终端”暗示它们仅仅适合于连接到服务器，这是您操控自己计算的一种坏方式。

### 盗窃（Theft）

那些支持过于严格和专制版权制度的支持者，通常使用诸如“盗版”或者“盗窃”这样的词语来指代侵犯版权的行为。这是一种偏见，但是它们希望您将其作为客观事实而接受。

在美国法律体系中，版权侵犯并不属于盗窃。适用于盗窃的法律并不适用于版权侵犯。专制性的版权制度的支持者正在请求权力机构——并且错误地解读权力机构所说的话[^wordtoavoid-30]，阐明了什么才能被恰当地描述为“版权盗窃”。

非授权复制在很多情况下（不是全部！）被版权法所禁止，但是被禁止并不意味着它是错误的。从普遍意义上说，法律并不定义正确与错误。法律充其量只能试图实施公正。如果法律（实现）不能适应我们的是非观（具体），那么这样的法律就应该被改变。

一位主持了一场版权侵犯审判的美国法官认可“盗版”和“盗窃”属于诽谤性的词语[^wordtoavoid-26]。

### 信任计算（Trusted Computing）

“信任计算”是其倡导者所起的名字，用于指代这样一种重新设计计算机的阴谋，这使得应用程序开发者可以信任您的计算机将会服从他们而非您[^wordtoavoid-32]。从他们的角度看，这是“信任”；从您的角度看，这是“背叛”。

### 供应商（Vendor）

请不要使用“供应商”一词一般性地指代任何开发或者打包软件的人。很多程序被开发的目的是贩卖其副本并且它们的开发者自然也是其供应商；这甚至也包括部分自由软件包。然而，很多程序是由志愿者或者并非致力于贩卖副本的组织开发的。这些开发者不是供应商。类似地，只有部分 GNU/Linux 发行版的打包者是供应商，我们建议使用“提供者”（supplier）这一通用性的概念。



 [^wordtoavoid-1]: 参见《什么是自由软件？》以获得自由软件的完整定义。

 [^wordtoavoid-2]: 参见《如今自由软件更加重要》和《服务器真正是在为谁服务？》以获得更多信息。

 [^wordtoavoid-3]: 参见 “The BSD License Problem” 一文，位于<http://gnu.org/philosophy/bsd.html>。

 [^wordtoavoid-4]: 参见 “Various Licenses and Comments about Them”，位于<http://gnu.org/licenses/license-list.html>。

 [^wordtoavoid-5]: 参见《为什么说开源漏掉了自由软件的要点》。

 [^wordtoavoid-6]: 参见《自由与非自由软件的分类》以获得关于私有软件的更多信息。

 [^wordtoavoid-7]: John Harris，“Why Hackers and Spooks Want Our Heads in the Cloud”，2011 年四月 25 日，[http://guardian.co.uk/commentisfree/2011/apr/25/hackers-spooks-cloud-antiauthoritarian-dream](http://guardian.co.uk/commentisfree/2011/apr/25/hackers-spooks-cloud-antiauthoritarian-dream)。

 [^wordtoavoid-8]: 参见《服务器真正是在为谁服务？》以获得关于此问题的更多信息。

 [^wordtoavoid-9]: Peter Mell 和 Anthony Grance，“The NIST Definition of Cloud Computing: Recommendations of the National Institute of Standards and Technology”，NIST Special Publication 800-145 (2011 年九月)，[http://csrc.nist.gov/publications/nistpubs/800-145/SP800-145.pdf](http://csrc.nist.gov/publications/nistpubs/800-145/SP800-145.pdf)。

 [^wordtoavoid-10]: Dan Farber，“Oracle’s Ellison Nails Cloud Computing”，2008 年九月 26 日，<http://news.cnet.com/8301-13953_3-10052188-80.html>。 

 [^wordtoavoid-11]: 参见《对版权的错误解读——一系列错误》 一文以获得关于此问题的更多信息。

 [^wordtoavoid-12]: Lara O’Reilly，“A Former Googler Has Declared War on Ad Blockers with a New Startup That Tackles Them in an Unorthodox Way”，2015 年六月 18 日，[http://uk.businessinsider.com/former-google-exec-launches-sourcepoint-with-10-million-series-a-funding-
 2015-6?r=US&IR=T](http://uk.businessinsider.com/former-google-exec-launches-sourcepoint-with-10-million-series-a-funding-2015-6?r=US&IR=T)。

 [^wordtoavoid-13]: 参见《如今自由软件更加重要》一文以获得关于此问题的更多信息。

 [^wordtoavoid-14]: Owen Hatherley，“Be a User, Not a Consumer: How Capitalism Has Changed Our Language”，2013 年八月 11 日，[http://theguardian.com/commentisfree/2013/aug/11/capitalism-language-raymond-williams](http://theguardian.com/commentisfree/2013/aug/11/capitalism-language-raymond-williams)。

 [^wordtoavoid-15]: 美国摇滚音乐家 Courtney Love 于 2000 年五月 16 日在数字好莱坞在线娱乐会议上的演讲的未编辑抄本可以在此找到：<http://www.salon.com/2000/06/14/love_7/>。

 [^wordtoavoid-16]: 参见《您说过“知识产权”吗？这是一种迷惑性的幻景》获知这一问题的原因。

 [^wordtoavoid-17]:  Cory Doctorow，“Encryption Won’t Work If It Has a Back Door Only the ‘Good Guys’ Have Keys To”，2015 年五月 1 日，[http://theguardian.com/technology/2015/may/01/encryption-wont-work-if-it-has-a-back-door-only-the-good-guys-have-keys-to-](http://theguardian.com/technology/2015/may/01/encryption-wont-work-if-it-has-a-back-door-only-the-good-guys-have-keys-to-)。

 [^wordtoavoid-18]: 参见 <http://www.gnu.org/philosophy/floss-and-foss.html> 以获得关于此问题的更多信息。

 [^wordtoavoid-19]: 参见上一条脚注。

 [^wordtoavoid-20]: “DuckDuckGo Privacy Policy”，最后更新于 2012 年四月 12 日，<https://duckduckgo.com/privacy>。

 [^wordtoavoid-21]: 参见我的文章 “On Hacking”，位于<http://stallman.org/articles/on-hacking.html>。

 [^wordtoavoid-22]: Richard Stallman，“Public Awareness of Copyright, WIPO, June 2002”，最后更新于 2014 年，[http://gnu.org/philosophy/wipo-PublicAwarenessOfCopyright-2002.html](http://gnu.org/philosophy/wipo-PublicAwarenessOfCopyright-2002.html)。

 [^wordtoavoid-23]: 参见《Linux 和 GNU 操作系统》一文以获知 GNU/Linux 操作系统的更多历史背景，由于它与本文所提到的命名问题相关。

 [^wordtoavoid-24]: 参见《为什么说开源漏掉了自由软件的要点》以获得完整解释。

 [^wordtoavoid-25]: 参见 <http://directory.fsf.org/wiki/GIMP>。

 [^wordtoavoid-26]: Ernesto Van der Sar，“MPAA Banned from Using Piracy and Theft Terms in Hotfile Trial”，2013 年十一月 29 日，[http://torrentfreak.com/mpaa-banned-from-using-piracy-and-theft-terms-in-hotfile-trial-131129](http://torrentfreak.com/mpaa-banned-from-using-piracy-and-theft-terms-in-hotfile-trial-131129)。

 [^wordtoavoid-27]: “软件，作为恶意的”之意。

 [^wordtoavoid-28]: 参见这份说明以获得更多信息 <http://gnu.org/proprietary/proprietary-surveillance.html\#SpywareInSkype>。

 [^wordtoavoid-29]: 欧洲议会，“Directive on the Patentability of Computer-Implemented Inventions”，2003 年九月 24 日，[http://web.archive.org/web/20071222001014/http://www.swpat.ffii.org/papers/europarl0309](http://web.archive.org/web/20071222001014/http://www.swpat.ffii.org/papers/europarl0309)。

 [^wordtoavoid-30]: 为了驳斥他们，您可以援引这一真实案例：Harper Lee 起诉她的代理人涉嫌诱骗她将 To Kill a Mockingbird 一书的版权指认给他。

[^wordtoavoid-32]: 参见《您能够信任您的计算机吗？》以获得关于此问题的更多信息。

