#Installation Process

## Dependencies of the qualitytest program

* **Qt5** developer files.
* **Opencv-2.4.13.2** or any in the family 2.X. (this code currently has some incompatibilities with 3.X family.)

## Building the project in Windows

For compile the **qualitytest.exe** program in windows we need:

1. Download **opencv-2.4.13.2** source code for Windows from http://opencv.org/downloads.html and uncompress (by example) in `c:\\` drive, so that the final installation directory will be `c:/opencv-2.4.13.2`.
2. Download **qtcreator** (qt-opensource-windows-x86-mingw530-5.8.0.exe) from https://www.qt.io/download-open-source/ and install in `C:\`.
3. Compile **opencv-2.4.13.2** source code with  **mingw** tool chain of **qt-creator** program, these are located in `C:\Qt\Qt5.8.0\Tools\mingw530_32\bin`, the **Opencv-2.4.13.2** code need the **CMake** program to be prepared, thus you need download it. The compiled source code should be located in `C:\OpenCV`.
4. Open **qtcreator** select the `qualitytest.pro` file and **Build all**. With this process you got the **qualitytest.exe** program file. Or:
    ./makewin.bat

### Compiling the source code of OpenCV
(info source:https://zahidhasan.wordpress.com/2014/08/19/qt-5-3-1-64-bit-mingw-windows/)

1. Open path editor and set the following two folder into system variable. `C:\Qt\Qt5.8.0\Tools\mingw530_32\bin` and `C:\Program Files\CMake\bin`
2. Open cmake-gui, set source path to `c:/opencv-2.4.13.2` and binary path to `C:\OpenCV`
3. Hit **configure** button. A pop up window will open and the from drop-down menu select **MinGW Makefiles** and press next. There you have to select c and c++ compilers which would be found in bin folder `C:\Qt\Qt5.8.0\Tools\mingw530_32\bin`. And finally press **generate** button.
4. Now open command prompt go to `C:\OpenCV`. Type: mingw32–make 
5. Now type: mingw32–make install

## Directory hierarchy

For the **qualitytest.exe** program works correctly, only are necessary the **qualitytest.exe** program and the **shared** directory, so that these fulfill the next directory hierarchy:

    ./win/  qualitytest.nsi

    ./bin/  qualitytest.exe
            libgcc_s_dw2-1.dll
            libstdc++-6.dll
            libwinpthread-1.dll
            Qt5Widgets.dll
            Qt5Core.dll
            Qt5Gui.dll
            libopencv_core2413.dll
            libopencv_video2413.dll
            libopencv_highgui2413.dll
            libopencv_imgproc2413.dll

            
    ./bin/platforms/qwindows.dll
    
    ./share/doc/qualitytest/    SpeckleQualityTestV1.0-UserGuide.pdf
                                SpeckleQualityTestV1.0-UserGuide.docx
    
    ./share/qualitytest/icons/  about.png
                                help.png
                                save.png
                                sqt_icon.ico
                                sqt_icon.png

    ./share/qualitytest/img/    contrast_scale.jpg
                                homogeneity_scale.jpg
                                Saturation_scale.jpg

    ./share/applications/       qualitytest.desktop


The `*.dll` files in `bin` can be found in `C:\Qt\Qt5.8.0\5.8\mingw53_32\bin` or `C:/OpenCV/install/x86/mingw/bin` or `C:\Qt\Qt5.8.0\5.8\mingw53_32\plugins\`


