#include "saveimagesequenceinterface.h"
#include "ui_saveimagesequenceinterface.h"

#include <QFileDialog>
#include <QDir>

SaveImageSequenceInterface::SaveImageSequenceInterface(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SaveImageSequenceInterface)
{
    ui->setupUi(this);
    ui->location_lineEdit->setText(QDir::currentPath());
    setWindowIcon(QIcon("icons/document-save-as.png"));
}

SaveImageSequenceInterface::~SaveImageSequenceInterface()
{
    delete ui;
}

void SaveImageSequenceInterface::on_location_pushButton_clicked()
{
    aux = QFileDialog::getExistingDirectory(this,
                                                tr("Select Folder"),
                                                QDir::currentPath());
    ui->location_lineEdit->setText(aux);
}

QString SaveImageSequenceInterface::getLocation()
{
    return ui->location_lineEdit->text();
}

int SaveImageSequenceInterface::getNumImage()
{
    return ui->numberImage_spinBox->value();
}
