/************************************************************************\
 * Magic Square solves magic squares.                                   *
 * Copyright (C) 2019  Asher Gordon <AsDaGo@posteo.net>                 *
 *                                                                      *
 * This file is part of Magic Square.                                   *
 *                                                                      *
 * Magic Square is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * Magic Square is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with Magic Square.  If not, see                                *
 * <https://www.gnu.org/licenses/>.                                     *
\************************************************************************/

/* debug.h -- print debugging message when we receive a signal that
   indicates a bug */

#ifndef _DEBUG_H
#define _DEBUG_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <signal.h>

/* Which signals to print a debug message on */
extern const int debug_signals[];
extern const size_t debug_signals_entries;

void __attribute__((__noreturn__)) debug_abort (int);

#endif /* !_DEBUG_H */
