/************************************************************************\
 * Magic Square solves magic squares.                                   *
 * Copyright (C) 2019  Asher Gordon <AsDaGo@posteo.net>                 *
 *                                                                      *
 * This file is part of Magic Square.                                   *
 *                                                                      *
 * Magic Square is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * Magic Square is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with Magic Square.  If not, see                                *
 * <https://www.gnu.org/licenses/>.                                     *
\************************************************************************/

/* sig2str.c -- convert signal numbers to names */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stddef.h> /* For NULL */
#include <signal.h> /* For signal definitions */

/* Convert `signum' to a signal name (without the leading
   "SIG"). Returns the signal name on success, NULL on error.

   Currently this only implements the signals in `debug_signals' (see
   debug.c) since those are the only ones we need. */
char *sig2str(int signum) {
  switch (signum) {
#ifdef SIGABRT
  case SIGABRT:
    return "ABRT";
#endif
#ifdef SIGBUS
  case SIGBUS:
    return "BUS";
#endif
#ifdef SIGFPE
  case SIGFPE:
    return "FPE";
#endif
#ifdef SIGILL
  case SIGILL:
    return "ILL";
#endif
#ifdef SIGSEGV
  case SIGSEGV:
    return "SEGV";
#endif
#ifdef SIGSTKFLT
  case SIGSTKFLT:
    return "STKFLT";
#endif
#ifdef SIGSYS
  case SIGSYS:
    return "SYS";
#endif
  default:
    return NULL;
  }
}
