/*
	This file is part of Reindeer-OpenGL.

	Copyright (C) 2008, 2009, 2010 - Patrik Olsson

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "opengl.h"
#include "conversion.h"
#include "color.h"

void
REN_IMPL_MANGLE(object_render) (RenReindeer *r, RenObject *object)
{
	RenTemplate *template;
	RenVectorArray *coord_array;
	RenColorArray *color_array;
	RenVectorArray *normal_array;
	ren_object_data (object, &template,
		&coord_array, &color_array, &normal_array);

	RenReindeerBackData *back_data = ren_reindeer_back_data (r);
	ren_uint32 prev_mode = back_data->prev_mode;
	ren_uint32 mode;

	RenIndexArray *ix_array;
	ren_size num_primitives;
	const RenTemplatePrimitive *primitives;
	ren_template_data_primitives (template,
		&ix_array, &num_primitives, &primitives);

	if (back_data->prev_object != object)
	{
		back_data->prev_object = object;

		REN_IMPL_MANGLE(coord_array_bind) (r, coord_array);
		REN_IMPL_MANGLE(color_array_bind) (r, color_array);
		REN_IMPL_MANGLE(normal_array_bind) (r, normal_array);

		RenTemplate *prev_template = back_data->prev_template;
		if (prev_template != template)
		{
			mode = primitives[0].mode;
			ren_object_begin_mode (r, prev_template, prev_mode, object, mode, NULL/*TODO: user_data*/);
			prev_mode = mode;
			back_data->prev_template = template;
		}
	}

	gint i;
	for (i = 0; i < num_primitives; ++i)
	{
		const RenTemplatePrimitive *primitive = &primitives[i];
		mode = primitive->mode;
		if (mode != prev_mode)
		{
			ren_object_change_mode (r, object, prev_mode, mode, NULL/*TODO: user_data*/);
			prev_mode = mode;
		}
		ren_size vxcount = ren_primitive_vertex_count (primitive->prim, primitive->count);
		GLenum glprim = convert_ren_prim_to_gl_prim (primitive->prim);
		if (ix_array != NULL)
		{
			RenType type;
			RenDataBlock* datablock;
			ren_size start;
			const void *data;
			ren_index_array_data (ix_array, &type, &datablock, &start, NULL);
			ren_data_block_data (datablock, &data, NULL, NULL);
			GLenum ixtype = convert_ren_type_to_gl_type (type);
			const void *ixdata = data + (primitive->offset + start) * opengl_type_sizeof (ixtype);
			glDrawElements (glprim, vxcount, ixtype, ixdata);
		}
		else
			glDrawArrays (glprim, primitive->offset, vxcount);
	}
	back_data->prev_mode = mode;
}

REN_IMPL_MANGLE(object_change_material) (RenReindeer *r,
	RenMaterial *front, RenMaterial *back, void *user_data)
{
	REN_IMPL_MANGLE(material_bind) (r, front, back);
}
