/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import org.apache.avalon.excalibur.collections.Buffer;
import org.apache.avalon.excalibur.collections.BufferOverflowException;
import org.apache.avalon.excalibur.collections.BufferUnderflowException;

public final class FixedSizeBuffer
implements Buffer {
    private final Object[] m_elements;
    private int m_start = 0;
    private int m_end = 0;
    private boolean m_full = false;

    public FixedSizeBuffer(int size) {
        this.m_elements = new Object[size];
    }

    public FixedSizeBuffer() {
        this(32);
    }

    public final int size() {
        int size = 0;
        size = this.m_end < this.m_start ? this.m_elements.length - this.m_start + this.m_end : (this.m_end == this.m_start ? (this.m_full ? this.m_elements.length : 0) : this.m_end - this.m_start);
        return size;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final void add(Object element) {
        if (null == element) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.m_full) {
            throw new BufferOverflowException("The buffer cannot hold more than " + this.m_elements.length + " objects.");
        }
        this.m_elements[this.m_end++] = element;
        if (this.m_end >= this.m_elements.length) {
            this.m_end = 0;
        }
        if (this.m_end == this.m_start) {
            this.m_full = true;
        }
    }

    public final Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object element = this.m_elements[this.m_start];
        if (null != element) {
            this.m_elements[this.m_start++] = null;
            if (this.m_start >= this.m_elements.length) {
                this.m_start = 0;
            }
            this.m_full = false;
        }
        return element;
    }
}

