/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import org.apache.avalon.excalibur.collections.Buffer;
import org.apache.avalon.excalibur.collections.BufferUnderflowException;

public final class VariableSizeBuffer
implements Buffer {
    protected Object[] m_buffer;
    protected int m_head;
    protected int m_tail;

    public VariableSizeBuffer(int size) {
        this.m_buffer = new Object[size + 1];
        this.m_head = 0;
        this.m_tail = 0;
    }

    public VariableSizeBuffer() {
        this(32);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final int size() {
        int size = 0;
        size = this.m_tail < this.m_head ? this.m_buffer.length - this.m_head + this.m_tail : this.m_tail - this.m_head;
        return size;
    }

    public final void add(Object o) {
        if (null == o) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() + 1 >= this.m_buffer.length) {
            Object[] tmp = new Object[(this.m_buffer.length - 1) * 2 + 1];
            int j = 0;
            int i = this.m_head;
            while (i != this.m_tail) {
                tmp[j] = this.m_buffer[i];
                this.m_buffer[i] = null;
                ++j;
                if (++i != this.m_buffer.length) continue;
                i = 0;
            }
            this.m_buffer = tmp;
            this.m_head = 0;
            this.m_tail = j;
        }
        this.m_buffer[this.m_tail] = o;
        ++this.m_tail;
        if (this.m_tail >= this.m_buffer.length) {
            this.m_tail = 0;
        }
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object element = this.m_buffer[this.m_head];
        if (null != element) {
            this.m_buffer[this.m_head] = null;
            ++this.m_head;
            if (this.m_head >= this.m_buffer.length) {
                this.m_head = 0;
            }
        }
        return element;
    }
}

