/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Driver;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.Statement;

public abstract class Connection {
    MysqlIO _IO = null;
    private boolean _isClosed = true;
    private String _Host = null;
    private int _port = 3306;
    private String _User = null;
    private String _Password = null;
    protected String _Database = null;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private boolean _do_unicode = false;
    private String _Encoding = null;
    private String _MyURL = null;
    private int _max_rows = -1;
    private boolean _max_rows_changed = false;
    private Driver _MyDriver;
    private Hashtable _ServerVariables = null;
    private int _max_allowed_packet = 65536;
    private int _net_buffer_length = 16384;
    private boolean _use_fast_ping = false;
    private boolean _high_availability = false;
    private int _max_reconnects = 3;
    private double _initial_timeout = 2.0;
    private static final String _PING_COMMAND = "SELECT 1";
    private boolean transactionsSupported = false;
    private boolean relaxAutoCommit = false;
    protected boolean useUltraDevWorkAround = false;
    private boolean hasIsolationLevels = false;
    private boolean capitalizeDBMDTypes = false;
    private int isolationLevel = 2;
    private static Hashtable _mapTransIsolationName2Value = null;

    /*
     * Loose catch block
     */
    public void connectionInit(String string, int n, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        Object object;
        int n2;
        this._Host = string == null ? "localhost" : new String(string);
        this._port = n;
        if (string2 == null) {
            throw new SQLException("Malformed URL '" + string3 + "'.", "S1000");
        }
        this._Database = new String(string2);
        this._MyURL = new String(string3);
        this._MyDriver = driver;
        String string4 = properties.getProperty("user");
        String string5 = properties.getProperty("password");
        this._User = string4 == null || string4.equals("") ? "nobody" : new String(string4);
        this._Password = string5 == null ? "" : new String(string5);
        if (properties.getProperty("relaxAutocommit") != null) {
            this.relaxAutoCommit = properties.getProperty("relaxAutocommit").toUpperCase().equals("TRUE");
        }
        if (properties.getProperty("autoReconnect") != null) {
            this._high_availability = properties.getProperty("autoReconnect").toUpperCase().equals("TRUE");
        }
        if (properties.getProperty("capitalizeTypeNames") != null) {
            this.capitalizeDBMDTypes = properties.getProperty("capitalizeTypeNames").toUpperCase().equals("TRUE");
        }
        if (properties.getProperty("ultraDevHack") != null) {
            this.useUltraDevWorkAround = properties.getProperty("ultraDevHack").toUpperCase().equals("TRUE");
        }
        if (this._high_availability) {
            if (properties.getProperty("maxReconnects") != null) {
                try {
                    this._max_reconnects = n2 = Integer.parseInt(properties.getProperty("maxReconnects"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + properties.getProperty("maxReconnects") + "' for maxReconnects", "0S100");
                }
            }
            if (properties.getProperty("initialTimeout") != null) {
                try {
                    double d;
                    this._initial_timeout = d = (double)Integer.parseInt(properties.getProperty("initialTimeout"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + properties.getProperty("initialTimeout") + "' for initialTimeout", "0S100");
                }
            }
        }
        if (properties.getProperty("maxRows") != null) {
            try {
                n2 = Integer.parseInt(properties.getProperty("maxRows"));
                if (n2 == 0) {
                    n2 = -1;
                }
                this._max_rows = n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Illegal parameter '" + properties.getProperty("maxRows") + "' for maxRows", "0S100");
            }
        }
        if (properties.getProperty("useUnicode") != null) {
            String string6 = properties.getProperty("useUnicode").toUpperCase();
            if (string6.startsWith("TRUE")) {
                this._do_unicode = true;
            }
            if (properties.getProperty("characterEncoding") != null) {
                this._Encoding = properties.getProperty("characterEncoding");
                try {
                    object = "abc";
                    ((String)object).getBytes(this._Encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("Unsupported character encoding '" + this._Encoding + "'.", "0S100");
                }
            }
        }
        try {
            block43: {
                block44: {
                    SQLException sQLException2222;
                    Statement statement;
                    block42: {
                        this._IO = this.createNewIO(string, n);
                        this._IO.init(this._User, this._Password);
                        if (this._Database.length() != 0) {
                            this._IO.sendCommand(2, this._Database, null);
                        }
                        this._isClosed = false;
                        this._ServerVariables = new Hashtable();
                        if (this._IO.versionMeetsMinimum(3, 22, 1)) {
                            this._use_fast_ping = true;
                        }
                        if (!this._IO.versionMeetsMinimum(3, 21, 22)) break block43;
                        statement = null;
                        object = null;
                        statement = (Statement)((Object)this.createStatement());
                        object = (ResultSet)((Object)statement.executeQuery("SHOW VARIABLES"));
                        while (((ResultSet)object).next()) {
                            this._ServerVariables.put(((ResultSet)object).getString(1), ((ResultSet)object).getString(2));
                        }
                        Object var13_20 = null;
                        if (object == null) break block42;
                        try {
                            ((ResultSet)object).close();
                        }
                        catch (SQLException sQLException2222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException2222) {}
                    }
                    break block44;
                    {
                        catch (SQLException sQLException3) {
                            throw sQLException3;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException sQLException42222;
                        Object var13_21 = null;
                        if (object != null) {
                            try {
                                ((ResultSet)object).close();
                            }
                            catch (SQLException sQLException42222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException42222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                if (this._ServerVariables.containsKey("max_allowed_packet")) {
                    this._max_allowed_packet = Integer.parseInt((String)this._ServerVariables.get("max_allowed_packet"));
                }
                if (this._ServerVariables.containsKey("net_buffer_length")) {
                    this._net_buffer_length = Integer.parseInt((String)this._ServerVariables.get("net_buffer_length"));
                }
                this.checkTransactionIsolationLevel();
                this.checkServerEncoding();
            }
            this.transactionsSupported = this._IO.versionMeetsMinimum(3, 23, 15);
            this.hasIsolationLevels = this._IO.versionMeetsMinimum(3, 23, 36);
            this._IO.resetMaxBuf();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot connect to MySQL server on " + this._Host + ":" + this._port + ". Is there a MySQL server running on the machine/port you are trying to connect to? (" + exception.getClass().getName() + ")", "08S01");
        }
    }

    public boolean capitalizeDBMDTypes() {
        return this.capitalizeDBMDTypes;
    }

    public boolean supportsTransactions() {
        return this.transactionsSupported;
    }

    public boolean supportsIsolationLevel() {
        return this.hasIsolationLevels;
    }

    public abstract java.sql.Statement createStatement() throws SQLException;

    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("Callable statments not supported.", "S1C00");
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.transactionsSupported) {
            String string = "SET autocommit=" + (bl ? "1" : "0");
            this.execSQL(string, -1);
            this._autoCommit = bl;
        } else {
            if (!bl && !this.relaxAutoCommit) {
                throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003");
            }
            this._autoCommit = bl;
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    public synchronized void commit() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Commit attempt on closed connection.", "08003");
        }
        if (this._autoCommit && !this.relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true");
        }
        if (this.transactionsSupported) {
            this.execSQL("commit", -1);
        }
    }

    public void rollback() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Rollback attempt on closed connection.", "08003");
        }
        if (this._autoCommit && !this.relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true", "08003");
        }
        if (this.transactionsSupported) {
            this.execSQL("rollback", -1);
        }
    }

    public synchronized void close() throws SQLException {
        if (this._IO != null) {
            try {
                this._IO.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._IO = null;
        }
        this._isClosed = true;
    }

    public synchronized boolean isClosed() throws SQLException {
        if (!this._isClosed) {
            try {
                MysqlIO mysqlIO = this._IO;
                synchronized (mysqlIO) {
                    this.ping();
                }
            }
            catch (Exception exception) {
                this._isClosed = true;
            }
        }
        return this._isClosed;
    }

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this._readOnly = bl;
    }

    public synchronized boolean isReadOnly() throws SQLException {
        return this._readOnly;
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.execSQL("USE " + string, -1);
        this._Database = string;
    }

    public synchronized String getCatalog() throws SQLException {
        return this._Database;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        StringBuffer stringBuffer;
        if (this.hasIsolationLevels) {
            stringBuffer = new StringBuffer("SET SESSION TRANSACTION ISOLATION LEVEL ");
            switch (n) {
                case 0: {
                    throw new SQLException("Transaction isolation level NONE not supported by MySQL");
                }
                case 2: {
                    stringBuffer.append("READ COMMITTED");
                    break;
                }
                case 1: {
                    stringBuffer.append("READ UNCOMMITTED");
                    break;
                }
                case 4: {
                    stringBuffer.append("REPEATABLE READ");
                    break;
                }
                case 8: {
                    stringBuffer.append("SERIALIZABLE");
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level '" + n + "'", "S1C00");
                }
            }
        } else {
            throw new SQLException("Transaction Isolation Levels are not supported on MySQL versions older than 3.23.36.", "S1C00");
        }
        this.execSQL(stringBuffer.toString(), -1);
        this.isolationLevel = n;
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
    }

    public void finalize() throws Throwable {
        if (this._IO != null && !this.isClosed()) {
            this.close();
        } else if (this._IO != null) {
            this._IO.forceClose();
        }
    }

    private void ping() throws Exception {
        if (this._use_fast_ping) {
            this._IO.sendCommand(14, null, null);
        } else {
            this._IO.sqlQuery(_PING_COMMAND, 50000000);
        }
    }

    ResultSet execSQL(String string, int n) throws SQLException {
        return this.execSQL(string, n, null);
    }

    /*
     * Unable to fully structure code
     */
    ResultSet execSQL(String var1_1, int var2_2, Buffer var3_3) throws SQLException {
        var4_4 = this._IO;
        synchronized (var4_4) {
            block23: {
                if (this._high_availability) {
                    try {
                        this.ping();
                        break block23;
                    }
                    catch (Exception var5_5) {
                        var6_8 = this._initial_timeout;
                        var8_12 = false;
                        var9_14 = 0;
                        ** while (var9_14 < this._max_reconnects)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            try {
                                this._IO.forceClose();
                            }
                            catch (Exception var10_16) {
                                // empty catch block
                            }
                            this._IO = this.createNewIO(this._Host, this._port);
                            this._IO.init(this._User, this._Password);
                            if (this._Database.length() != 0) {
                                this._IO.sendCommand(2, this._Database, null);
                            }
                            if (this._use_fast_ping) {
                                this._IO.sendCommand(14, null, null);
                            } else {
                                this._IO.sqlQuery("SELECT 1", 50000000);
                            }
                            var8_12 = true;
                            break;
                        }
                        catch (Exception var10_17) {
                            try {
                                Thread.currentThread();
                                Thread.sleep((long)var6_8 * 1000L);
                                var6_8 *= var6_8;
                            }
                            catch (InterruptedException var10_18) {
                                // empty catch block
                            }
                            ++var9_14;
                        }
                        continue;
                    }
lbl43:
                    // 2 sources

                    if (!var8_12) {
                        throw new SQLException("Server connection failure during transaction. \nAttemtped reconnect " + this._max_reconnects + " times. Giving up.", "08001");
                    }
                }
            }
            try {
                v0 = var5_6 = var2_2 == -1 ? 50000000 : var2_2;
                if (var3_3 == null) {
                    var6_9 = null;
                    if (this.useUnicode()) {
                        var6_9 = this.getEncoding();
                    }
                    var7_20 = this._IO.sqlQuery(var1_1, var5_6, var6_9, this);
                    return var7_20;
                }
                var6_10 = this._IO.sqlQueryDirect(var3_3, var5_6, this);
                return var6_10;
            }
            catch (EOFException var5_7) {
                throw new SQLException("Lost connection to server during query", "08007");
            }
            catch (SQLException var6_11) {
                throw var6_11;
            }
            catch (Exception var7_21) {
                var8_13 = var7_21.getClass().getName();
                var9_15 = var7_21.getMessage();
                throw new SQLException("Error during query: Unexpected Exception: " + var8_13 + " message given: " + var9_15, "S1000");
            }
        }
    }

    protected abstract MysqlIO createNewIO(String var1, int var2) throws Exception;

    String getURL() {
        return this._MyURL;
    }

    String getUser() {
        return this._User;
    }

    String getServerVersion() {
        return this._IO.getServerVersion();
    }

    int getServerMajorVersion() {
        return this._IO.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this._IO.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this._IO.getServerSubMinorVersion();
    }

    synchronized void maxRowsChanged() {
        this._max_rows_changed = true;
    }

    synchronized boolean useMaxRows() {
        return this._max_rows_changed;
    }

    public boolean useUnicode() {
        return this._do_unicode;
    }

    public String getEncoding() {
        return this._Encoding;
    }

    Object getMutex() throws SQLException {
        if (this._IO == null) {
            throw new SQLException("Connection.close() has already been called. Invalid operation in this state.", "08003");
        }
        return this._IO;
    }

    int getMaxAllowedPacket() {
        return this._max_allowed_packet;
    }

    int getNetBufferLength() {
        return this._net_buffer_length;
    }

    protected MysqlIO getIO() {
        return this._IO;
    }

    private void checkServerEncoding() throws SQLException {
        if (this.useUnicode() && this.getEncoding() == null) {
            this._Encoding = (String)this._ServerVariables.get("character_set");
            if (this._Encoding != null) {
                Object object;
                if (Character.isLowerCase(this._Encoding.charAt(0))) {
                    object = this._Encoding.toCharArray();
                    object[0] = Character.toUpperCase(this._Encoding.charAt(0));
                    this._Encoding = new String((char[])object);
                }
                try {
                    object = "abc";
                    ((String)object).getBytes(this._Encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this._Encoding = null;
                }
            }
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer n;
        String string = (String)this._ServerVariables.get("transaction_isolation");
        if (string != null && (n = (Integer)_mapTransIsolationName2Value.get(string)) != null) {
            this.isolationLevel = n;
        }
    }

    static {
        _mapTransIsolationName2Value = new Hashtable(8);
        _mapTransIsolationName2Value.put("READ-UNCOMMITED", new Integer(1));
        _mapTransIsolationName2Value.put("READ-COMMITTED", new Integer(2));
        _mapTransIsolationName2Value.put("REPEATABLE-READ", new Integer(4));
        _mapTransIsolationName2Value.put("SERIALIZABLE", new Integer(8));
    }
}

