/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class RequestOutputStream
extends OutputStream {
    private static final Log wireLog = LogSource.getInstance("httpclient.wire");
    private boolean closed = false;
    private OutputStream stream = null;
    private boolean useChunking = false;
    private boolean writingChunk = false;
    private static final byte[] endChunk = new byte[]{13, 10};
    private static final byte[] crlf = new byte[]{13, 10};
    private static final byte[] zero = new byte[]{48};
    private static final byte[] one = new byte[]{49};

    public RequestOutputStream(OutputStream stream) {
        this(stream, false);
    }

    public RequestOutputStream(OutputStream stream, boolean useChunking) {
        if (stream == null) {
            throw new NullPointerException("stream parameter is null");
        }
        this.stream = stream;
        this.useChunking = useChunking;
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.write(s.charAt(i));
            ++i;
        }
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void write(int b) throws IOException {
        if (this.useChunking) {
            this.stream.write(one, 0, one.length);
            this.stream.write(crlf, 0, crlf.length);
            this.stream.write(b);
            this.stream.write(endChunk, 0, endChunk.length);
            if (wireLog.isInfoEnabled()) {
                wireLog.info(">> byte 1 \\r\\n (chunk length \"header\")");
                wireLog.info(">> byte " + b + "\\r\\n (chunked byte)");
            }
        } else {
            this.stream.write(b);
            if (wireLog.isInfoEnabled()) {
                wireLog.info(">> byte " + b);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.useChunking) {
            byte[] chunkHeader = (Integer.toHexString(len) + "\r\n").getBytes();
            this.stream.write(chunkHeader, 0, chunkHeader.length);
            this.stream.write(b, off, len);
            this.stream.write(endChunk, 0, endChunk.length);
            if (wireLog.isInfoEnabled()) {
                wireLog.info(">> byte(s)" + len + " \\r\\n (chunk length \"header\")");
                wireLog.info(">> \"" + new String(b, off, len) + "\"\\r\\n (chunked bytes)");
            }
        } else {
            this.stream.write(b, off, len);
            if (wireLog.isInfoEnabled() && len > 0) {
                wireLog.info(">> \"" + new String(b, off, len) + "\"");
            }
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.useChunking) {
                    this.stream.write(zero, 0, zero.length);
                    this.stream.write(crlf, 0, crlf.length);
                    this.stream.write(endChunk, 0, endChunk.length);
                    if (wireLog.isInfoEnabled()) {
                        wireLog.info(">> byte 0 \\r\\n\\r\\n (final chunk)");
                    }
                }
                super.close();
                Object var3_1 = null;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.closed = true;
                throw throwable;
            }
        }
    }
}

