/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xmlizer.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractXMLizer
extends AbstractLogEnabled
implements XMLizer,
ThreadSafe,
Serviceable {
    private final String m_mimeType;
    private Parser m_parser;

    protected AbstractXMLizer(String mimeType) {
        this.m_mimeType = mimeType;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_parser = (Parser)manager.lookup(Parser.ROLE);
    }

    public void toSAX(InputStream stream, String mimeType, String systemID, ContentHandler handler) throws SAXException, IOException {
        if (null == stream) {
            throw new NullPointerException("stream");
        }
        if (null == handler) {
            throw new NullPointerException("handler");
        }
        if (null == mimeType) {
            if (this.getLogger().isDebugEnabled()) {
                String message = "No mime-type for xmlizing " + systemID + ", guessing text/html";
                this.getLogger().debug(message);
            }
        } else if (!mimeType.equalsIgnoreCase(this.m_mimeType) && this.getLogger().isDebugEnabled()) {
            String message = "Mime-type " + mimeType + "not supported for xmlizing " + systemID + ", guessing text/html";
            this.getLogger().debug(message);
        }
        this.toSAX(stream, systemID, handler);
    }

    protected abstract void toSAX(InputStream var1, String var2, ContentHandler var3) throws SAXException, IOException;

    protected Parser getParser() {
        return this.m_parser;
    }
}

