/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.NoRepaintRunnable;
import org.apache.batik.bridge.RepaintManager;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.UpdateTracker;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.RunnableQueue;
import org.w3c.dom.Document;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class UpdateManager
implements RunnableQueue.RunHandler {
    static final long MIN_REPAINT_TIME;
    protected BridgeContext bridgeContext;
    protected Document document;
    protected RunnableQueue updateRunnableQueue;
    protected boolean running;
    protected boolean suspendCalled;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected ScriptingEnvironment scriptingEnvironment;
    protected RepaintManager repaintManager;
    protected UpdateTracker updateTracker;
    protected GraphicsNode graphicsNode;
    protected boolean started;
    long lastRepaint = 0L;
    static EventDispatcher.Dispatcher startedDispatcher;
    static EventDispatcher.Dispatcher stoppedDispatcher;
    static EventDispatcher.Dispatcher suspendedDispatcher;
    static EventDispatcher.Dispatcher resumedDispatcher;
    static EventDispatcher.Dispatcher updateStartedDispatcher;
    static EventDispatcher.Dispatcher updateCompletedDispatcher;
    static EventDispatcher.Dispatcher updateFailedDispatcher;

    public static boolean isDynamicDocument(Document document) {
        return BaseScriptingEnvironment.isDynamicDocument(document);
    }

    public UpdateManager(BridgeContext bridgeContext, GraphicsNode graphicsNode, Document document) {
        this.bridgeContext = bridgeContext;
        this.bridgeContext.setUpdateManager(this);
        this.document = document;
        this.updateRunnableQueue = RunnableQueue.createRunnableQueue();
        this.updateRunnableQueue.setRunHandler(this);
        this.graphicsNode = graphicsNode;
        this.scriptingEnvironment = new ScriptingEnvironment(bridgeContext);
    }

    public synchronized void dispatchSVGLoadEvent() throws InterruptedException {
        this.scriptingEnvironment.loadScripts();
        this.scriptingEnvironment.dispatchSVGLoadEvent();
    }

    public void dispatchSVGZoomEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGZoomEvent();
    }

    public void dispatchSVGScrollEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGScrollEvent();
    }

    public void dispatchSVGResizeEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGResizeEvent();
    }

    public void manageUpdates(final ImageRenderer imageRenderer) {
        this.updateRunnableQueue.preemptLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    UpdateManager.this.running = true;
                    UpdateManager.this.updateTracker = new UpdateTracker();
                    RootGraphicsNode rootGraphicsNode = UpdateManager.this.graphicsNode.getRoot();
                    if (rootGraphicsNode != null) {
                        rootGraphicsNode.addTreeGraphicsNodeChangeListener(UpdateManager.this.updateTracker);
                    }
                    UpdateManager.this.repaintManager = new RepaintManager(imageRenderer);
                    UpdateManager.this.fireEvent(startedDispatcher, new UpdateManagerEvent(this, null, null));
                    UpdateManager.this.started = true;
                }
            }
        });
        this.updateRunnableQueue.resumeExecution();
    }

    public BridgeContext getBridgeContext() {
        return this.bridgeContext;
    }

    public RunnableQueue getUpdateRunnableQueue() {
        return this.updateRunnableQueue;
    }

    public RepaintManager getRepaintManager() {
        return this.repaintManager;
    }

    public UpdateTracker getUpdateTracker() {
        return this.updateTracker;
    }

    public Document getDocument() {
        return this.document;
    }

    public ScriptingEnvironment getScriptingEnvironment() {
        return this.scriptingEnvironment;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void suspend() {
        if (this.running) {
            this.suspendCalled = true;
            this.updateRunnableQueue.suspendExecution(false);
        }
    }

    public synchronized void resume() {
        if (!this.running) {
            this.updateRunnableQueue.resumeExecution();
        }
    }

    public synchronized void interrupt() {
        if (this.updateRunnableQueue.getThread() != null) {
            if (this.started) {
                this.dispatchSVGUnLoadEvent();
            } else {
                this.updateRunnableQueue.preemptLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        UpdateManager updateManager = UpdateManager.this;
                        synchronized (updateManager) {
                            UpdateManager.this.running = false;
                            UpdateManager.this.scriptingEnvironment.interrupt();
                            UpdateManager.this.updateRunnableQueue.getThread().interrupt();
                        }
                    }
                });
                this.resume();
            }
        }
    }

    public void dispatchSVGUnLoadEvent() {
        if (!this.started) {
            throw new IllegalStateException("UpdateManager not started.");
        }
        this.updateRunnableQueue.preemptLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    Event event = ((DocumentEvent)((Object)UpdateManager.this.document)).createEvent("SVGEvents");
                    event.initEvent("SVGUnload", false, false);
                    ((EventTarget)((Object)UpdateManager.this.document.getDocumentElement())).dispatchEvent(event);
                    UpdateManager.this.running = false;
                    UpdateManager.this.scriptingEnvironment.interrupt();
                    UpdateManager.this.updateRunnableQueue.getThread().interrupt();
                    UpdateManager.this.fireEvent(stoppedDispatcher, new UpdateManagerEvent(this, null, null));
                }
            }
        });
        this.resume();
    }

    public void updateRendering(AffineTransform affineTransform, boolean bl, Shape shape, int n, int n2) {
        this.repaintManager.setupRenderer(affineTransform, bl, shape, n, n2);
        ArrayList<Shape> arrayList = new ArrayList<Shape>(1);
        arrayList.add(shape);
        this.updateRendering(arrayList);
    }

    public void updateRendering(List list) {
        try {
            this.fireEvent(updateStartedDispatcher, new UpdateManagerEvent(this, this.repaintManager.getOffScreen(), null));
            List list2 = this.repaintManager.updateRendering(list);
            this.fireEvent(updateCompletedDispatcher, new UpdateManagerEvent(this, this.repaintManager.getOffScreen(), list2));
        }
        catch (Throwable throwable) {
            this.fireEvent(updateFailedDispatcher, new UpdateManagerEvent(this, null, null));
        }
    }

    public void repaint() {
        long l = System.currentTimeMillis();
        if (this.updateTracker.hasChanged()) {
            Object object;
            if (l - this.lastRepaint < MIN_REPAINT_TIME) {
                object = this.updateRunnableQueue.iterator();
                while (object.hasNext()) {
                    if (object.next() instanceof NoRepaintRunnable) continue;
                    return;
                }
            }
            if ((object = this.updateTracker.getDirtyAreas()) != null) {
                this.updateRendering((List)object);
            }
            this.updateTracker.clear();
            this.lastRepaint = System.currentTimeMillis();
        }
    }

    public void addUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.listeners.add(updateManagerListener);
    }

    public void removeUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.listeners.remove(updateManagerListener);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent(dispatcher, this.listeners, object, false);
    }

    public void runnableInvoked(RunnableQueue runnableQueue, Runnable runnable) {
        if (this.running && !(runnable instanceof NoRepaintRunnable)) {
            this.repaint();
        }
    }

    public void executionSuspended(RunnableQueue runnableQueue) {
        if (this.suspendCalled) {
            this.running = false;
            this.fireEvent(suspendedDispatcher, new UpdateManagerEvent(this, null, null));
        }
    }

    public void executionResumed(RunnableQueue runnableQueue) {
        if (this.suspendCalled && !this.running) {
            this.running = true;
            this.suspendCalled = false;
            this.fireEvent(resumedDispatcher, new UpdateManagerEvent(this, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l = 20L;
        try {
            String string = System.getProperty("org.apache.batik.min_repaint_time", "20");
            l = Long.parseLong(string);
        }
        catch (SecurityException securityException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            MIN_REPAINT_TIME = l;
        }
        startedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerStarted((UpdateManagerEvent)object2);
            }
        };
        stoppedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerStopped((UpdateManagerEvent)object2);
            }
        };
        suspendedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerSuspended((UpdateManagerEvent)object2);
            }
        };
        resumedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerResumed((UpdateManagerEvent)object2);
            }
        };
        updateStartedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateStarted((UpdateManagerEvent)object2);
            }
        };
        updateCompletedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateCompleted((UpdateManagerEvent)object2);
            }
        };
        updateFailedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateFailed((UpdateManagerEvent)object2);
            }
        };
    }
}

