/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class GammaTransfer
implements TransferFunction {
    public byte[] lutData;
    public float amplitude;
    public float exponent;
    public float offset;

    public GammaTransfer(float f, float f2, float f3) {
        this.amplitude = f;
        this.exponent = f2;
        this.offset = f3;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int i = 0; i <= 255; ++i) {
            int n = (int)Math.round(255.0 * ((double)this.amplitude * Math.pow((float)i / 255.0f, this.exponent) + (double)this.offset));
            if (n > 255) {
                n = -1;
            } else if (n < 0) {
                n = 0;
            }
            this.lutData[i] = (byte)(n & 0xFF);
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

