/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Gen;
import net.sf.pizzacompiler.compiler.ImmediateItem;
import net.sf.pizzacompiler.compiler.IntConst;
import net.sf.pizzacompiler.compiler.Item;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.StackItem;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.VarSymbol;

class LocalItem
extends Item {
    int pos;
    int adr;
    Type type;

    LocalItem(Type type, int n, int n2) {
        super(Gen.typecode(type));
        this.type = type;
        this.pos = n;
        this.adr = n2;
    }

    static Item make(int n, VarSymbol varSymbol) {
        return new LocalItem(varSymbol.type, n, varSymbol.adr);
    }

    static Item make(int n, Type type, int n2) {
        return new LocalItem(type, n, n2);
    }

    Item load() {
        if (this.adr < 0) {
            Report.error(this.pos, "variable might not have been initialized");
            Gen.emitop(26 + Gen.truncate(this.typecode) * 4);
        } else {
            Gen.checkInit(this.pos, this.adr);
            int n = Gen.regOf(this.adr);
            if (n <= 3) {
                Gen.emitop(26 + Gen.truncate(this.typecode) * 4 + n);
            } else {
                Gen.emitop1w(21 + Gen.truncate(this.typecode), n);
            }
        }
        return Item.stackItem[this.typecode];
    }

    Item store() {
        int n = Gen.regOf(this.adr);
        if (n <= 3) {
            Gen.emitop(59 + Gen.truncate(this.typecode) * 4 + n);
        } else {
            Gen.emitop1w(54 + Gen.truncate(this.typecode), n);
        }
        if (this.adr < Gen.locals.length && Gen.locals[this.adr] != null && (Gen.locals[this.adr].modifiers & 0x10) != 0) {
            Gen.checkUninit(this.pos, this.adr);
        }
        Gen.letInit(this.adr);
        return Item.voidItem;
    }

    void incr(int n) {
        if (this.typecode == 0) {
            Gen.checkInit(this.pos, this.adr);
            if (this.adr < Gen.locals.length && Gen.locals[this.adr] != null && (Gen.locals[this.adr].modifiers & 0x10) != 0) {
                Gen.checkUninit(this.pos, this.adr);
            }
            int n2 = Gen.regOf(this.adr);
            Gen.emitop1w(132, n2);
            if (n2 > 255) {
                Gen.emit2(n);
            } else {
                Gen.emit1(n);
            }
        } else {
            this.load();
            ImmediateItem.make(new IntConst(n)).load();
            Gen.emitop(96);
            StackItem.make(Type.intType).coerce(this.typecode);
            this.store();
        }
    }
}

