/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.jfor.jfor.rtflib.rtfdoc.IRtfTextContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfElement;
import org.jfor.jfor.rtflib.rtfdoc.RtfStringConverter;

public class RtfText
extends RtfElement {
    private static final int CHAR_NBSP = 160;
    private static final int CHAR_TAB = 137;
    private static final int CHAR_NEW_LINE = 141;
    private static final int CHAR_BOLD_START = 130;
    private static final int CHAR_BOLD_END = 131;
    private String m_text;
    private final RtfAttributes m_attr;
    public static final String ATTR_BOLD = "b";
    public static final String ATTR_ITALIC = "i";
    public static final String ATTR_UNDERLINE = "ul";
    public static final String ATTR_FONT_SIZE = "fs";
    public static final String ATTR_FONT_FAMILY = "f";
    public static final String ATTR_FONT_COLOR = "cf";
    public static String ALIGN_CENTER = "qc";
    public static String ALIGN_LEFT = "ql";
    public static String ALIGN_RIGHT = "qr";
    public static String ALIGN_JUSTIFIED = "qj";
    public static String ALIGN_DISTRIBUTED = "qd";
    public static String BDR_BOTTOM_SINGLE = "brdrb\\brsp40\\brdrs";
    public static String BDR_BOTTOM_DOUBLE = "brdrb\\brsp40\\brdrdb";
    public static String BDR_BOTTOM_EMBOSS = "brdrb\\brsp40\\brdremboss";
    public static String BDR_BOTTOM_DOTTED = "brdrb\\brsp40\\brdrdot";
    public static String BDR_BOTTOM_DASH = "brdrb\\brsp40\\brdrdash";
    public static String RTF_FIELD = "field";
    public static String RTF_FIELD_PAGE = "fldinst { PAGE }";
    public static String RTF_FIELD_RESULT = "fldrslt";
    public static String LEFT_INDENT_BODY = "li";
    public static String LEFT_INDENT_FIRST = "fi-";
    public static String TAB_CENTER = "tqc\\tx";
    public static String TAB_RIGHT = "tqr\\tx";
    public static String TAB_LEADER_DOTS = "tldot";
    public static String TAB_LEADER_HYPHEN = "tlhyph";
    public static String TAB_LEADER_UNDER = "tlul";
    public static String TAB_LEADER_THICK = "tlth";
    public static String TAB_LEADER_EQUALS = "tleq";
    public static String[] ALIGNMENT = new String[]{ALIGN_CENTER, ALIGN_LEFT, ALIGN_RIGHT, ALIGN_JUSTIFIED, ALIGN_DISTRIBUTED};
    public static String[] BORDER = new String[]{BDR_BOTTOM_SINGLE, BDR_BOTTOM_DOUBLE, BDR_BOTTOM_EMBOSS, BDR_BOTTOM_DOTTED, BDR_BOTTOM_DASH};
    public static String[] INDENT = new String[]{LEFT_INDENT_BODY, LEFT_INDENT_FIRST};
    public static String[] TABS = new String[]{TAB_CENTER, TAB_RIGHT, TAB_LEADER_DOTS, TAB_LEADER_HYPHEN, TAB_LEADER_UNDER, TAB_LEADER_THICK, TAB_LEADER_EQUALS};
    public static final String[] ATTR_NAMES = new String[]{"b", "i", "ul", "fs", "f", "cf"};

    RtfText(IRtfTextContainer iRtfTextContainer, Writer writer, String string, RtfAttributes rtfAttributes) throws IOException {
        super((RtfContainer)((Object)iRtfTextContainer), writer);
        this.m_text = string;
        this.m_attr = rtfAttributes;
    }

    public void writeRtfContent() throws IOException {
        if (this.isTab()) {
            this.writeControlWord("tab");
        } else if (!this.isNewLine()) {
            if (this.isBold(true)) {
                this.writeControlWord(ATTR_BOLD);
            } else if (this.isBold(false)) {
                this.writeControlWord("b0");
            } else {
                this.writeGroupMark(true);
                if (this.m_attr != null && this.mustWriteAttributes()) {
                    this.writeAttributes(this.m_attr, ATTR_NAMES);
                }
                RtfStringConverter.getInstance().writeRtfString(this.m_writer, this.m_text);
                this.writeGroupMark(false);
            }
        }
    }

    private boolean mustWriteAttributes() {
        return !this.isEmpty() && !this.isNbsp();
    }

    public RtfAttributes getTextContainerAttributes() {
        if (this.m_attrib == null) {
            return null;
        }
        return (RtfAttributes)this.m_attrib.clone();
    }

    String getText() {
        return this.m_text;
    }

    void setText(String string) {
        this.m_text = string;
    }

    public boolean isEmpty() {
        return this.m_text == null || this.m_text.trim().length() == 0;
    }

    public boolean isNbsp() {
        return !this.isEmpty() && this.m_text.trim().length() == 1 && this.m_text.charAt(0) == '\u00a0';
    }

    public boolean isTab() {
        return this.m_text.trim().length() == 1 && this.m_text.charAt(0) == '\u0089';
    }

    public boolean isNewLine() {
        return this.m_text.trim().length() == 1 && this.m_text.charAt(0) == '\u008d';
    }

    public boolean isBold(boolean bl) {
        if (bl) {
            return this.m_text.trim().length() == 1 && this.m_text.charAt(0) == '\u0082';
        }
        return this.m_text.trim().length() == 1 && this.m_text.charAt(0) == '\u0083';
    }
}

